# This file was autogenerated from vk-api json schema

from typing import List, Union, Optional, Literal, overload
from easy_vk.types import objects
from easy_vk.types import responses
from easy_vk.api_category import BaseCategory


class Apps(BaseCategory):
    def __init__(self, session, access_token: str, v: str, last_call_timer, delay: float, auto_retry: bool, max_retries: int, timeout: float):
        super().__init__(session, access_token, v, last_call_timer, delay, auto_retry, max_retries, timeout)

    def delete_app_requests(self) -> responses.BaseOk:
        """
        Deletes all request notifications from the current app.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'apps.deleteAppRequests'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get(self, app_id: Optional[int] = None, app_ids: Optional[List[str]] = None, platform: Optional[str] = None, extended: Optional[bool] = None, return_friends: Optional[bool] = None, fields: Optional[List[Union[objects.UsersFields, str]]] = None, name_case: Optional[str] = None) -> responses.AppsGet:
        """
        Returns applications data.
        
        :param app_id: Application ID
        :param app_ids: List of application ID
        :param platform: platform. Possible values: *'ios' — iOS,, *'android' — Android,, *'winphone' — Windows Phone,, *'web' — приложения на vk.com. By default: 'web'.
        :param extended:
        :param return_friends:
        :param fields: Profile fields to return. Sample values: 'nickname', 'screen_name', 'sex', 'bdate' (birthdate), 'city', 'country', 'timezone', 'photo', 'photo_medium', 'photo_big', 'has_mobile', 'contacts', 'education', 'online', 'counters', 'relation', 'last_seen', 'activity', 'can_write_private_message', 'can_see_all_posts', 'can_post', 'universities', (only if return_friends - 1)
        :param name_case: Case for declension of user name and surname: 'nom' — nominative (default),, 'gen' — genitive,, 'dat' — dative,, 'acc' — accusative,, 'ins' — instrumental,, 'abl' — prepositional. (only if 'return_friends' = '1')
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'apps.get'
        response_type = responses.AppsGet
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_catalog(self, count: int, sort: Optional[str] = None, offset: Optional[int] = None, platform: Optional[str] = None, extended: Optional[bool] = None, return_friends: Optional[bool] = None, fields: Optional[List[Union[objects.UsersFields, str]]] = None, name_case: Optional[str] = None, q: Optional[str] = None, genre_id: Optional[int] = None, filter_: Optional[str] = None) -> responses.AppsGetCatalog:
        """
        Returns a list of applications (apps) available to users in the App Catalog.
        
        :param count: Number of apps to return.
        :param sort: Sort order: 'popular_today' — popular for one day (default), 'visitors' — by visitors number , 'create_date' — by creation date, 'growth_rate' — by growth rate, 'popular_week' — popular for one week
        :param offset: Offset required to return a specific subset of apps.
        :param platform:
        :param extended: '1' — to return additional fields 'screenshots', 'MAU', 'catalog_position', and 'international'. If set, 'count' must be less than or equal to '100'. '0' — not to return additional fields (default).
        :param return_friends:
        :param fields:
        :param name_case:
        :param q: Search query string.
        :param genre_id:
        :param filter_: 'installed' — to return list of installed apps (only for mobile platform).
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = [('filter_', 'filter')]
        method_name = 'apps.getCatalog'
        response_type = responses.AppsGetCatalog
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_friends_list(self, extended: Optional[bool] = None, count: Optional[int] = None, offset: Optional[int] = None, type_: Optional[str] = None, fields: Optional[List[Union[objects.UsersFields, str]]] = None) -> responses.AppsGetFriendsList:
        """
        Creates friends list for requests and invites in current app.
        
        :param extended:
        :param count: List size.
        :param offset:
        :param type_: List type. Possible values: * 'invite' — available for invites (don't play the game),, * 'request' — available for request (play the game). By default: 'invite'.
        :param fields: Additional profile fields, see [vk.com/dev/fields|description].
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = [('type_', 'type')]
        method_name = 'apps.getFriendsList'
        response_type = responses.AppsGetFriendsList
        return self._call(method_name, method_parameters, param_aliases, response_type)

    @overload
    def get_leaderboard(self, type_: str, global_: Optional[bool] = None, extended: None = None) -> responses.AppsGetLeaderboard: ...
    @overload
    def get_leaderboard(self, type_: str, extended: bool, global_: Optional[bool] = None) -> responses.AppsGetLeaderboardExtended: ...
    def get_leaderboard(self, type_: str, global_: Optional[bool] = None, extended: Optional[bool] = None):
        """
        Returns players rating in the game.
        
        :param type_: Leaderboard type. Possible values: *'level' — by level,, *'points' — by mission points,, *'score' — by score ().
        :param global_: Rating type. Possible values: *'1' — global rating among all players,, *'0' — rating among user friends.
        :param extended: 1 — to return additional info about users
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = [('type_', 'type'), ('global_', 'global')]
        method_name = 'apps.getLeaderboard'
        if not extended:
            response_type = responses.AppsGetLeaderboard
        if extended:
            response_type = responses.AppsGetLeaderboardExtended
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_scopes(self, type_: Optional[str] = None) -> responses.AppsGetScopes:
        """
        Returns scopes for auth
        
        :param type_:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = [('type_', 'type')]
        method_name = 'apps.getScopes'
        response_type = responses.AppsGetScopes
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_score(self, user_id: int) -> responses.AppsGetScore:
        """
        Returns user score in app
        
        :param user_id:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'apps.getScore'
        response_type = responses.AppsGetScore
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def promo_has_active_gift(self, promo_id: int, user_id: Optional[int] = None) -> responses.BaseBool:
        """
        :param promo_id: Id of game promo action
        :param user_id:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'apps.promoHasActiveGift'
        response_type = responses.BaseBool
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def promo_use_gift(self, promo_id: int, user_id: Optional[int] = None) -> responses.BaseBool:
        """
        :param promo_id: Id of game promo action
        :param user_id:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'apps.promoUseGift'
        response_type = responses.BaseBool
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def send_request(self, user_id: int, text: Optional[str] = None, type_: Optional[str] = None, name: Optional[str] = None, key: Optional[str] = None, separate: Optional[bool] = None) -> responses.AppsSendRequest:
        """
        Sends a request to another user in an app that uses VK authorization.
        
        :param user_id: id of the user to send a request
        :param text: request text
        :param type_: request type. Values: 'invite' – if the request is sent to a user who does not have the app installed,, 'request' – if a user has already installed the app
        :param name:
        :param key: special string key to be sent with the request
        :param separate:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = [('type_', 'type')]
        method_name = 'apps.sendRequest'
        response_type = responses.AppsSendRequest
        return self._call(method_name, method_parameters, param_aliases, response_type)
