# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-09-22 15:43
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0016_auto_20160608_1535'),
    ]

    operations = [
        migrations.CreateModel(
            name='MailingList',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('external_service', models.PositiveSmallIntegerField(choices=[(1, 'None'), (2, 'Mailchimp')], default=1)),
                ('external_id', models.CharField(blank=True, max_length=10, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='NewsletterPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='cms_qe_newsletter_newsletterpluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('title', models.CharField(blank=True, help_text='The title of subscribes that will be shown to users', max_length=150, verbose_name='Title')),
                ('fullname_show', models.BooleanField(default=False, verbose_name='Show fullname fields')),
                ('fullname_require', models.BooleanField(default=False, verbose_name='Require fullname')),
                ('mailing_lists', models.ManyToManyField(to='cms_qe_newsletter.MailingList', verbose_name='Maillist')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='Subscriber',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254)),
                ('first_name', models.CharField(blank=True, max_length=50)),
                ('last_name', models.CharField(blank=True, max_length=50)),
                ('external_id', models.CharField(blank=True, max_length=50, null=True)),
                ('mailing_list', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cms_qe_newsletter.MailingList')),
            ],
        ),
        migrations.CreateModel(
            name='SubscribeTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254)),
                ('first_name', models.CharField(max_length=50, null=True)),
                ('last_name', models.CharField(max_length=50, null=True)),
                ('external_id', models.CharField(max_length=10, null=True)),
                ('type', models.PositiveSmallIntegerField(choices=[(1, 'Subscribe'), (2, 'Unsubscribe')])),
                ('created', models.DateTimeField(auto_now=True)),
                ('attempts', models.PositiveSmallIntegerField(default=0)),
                ('last_error', models.TextField()),
                ('mailing_list', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='cms_qe_newsletter.MailingList')),
            ],
        ),
    ]
