# Foundry

<p align="center">
<a href="https://github.com/TheJoeSmo/Foundry/actions"><img alt="Actions Status" src="https://github.com/TheJoeSmo/Foundry/actions/workflows/tests.yml/badge.svg"></a>
<a href="https://github.com/TheJoeSmo/Foundry/actions"><img alt="Actions Status" src="https://github.com/TheJoeSmo/Foundry/actions/workflows/github_pages.yml/badge.svg"></a>
<a href="https://github.com/TheJoeSmo/Foundry/block/main/LICENSE.md"><img alt="License GPL3" src="https://img.shields.io/badge/License-GPLv3-blue.svg"></a>
<a href="https://pypi.org/project/foundry-smb3/"><img alt="PyPI" src="https://img.shields.io/pypi/v/foundry-smb3"></a>
<a href="https://pepy.tech/project/black"><img alt="Downloads" src="https://pepy.tech/badge/foundry-smb3"></a>
<a href="https://github.com/psf/black"><img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>
</p>

Purpose
-------
Foundry is the all-in-one editor for modifying copies of the North American release of [SMB3](https://en.wikipedia.org/wiki/Super_Mario_Bros._3).  We seek to streamline the game development processes to ensure that the nostalgic memories of [Power Glove](https://en.wikipedia.org/wiki/Power_Glove), [Nintendo Power](https://en.wikipedia.org/wiki/Nintendo_Power), and goomba stomping can be accessed and modified by all.  We want to put the power into our favorite game and you the super player!


Installation
------------
To install and use Foundry, there are three options:

1. [Download Foundry Executable](https://github.com/TheJoeSmo/Foundry/releases)
    
    This is the every-person method.  Every minor and major release will prepackage the editor into an executable to run painlessly on your native machine.  To get started, go to [Releases](https://github.com/TheJoeSmo/Foundry/releases) and download the executable specific to your operating system.

2. [Download Foundry from PyPi](https://pypi.org/project/foundry-smb3/)
    
    This is the method recommended if you wish to run the project natively with Python.  This may required if you use a 32 bit machine or an obscure operating system.  It is also required if you wish to use Foundry in some combination with other Python packages.  With [Python](https://www.python.org/downloads/) installed, write `pip install foundry-smb3` into your console and run `foundry` or run `foundry.main.start` from inside Python.

3. [Download Foundry from Github](https://github.com/TheJoeSmo/Foundry.git)

    This is the developer method.  This will provide you easy access to the entire repository.  In addition to [Python](https://www.python.org/downloads/) you will need [Poetry](https://python-poetry.org/docs/) installed.  Once installed run the following commands into your terminal:

    ```
    $ git clone git@github.com:TheJoeSmo/Foundry.git
    $ cd Foundry
    $ poetry install
    ```

Documentation
-------------

All documentation of the editor can be found at [Foundry Documentation](https://thejoesmo.github.io/Foundry/).


Call for Contributions
----------------------
Foundry is a community driven initiative that relies on your help and expertise.

Small improvements or fixes are critical to this repository's success.  Issues labeled `good first issue` are a great place to start.  For larger contributions WIP.

You do not need to be literate with programming to aid Foundry on its journey.  We also need help with:
- Developing tutorials
- Creating graphics for our brand and promotional material
- Translation
- Outreach and onboarding new contributors
- Reviewing issues and suggestions

If you are undecided on where to start, we encourage you to reach out.  You can ask on our Discord or privately through email.

If you are new to open source projects and want to be caught up to speed, we recommend [this guide](https://opensource.guide/how-to-contribute/)

Important Links
---------------
- [Website](https://thejoesmo.github.io/Foundry/)
- [Discord](https://discord.gg/pm87gm7)
- [Documentation](https://thejoesmo.github.io/Foundry/)
- [Manual](https://github.com/TheJoeSmo/Foundry/blob/master/MANUAL.md)
- [Source Code](https://github.com/TheJoeSmo/Foundry)
- [Bug Reporting](https://github.com/TheJoeSmo/Foundry/issues)
