"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schedule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_scheduler_1 = require("aws-cdk-lib/aws-scheduler");
/**
 * An EventBridge Schedule
 */
class Schedule extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.scheduleName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_alpha_ScheduleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Schedule);
            }
            throw error;
        }
        this.group = props.group;
        const targetConfig = props.target.bind(this);
        const resource = new aws_scheduler_1.CfnSchedule(this, 'Resource', {
            name: this.physicalName,
            flexibleTimeWindow: { mode: 'OFF' },
            scheduleExpression: props.schedule.expressionString,
            scheduleExpressionTimezone: props.schedule.timeZone?.timezoneName,
            groupName: this.group?.groupName,
            target: {
                arn: targetConfig.arn,
                roleArn: targetConfig.role.roleArn,
                input: targetConfig.input?.bind(this),
                deadLetterConfig: targetConfig.deadLetterConfig,
                retryPolicy: targetConfig.retryPolicy,
                ecsParameters: targetConfig.ecsParameters,
                kinesisParameters: targetConfig.kinesisParameters,
                eventBridgeParameters: targetConfig.eventBridgeParameters,
                sageMakerPipelineParameters: targetConfig.sageMakerPipelineParameters,
                sqsParameters: targetConfig.sqsParameters,
            },
        });
        this.scheduleName = this.getResourceNameAttribute(resource.ref);
        this.scheduleArn = this.getResourceArnAttribute(resource.attrArn, {
            service: 'scheduler',
            resource: 'schedule',
            resourceName: `${this.group?.groupName ?? 'default'}/${this.physicalName}`,
        });
    }
}
exports.Schedule = Schedule;
_a = JSII_RTTI_SYMBOL_1;
Schedule[_a] = { fqn: "@aws-cdk/aws-scheduler-alpha.Schedule", version: "2.96.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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