import { IResource, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IGroup } from './group';
import { ScheduleExpression } from './schedule-expression';
import { IScheduleTarget } from './target';
/**
 * Interface representing a created or an imported `Schedule`.
 */
export interface ISchedule extends IResource {
    /**
     * The name of the schedule.
     */
    readonly scheduleName: string;
    /**
     * The schedule group associated with this schedule.
     */
    readonly group?: IGroup;
    /**
     * The arn of the schedule.
     */
    readonly scheduleArn: string;
}
/**
 * Construction properties for `Schedule`.
 */
export interface ScheduleProps {
    /**
     * The expression that defines when the schedule runs. Can be either a `at`, `rate`
     * or `cron` expression.
     */
    readonly schedule: ScheduleExpression;
    /**
     * The schedule's target details.
     */
    readonly target: IScheduleTarget;
    /**
     * The name of the schedule.
     *
     * Up to 64 letters (uppercase and lowercase), numbers, hyphens, underscores and dots are allowed.
     *
     * @default - A unique name will be generated
     */
    readonly scheduleName?: string;
    /**
     * The description you specify for the schedule.
     *
     * @default - no value
     */
    readonly description?: string;
    /**
     * The schedule's group.
     *
     * @deafult - By default a schedule will be associated with the `default` group.
     */
    readonly group?: IGroup;
}
/**
 * An EventBridge Schedule
 */
export declare class Schedule extends Resource implements ISchedule {
    /**
     * The schedule group associated with this schedule.
     */
    readonly group?: IGroup;
    /**
     * The arn of the schedule.
     */
    readonly scheduleArn: string;
    /**
     * The name of the schedule.
     */
    readonly scheduleName: string;
    constructor(scope: Construct, id: string, props: ScheduleProps);
}
