"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContextAttribute = exports.ScheduleTargetInput = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The text, or well-formed JSON, passed to the target of the schedule.
 */
class ScheduleTargetInput {
    /**
     * Pass text to the target, it is possible to embed `ContextAttributes`
     * that will be resolved to actual values while the CloudFormation is
     * deployed or cdk Tokens that will be resolved when the CloudFormation
     * templates are generated by CDK.
     *
     * The target input value will be a single string that you pass.
     * For passing complex values like JSON object to a target use method
     * `ScheduleTargetInput.fromObject()` instead.
     *
     * @param text Text to use as the input for the target
     */
    static fromText(text) {
        return new FieldAwareEventInput(text);
    }
    /**
     * Pass a JSON object to the target, it is possible to embed `ContextAttributes` and other
     * cdk references.
     *
     * @param obj object to use to convert to JSON to use as input for the target
     */
    static fromObject(obj) {
        return new FieldAwareEventInput(obj);
    }
    constructor() {
    }
}
exports.ScheduleTargetInput = ScheduleTargetInput;
_a = JSII_RTTI_SYMBOL_1;
ScheduleTargetInput[_a] = { fqn: "@aws-cdk/aws-scheduler-alpha.ScheduleTargetInput", version: "2.96.1-alpha.0" };
class FieldAwareEventInput extends ScheduleTargetInput {
    constructor(input) {
        super();
        this.input = input;
    }
    bind(schedule) {
        class Replacer extends aws_cdk_lib_1.DefaultTokenResolver {
            constructor() {
                super(new aws_cdk_lib_1.StringConcat());
            }
            resolveToken(t, _context) {
                return aws_cdk_lib_1.Token.asString(t);
            }
        }
        const stack = aws_cdk_lib_1.Stack.of(schedule);
        return stack.toJsonString(aws_cdk_lib_1.Tokenization.resolve(this.input, {
            scope: schedule,
            resolver: new Replacer(),
        }));
    }
}
/**
 * Represents a field in the event pattern
 *
 * @see https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-schedule-context-attributes.html
 */
class ContextAttribute {
    /**
     * The ARN of the schedule.
     */
    static get scheduleArn() {
        return this.fromName('schedule-arn');
    }
    /**
     * The time you specified for the schedule to invoke its target, for example,
     * 2022-03-22T18:59:43Z.
     */
    static get scheduledTime() {
        return this.fromName('scheduled-time');
    }
    /**
     * The unique ID that EventBridge Scheduler assigns for each attempted invocation of
     * a target, for example, d32c5kddcf5bb8c3.
     */
    static get executionId() {
        return this.fromName('execution-id');
    }
    /**
     * A counter that identifies the attempt number for the current invocation, for
     * example, 1.
     */
    static get attemptNumber() {
        return this.fromName('attempt-number');
    }
    /**
     * Escape hatch for other ContextAttribute that might be resolved in future.
     *
     * @param name - name will replace xxx in <aws.scheduler.xxx>
     */
    static fromName(name) {
        return new ContextAttribute(name).toString();
    }
    constructor(name) {
        this.name = name;
    }
    /**
     * Convert the path to the field in the event pattern to JSON
     */
    toString() {
        return `<aws.scheduler.${this.name}>`;
    }
}
exports.ContextAttribute = ContextAttribute;
_b = JSII_RTTI_SYMBOL_1;
ContextAttribute[_b] = { fqn: "@aws-cdk/aws-scheduler-alpha.ContextAttribute", version: "2.96.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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