import { ISchedule } from './schedule';
/**
 * The text, or well-formed JSON, passed to the target of the schedule.
 */
export declare abstract class ScheduleTargetInput {
    /**
     * Pass text to the target, it is possible to embed `ContextAttributes`
     * that will be resolved to actual values while the CloudFormation is
     * deployed or cdk Tokens that will be resolved when the CloudFormation
     * templates are generated by CDK.
     *
     * The target input value will be a single string that you pass.
     * For passing complex values like JSON object to a target use method
     * `ScheduleTargetInput.fromObject()` instead.
     *
     * @param text Text to use as the input for the target
     */
    static fromText(text: string): ScheduleTargetInput;
    /**
     * Pass a JSON object to the target, it is possible to embed `ContextAttributes` and other
     * cdk references.
     *
     * @param obj object to use to convert to JSON to use as input for the target
     */
    static fromObject(obj: any): ScheduleTargetInput;
    protected constructor();
    /**
     * Return the input properties for this input object
     */
    abstract bind(schedule: ISchedule): string;
}
/**
 * Represents a field in the event pattern
 *
 * @see https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-schedule-context-attributes.html
 */
export declare class ContextAttribute {
    readonly name: string;
    /**
     * The ARN of the schedule.
     */
    static get scheduleArn(): string;
    /**
     * The time you specified for the schedule to invoke its target, for example,
     * 2022-03-22T18:59:43Z.
     */
    static get scheduledTime(): string;
    /**
     * The unique ID that EventBridge Scheduler assigns for each attempted invocation of
     * a target, for example, d32c5kddcf5bb8c3.
     */
    static get executionId(): string;
    /**
     * A counter that identifies the attempt number for the current invocation, for
     * example, 1.
     */
    static get attemptNumber(): string;
    /**
     * Escape hatch for other ContextAttribute that might be resolved in future.
     *
     * @param name - name will replace xxx in <aws.scheduler.xxx>
     */
    static fromName(name: string): string;
    private constructor();
    /**
     * Convert the path to the field in the event pattern to JSON
     */
    toString(): string;
}
