"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUserPoolAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Authorize Http Api routes on whether the requester is registered as part of
 * an AWS Cognito user pool.
 */
class HttpUserPoolAuthorizer {
    /**
     * Initialize a Cognito user pool authorizer to be bound with HTTP route.
     * @param id The id of the underlying construct
     * @param pool The user pool to use for authorization
     * @param props Properties to configure the authorizer
     */
    constructor(id, pool, props = {}) {
        this.id = id;
        this.pool = pool;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_HttpUserPoolAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(options) {
        var _b, _c, _d, _e;
        if (!this.authorizer) {
            const region = (_b = this.props.userPoolRegion) !== null && _b !== void 0 ? _b : aws_cdk_lib_1.Stack.of(options.scope).region;
            const clients = (_c = this.props.userPoolClients) !== null && _c !== void 0 ? _c : [this.pool.addClient('UserPoolAuthorizerClient')];
            this.authorizer = new aws_apigatewayv2_alpha_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_d = this.props.identitySource) !== null && _d !== void 0 ? _d : ['$request.header.Authorization'],
                type: aws_apigatewayv2_alpha_1.HttpAuthorizerType.JWT,
                authorizerName: (_e = this.props.authorizerName) !== null && _e !== void 0 ? _e : this.id,
                jwtAudience: clients.map((c) => c.userPoolClientId),
                jwtIssuer: `https://cognito-idp.${region}.amazonaws.com/${this.pool.userPoolId}`,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpUserPoolAuthorizer = HttpUserPoolAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpUserPoolAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpUserPoolAuthorizer", version: "2.24.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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