"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new aws_cdk_lib_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stackTest = new aws_cdk_lib_1.Stack(app, 'TestStackCreateLambda', { env });
        const fn = new aws_cdk_lib_1.aws_lambda.DockerImageFunction(stackTest, 'TestLambda', {
            code: aws_cdk_lib_1.aws_lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda')),
            currentVersionOptions: {
                removalPolicy: aws_cdk_lib_1.RemovalPolicy.RETAIN,
            },
        });
        new index_1.LambdaAliasRetention(stackTest, 'TestLambdaAliasRetention', {
            fn,
            lambdaAlias: 'v1',
        });
        app.synth();
        this.stack = [stackTest];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDZCQUE2QjtBQUM3Qiw2Q0FBOEU7QUFDOUUsbUNBQStDO0FBRS9DLE1BQWEsWUFBWTtJQUV2QjtRQUNFLE1BQU0sR0FBRyxHQUFHLElBQUksaUJBQUcsRUFBRSxDQUFDO1FBRXRCLE1BQU0sR0FBRyxHQUFHO1lBQ1YsTUFBTSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCO1lBQ3RDLE9BQU8sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLG1CQUFtQjtTQUN6QyxDQUFDO1FBRUYsTUFBTSxTQUFTLEdBQUcsSUFBSSxtQkFBSyxDQUFDLEdBQUcsRUFBRSx1QkFBdUIsRUFBRSxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQUM7UUFFbkUsTUFBTSxFQUFFLEdBQUcsSUFBSSx3QkFBTSxDQUFDLG1CQUFtQixDQUFDLFNBQVMsRUFBRSxZQUFZLEVBQUU7WUFDakUsSUFBSSxFQUFFLHdCQUFNLENBQUMsZUFBZSxDQUFDLGNBQWMsQ0FDekMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsV0FBVyxDQUFDLENBQ2xDO1lBQ0QscUJBQXFCLEVBQUU7Z0JBQ3JCLGFBQWEsRUFBRSwyQkFBYSxDQUFDLE1BQU07YUFDcEM7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLDRCQUFvQixDQUFDLFNBQVMsRUFBRSwwQkFBMEIsRUFBRTtZQUM5RCxFQUFFO1lBQ0YsV0FBVyxFQUFFLElBQUk7U0FDbEIsQ0FBQyxDQUFDO1FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ1osSUFBSSxDQUFDLEtBQUssR0FBRyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzNCLENBQUM7Q0FDRjtBQTdCRCxvQ0E2QkM7QUFFRCxJQUFJLFlBQVksRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCB7IEFwcCwgU3RhY2ssIFJlbW92YWxQb2xpY3ksIGF3c19sYW1iZGEgYXMgbGFtYmRhIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgTGFtYmRhQWxpYXNSZXRlbnRpb24gfSBmcm9tICcuL2luZGV4JztcblxuZXhwb3J0IGNsYXNzIEludGVnVGVzdGluZyB7XG4gIHJlYWRvbmx5IHN0YWNrOiBTdGFja1tdO1xuICBjb25zdHJ1Y3RvcigpIHtcbiAgICBjb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5cbiAgICBjb25zdCBlbnYgPSB7XG4gICAgICByZWdpb246IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX1JFR0lPTixcbiAgICAgIGFjY291bnQ6IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX0FDQ09VTlQsXG4gICAgfTtcblxuICAgIGNvbnN0IHN0YWNrVGVzdCA9IG5ldyBTdGFjayhhcHAsICdUZXN0U3RhY2tDcmVhdGVMYW1iZGEnLCB7IGVudiB9KTtcblxuICAgIGNvbnN0IGZuID0gbmV3IGxhbWJkYS5Eb2NrZXJJbWFnZUZ1bmN0aW9uKHN0YWNrVGVzdCwgJ1Rlc3RMYW1iZGEnLCB7XG4gICAgICBjb2RlOiBsYW1iZGEuRG9ja2VySW1hZ2VDb2RlLmZyb21JbWFnZUFzc2V0KFxuICAgICAgICBwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vbGFtYmRhJyksXG4gICAgICApLFxuICAgICAgY3VycmVudFZlcnNpb25PcHRpb25zOiB7XG4gICAgICAgIHJlbW92YWxQb2xpY3k6IFJlbW92YWxQb2xpY3kuUkVUQUlOLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIG5ldyBMYW1iZGFBbGlhc1JldGVudGlvbihzdGFja1Rlc3QsICdUZXN0TGFtYmRhQWxpYXNSZXRlbnRpb24nLCB7XG4gICAgICBmbixcbiAgICAgIGxhbWJkYUFsaWFzOiAndjEnLFxuICAgIH0pO1xuXG4gICAgYXBwLnN5bnRoKCk7XG4gICAgdGhpcy5zdGFjayA9IFtzdGFja1Rlc3RdO1xuICB9XG59XG5cbm5ldyBJbnRlZ1Rlc3RpbmcoKTsiXX0=