"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaAliasRetention = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * @stability stable
 */
class LambdaAliasRetention extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const onEvent = new aws_cdk_lib_1.aws_lambda.Function(this, 'MyHandler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'lambda-alias-retention.on_event',
        });
        const myProvider = new aws_cdk_lib_1.custom_resources.Provider(this, 'LambdaAliasProvider', {
            onEventHandler: onEvent,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
        });
        onEvent.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            actions: ['lambda:CreateAlias'],
            resources: [`arn:aws:lambda:${aws_cdk_lib_1.Stack.of(this).region}:${aws_cdk_lib_1.Stack.of(this).account}:function:${props.fn.functionName}`],
        }));
        const outputs = new aws_cdk_lib_1.CustomResource(this, 'LambdaAlias', {
            serviceToken: myProvider.serviceToken,
            properties: {
                regionName: aws_cdk_lib_1.Stack.of(this).region,
                functionName: props.fn.functionName,
                version: props.fn.currentVersion.version,
                alias: props.lambdaAlias,
            },
        });
        onEvent.node.addDependency(props.fn);
        outputs.node.addDependency(props.fn);
    }
}
exports.LambdaAliasRetention = LambdaAliasRetention;
_a = JSII_RTTI_SYMBOL_1;
LambdaAliasRetention[_a] = { fqn: "cdk-lambda-alias-retention.LambdaAliasRetention", version: "2.1.2" };
//# sourceMappingURL=data:application/json;base64,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