# Point Topic MCP Server

UK broadband data analysis server via Model Context Protocol. Simple stdio-based server for local development and Claude Desktop integration.

## ✅ what's implemented

**core tools**:

- `assemble_dataset_context()` - gets database schemas and examples for datasets (upc, upc_take_up, upc_forecast, ontology)
- `execute_query()` - runs safe read-only SQL queries against Snowflake

**authentication**: environment variables for Snowflake credentials

## installation (for end users)

**simple pip install**:

```bash
pip install point-topic-mcp
```

**add to your MCP client** (Claude Desktop, Cursor, etc.):

```json
{
  "mcpServers": {
    "point-topic": {
      "command": "point-topic-mcp",
      "env": {
        "SNOWFLAKE_USER": "your_user", 
        "SNOWFLAKE_PASSWORD": "your_password"
      }
    }
  }
}
```

**Claude Desktop config location**:
- Mac: `~/Library/Application Support/Claude/claude_desktop_config.json`
- Windows: `%APPDATA%\Claude\claude_desktop_config.json`

## development setup

setup: `uv sync`

**for local development with claude desktop**:

This will add the server to your claude desktop config.

```bash
uv run mcp install src/point_topic_mcp/server_local.py --with "snowflake-connector-python[pandas]" -f .env
```

**for mcp inspector**:

```bash
uv run mcp dev src/point_topic_mcp/server_local.py
```

**environment configuration**:

create `.env` file with your snowflake credentials:

```bash
# Your Snowflake credentials
SNOWFLAKE_USER=your_user
SNOWFLAKE_PASSWORD=your_password
```

## architecture

**stdio transport**: communicates with MCP clients (Claude Desktop, Cursor) via standard input/output for local integration

**tools**: two main tools for Snowflake data analysis
- `assemble_dataset_context()` - provides schemas and context for available datasets  
- `execute_query()` - executes safe read-only SQL queries

**authentication**: uses environment variables for Snowflake database credentials

## adding new datasets

this project uses a modular dataset system that allows easy addition of new data sources. each dataset is self-contained and automatically discovered by the MCP server.

### dataset structure

each dataset is a python module in `src/point_topic_mcp/context/datasets/` with two required functions:

```python
def get_dataset_summary():
    """Brief description visible to agents at all times.
    Keep concise - this goes in every agent prompt."""
    return "short description of what data is available"

def get_db_info():
    """Complete context: schema, instructions, examples.
    Only loaded when agent requests this dataset."""
    return f"""
    {DB_INFO}
    
    {DB_SCHEMA}
    
    {SQL_EXAMPLES}
    """
```

### key principles

1. **context window efficiency**: keep `get_dataset_summary()` extremely concise - it's always visible to agents
2. **lazy loading**: full context via `get_db_info()` only loads when needed
3. **self-contained**: each dataset module includes all its own schema, examples, and usage notes
4. **auto-discovery**: new `.py` files in the datasets directory are automatically available

### adding a new dataset

1. **create the module**: `src/point_topic_mcp/context/datasets/your_dataset.py`
2. **implement required functions**: `get_dataset_summary()` and `get_db_info()`
3. **test locally**: `uv run mcp dev src/point_topic_mcp/server_local.py`
4. **verify discovery**: agent should see your dataset in `assemble_dataset_context()` tool description

see existing modules (`upc.py`, `upc_take_up.py`, `upc_forecast.py`) for structure examples.

### optimization tips

- prioritize essential info in summaries
- use clear table descriptions that help agents choose the right dataset
- include common query patterns in examples
- sanity check data against known UK facts in instructions

## publishing to PyPI (for maintainers)

**build and test locally**:

```bash
# Build the package with UV (super fast!)
uv build

# Test installation locally
pip install dist/point_topic_mcp-*.whl

# Test the command works
point-topic-mcp
```

**publish to PyPI**:

```bash
# Set up PyPI credentials in ~/.pypirc first (one time setup)
# [pypi]
#   username = __token__
#   password = pypi-xxxxx...

# Publish to PyPI with the publish script
./publish_to_pypi.sh
```

**test installation from PyPI**:

```bash
pip install point-topic-mcp
point-topic-mcp
```