# Copyright 2015
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import os

from tempest import config as tempest_config
from tempest.test_discover import plugins

from freezer_tempest_plugin import config as freezer_config


class FreezerTempestPlugin(plugins.TempestPlugin):
    def load_tests(self):
        base_path = os.path.split(os.path.dirname(
            os.path.abspath(__file__)))[0]
        test_dir = "freezer_tempest_plugin/tests"
        full_test_dir = os.path.join(base_path, test_dir)
        return full_test_dir, base_path

    def register_opts(self, conf):
        tempest_config.register_opt_group(
            conf, freezer_config.service_available_group,
            freezer_config.ServiceAvailableGroup)
        tempest_config.register_opt_group(
            conf, freezer_config.freezer_api_group,
            freezer_config.FreezerApiGroup)
        conf.register_opt(freezer_config.service_option,
                          group='service_available')

    def get_opt_lists(self):
        return [('service_available', [freezer_config.service_option]),
                (freezer_config.freezer_api_group.name,
                 freezer_config.FreezerApiGroup)]
