# Generated by Django 2.2.12 on 2020-04-21 05:30
import uuid

import django.db.models.deletion
from django.db import migrations
from django.db import models

import a3m.main.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [("fpr", "0001_initial")]

    operations = [
        migrations.CreateModel(
            name="Agent",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "identifiertype",
                    models.TextField(
                        db_column="agentIdentifierType",
                        null=True,
                        verbose_name="Agent Identifier Type",
                    ),
                ),
                (
                    "identifiervalue",
                    models.TextField(
                        db_column="agentIdentifierValue",
                        help_text="Used for premis:agentIdentifierValue and premis:linkingAgentIdentifierValue in the METS file.",
                        null=True,
                        verbose_name="Agent Identifier Value",
                    ),
                ),
                (
                    "name",
                    models.TextField(
                        db_column="agentName",
                        help_text="Used for premis:agentName in the METS file.",
                        null=True,
                        verbose_name="Agent Name",
                    ),
                ),
                (
                    "agenttype",
                    models.TextField(
                        db_column="agentType",
                        default="organization",
                        help_text="Used for premis:agentType in the METS file.",
                        verbose_name="Agent Type",
                    ),
                ),
            ],
            options={"db_table": "Agents"},
        ),
        migrations.CreateModel(
            name="File",
            fields=[
                (
                    "uuid",
                    models.CharField(
                        db_column="fileUUID",
                        max_length=36,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "originallocation",
                    a3m.main.models.BlobTextField(db_column="originalLocation"),
                ),
                (
                    "currentlocation",
                    a3m.main.models.BlobTextField(
                        db_column="currentLocation", null=True
                    ),
                ),
                (
                    "filegrpuse",
                    models.CharField(
                        db_column="fileGrpUse", default="Original", max_length=50
                    ),
                ),
                (
                    "filegrpuuid",
                    models.CharField(
                        blank=True, db_column="fileGrpUUID", max_length=36
                    ),
                ),
                (
                    "checksum",
                    models.CharField(blank=True, db_column="checksum", max_length=128),
                ),
                (
                    "checksumtype",
                    models.CharField(
                        blank=True, db_column="checksumType", max_length=36
                    ),
                ),
                (
                    "size",
                    models.BigIntegerField(blank=True, db_column="fileSize", null=True),
                ),
                ("label", models.TextField(blank=True)),
                (
                    "modificationtime",
                    models.DateTimeField(
                        auto_now_add=True, db_column="modificationTime", null=True
                    ),
                ),
                (
                    "enteredsystem",
                    models.DateTimeField(auto_now_add=True, db_column="enteredSystem"),
                ),
                (
                    "removedtime",
                    models.DateTimeField(
                        db_column="removedTime", default=None, null=True
                    ),
                ),
            ],
            options={"db_table": "Files"},
        ),
        migrations.CreateModel(
            name="Identifier",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("type", models.TextField(null=True, verbose_name="Identifier Type")),
                (
                    "value",
                    models.TextField(
                        help_text="Used for premis:objectIdentifierType and premis:objectIdentifierValue in the METS file.",
                        null=True,
                        verbose_name="Identifier Value",
                    ),
                ),
            ],
            options={"db_table": "Identifiers"},
        ),
        migrations.CreateModel(
            name="Job",
            fields=[
                (
                    "jobuuid",
                    models.UUIDField(
                        db_column="jobUUID",
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "jobtype",
                    models.CharField(blank=True, db_column="jobType", max_length=250),
                ),
                ("createdtime", models.DateTimeField(db_column="createdTime")),
                (
                    "createdtimedec",
                    models.DecimalField(
                        db_column="createdTimeDec",
                        decimal_places=10,
                        default=0.0,
                        max_digits=26,
                    ),
                ),
                ("directory", models.TextField(blank=True)),
                (
                    "sipuuid",
                    models.CharField(db_column="SIPUUID", db_index=True, max_length=36),
                ),
                (
                    "unittype",
                    models.CharField(blank=True, db_column="unitType", max_length=50),
                ),
                (
                    "currentstep",
                    models.IntegerField(
                        choices=[
                            (0, "Unknown"),
                            (1, "Completed successfully"),
                            (2, "Executing command(s)"),
                            (3, "Failed"),
                        ],
                        db_column="currentStep",
                        default=0,
                    ),
                ),
                (
                    "microservicegroup",
                    models.CharField(
                        blank=True, db_column="microserviceGroup", max_length=50
                    ),
                ),
                ("hidden", models.BooleanField(default=False)),
                (
                    "microservicechainlink",
                    models.UUIDField(
                        blank=True,
                        db_column="MicroServiceChainLinksPK",
                        default=uuid.uuid4,
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "Jobs",
                "index_together": {
                    (
                        "sipuuid",
                        "currentstep",
                        "microservicegroup",
                        "microservicechainlink",
                    ),
                    ("jobtype", "currentstep"),
                    ("sipuuid", "createdtime", "createdtimedec"),
                    ("sipuuid", "jobtype", "createdtime", "createdtimedec"),
                },
            },
        ),
        migrations.CreateModel(
            name="MetadataAppliesToType",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_column="pk",
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "description",
                    models.CharField(db_column="description", max_length=50),
                ),
                (
                    "replaces",
                    models.CharField(
                        blank=True, db_column="replaces", max_length=36, null=True
                    ),
                ),
                (
                    "lastmodified",
                    models.DateTimeField(auto_now=True, db_column="lastModified"),
                ),
            ],
            options={"db_table": "MetadataAppliesToTypes"},
        ),
        migrations.CreateModel(
            name="RightsStatement",
            fields=[
                (
                    "id",
                    models.AutoField(db_column="pk", primary_key=True, serialize=False),
                ),
                (
                    "metadataappliestoidentifier",
                    models.CharField(
                        blank=True,
                        db_column="metadataAppliesToidentifier",
                        max_length=36,
                    ),
                ),
                (
                    "rightsstatementidentifiertype",
                    models.TextField(
                        blank=True,
                        db_column="rightsStatementIdentifierType",
                        verbose_name="Type",
                    ),
                ),
                (
                    "rightsstatementidentifiervalue",
                    models.TextField(
                        blank=True,
                        db_column="rightsStatementIdentifierValue",
                        verbose_name="Value",
                    ),
                ),
                (
                    "rightsholder",
                    models.IntegerField(
                        db_column="fkAgent", default=0, verbose_name="Rights holder"
                    ),
                ),
                (
                    "rightsbasis",
                    models.CharField(
                        choices=[
                            ("Copyright", "Copyright"),
                            ("Statute", "Statute"),
                            ("License", "License"),
                            ("Donor", "Donor"),
                            ("Policy", "Policy"),
                            ("Other", "Other"),
                        ],
                        db_column="rightsBasis",
                        default="Copyright",
                        max_length=64,
                        verbose_name="Basis",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("ORIGINAL", "original"),
                            ("REINGEST", "parsed from reingest"),
                            ("UPDATED", "updated"),
                        ],
                        db_column="status",
                        default="ORIGINAL",
                        max_length=8,
                    ),
                ),
                (
                    "metadataappliestotype",
                    models.ForeignKey(
                        db_column="metadataAppliesToType",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.MetadataAppliesToType",
                    ),
                ),
            ],
            options={"verbose_name": "Rights Statement", "db_table": "RightsStatement"},
        ),
        migrations.CreateModel(
            name="RightsStatementCopyright",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "copyrightstatus",
                    models.TextField(
                        choices=[
                            ("copyrighted", "copyrighted"),
                            ("public domain", "public domain"),
                            ("unknown", "unknown"),
                        ],
                        db_column="copyrightStatus",
                        default="unknown",
                        verbose_name="Copyright status",
                    ),
                ),
                (
                    "copyrightjurisdiction",
                    models.TextField(
                        db_column="copyrightJurisdiction",
                        verbose_name="Copyright jurisdiction",
                    ),
                ),
                (
                    "copyrightstatusdeterminationdate",
                    models.TextField(
                        blank=True,
                        db_column="copyrightStatusDeterminationDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="Copyright determination date",
                    ),
                ),
                (
                    "copyrightapplicablestartdate",
                    models.TextField(
                        blank=True,
                        db_column="copyrightApplicableStartDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="Copyright start date",
                    ),
                ),
                (
                    "copyrightapplicableenddate",
                    models.TextField(
                        blank=True,
                        db_column="copyrightApplicableEndDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="Copyright end date",
                    ),
                ),
                (
                    "copyrightenddateopen",
                    models.BooleanField(
                        db_column="copyrightApplicableEndDateOpen",
                        default=False,
                        help_text="Indicate end date is open",
                        verbose_name="Open End Date",
                    ),
                ),
                (
                    "rightsstatement",
                    models.ForeignKey(
                        db_column="fkRightsStatement",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatement",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Copyright",
                "db_table": "RightsStatementCopyright",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementLicense",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "licenseterms",
                    models.TextField(
                        blank=True,
                        db_column="licenseTerms",
                        null=True,
                        verbose_name="License terms",
                    ),
                ),
                (
                    "licenseapplicablestartdate",
                    models.TextField(
                        blank=True,
                        db_column="licenseApplicableStartDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="License start date",
                    ),
                ),
                (
                    "licenseapplicableenddate",
                    models.TextField(
                        blank=True,
                        db_column="licenseApplicableEndDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="License end date",
                    ),
                ),
                (
                    "licenseenddateopen",
                    models.BooleanField(
                        db_column="licenseApplicableEndDateOpen",
                        default=False,
                        help_text="Indicate end date is open",
                        verbose_name="Open End Date",
                    ),
                ),
                (
                    "rightsstatement",
                    models.ForeignKey(
                        db_column="fkRightsStatement",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatement",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: License",
                "db_table": "RightsStatementLicense",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementOtherRightsInformation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "otherrightsbasis",
                    models.TextField(
                        db_column="otherRightsBasis",
                        default="Other",
                        verbose_name="Other rights basis",
                    ),
                ),
                (
                    "otherrightsapplicablestartdate",
                    models.TextField(
                        blank=True,
                        db_column="otherRightsApplicableStartDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="Other rights start date",
                    ),
                ),
                (
                    "otherrightsapplicableenddate",
                    models.TextField(
                        blank=True,
                        db_column="otherRightsApplicableEndDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="Other rights end date",
                    ),
                ),
                (
                    "otherrightsenddateopen",
                    models.BooleanField(
                        db_column="otherRightsApplicableEndDateOpen",
                        default=False,
                        help_text="Indicate end date is open",
                        verbose_name="Open End Date",
                    ),
                ),
                (
                    "rightsstatement",
                    models.ForeignKey(
                        db_column="fkRightsStatement",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatement",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Other",
                "db_table": "RightsStatementOtherRightsInformation",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementRightsGranted",
            fields=[
                (
                    "id",
                    models.AutoField(db_column="pk", primary_key=True, serialize=False),
                ),
                ("act", models.TextField(db_column="act")),
                (
                    "startdate",
                    models.TextField(
                        blank=True,
                        db_column="startDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="Start",
                    ),
                ),
                (
                    "enddate",
                    models.TextField(
                        blank=True,
                        db_column="endDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="End",
                    ),
                ),
                (
                    "enddateopen",
                    models.BooleanField(
                        db_column="endDateOpen",
                        default=False,
                        help_text="Indicate end date is open",
                        verbose_name="Open End Date",
                    ),
                ),
                (
                    "rightsstatement",
                    models.ForeignKey(
                        db_column="fkRightsStatement",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatement",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Granted",
                "db_table": "RightsStatementRightsGranted",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementStatuteInformation",
            fields=[
                (
                    "id",
                    models.AutoField(db_column="pk", primary_key=True, serialize=False),
                ),
                (
                    "statutejurisdiction",
                    models.TextField(
                        db_column="statuteJurisdiction",
                        verbose_name="Statute jurisdiction",
                    ),
                ),
                (
                    "statutecitation",
                    models.TextField(
                        db_column="statuteCitation", verbose_name="Statute citation"
                    ),
                ),
                (
                    "statutedeterminationdate",
                    models.TextField(
                        blank=True,
                        db_column="statuteInformationDeterminationDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="Statute determination date",
                    ),
                ),
                (
                    "statuteapplicablestartdate",
                    models.TextField(
                        blank=True,
                        db_column="statuteApplicableStartDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="Statute start date",
                    ),
                ),
                (
                    "statuteapplicableenddate",
                    models.TextField(
                        blank=True,
                        db_column="statuteApplicableEndDate",
                        help_text="Use ISO 8061 (YYYY-MM-DD)",
                        null=True,
                        verbose_name="Statute end date",
                    ),
                ),
                (
                    "statuteenddateopen",
                    models.BooleanField(
                        db_column="statuteApplicableEndDateOpen",
                        default=False,
                        help_text="Indicate end date is open",
                        verbose_name="Open End Date",
                    ),
                ),
                (
                    "rightsstatement",
                    models.ForeignKey(
                        db_column="fkRightsStatement",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatement",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Statute",
                "db_table": "RightsStatementStatuteInformation",
            },
        ),
        migrations.CreateModel(
            name="Taxonomy",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_column="pk",
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "createdtime",
                    models.DateTimeField(
                        auto_now_add=True, db_column="createdTime", null=True
                    ),
                ),
                (
                    "name",
                    models.CharField(blank=True, db_column="name", max_length=255),
                ),
                ("type", models.CharField(default="open", max_length=50)),
            ],
            options={"db_table": "Taxonomies"},
        ),
        migrations.CreateModel(
            name="TransferMetadataField",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_column="pk",
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "createdtime",
                    models.DateTimeField(
                        auto_now_add=True, db_column="createdTime", null=True
                    ),
                ),
                (
                    "fieldlabel",
                    models.CharField(blank=True, db_column="fieldLabel", max_length=50),
                ),
                ("fieldname", models.CharField(db_column="fieldName", max_length=50)),
                ("fieldtype", models.CharField(db_column="fieldType", max_length=50)),
                ("sortorder", models.IntegerField(db_column="sortOrder", default=0)),
                (
                    "optiontaxonomy",
                    models.ForeignKey(
                        db_column="optionTaxonomyUUID",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.Taxonomy",
                    ),
                ),
            ],
            options={"db_table": "TransferMetadataFields"},
        ),
        migrations.CreateModel(
            name="TransferMetadataSet",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_column="pk",
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "createdtime",
                    models.DateTimeField(auto_now_add=True, db_column="createdTime"),
                ),
                ("createdbyuserid", models.IntegerField(db_column="createdByUserID")),
            ],
            options={"db_table": "TransferMetadataSets"},
        ),
        migrations.CreateModel(
            name="UnitVariable",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_column="pk",
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "unittype",
                    models.CharField(
                        blank=True, db_column="unitType", max_length=50, null=True
                    ),
                ),
                (
                    "unituuid",
                    models.CharField(
                        db_column="unitUUID",
                        help_text="Semantically a foreign key to SIP or Transfer",
                        max_length=36,
                        null=True,
                    ),
                ),
                ("variable", models.TextField(db_column="variable", null=True)),
                (
                    "variablevalue",
                    models.TextField(db_column="variableValue", null=True),
                ),
                (
                    "microservicechainlink",
                    models.UUIDField(
                        blank=True,
                        db_column="microServiceChainLink",
                        default=uuid.uuid4,
                        null=True,
                    ),
                ),
                (
                    "createdtime",
                    models.DateTimeField(auto_now_add=True, db_column="createdTime"),
                ),
                (
                    "updatedtime",
                    models.DateTimeField(auto_now=True, db_column="updatedTime"),
                ),
            ],
            options={"db_table": "UnitVariables"},
        ),
        migrations.CreateModel(
            name="TransferMetadataFieldValue",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_column="pk",
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "createdtime",
                    models.DateTimeField(auto_now_add=True, db_column="createdTime"),
                ),
                ("fieldvalue", models.TextField(blank=True, db_column="fieldValue")),
                (
                    "field",
                    models.ForeignKey(
                        db_column="fieldUUID",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.TransferMetadataField",
                    ),
                ),
                (
                    "set",
                    models.ForeignKey(
                        db_column="setUUID",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.TransferMetadataSet",
                    ),
                ),
            ],
            options={"db_table": "TransferMetadataFieldValues"},
        ),
        migrations.CreateModel(
            name="Transfer",
            fields=[
                (
                    "uuid",
                    models.CharField(
                        db_column="transferUUID",
                        max_length=36,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("currentlocation", models.TextField(db_column="currentLocation")),
                ("type", models.CharField(db_column="type", max_length=50)),
                ("accessionid", models.TextField(db_column="accessionID")),
                (
                    "sourceofacquisition",
                    models.TextField(blank=True, db_column="sourceOfAcquisition"),
                ),
                (
                    "typeoftransfer",
                    models.TextField(blank=True, db_column="typeOfTransfer"),
                ),
                ("description", models.TextField(blank=True)),
                ("notes", models.TextField(blank=True)),
                ("access_system_id", models.TextField(db_column="access_system_id")),
                ("hidden", models.BooleanField(default=False)),
                ("diruuids", models.BooleanField(db_column="dirUUIDs", default=False)),
                (
                    "transfermetadatasetrow",
                    models.ForeignKey(
                        blank=True,
                        db_column="transferMetadataSetRowUUID",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.TransferMetadataSet",
                    ),
                ),
            ],
            options={"db_table": "Transfers"},
        ),
        migrations.CreateModel(
            name="TaxonomyTerm",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_column="pk",
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "createdtime",
                    models.DateTimeField(
                        auto_now_add=True, db_column="createdTime", null=True
                    ),
                ),
                ("term", models.CharField(db_column="term", max_length=255)),
                (
                    "taxonomy",
                    models.ForeignKey(
                        db_column="taxonomyUUID",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.Taxonomy",
                    ),
                ),
            ],
            options={"db_table": "TaxonomyTerms"},
        ),
        migrations.CreateModel(
            name="Task",
            fields=[
                (
                    "taskuuid",
                    models.CharField(
                        db_column="taskUUID",
                        max_length=36,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("createdtime", models.DateTimeField(db_column="createdTime")),
                (
                    "fileuuid",
                    models.CharField(
                        blank=True, db_column="fileUUID", max_length=36, null=True
                    ),
                ),
                ("filename", models.TextField(blank=True, db_column="fileName")),
                (
                    "execution",
                    models.CharField(blank=True, db_column="exec", max_length=250),
                ),
                ("arguments", models.CharField(blank=True, max_length=1000)),
                (
                    "starttime",
                    models.DateTimeField(
                        db_column="startTime", default=None, null=True
                    ),
                ),
                (
                    "endtime",
                    models.DateTimeField(db_column="endTime", default=None, null=True),
                ),
                ("client", models.CharField(blank=True, max_length=50)),
                ("stdout", models.TextField(blank=True, db_column="stdOut")),
                ("stderror", models.TextField(blank=True, db_column="stdError")),
                (
                    "exitcode",
                    models.BigIntegerField(blank=True, db_column="exitCode", null=True),
                ),
                (
                    "job",
                    models.ForeignKey(
                        db_column="jobuuid",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.Job",
                    ),
                ),
            ],
            options={"db_table": "Tasks"},
        ),
        migrations.CreateModel(
            name="SIP",
            fields=[
                (
                    "uuid",
                    models.CharField(
                        db_column="sipUUID",
                        max_length=36,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "createdtime",
                    models.DateTimeField(auto_now_add=True, db_column="createdTime"),
                ),
                (
                    "currentpath",
                    models.TextField(blank=True, db_column="currentPath", null=True),
                ),
                ("hidden", models.BooleanField(default=False)),
                (
                    "aip_filename",
                    models.TextField(blank=True, db_column="aipFilename", null=True),
                ),
                (
                    "sip_type",
                    models.CharField(
                        choices=[
                            ("SIP", "SIP"),
                            ("AIC", "AIC"),
                            ("AIP-REIN", "Reingested AIP"),
                            ("AIC-REIN", "Reingested AIC"),
                        ],
                        db_column="sipType",
                        default="SIP",
                        max_length=8,
                    ),
                ),
                ("diruuids", models.BooleanField(db_column="dirUUIDs", default=False)),
                ("identifiers", models.ManyToManyField(to="main.Identifier")),
            ],
            options={"db_table": "SIPs"},
        ),
        migrations.CreateModel(
            name="RightsStatementStatuteInformationNote",
            fields=[
                (
                    "id",
                    models.AutoField(db_column="pk", primary_key=True, serialize=False),
                ),
                (
                    "statutenote",
                    models.TextField(
                        db_column="statuteNote", verbose_name="Statute note"
                    ),
                ),
                (
                    "rightsstatementstatute",
                    models.ForeignKey(
                        db_column="fkRightsStatementStatuteInformation",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatementStatuteInformation",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Statute: Note",
                "db_table": "RightsStatementStatuteInformationNote",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementStatuteDocumentationIdentifier",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "statutedocumentationidentifiertype",
                    models.TextField(
                        db_column="statuteDocumentationIdentifierType",
                        verbose_name="Statute document identification type",
                    ),
                ),
                (
                    "statutedocumentationidentifiervalue",
                    models.TextField(
                        db_column="statuteDocumentationIdentifierValue",
                        verbose_name="Statute document identification value",
                    ),
                ),
                (
                    "statutedocumentationidentifierrole",
                    models.TextField(
                        blank=True,
                        db_column="statuteDocumentationIdentifierRole",
                        null=True,
                        verbose_name="Statute document identification role",
                    ),
                ),
                (
                    "rightsstatementstatute",
                    models.ForeignKey(
                        db_column="fkRightsStatementStatuteInformation",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatementStatuteInformation",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Statute: Docs ID",
                "db_table": "RightsStatementStatuteDocumentationIdentifier",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementRightsGrantedRestriction",
            fields=[
                (
                    "id",
                    models.AutoField(db_column="pk", primary_key=True, serialize=False),
                ),
                ("restriction", models.TextField(db_column="restriction")),
                (
                    "rightsgranted",
                    models.ForeignKey(
                        db_column="fkRightsStatementRightsGranted",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="restrictions",
                        to="main.RightsStatementRightsGranted",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Granted: Restriction",
                "db_table": "RightsStatementRightsGrantedRestriction",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementRightsGrantedNote",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "rightsgrantednote",
                    models.TextField(
                        db_column="rightsGrantedNote", verbose_name="Rights note"
                    ),
                ),
                (
                    "rightsgranted",
                    models.ForeignKey(
                        db_column="fkRightsStatementRightsGranted",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notes",
                        to="main.RightsStatementRightsGranted",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Granted: Note",
                "db_table": "RightsStatementRightsGrantedNote",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementOtherRightsInformationNote",
            fields=[
                (
                    "id",
                    models.AutoField(db_column="pk", primary_key=True, serialize=False),
                ),
                (
                    "otherrightsnote",
                    models.TextField(
                        db_column="otherRightsNote", verbose_name="Other rights note"
                    ),
                ),
                (
                    "rightsstatementotherrights",
                    models.ForeignKey(
                        db_column="fkRightsStatementOtherRightsInformation",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatementOtherRightsInformation",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Other: Note",
                "db_table": "RightsStatementOtherRightsNote",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementOtherRightsDocumentationIdentifier",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "otherrightsdocumentationidentifiertype",
                    models.TextField(
                        db_column="otherRightsDocumentationIdentifierType",
                        verbose_name="Other rights document identification type",
                    ),
                ),
                (
                    "otherrightsdocumentationidentifiervalue",
                    models.TextField(
                        db_column="otherRightsDocumentationIdentifierValue",
                        verbose_name="Other right document identification value",
                    ),
                ),
                (
                    "otherrightsdocumentationidentifierrole",
                    models.TextField(
                        blank=True,
                        db_column="otherRightsDocumentationIdentifierRole",
                        null=True,
                        verbose_name="Other rights document identification role",
                    ),
                ),
                (
                    "rightsstatementotherrights",
                    models.ForeignKey(
                        db_column="fkRightsStatementOtherRightsInformation",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatementOtherRightsInformation",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Other: Docs ID",
                "db_table": "RightsStatementOtherRightsDocumentationIdentifier",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementLinkingAgentIdentifier",
            fields=[
                (
                    "id",
                    models.AutoField(db_column="pk", primary_key=True, serialize=False),
                ),
                (
                    "linkingagentidentifiertype",
                    models.TextField(
                        blank=True,
                        db_column="linkingAgentIdentifierType",
                        verbose_name="Linking Agent",
                    ),
                ),
                (
                    "linkingagentidentifiervalue",
                    models.TextField(
                        blank=True,
                        db_column="linkingAgentIdentifierValue",
                        verbose_name="Linking Agent Value",
                    ),
                ),
                (
                    "rightsstatement",
                    models.ForeignKey(
                        db_column="fkRightsStatement",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatement",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Agent",
                "db_table": "RightsStatementLinkingAgentIdentifier",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementLicenseNote",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "licensenote",
                    models.TextField(
                        db_column="licenseNote", verbose_name="License note"
                    ),
                ),
                (
                    "rightsstatementlicense",
                    models.ForeignKey(
                        db_column="fkRightsStatementLicense",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatementLicense",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: License: Note",
                "db_table": "RightsStatementLicenseNote",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementLicenseDocumentationIdentifier",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "licensedocumentationidentifiertype",
                    models.TextField(
                        db_column="licenseDocumentationIdentifierType",
                        verbose_name="License documentation identification type",
                    ),
                ),
                (
                    "licensedocumentationidentifiervalue",
                    models.TextField(
                        db_column="licenseDocumentationIdentifierValue",
                        verbose_name="License documentation identification value",
                    ),
                ),
                (
                    "licensedocumentationidentifierrole",
                    models.TextField(
                        blank=True,
                        db_column="licenseDocumentationIdentifierRole",
                        null=True,
                        verbose_name="License document identification role",
                    ),
                ),
                (
                    "rightsstatementlicense",
                    models.ForeignKey(
                        db_column="fkRightsStatementLicense",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatementLicense",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: License: Docs ID",
                "db_table": "RightsStatementLicenseDocumentationIdentifier",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementCopyrightNote",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "copyrightnote",
                    models.TextField(
                        db_column="copyrightNote", verbose_name="Copyright note"
                    ),
                ),
                (
                    "rightscopyright",
                    models.ForeignKey(
                        db_column="fkRightsStatementCopyrightInformation",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatementCopyright",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Copyright: Note",
                "db_table": "RightsStatementCopyrightNote",
            },
        ),
        migrations.CreateModel(
            name="RightsStatementCopyrightDocumentationIdentifier",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "copyrightdocumentationidentifiertype",
                    models.TextField(
                        db_column="copyrightDocumentationIdentifierType",
                        verbose_name="Copyright document identification type",
                    ),
                ),
                (
                    "copyrightdocumentationidentifiervalue",
                    models.TextField(
                        db_column="copyrightDocumentationIdentifierValue",
                        verbose_name="Copyright document identification value",
                    ),
                ),
                (
                    "copyrightdocumentationidentifierrole",
                    models.TextField(
                        blank=True,
                        db_column="copyrightDocumentationIdentifierRole",
                        null=True,
                        verbose_name="Copyright document identification role",
                    ),
                ),
                (
                    "rightscopyright",
                    models.ForeignKey(
                        db_column="fkRightsStatementCopyrightInformation",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.RightsStatementCopyright",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rights: Copyright: Docs ID",
                "db_table": "RightsStatementCopyrightDocumentationIdentifier",
            },
        ),
        migrations.CreateModel(
            name="FPCommandOutput",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("content", models.TextField(null=True)),
                (
                    "file",
                    models.ForeignKey(
                        db_column="fileUUID",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.File",
                    ),
                ),
                (
                    "rule",
                    models.ForeignKey(
                        db_column="ruleUUID",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="fpr.FPRule",
                        to_field="uuid",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="FileID",
            fields=[
                (
                    "id",
                    models.AutoField(db_column="pk", primary_key=True, serialize=False),
                ),
                ("format_name", models.TextField(blank=True, db_column="formatName")),
                (
                    "format_version",
                    models.TextField(blank=True, db_column="formatVersion"),
                ),
                (
                    "format_registry_name",
                    models.TextField(blank=True, db_column="formatRegistryName"),
                ),
                (
                    "format_registry_key",
                    models.TextField(blank=True, db_column="formatRegistryKey"),
                ),
                (
                    "file",
                    models.ForeignKey(
                        blank=True,
                        db_column="fileUUID",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.File",
                    ),
                ),
            ],
            options={"db_table": "FilesIDs"},
        ),
        migrations.CreateModel(
            name="FileFormatVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "file_uuid",
                    models.ForeignKey(
                        db_column="fileUUID",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.File",
                    ),
                ),
                (
                    "format_version",
                    models.ForeignKey(
                        db_column="fileID",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="fpr.FormatVersion",
                        to_field="uuid",
                    ),
                ),
            ],
            options={"db_table": "FilesIdentifiedIDs"},
        ),
        migrations.AddField(
            model_name="file",
            name="identifiers",
            field=models.ManyToManyField(to="main.Identifier"),
        ),
        migrations.AddField(
            model_name="file",
            name="sip",
            field=models.ForeignKey(
                blank=True,
                db_column="sipUUID",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="main.SIP",
            ),
        ),
        migrations.AddField(
            model_name="file",
            name="transfer",
            field=models.ForeignKey(
                blank=True,
                db_column="transferUUID",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="main.Transfer",
            ),
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "event_id",
                    models.UUIDField(
                        db_column="eventIdentifierUUID",
                        default=uuid.uuid4,
                        null=True,
                        unique=True,
                    ),
                ),
                ("event_type", models.TextField(blank=True, db_column="eventType")),
                (
                    "event_datetime",
                    models.DateTimeField(auto_now=True, db_column="eventDateTime"),
                ),
                ("event_detail", models.TextField(blank=True, db_column="eventDetail")),
                (
                    "event_outcome",
                    models.TextField(blank=True, db_column="eventOutcome"),
                ),
                (
                    "event_outcome_detail",
                    models.TextField(blank=True, db_column="eventOutcomeDetailNote"),
                ),
                ("agents", models.ManyToManyField(to="main.Agent")),
                (
                    "file_uuid",
                    models.ForeignKey(
                        blank=True,
                        db_column="fileUUID",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.File",
                    ),
                ),
            ],
            options={"db_table": "Events"},
        ),
        migrations.CreateModel(
            name="DublinCore",
            fields=[
                (
                    "id",
                    models.AutoField(db_column="pk", primary_key=True, serialize=False),
                ),
                (
                    "metadataappliestoidentifier",
                    models.CharField(
                        blank=True,
                        db_column="metadataAppliesToidentifier",
                        default=None,
                        max_length=36,
                        null=True,
                    ),
                ),
                ("title", models.TextField(blank=True, db_column="title")),
                (
                    "is_part_of",
                    models.TextField(
                        blank=True,
                        db_column="isPartOf",
                        help_text="Optional: leave blank if unsure",
                        verbose_name="Part of AIC",
                    ),
                ),
                ("creator", models.TextField(blank=True, db_column="creator")),
                ("subject", models.TextField(blank=True, db_column="subject")),
                ("description", models.TextField(blank=True, db_column="description")),
                ("publisher", models.TextField(blank=True, db_column="publisher")),
                ("contributor", models.TextField(blank=True, db_column="contributor")),
                (
                    "date",
                    models.TextField(
                        blank=True,
                        db_column="date",
                        help_text="Use ISO 8601 (YYYY-MM-DD or YYYY-MM-DD/YYYY-MM-DD)",
                    ),
                ),
                ("type", models.TextField(blank=True, db_column="type")),
                ("format", models.TextField(blank=True, db_column="format")),
                ("identifier", models.TextField(blank=True, db_column="identifier")),
                ("source", models.TextField(blank=True, db_column="source")),
                ("relation", models.TextField(blank=True, db_column="relation")),
                (
                    "language",
                    models.TextField(
                        blank=True, db_column="language", help_text="Use ISO 639"
                    ),
                ),
                ("coverage", models.TextField(blank=True, db_column="coverage")),
                ("rights", models.TextField(blank=True, db_column="rights")),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("ORIGINAL", "original"),
                            ("REINGEST", "parsed from reingest"),
                            ("UPDATED", "updated"),
                        ],
                        db_column="status",
                        default="ORIGINAL",
                        max_length=8,
                    ),
                ),
                (
                    "metadataappliestotype",
                    models.ForeignKey(
                        db_column="metadataAppliesToType",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.MetadataAppliesToType",
                    ),
                ),
            ],
            options={"db_table": "Dublincore"},
        ),
        migrations.CreateModel(
            name="Directory",
            fields=[
                (
                    "uuid",
                    models.CharField(
                        db_column="directoryUUID",
                        max_length=36,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "originallocation",
                    a3m.main.models.BlobTextField(db_column="originalLocation"),
                ),
                (
                    "currentlocation",
                    a3m.main.models.BlobTextField(
                        db_column="currentLocation", null=True
                    ),
                ),
                (
                    "enteredsystem",
                    models.DateTimeField(auto_now_add=True, db_column="enteredSystem"),
                ),
                ("identifiers", models.ManyToManyField(to="main.Identifier")),
                (
                    "sip",
                    models.ForeignKey(
                        blank=True,
                        db_column="sipUUID",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.SIP",
                    ),
                ),
                (
                    "transfer",
                    models.ForeignKey(
                        blank=True,
                        db_column="transferUUID",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.Transfer",
                    ),
                ),
            ],
            options={"db_table": "Directories"},
        ),
        migrations.CreateModel(
            name="Derivation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        db_column="pk",
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "derived_file",
                    models.ForeignKey(
                        db_column="derivedFileUUID",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="original_file_set",
                        to="main.File",
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        blank=True,
                        db_column="relatedEventUUID",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="main.Event",
                        to_field="event_id",
                    ),
                ),
                (
                    "source_file",
                    models.ForeignKey(
                        db_column="sourceFileUUID",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="derived_file_set",
                        to="main.File",
                    ),
                ),
            ],
            options={"db_table": "Derivations"},
        ),
        migrations.AlterIndexTogether(
            name="file", index_together={("sip", "filegrpuse")}
        ),
    ]
