# This file is part of Archivematica.
#
# Copyright 2010-2013 Artefactual Systems Inc. <http://artefactual.com>
#
# Archivematica is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Archivematica is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Archivematica.  If not, see <http://www.gnu.org/licenses/>.
# fileOperations requires Django to be set up
from django.db import transaction

from a3m.fileOperations import updateFileGrpUse


def call(jobs):
    with transaction.atomic():
        for job in jobs:
            with job.JobContext():
                fileUUID = job.args[1]
                updateFileGrpUse(fileUUID, "manualNormalization")
