"""Add EmailTemplate model

Revision ID: 2501f74d0c55
Revises: 67c0904f3ebc
Create Date: 2022-10-28 16:00:00.652479

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "2501f74d0c55"
down_revision = "67c0904f3ebc"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "fief_email_templates",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("type", sa.String(length=255), nullable=False),
        sa.Column("subject", sa.Text(), nullable=False),
        sa.Column("content", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("type"),
    )
    op.create_index(
        op.f("ix_fief_email_templates_created_at"),
        "fief_email_templates",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_fief_email_templates_updated_at"),
        "fief_email_templates",
        ["updated_at"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_fief_email_templates_updated_at"), table_name="fief_email_templates"
    )
    op.drop_index(
        op.f("ix_fief_email_templates_created_at"), table_name="fief_email_templates"
    )
    op.drop_table("fief_email_templates")
    # ### end Alembic commands ###
