"""Tests for the `cli` module."""

import sys

import pytest

from griffe import cli


def test_main():
    """Basic CLI test."""
    if sys.platform == "win32":
        assert cli.main(["griffe", "-s", "src", "-oNUL"]) == 0
    else:
        assert cli.main(["griffe", "-s", "src", "-o/dev/null"]) == 0


def test_show_help(capsys):
    """
    Show help.

    Parameters:
        capsys: Pytest fixture to capture output.
    """
    with pytest.raises(SystemExit):
        cli.main(["-h"])
    captured = capsys.readouterr()
    assert "griffe" in captured.out
