# coding:utf8
__doc__ = 'play music with beep command'
__author__ = 'Peng Shulin <trees_peng@163.com>'
__license__ = 'MCUSH designed by Peng Shulin, all rights reserved.'
import time
from .. import Mcush


OK = '2+:/4 5:/8'
QUESTION = '5:/8 2+:/4 '
POWERON = '1:/8 3:/8 2:/8 2+:/8 '
POWEROFF = '2+:/8 2:/8 3:/8 1:/8 '

WAHAHA = '''
a3:/2 e:/4 e:/4 e:/2 e:/2   f:/2 f:/4 a:/4 e:1
d:/2 d:/4 d:/4 d:/2 c:/2 d:/2 d:/4 e:/4 a3:1
d:/2 d:/4 d:/4 d:/2 a3:/4 b3:/4   c:/2 c:/4 c:/4 c:/2 b3:/4 a3:/4
b3:/2 b:/4 b:/4 b:/4 d:/4 c:/4 b:/4   a3:/2 a3:/2 a3:1
d:/2 d:/2 d:/2 a3:/4 b3:/4   c:/2 c:/2 c:/2 b3:/4 a3:/4
b3:/2 b3:/4 b3:/4 b3:/4 d:/4 c:/4 b3:/4 a3:/2 a3:/2 a3:/1
'''

JINGLE_BELLS = '''
5-:/2 5-:/2 3:/2 2:/2 1:/2 5-  5:/4 5:/4 5-:/2 3:/2 2:/2 1:/2 6-:1
6-:/2 6-:/2 4:/2 3:/2 2:/2 7-:1.5   7-:/2 5:/2 5:/2 4:/2 2:/2 3:1
1:/2 5-:/2 5-:/2 3:/2 2:/2 1:/2 5-:1.5  5-:/2 5-:/2 3:/2 2:/2 1:/2 6-:1.5
6-:/2 6-:/2 4:/2 3:/2 2:/2 5:/2 5:/2 5:/2 5:/2 6:/2 5:/2 4:/2 2:/2 1:1.5
3:/2 3:/2 3 3:/2 3:/2 3 3:/2 5:/2 1:/2 2:/2 3:3
4:/2 4:/2 4:1.5 4:/4 4:/2 3:/2 3:/2 3:/4 3:/4 3:/2 2:/2 2:/2 1:/2 2:/2 5:1.5
5:/2 5:/2 4:/2 2:/2 1
'''

LOVE_SONG = '''
3 4:/2 5:/2 3 2:/2 1:/2 3 4:/2 5:/2 3:2
5 6:/2 1+:/2 7 6:/2 5:/2 4:1.5 6:/2 5:/2 4:/2 3:/2 2:/4 1:/4
3 4:/2 5:/2 3 2:/2 1:/2 3 4:/2 5:/2 3:2
5 6:/2 1+:/2 7 6:/2 5:/2 4:1.5 6:/2 5:/2 4:/2 3:/2 2:/4 1:/4
3 4:/2 5:/2 3 2:/2 1:/2 3 4:/2 5:/2 3:2
1+:/2 7:/4 1+/2 7:/4 0:/2 6:/2 6:/2 5:/2 4:/2 3:/2 5:3
'''

ALISE = '''
3+:/4 2#+:/4 3+:/4 2#+:/4 3+:/4 7:/4 2+:/4 1+:/4
6:/2 1:/4 3:/4 6:/4 7:/2 3:/4 5#:/4 7:/4
1+:/2 3:/4 3+:/4 2#+:/4  3+:/4 2#+:/4 3+:/4 7:/4 2+:/4 1+:/4
6:/2 1:/4 3:/4 6:/4 7:/2 3:/4 1+:/4 7:/4 6:/2 7:/4 1+:/4 2+:/4
3+:/2 5:/4 4+:/4 3+:/4 2+:/2 4:/4 3+:/4 2+:/4 1+:/2 3:/4 2+:/4 1+:/4
7:/2 7:/4 0:/4 3:/4 3+:1.5 3+:/4 3+:/4 2+:/4 3+:/4 2#+:/4 3+:/4 7:/4 2+:/4 1+:/4
6:/2 1:/4 3:/4 6:/4 7:/2 3:/4 5#:/4 7:/4 1+:/2 3:/4 3+:/4 2#+:/4
3+:/4 2#+:/4 3+:/4 7:/4 2+:/4 1+:/4  6:/2 1:/4 3:/4 6:/4 7:/2 3:/4 1+:/4 7:/4 6:/2 0:/4
1+ 4+:/4 3+:/8 4+:/2 2+:/2 2+:/4 4+:/8
6+:/4 5+:/4 4+:/4 3+:/4 2+:/4 1+:/4 7:/2 6:/2 6:/8 5:/8 6:/8 7:/8
1+ 2+:/4 2#+:/4 3+ 4+:/4 6:/4 1+ 2:/4 7:/8 1+:/4 0:/4 2+:/4 0:/4 3+:/4 0:/4
'''

DORAEMON = '''
5-:/2 1:/2 1:/2 3:/2 5:/2 3:/2 5:1     5:/2 6:/2 5:/2 3:/2 4:/2 3:/2 2:1
6-:/2 2:/2 2:/2 4:/2 7:/2 7:/2 6:/2 5:/2    4:1 4:/2 3:/2 6-:/2 7-:/2 7-:/2 1:/2 2:4
5-:/2 1:/2 1:/2 3:/2 5:/2 3:/2 5:1     5:/2 6:/2 5:/2 3:/2 4:/2 3:/2 2:1
6-:/2 2:/2 2:/2 4:/2 7:/2 7:/2 6:/2 5:/2 4:1 3:/2 2:/2 7-:1 2:1 1:4
6:1 6:/2 5:/2 4:/4 5:/4 6:/4 5:1   2:/2 3:/2 4#:/2 2:/2 5:2
6:1 5:1 4:2  2:1 7:/2 6:/2 5:/2 6:/2 5:/2 4:/2 4:1 5:/2 6:/2 3:1.5 2:/2 1:4
'''

DO_RE_MI = '''
1:1.5 2:/2 3:1.5 1:/2 3 1 3:2  2:1.5 3:/2 4:/2 4:/2 3:/2 2:/2 4:4
3:1.5 4:/2 5:1.5 3:/2 5 3 5:2  4:1.5 5:/2 6:/2 6:/2 5:/2 4:/2 6:4
5:1.5 1:/2 2:/2 3:/2 4:/2 5:/2 6:4   6:1.5 2:/2 3#:/2 4#:/2 5:/2 6:/2 7:4
7:1.5 3:/2 4#:/2 5#:/2 6:/2 7:/2 1+:/2
1+:/2 0:/2 7b:/2 7:/2 6 4 7 5 1+ 5 3 2
'''




BEEP_NOTE_FREQS = {
'c0':16, 'c#0':17, 'db0':17, 'd0':18, 'd#0':19, 'eb0':19, 'e0':20, 
'f0':21, 'f#0':23, 'gb0':23, 'g0':24, 'g#0':25, 'ab0':25, 'a0':27,
'a#0':29, 'bb0':29, 'b0':30, 'c1':32, 'c#1':34, 'db1':34, 'd1':36,
'd#1':38, 'eb1':38, 'e1':41, 'f1':43, 'f#1':46, 'gb1':46, 'g1':48,
'g#1':51, 'ab1':51, 'a1':55, 'a#1':58, 'bb1':58, 'b1':61, 'c2':65,
'c#2':69, 'db2':69, 'd2':73, 'd#2':77, 'eb2':77, 'e2':82, 'f2':87,
'f#2':92, 'gb2':92, 'g2':97, 'g#2':103, 'ab2':103, 'a2':110,
'a#2':116, 'bb2':116, 'b2':123, 'c3':130, 'c#3':138, 'db3':138,
'd3':146, 'd#3':155, 'eb3':155, 'e3':164, 'f3':174, 'f#3':184,
'gb3':184, 'g3':195, 'g#3':207, 'ab3':207, 'a3':220, 'a#3':233,
'bb3':233, 'b3':246, 'c':261, 'c#':277, 'db':277, 'd':293, 'd#':311,
'eb':311, 'e':329, 'f':349, 'f#':369, 'gb':369, 'g':391, 'g#':415,
'ab':415, 'a':440, 'a#':466, 'bb':466, 'b':493, 'c4':261, 'c#4':277,
'db4':277, 'd4':293, 'd#4':311, 'eb4':311, 'e4':329, 'f4':349,
'f#4':369, 'gb4':369, 'g4':391, 'g#4':415, 'ab4':415, 'a4':440,
'a#4':466, 'bb4':466, 'b4':493, 'c5':523, 'c#5':554, 'db5':554,
'd5':587, 'd#5':622, 'eb5':622, 'e5':659, 'f5':698, 'f#5':739,
'gb5':739, 'g5':783, 'g#5':830, 'ab5':830, 'a5':880, 'a#5':932,
'bb5':932, 'b5':987, 'c6':1046, 'c#6':1108, 'db6':1108, 'd6':1174,
'd#6':1244, 'eb6':1244, 'e6':1318, 'f6':1396, 'f#6':1479, 'gb6':1479,
'g6':1567, 'g#6':1661, 'ab6':1661, 'a6':1760, 'a#6':1864, 'bb6':1864,
'b6':1975, 'c7':2093, 'c#7':2217, 'db7':2217, 'd7':2349, 'd#7':2489,
'eb7':2489, 'e7':2637, 'f7':2793, 'f#7':2959, 'gb7':2959, 'g7':3135,
'g#7':3322, 'ab7':3322, 'a7':3520, 'a#7':3729, 'bb7':3729, 'b7':3951, 
'c8':4186, 'c#8':4434, 'db8':4434, 'd8':4698, 'd#8':4978, 'eb8':4978,
'e8':5274, 'f8':5587, 'f#8':5919, 'gb8':5919, 'g8':6271, 'g#8':6644,
'ab8':6644, 'a8':7040, 'a#8':7458, 'bb8':7458, 'b8':7902, 'c9':8372,
'c#9':8869, 'db9':8869, 'd9':9397, 'd#9':9956, 'eb9':9956, 'e9':10548,
'f9':11175, 'f#9':11839, 'gb9':11839, 'g9':12543, '1--':65, '1#--':69,
'2b--':69, '2--':73, '2#--':77, '3b--':77, '3--':82, '4--':87,
'4#--':92, '5b--':92, '5--':97, '5#--':103, '6b--':103, '6--':110, 
'6#--':116, '7b--':116, '7--':123, '1-':130, '1#-':138, '2b-':138,
'2-':146, '2#-':155, '3b-':155, '3-':164, '4-':174, '4#-':184,
'5b-':184, '5-':195, '5#-':207, '6b-':207, '6-':220, '6#-':233,
'7b-':233, '7-':246, '1':261, '1#':277, '2b':277, '2':293, '2#':311,
'3b':311, '3':329, '4':349, '4#':369, '5b':369, '5':391, '5#':415,
'6b':415, '6':440, '6#':466, '7b':466, '7':493, '1+':523, '1#+':554,
'2b+':554, '2+':587, '2#+':622, '3b+':622, '3+':659, '4+':698,
'4#+':739, '5b+':739, '5+':783, '5#+':830, '6b+':830, '6+':880,
'6#+':932, '7b+':932, '7+':987, '1++':1046, '1#++':1108,
'2b++':1108, '2++':1174, '2#++':1244, '3b++':1244, '3++':1318,
'4++':1396, '4#++':1479, '5b++':1479, '5++':1567, '5#++':1661,
'6b++':1661, '6++':1760, '6#++':1864, '7b++':1864, '7++':1975, 
}

   

class BeepPlayer():

    def __init__( self, controller ):
        self.controller = controller

    def beep_code( self, code, tick=0.5 ):
        '''play music code'''
        if isinstance(code,list):
            code = ' '.join(code)
        lastnote, lastdelay = '0', '1'
        for i in code.split():
            i = i.strip()
            if not i:
                continue
            if i.find(':') >= 0:
                note, delay = i.split(':')
                if not note:
                    note = lastnote
                if not delay:
                    delay = lastdelay
            else:
                note = i
                delay = '1'
            if delay == '~':
                delay = lastdelay
            if note == '~':
                note = lastnote
            lastnote, lastdelay = note, delay
            if delay.startswith( '/' ):
                delay = tick / int(delay[1:])
            else:
                delay = float(delay)*tick
            if note == '0':
                time.sleep( delay )
                continue
            #if not ord('0') <= ord(note[-1]) <= ord('9'):  c += '4'  # default
            if note in BEEP_NOTE_FREQS:
                freq = BEEP_NOTE_FREQS[note]
                self.controller.beep( freq, delay )
                #time.sleep( delay )
            else:
                print( 'error note %s'% note )
     
    def play( self, code, tick=0.5 ):
        self.beep_code( code, tick )
        
    def play_ok( self ):
        self.beep_code( OK )

    def play_question( self ):
        self.beep_code( QUESTION )

    def play_poweron( self ):
        self.beep_code( POWERON )

    def play_poweroff( self ):
        self.beep_code( POWEROFF )



