# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.9.7, generator: @autorest/python@6.11.1)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from io import IOBase
from typing import (
    IO,
    Any,
    Callable,
    Dict,
    Iterator,
    List,
    Optional,
    TypeVar,
    Union,
    cast,
    overload,
)

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._serialization import Serializer
from .._vendor import raise_if_not_implemented

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import (
        MutableMapping,  # type: ignore  # pylint: disable=ungrouped-imports
    )
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[
    Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]
]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_audits_label_request(audit_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/audits/{audit_id}/labels"
    path_format_arguments = {
        "audit_id": _SERIALIZER.url("audit_id", audit_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_audits_query_request(
    *,
    id: Optional[str] = None,
    account: Optional[str] = None,
    status: Optional[str] = None,
    reason: Optional[str] = None,
    labels: Optional[str] = None,
    name: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/audits"

    # Construct parameters
    if id is not None:
        _params["id"] = _SERIALIZER.query("id", id, "str")
    if account is not None:
        _params["account"] = _SERIALIZER.query("account", account, "str")
    if status is not None:
        _params["status"] = _SERIALIZER.query("status", status, "str")
    if reason is not None:
        _params["reason"] = _SERIALIZER.query("reason", reason, "str")
    if labels is not None:
        _params["labels"] = _SERIALIZER.query("labels", labels, "str")
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_audits_get_request(audit_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/audits/{audit_id}"
    path_format_arguments = {
        "audit_id": _SERIALIZER.url("audit_id", audit_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_audits_delete_request(audit_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/audits/{audit_id}/delete"
    path_format_arguments = {
        "audit_id": _SERIALIZER.url("audit_id", audit_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_auditprocedures_download_request(path: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/auditprocedures/{path}/download"
    path_format_arguments = {
        "path": _SERIALIZER.url("path", path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_datasets_label_request(dataset_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/datasets/{dataset_id}/labels"
    path_format_arguments = {
        "dataset_id": _SERIALIZER.url("dataset_id", dataset_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_datasets_query_request(
    *,
    id: Optional[str] = None,
    account: Optional[str] = None,
    status: Optional[str] = None,
    reason: Optional[str] = None,
    labels: Optional[str] = None,
    name: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/datasets"

    # Construct parameters
    if id is not None:
        _params["id"] = _SERIALIZER.query("id", id, "str")
    if account is not None:
        _params["account"] = _SERIALIZER.query("account", account, "str")
    if status is not None:
        _params["status"] = _SERIALIZER.query("status", status, "str")
    if reason is not None:
        _params["reason"] = _SERIALIZER.query("reason", reason, "str")
    if labels is not None:
        _params["labels"] = _SERIALIZER.query("labels", labels, "str")
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_datasets_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/datasets"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_datasets_get_request(dataset_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/datasets/{dataset_id}"
    path_format_arguments = {
        "dataset_id": _SERIALIZER.url("dataset_id", dataset_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_datasets_strata_request(dataset_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/datasets/{dataset_id}/strata"
    path_format_arguments = {
        "dataset_id": _SERIALIZER.url("dataset_id", dataset_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_datasets_data_request(dataset_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/datasets/{dataset_id}/data"
    path_format_arguments = {
        "dataset_id": _SERIALIZER.url("dataset_id", dataset_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_datasets_delete_request(dataset_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/datasets/{dataset_id}/delete"
    path_format_arguments = {
        "dataset_id": _SERIALIZER.url("dataset_id", dataset_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_datasets_upload_request(
    dataset_id: str, artifact_path: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/datasets/{dataset_id}/upload/{artifact_path}"
    path_format_arguments = {
        "dataset_id": _SERIALIZER.url("dataset_id", dataset_id, "str"),
        "artifact_path": _SERIALIZER.url("artifact_path", artifact_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_datasets_finalize_request(dataset_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/datasets/{dataset_id}/finalize"
    path_format_arguments = {
        "dataset_id": _SERIALIZER.url("dataset_id", dataset_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_evaluations_label_request(evaluation_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/evaluations/{evaluation_id}/labels"
    path_format_arguments = {
        "evaluation_id": _SERIALIZER.url("evaluation_id", evaluation_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_evaluations_query_request(
    *,
    id: Optional[str] = None,
    account: Optional[str] = None,
    status: Optional[str] = None,
    reason: Optional[str] = None,
    labels: Optional[str] = None,
    dataset: Optional[str] = None,
    inference_service: Optional[str] = None,
    inference_service_name: Optional[str] = None,
    model: Optional[str] = None,
    model_name: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/evaluations"

    # Construct parameters
    if id is not None:
        _params["id"] = _SERIALIZER.query("id", id, "str")
    if account is not None:
        _params["account"] = _SERIALIZER.query("account", account, "str")
    if status is not None:
        _params["status"] = _SERIALIZER.query("status", status, "str")
    if reason is not None:
        _params["reason"] = _SERIALIZER.query("reason", reason, "str")
    if labels is not None:
        _params["labels"] = _SERIALIZER.query("labels", labels, "str")
    if dataset is not None:
        _params["dataset"] = _SERIALIZER.query("dataset", dataset, "str")
    if inference_service is not None:
        _params["inferenceService"] = _SERIALIZER.query(
            "inference_service", inference_service, "str"
        )
    if inference_service_name is not None:
        _params["inferenceServiceName"] = _SERIALIZER.query(
            "inference_service_name", inference_service_name, "str"
        )
    if model is not None:
        _params["model"] = _SERIALIZER.query("model", model, "str")
    if model_name is not None:
        _params["modelName"] = _SERIALIZER.query("model_name", model_name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_evaluations_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/evaluations"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_evaluations_get_request(evaluation_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/evaluations/{evaluation_id}"
    path_format_arguments = {
        "evaluation_id": _SERIALIZER.url("evaluation_id", evaluation_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_evaluations_delete_request(evaluation_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/evaluations/{evaluation_id}/delete"
    path_format_arguments = {
        "evaluation_id": _SERIALIZER.url("evaluation_id", evaluation_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_inferenceservices_label_request(
    service_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferenceservices/{service_id}/labels"
    path_format_arguments = {
        "service_id": _SERIALIZER.url("service_id", service_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_inferenceservices_query_request(
    *,
    id: Optional[str] = None,
    account: Optional[str] = None,
    status: Optional[str] = None,
    reason: Optional[str] = None,
    labels: Optional[str] = None,
    name: Optional[str] = None,
    model: Optional[str] = None,
    model_name: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferenceservices"

    # Construct parameters
    if id is not None:
        _params["id"] = _SERIALIZER.query("id", id, "str")
    if account is not None:
        _params["account"] = _SERIALIZER.query("account", account, "str")
    if status is not None:
        _params["status"] = _SERIALIZER.query("status", status, "str")
    if reason is not None:
        _params["reason"] = _SERIALIZER.query("reason", reason, "str")
    if labels is not None:
        _params["labels"] = _SERIALIZER.query("labels", labels, "str")
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")
    if model is not None:
        _params["model"] = _SERIALIZER.query("model", model, "str")
    if model_name is not None:
        _params["modelName"] = _SERIALIZER.query("model_name", model_name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_inferenceservices_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferenceservices"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_inferenceservices_get_request(service_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferenceservices/{service_id}"
    path_format_arguments = {
        "service_id": _SERIALIZER.url("service_id", service_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_inferenceservices_delete_request(
    service_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferenceservices/{service_id}/delete"
    path_format_arguments = {
        "service_id": _SERIALIZER.url("service_id", service_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_inferencesessions_label_request(
    session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferencesessions/{session_id}/labels"
    path_format_arguments = {
        "session_id": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_inferencesessions_query_request(
    *,
    id: Optional[str] = None,
    account: Optional[str] = None,
    status: Optional[str] = None,
    reason: Optional[str] = None,
    labels: Optional[str] = None,
    name: Optional[str] = None,
    inference_service: Optional[str] = None,
    inference_service_name: Optional[str] = None,
    model: Optional[str] = None,
    model_name: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferencesessions"

    # Construct parameters
    if id is not None:
        _params["id"] = _SERIALIZER.query("id", id, "str")
    if account is not None:
        _params["account"] = _SERIALIZER.query("account", account, "str")
    if status is not None:
        _params["status"] = _SERIALIZER.query("status", status, "str")
    if reason is not None:
        _params["reason"] = _SERIALIZER.query("reason", reason, "str")
    if labels is not None:
        _params["labels"] = _SERIALIZER.query("labels", labels, "str")
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")
    if inference_service is not None:
        _params["inferenceService"] = _SERIALIZER.query(
            "inference_service", inference_service, "str"
        )
    if inference_service_name is not None:
        _params["inferenceServiceName"] = _SERIALIZER.query(
            "inference_service_name", inference_service_name, "str"
        )
    if model is not None:
        _params["model"] = _SERIALIZER.query("model", model, "str")
    if model_name is not None:
        _params["modelName"] = _SERIALIZER.query("model_name", model_name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_inferencesessions_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferencesessions"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_inferencesessions_get_request(session_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferencesessions/{session_id}"
    path_format_arguments = {
        "session_id": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_inferencesessions_delete_request(
    session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferencesessions/{session_id}/delete"
    path_format_arguments = {
        "session_id": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_inferencesessions_terminate_request(  # pylint: disable=name-too-long
    session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferencesessions/{session_id}/terminate"
    path_format_arguments = {
        "session_id": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_inferencesessions_infer_request(
    session_id: str, inference_endpoint: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferencesessions/{session_id}/infer/{inference_endpoint}"
    path_format_arguments = {
        "session_id": _SERIALIZER.url("session_id", session_id, "str"),
        "inference_endpoint": _SERIALIZER.url(
            "inference_endpoint", inference_endpoint, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_inferencesessions_token_request(
    session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferencesessions/{session_id}/token"
    path_format_arguments = {
        "session_id": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_inferencesessions_ready_request(
    session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/inferencesessions/{session_id}/ready"
    path_format_arguments = {
        "session_id": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_models_label_request(model_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/models/{model_id}/labels"
    path_format_arguments = {
        "model_id": _SERIALIZER.url("model_id", model_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_models_query_request(
    *,
    id: Optional[str] = None,
    account: Optional[str] = None,
    status: Optional[str] = None,
    reason: Optional[str] = None,
    labels: Optional[str] = None,
    name: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/models"

    # Construct parameters
    if id is not None:
        _params["id"] = _SERIALIZER.query("id", id, "str")
    if account is not None:
        _params["account"] = _SERIALIZER.query("account", account, "str")
    if status is not None:
        _params["status"] = _SERIALIZER.query("status", status, "str")
    if reason is not None:
        _params["reason"] = _SERIALIZER.query("reason", reason, "str")
    if labels is not None:
        _params["labels"] = _SERIALIZER.query("labels", labels, "str")
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_models_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/models"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_models_get_request(model_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/models/{model_id}"
    path_format_arguments = {
        "model_id": _SERIALIZER.url("model_id", model_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_models_delete_request(model_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/models/{model_id}/delete"
    path_format_arguments = {
        "model_id": _SERIALIZER.url("model_id", model_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_reports_label_request(report_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/reports/{report_id}/labels"
    path_format_arguments = {
        "report_id": _SERIALIZER.url("report_id", report_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_reports_query_request(
    *,
    id: Optional[str] = None,
    account: Optional[str] = None,
    status: Optional[str] = None,
    reason: Optional[str] = None,
    labels: Optional[str] = None,
    report: Optional[str] = None,
    dataset: Optional[str] = None,
    evaluation: Optional[str] = None,
    inference_service: Optional[str] = None,
    model: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/reports"

    # Construct parameters
    if id is not None:
        _params["id"] = _SERIALIZER.query("id", id, "str")
    if account is not None:
        _params["account"] = _SERIALIZER.query("account", account, "str")
    if status is not None:
        _params["status"] = _SERIALIZER.query("status", status, "str")
    if reason is not None:
        _params["reason"] = _SERIALIZER.query("reason", reason, "str")
    if labels is not None:
        _params["labels"] = _SERIALIZER.query("labels", labels, "str")
    if report is not None:
        _params["report"] = _SERIALIZER.query("report", report, "str")
    if dataset is not None:
        _params["dataset"] = _SERIALIZER.query("dataset", dataset, "str")
    if evaluation is not None:
        _params["evaluation"] = _SERIALIZER.query("evaluation", evaluation, "str")
    if inference_service is not None:
        _params["inferenceService"] = _SERIALIZER.query(
            "inference_service", inference_service, "str"
        )
    if model is not None:
        _params["model"] = _SERIALIZER.query("model", model, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_reports_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/reports"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_reports_get_request(report_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/reports/{report_id}"
    path_format_arguments = {
        "report_id": _SERIALIZER.url("report_id", report_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_reports_delete_request(report_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/reports/{report_id}/delete"
    path_format_arguments = {
        "report_id": _SERIALIZER.url("report_id", report_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_reports_data_request(report_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/reports/{report_id}/data"
    path_format_arguments = {
        "report_id": _SERIALIZER.url("report_id", report_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


class AuditsOperations:  # pylint: disable=abstract-class-instantiated
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.DyffAPI`'s
        :attr:`audits` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

        raise_if_not_implemented(
            self.__class__,
            [
                "upload",
            ],
        )

    @overload
    def label(
        self,
        audit_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing Audit.

        Update labels for an existing Audit.

        :param audit_id: Required.
        :type audit_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def label(
        self,
        audit_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        """Update labels for an existing Audit.

        Update labels for an existing Audit.

        :param audit_id: Required.
        :type audit_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def label(
        self, audit_id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing Audit.

        Update labels for an existing Audit.

        :param audit_id: Required.
        :type audit_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Union[Any, JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_audits_label_request(
            audit_id=audit_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[Any, JSON], deserialized), {})  # type: ignore

        return cast(Union[Any, JSON], deserialized)  # type: ignore

    @distributed_trace
    def query(
        self,
        *,
        id: Optional[str] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> Union[List[JSON], JSON]:
        # pylint: disable=line-too-long
        """Get all Audits matching a query.

        Get all Audits matching a query. The query is a set of equality
        constraints specified as key-value pairs.

        :keyword id: Default value is None.
        :paramtype id: str
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword name: Default value is None.
        :paramtype name: str
        :return: list of JSON object or JSON object
        :rtype: list[JSON] or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",  # Account that owns the entity. Required.
                        "auditProcedure": "str",  # The AuditProcedure to run. Required.
                        "id": "str",  # Unique identifier of the entity. Required.
                        "inferenceService": "str",  # The InferenceService to audit.
                          Required.
                        "annotations": [
                            {
                                "key": "str",  # The annotation key. A DNS label with
                                  an optional DNS domain prefix. For example: 'my-key',
                                  'your.com/key_0'. Names prefixed with 'dyff.io/',
                                  'subdomain.dyff.io/', etc. are reserved.  See
                                  https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                                  for detailed naming rules. Required.
                                "value": "str"  # The annotation value. An arbitrary
                                  string. Required.
                            }
                        ],
                        "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation
                          time (assigned by system).
                        "kind": "Audit",  # Optional. Default value is "Audit". Kind. "Audit"
                        "labels": {
                            "str": "str"  # Optional. A set of key-value labels for the
                              resource. Used to specify identifying attributes of resources that are
                              meaningful to users but do not imply semantics in the dyff system.  The
                              keys are DNS labels with an optional DNS domain prefix. For example:
                              'my-key', 'your.com/key_0'. Keys prefixed with 'dyff.io/',
                              'subdomain.dyff.io/', etc. are reserved.  The label values are
                              alphanumeric characters separated by '.', '-', or '_'.  We follow the
                              kubernetes label conventions closely. See:
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                        },
                        "reason": "str",  # Optional. Reason for current status (assigned by
                          system).
                        "schemaVersion": "0.1",  # Optional. Default value is "0.1". The
                          schema version. "0.1"
                        "status": "str"  # Optional. Top-level resource status (assigned by
                          system).
                    }
                ]
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[List[JSON], JSON]] = kwargs.pop("cls", None)

        _request = build_audits_query_request(
            id=id,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            name=name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[List[JSON], JSON], deserialized), {})  # type: ignore

        return cast(Union[List[JSON], JSON], deserialized)  # type: ignore

    @distributed_trace
    def get(self, audit_id: str, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Get an Audit by its key.

        Get an Audit by its key. Raises a 404 error if no entity exists with that key.

        :param audit_id: Required.
        :type audit_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "auditProcedure": "str",  # The AuditProcedure to run. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "inferenceService": "str",  # The InferenceService to audit. Required.
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Audit",  # Optional. Default value is "Audit". Kind. "Audit"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_audits_get_request(
            audit_id=audit_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def delete(self, audit_id: str, **kwargs: Any) -> JSON:
        """Mark an Audit for deletion.

        Mark an Audit for deletion.

        :param audit_id: Required.
        :type audit_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_audits_delete_request(
            audit_id=audit_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class AuditproceduresOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.DyffAPI`'s
        :attr:`auditprocedures` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace
    def download(self, path: str, **kwargs: Any) -> Union[Iterator[bytes], JSON]:
        """Download the source code of an AuditProcedure.

        Download the source code of an AuditProcedure.

        :param path: Required.
        :type path: str
        :return: Iterator of the response bytes or JSON object or None
        :rtype: Iterator[bytes] or JSON or None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[Iterator[bytes], JSON]] = kwargs.pop("cls", None)

        _request = build_auditprocedures_download_request(
            path=path,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 200:
            deserialized = response.iter_bytes()

        if response.status_code == 422:
            deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class DatasetsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.DyffAPI`'s
        :attr:`datasets` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    def label(
        self,
        dataset_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing Dataset.

        Update labels for an existing Dataset.

        :param dataset_id: Required.
        :type dataset_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def label(
        self,
        dataset_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        """Update labels for an existing Dataset.

        Update labels for an existing Dataset.

        :param dataset_id: Required.
        :type dataset_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def label(
        self, dataset_id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing Dataset.

        Update labels for an existing Dataset.

        :param dataset_id: Required.
        :type dataset_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Union[Any, JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_datasets_label_request(
            dataset_id=dataset_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[Any, JSON], deserialized), {})  # type: ignore

        return cast(Union[Any, JSON], deserialized)  # type: ignore

    @distributed_trace
    def query(
        self,
        *,
        id: Optional[str] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> Union[List[JSON], JSON]:
        # pylint: disable=line-too-long
        """Get all Datasets matching a query.

        Get all Datasets matching a query. The query is a set of equality
        constraints specified as key-value pairs.

        :keyword id: Default value is None.
        :paramtype id: str
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword name: Default value is None.
        :paramtype name: str
        :return: list of JSON object or JSON object
        :rtype: list[JSON] or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",  # Account that owns the entity. Required.
                        "artifacts": [
                            {
                                "digest": {
                                    "md5": "str"  # Optional. Md5.
                                },
                                "kind": "str",  # The kind of artifact. Required.
                                "path": "str"  # The relative path of the artifact
                                  within the dataset. Required.
                            }
                        ],
                        "id": "str",  # Unique identifier of the entity. Required.
                        "name": "str",  # The name of the Dataset. Required.
                        "schema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "annotations": [
                            {
                                "key": "str",  # The annotation key. A DNS label with
                                  an optional DNS domain prefix. For example: 'my-key',
                                  'your.com/key_0'. Names prefixed with 'dyff.io/',
                                  'subdomain.dyff.io/', etc. are reserved.  See
                                  https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                                  for detailed naming rules. Required.
                                "value": "str"  # The annotation value. An arbitrary
                                  string. Required.
                            }
                        ],
                        "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation
                          time (assigned by system).
                        "kind": "Dataset",  # Optional. Default value is "Dataset". Kind.
                          "Dataset"
                        "labels": {
                            "str": "str"  # Optional. A set of key-value labels for the
                              resource. Used to specify identifying attributes of resources that are
                              meaningful to users but do not imply semantics in the dyff system.  The
                              keys are DNS labels with an optional DNS domain prefix. For example:
                              'my-key', 'your.com/key_0'. Keys prefixed with 'dyff.io/',
                              'subdomain.dyff.io/', etc. are reserved.  The label values are
                              alphanumeric characters separated by '.', '-', or '_'.  We follow the
                              kubernetes label conventions closely. See:
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                        },
                        "reason": "str",  # Optional. Reason for current status (assigned by
                          system).
                        "schemaVersion": "0.1",  # Optional. Default value is "0.1". The
                          schema version. "0.1"
                        "status": "str",  # Optional. Top-level resource status (assigned by
                          system).
                        "views": [
                            {
                                "id": "str",  # Unique ID of the DataView. Required.
                                "schema": {
                                    "arrowSchema": "str",  # The schema in Arrow
                                      format, encoded with dyff.schema.arrow.encode_schema(). This is
                                      required, but can be populated from a DyffDataSchema. Required.
                                    "dyffSchema": {
                                        "components": [
                                            "str"  # A list of named dyff
                                              data schemas. The final schema is the composition of
                                              these component schemas. Required.
                                        ],
                                        "schemaVersion": "0.1"  # Optional.
                                          Default value is "0.1". The dyff schema version. "0.1"
                                    },
                                    "jsonSchema": {}  # Optional. The schema in
                                      JSON Schema format.
                                },
                                "viewOf": "str",  # ID of the resource that this is a
                                  view of. Required.
                                "adapterPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ]
                            }
                        ]
                    }
                ]
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[List[JSON], JSON]] = kwargs.pop("cls", None)

        _request = build_datasets_query_request(
            id=id,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            name=name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[List[JSON], JSON], deserialized), {})  # type: ignore

        return cast(Union[List[JSON], JSON], deserialized)  # type: ignore

    @overload
    def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create a Dataset.

        Create a Dataset.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifacts": [
                        {
                            "digest": {
                                "md5": "str"  # Optional. Md5.
                            },
                            "kind": "str",  # The kind of artifact. Required.
                            "path": "str"  # The relative path of the artifact within the
                              dataset. Required.
                        }
                    ],
                    "name": "str",  # The name of the Dataset. Required.
                    "schema": {
                        "arrowSchema": "str",  # The schema in Arrow format, encoded with
                          dyff.schema.arrow.encode_schema(). This is required, but can be populated
                          from a DyffDataSchema. Required.
                        "dyffSchema": {
                            "components": [
                                "str"  # A list of named dyff data schemas. The final
                                  schema is the composition of these component schemas. Required.
                            ],
                            "schemaVersion": "0.1"  # Optional. Default value is "0.1".
                              The dyff schema version. "0.1"
                        },
                        "jsonSchema": {}  # Optional. The schema in JSON Schema format.
                    },
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "views": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifacts": [
                        {
                            "digest": {
                                "md5": "str"  # Optional. Md5.
                            },
                            "kind": "str",  # The kind of artifact. Required.
                            "path": "str"  # The relative path of the artifact within the
                              dataset. Required.
                        }
                    ],
                    "id": "str",  # Unique identifier of the entity. Required.
                    "name": "str",  # The name of the Dataset. Required.
                    "schema": {
                        "arrowSchema": "str",  # The schema in Arrow format, encoded with
                          dyff.schema.arrow.encode_schema(). This is required, but can be populated
                          from a DyffDataSchema. Required.
                        "dyffSchema": {
                            "components": [
                                "str"  # A list of named dyff data schemas. The final
                                  schema is the composition of these component schemas. Required.
                            ],
                            "schemaVersion": "0.1"  # Optional. Default value is "0.1".
                              The dyff schema version. "0.1"
                        },
                        "jsonSchema": {}  # Optional. The schema in JSON Schema format.
                    },
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Dataset",  # Optional. Default value is "Dataset". Kind. "Dataset"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str",  # Optional. Top-level resource status (assigned by system).
                    "views": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ]
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create a Dataset.

        Create a Dataset.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifacts": [
                        {
                            "digest": {
                                "md5": "str"  # Optional. Md5.
                            },
                            "kind": "str",  # The kind of artifact. Required.
                            "path": "str"  # The relative path of the artifact within the
                              dataset. Required.
                        }
                    ],
                    "id": "str",  # Unique identifier of the entity. Required.
                    "name": "str",  # The name of the Dataset. Required.
                    "schema": {
                        "arrowSchema": "str",  # The schema in Arrow format, encoded with
                          dyff.schema.arrow.encode_schema(). This is required, but can be populated
                          from a DyffDataSchema. Required.
                        "dyffSchema": {
                            "components": [
                                "str"  # A list of named dyff data schemas. The final
                                  schema is the composition of these component schemas. Required.
                            ],
                            "schemaVersion": "0.1"  # Optional. Default value is "0.1".
                              The dyff schema version. "0.1"
                        },
                        "jsonSchema": {}  # Optional. The schema in JSON Schema format.
                    },
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Dataset",  # Optional. Default value is "Dataset". Kind. "Dataset"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str",  # Optional. Top-level resource status (assigned by system).
                    "views": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ]
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Create a Dataset.

        Create a Dataset.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifacts": [
                        {
                            "digest": {
                                "md5": "str"  # Optional. Md5.
                            },
                            "kind": "str",  # The kind of artifact. Required.
                            "path": "str"  # The relative path of the artifact within the
                              dataset. Required.
                        }
                    ],
                    "name": "str",  # The name of the Dataset. Required.
                    "schema": {
                        "arrowSchema": "str",  # The schema in Arrow format, encoded with
                          dyff.schema.arrow.encode_schema(). This is required, but can be populated
                          from a DyffDataSchema. Required.
                        "dyffSchema": {
                            "components": [
                                "str"  # A list of named dyff data schemas. The final
                                  schema is the composition of these component schemas. Required.
                            ],
                            "schemaVersion": "0.1"  # Optional. Default value is "0.1".
                              The dyff schema version. "0.1"
                        },
                        "jsonSchema": {}  # Optional. The schema in JSON Schema format.
                    },
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "views": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifacts": [
                        {
                            "digest": {
                                "md5": "str"  # Optional. Md5.
                            },
                            "kind": "str",  # The kind of artifact. Required.
                            "path": "str"  # The relative path of the artifact within the
                              dataset. Required.
                        }
                    ],
                    "id": "str",  # Unique identifier of the entity. Required.
                    "name": "str",  # The name of the Dataset. Required.
                    "schema": {
                        "arrowSchema": "str",  # The schema in Arrow format, encoded with
                          dyff.schema.arrow.encode_schema(). This is required, but can be populated
                          from a DyffDataSchema. Required.
                        "dyffSchema": {
                            "components": [
                                "str"  # A list of named dyff data schemas. The final
                                  schema is the composition of these component schemas. Required.
                            ],
                            "schemaVersion": "0.1"  # Optional. Default value is "0.1".
                              The dyff schema version. "0.1"
                        },
                        "jsonSchema": {}  # Optional. The schema in JSON Schema format.
                    },
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Dataset",  # Optional. Default value is "Dataset". Kind. "Dataset"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str",  # Optional. Top-level resource status (assigned by system).
                    "views": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ]
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_datasets_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get(self, dataset_id: str, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Get a Dataset by its key.

        Get a Dataset by its key. Raises a 404 error if no entity exists with that key.

        :param dataset_id: Required.
        :type dataset_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifacts": [
                        {
                            "digest": {
                                "md5": "str"  # Optional. Md5.
                            },
                            "kind": "str",  # The kind of artifact. Required.
                            "path": "str"  # The relative path of the artifact within the
                              dataset. Required.
                        }
                    ],
                    "id": "str",  # Unique identifier of the entity. Required.
                    "name": "str",  # The name of the Dataset. Required.
                    "schema": {
                        "arrowSchema": "str",  # The schema in Arrow format, encoded with
                          dyff.schema.arrow.encode_schema(). This is required, but can be populated
                          from a DyffDataSchema. Required.
                        "dyffSchema": {
                            "components": [
                                "str"  # A list of named dyff data schemas. The final
                                  schema is the composition of these component schemas. Required.
                            ],
                            "schemaVersion": "0.1"  # Optional. Default value is "0.1".
                              The dyff schema version. "0.1"
                        },
                        "jsonSchema": {}  # Optional. The schema in JSON Schema format.
                    },
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Dataset",  # Optional. Default value is "Dataset". Kind. "Dataset"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str",  # Optional. Top-level resource status (assigned by system).
                    "views": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ]
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_datasets_get_request(
            dataset_id=dataset_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def strata(self, dataset_id: str, **kwargs: Any) -> Union[Iterator[bytes], JSON]:
        """Get the strata corresponding to a Dataset.

        Get the strata corresponding to a Dataset. The data is returned as a
        Parquet file suitable for reading with libraries like Pandas.

        :param dataset_id: Required.
        :type dataset_id: str
        :return: Iterator of the response bytes or JSON object or None
        :rtype: Iterator[bytes] or JSON or None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[Iterator[bytes], JSON]] = kwargs.pop("cls", None)

        _request = build_datasets_strata_request(
            dataset_id=dataset_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 200:
            deserialized = response.iter_bytes()

        if response.status_code == 422:
            deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def data(self, dataset_id: str, **kwargs: Any) -> Union[Iterator[bytes], JSON]:
        """Get the raw data for the Dataset.

        Get the raw data for the Dataset. The data is streamed in pyarrow.ipc
        format.

        :param dataset_id: Required.
        :type dataset_id: str
        :return: Iterator of the response bytes or JSON object or None
        :rtype: Iterator[bytes] or JSON or None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[Iterator[bytes], JSON]] = kwargs.pop("cls", None)

        _request = build_datasets_data_request(
            dataset_id=dataset_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 200:
            deserialized = response.iter_bytes()

        if response.status_code == 422:
            deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete(self, dataset_id: str, **kwargs: Any) -> JSON:
        """Mark a Dataset for deletion.

        Mark a Dataset for deletion.

        :param dataset_id: Required.
        :type dataset_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_datasets_delete_request(
            dataset_id=dataset_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def upload(self, dataset_id: str, artifact_path: str, **kwargs: Any) -> JSON:
        """Get a signed URL to which the given artifact can be uploaded.

        Get a signed URL to which the given artifact can be uploaded.

        :param dataset_id: Required.
        :type dataset_id: str
        :param artifact_path: Required.
        :type artifact_path: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "method": "str",  # The HTTP method applicable to the URL. Required.
                    "url": "str",  # The signed URL. Required.
                    "headers": {
                        "str": "str"  # Optional. Mandatory headers that must be passed with
                          the request.
                    }
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_datasets_upload_request(
            dataset_id=dataset_id,
            artifact_path=artifact_path,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def finalize(self, dataset_id: str, **kwargs: Any) -> Union[Any, JSON]:
        """Indicate that all dataset artifacts have been uploaded.

        Indicate that all dataset artifacts have been uploaded.

        :param dataset_id: Required.
        :type dataset_id: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[Any, JSON]] = kwargs.pop("cls", None)

        _request = build_datasets_finalize_request(
            dataset_id=dataset_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[Any, JSON], deserialized), {})  # type: ignore

        return cast(Union[Any, JSON], deserialized)  # type: ignore


class EvaluationsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.DyffAPI`'s
        :attr:`evaluations` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    def label(
        self,
        evaluation_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing Evaluation.

        Update labels for an existing Evaluation.

        :param evaluation_id: Required.
        :type evaluation_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def label(
        self,
        evaluation_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        """Update labels for an existing Evaluation.

        Update labels for an existing Evaluation.

        :param evaluation_id: Required.
        :type evaluation_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def label(
        self, evaluation_id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing Evaluation.

        Update labels for an existing Evaluation.

        :param evaluation_id: Required.
        :type evaluation_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Union[Any, JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_evaluations_label_request(
            evaluation_id=evaluation_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[Any, JSON], deserialized), {})  # type: ignore

        return cast(Union[Any, JSON], deserialized)  # type: ignore

    @distributed_trace
    def query(
        self,
        *,
        id: Optional[str] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        dataset: Optional[str] = None,
        inference_service: Optional[str] = None,
        inference_service_name: Optional[str] = None,
        model: Optional[str] = None,
        model_name: Optional[str] = None,
        **kwargs: Any
    ) -> Union[List[JSON], JSON]:
        # pylint: disable=line-too-long
        """Get all Evaluations matching a query.

        Get all Evaluations matching a query. The query is a set of equality
        constraints specified as key-value pairs.

        :keyword id: Default value is None.
        :paramtype id: str
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword dataset: Default value is None.
        :paramtype dataset: str
        :keyword inference_service: Default value is None.
        :paramtype inference_service: str
        :keyword inference_service_name: Default value is None.
        :paramtype inference_service_name: str
        :keyword model: Default value is None.
        :paramtype model: str
        :keyword model_name: Default value is None.
        :paramtype model_name: str
        :return: list of JSON object or JSON object
        :rtype: list[JSON] or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",  # Account that owns the entity. Required.
                        "dataset": "str",  # The Dataset to evaluate on. Required.
                        "id": "str",  # Unique identifier of the entity. Required.
                        "inferenceSession": {
                            "inferenceService": {
                                "account": "str",  # Account that owns the entity.
                                  Required.
                                "id": "str",  # Unique identifier of the entity.
                                  Required.
                                "interface": {
                                    "endpoint": "str",  # HTTP endpoint for
                                      inference. Required.
                                    "outputSchema": {
                                        "arrowSchema": "str",  # The schema
                                          in Arrow format, encoded with
                                          dyff.schema.arrow.encode_schema(). This is required, but can
                                          be populated from a DyffDataSchema. Required.
                                        "dyffSchema": {
                                            "components": [
                                                "str"  # A list of
                                                  named dyff data schemas. The final schema is the
                                                  composition of these component schemas. Required.
                                            ],
                                            "schemaVersion": "0.1"  #
                                              Optional. Default value is "0.1". The dyff schema
                                              version. "0.1"
                                        },
                                        "jsonSchema": {}  # Optional. The
                                          schema in JSON Schema format.
                                    },
                                    "inputPipeline": [
                                        {
                                            "kind": "str",  # Name of a
                                              schema adapter available on the platform. Required.
                                            "configuration": {}  #
                                              Optional. Configuration for the schema adapter. Must be
                                              encodable as JSON.
                                        }
                                    ],
                                    "outputPipeline": [
                                        {
                                            "kind": "str",  # Name of a
                                              schema adapter available on the platform. Required.
                                            "configuration": {}  #
                                              Optional. Configuration for the schema adapter. Must be
                                              encodable as JSON.
                                        }
                                    ]
                                },
                                "name": "str",  # The name of the service. Required.
                                "builder": {
                                    "kind": "str",  # Kind. Required.
                                    "args": [
                                        "str"  # Optional. Args.
                                    ]
                                },
                                "model": {
                                    "account": "str",  # Account that owns the
                                      entity. Required.
                                    "artifact": {
                                        "kind": "str",  # How the model data
                                          is represented. Required. "HuggingFaceCache"
                                        "huggingFaceCache": {
                                            "repoID": "str",  # Name of
                                              the model in the HuggingFace cache. Required.
                                            "revision": "str"  # Model
                                              revision. Required.
                                        }
                                    },
                                    "id": "str",  # Unique identifier of the
                                      entity. Required.
                                    "name": "str",  # The name of the Model.
                                      Required.
                                    "storage": {
                                        "medium": "str"  # Storage medium.
                                          Required. Known values are: "ObjectStorage" and
                                          "PersistentVolume".
                                    }
                                },
                                "outputViews": [
                                    {
                                        "id": "str",  # Unique ID of the
                                          DataView. Required.
                                        "schema": {
                                            "arrowSchema": "str",  # The
                                              schema in Arrow format, encoded with
                                              dyff.schema.arrow.encode_schema(). This is required, but
                                              can be populated from a DyffDataSchema. Required.
                                            "dyffSchema": {
                                                "components": [
                                                    "str"  # A
                                                      list of named dyff data schemas. The final schema
                                                      is the composition of these component schemas.
                                                      Required.
                                                ],
                                                "schemaVersion":
                                                  "0.1"  # Optional. Default value is "0.1". The dyff
                                                  schema version. "0.1"
                                            },
                                            "jsonSchema": {}  # Optional.
                                              The schema in JSON Schema format.
                                        },
                                        "viewOf": "str",  # ID of the
                                          resource that this is a view of. Required.
                                        "adapterPipeline": [
                                            {
                                                "kind": "str",  #
                                                  Name of a schema adapter available on the platform.
                                                  Required.
                                                "configuration": {}
                                                  # Optional. Configuration for the schema adapter.
                                                  Must be encodable as JSON.
                                            }
                                        ]
                                    }
                                ],
                                "runner": {
                                    "kind": "str",  # An enumeration. Required.
                                      Known values are: "bentoml_service_openllm", "mock",
                                      "standalone", and "vllm".
                                    "resources": {
                                        "storage": "str",  # Amount of
                                          storage required for packaged model, in k8s Quantity
                                          notation. Required.
                                        "memory": "str"  # Optional. Amount
                                          of memory required to run the model on CPU, in k8s Quantity
                                          notation.
                                    },
                                    "accelerator": {
                                        "kind": "str",  # The kind of
                                          accelerator; available kinds are {{GPU}}. Required.
                                        "gpu": {
                                            "hardwareTypes": [
                                                "str"  # Acceptable
                                                  GPU hardware types. Required.
                                            ],
                                            "count": 1,  # Optional.
                                              Default value is 1. Number of GPUs required.
                                            "memory": "str"  # Optional.
                                              [DEPRECATED] Amount of GPU memory required, in k8s
                                              Quantity notation.
                                        }
                                    },
                                    "args": [
                                        "str"  # Optional. Command line
                                          arguments to forward to the runner.
                                    ]
                                }
                            },
                            "accelerator": {
                                "kind": "str",  # The kind of accelerator; available
                                  kinds are {{GPU}}. Required.
                                "gpu": {
                                    "hardwareTypes": [
                                        "str"  # Acceptable GPU hardware
                                          types. Required.
                                    ],
                                    "count": 1,  # Optional. Default value is 1.
                                      Number of GPUs required.
                                    "memory": "str"  # Optional. [DEPRECATED]
                                      Amount of GPU memory required, in k8s Quantity notation.
                                }
                            },
                            "expires": "2020-02-20 00:00:00",  # Optional. Expiration
                              time for the session. Use of this field is recommended to avoid
                              accidental compute costs.
                            "replicas": 1,  # Optional. Default value is 1. Number of
                              model replicas.
                            "useSpotPods": True  # Optional. Default value is True. Use
                              'spot pods' for cheaper computation.
                        },
                        "annotations": [
                            {
                                "key": "str",  # The annotation key. A DNS label with
                                  an optional DNS domain prefix. For example: 'my-key',
                                  'your.com/key_0'. Names prefixed with 'dyff.io/',
                                  'subdomain.dyff.io/', etc. are reserved.  See
                                  https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                                  for detailed naming rules. Required.
                                "value": "str"  # The annotation value. An arbitrary
                                  string. Required.
                            }
                        ],
                        "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation
                          time (assigned by system).
                        "kind": "Evaluation",  # Optional. Default value is "Evaluation".
                          Kind. "Evaluation"
                        "labels": {
                            "str": "str"  # Optional. A set of key-value labels for the
                              resource. Used to specify identifying attributes of resources that are
                              meaningful to users but do not imply semantics in the dyff system.  The
                              keys are DNS labels with an optional DNS domain prefix. For example:
                              'my-key', 'your.com/key_0'. Keys prefixed with 'dyff.io/',
                              'subdomain.dyff.io/', etc. are reserved.  The label values are
                              alphanumeric characters separated by '.', '-', or '_'.  We follow the
                              kubernetes label conventions closely. See:
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                        },
                        "reason": "str",  # Optional. Reason for current status (assigned by
                          system).
                        "replications": 1,  # Optional. Default value is 1. Number of
                          replications to run.
                        "schemaVersion": "0.1",  # Optional. Default value is "0.1". The
                          schema version. "0.1"
                        "status": "str",  # Optional. Top-level resource status (assigned by
                          system).
                        "workersPerReplica": 0  # Optional. Number of data workers per
                          inference service replica.
                    }
                ]
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[List[JSON], JSON]] = kwargs.pop("cls", None)

        _request = build_evaluations_query_request(
            id=id,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            dataset=dataset,
            inference_service=inference_service,
            inference_service_name=inference_service_name,
            model=model,
            model_name=model_name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[List[JSON], JSON], deserialized), {})  # type: ignore

        return cast(Union[List[JSON], JSON], deserialized)  # type: ignore

    @overload
    def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create an Evaluation.

        Create an Evaluation.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "dataset": "str",  # The Dataset to evaluate on. Required.
                    "inferenceSession": {
                        "inferenceService": "str",  # InferenceService ID. Required.
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for
                          the session. Use of this field is recommended to avoid accidental compute
                          costs.
                        "replicas": 1,  # Optional. Default value is 1. Number of model
                          replicas.
                        "useSpotPods": True  # Optional. Default value is True. Use 'spot
                          pods' for cheaper computation.
                    },
                    "replications": 1,  # Optional. Default value is 1. Number of replications to
                      run.
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "workersPerReplica": 0  # Optional. Number of data workers per inference
                      service replica.
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "dataset": "str",  # The Dataset to evaluate on. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "inferenceSession": {
                        "inferenceService": {
                            "account": "str",  # Account that owns the entity. Required.
                            "id": "str",  # Unique identifier of the entity. Required.
                            "interface": {
                                "endpoint": "str",  # HTTP endpoint for inference.
                                  Required.
                                "outputSchema": {
                                    "arrowSchema": "str",  # The schema in Arrow
                                      format, encoded with dyff.schema.arrow.encode_schema(). This is
                                      required, but can be populated from a DyffDataSchema. Required.
                                    "dyffSchema": {
                                        "components": [
                                            "str"  # A list of named dyff
                                              data schemas. The final schema is the composition of
                                              these component schemas. Required.
                                        ],
                                        "schemaVersion": "0.1"  # Optional.
                                          Default value is "0.1". The dyff schema version. "0.1"
                                    },
                                    "jsonSchema": {}  # Optional. The schema in
                                      JSON Schema format.
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ]
                            },
                            "name": "str",  # The name of the service. Required.
                            "builder": {
                                "kind": "str",  # Kind. Required.
                                "args": [
                                    "str"  # Optional. Args.
                                ]
                            },
                            "model": {
                                "account": "str",  # Account that owns the entity.
                                  Required.
                                "artifact": {
                                    "kind": "str",  # How the model data is
                                      represented. Required. "HuggingFaceCache"
                                    "huggingFaceCache": {
                                        "repoID": "str",  # Name of the model
                                          in the HuggingFace cache. Required.
                                        "revision": "str"  # Model revision.
                                          Required.
                                    }
                                },
                                "id": "str",  # Unique identifier of the entity.
                                  Required.
                                "name": "str",  # The name of the Model. Required.
                                "storage": {
                                    "medium": "str"  # Storage medium. Required.
                                      Known values are: "ObjectStorage" and "PersistentVolume".
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",  # Unique ID of the DataView.
                                      Required.
                                    "schema": {
                                        "arrowSchema": "str",  # The schema
                                          in Arrow format, encoded with
                                          dyff.schema.arrow.encode_schema(). This is required, but can
                                          be populated from a DyffDataSchema. Required.
                                        "dyffSchema": {
                                            "components": [
                                                "str"  # A list of
                                                  named dyff data schemas. The final schema is the
                                                  composition of these component schemas. Required.
                                            ],
                                            "schemaVersion": "0.1"  #
                                              Optional. Default value is "0.1". The dyff schema
                                              version. "0.1"
                                        },
                                        "jsonSchema": {}  # Optional. The
                                          schema in JSON Schema format.
                                    },
                                    "viewOf": "str",  # ID of the resource that
                                      this is a view of. Required.
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",  # Name of a
                                              schema adapter available on the platform. Required.
                                            "configuration": {}  #
                                              Optional. Configuration for the schema adapter. Must be
                                              encodable as JSON.
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",  # An enumeration. Required. Known
                                  values are: "bentoml_service_openllm", "mock", "standalone", and
                                  "vllm".
                                "resources": {
                                    "storage": "str",  # Amount of storage
                                      required for packaged model, in k8s Quantity notation. Required.
                                    "memory": "str"  # Optional. Amount of memory
                                      required to run the model on CPU, in k8s Quantity notation.
                                },
                                "accelerator": {
                                    "kind": "str",  # The kind of accelerator;
                                      available kinds are {{GPU}}. Required.
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"  # Acceptable GPU
                                              hardware types. Required.
                                        ],
                                        "count": 1,  # Optional. Default
                                          value is 1. Number of GPUs required.
                                        "memory": "str"  # Optional.
                                          [DEPRECATED] Amount of GPU memory required, in k8s Quantity
                                          notation.
                                    }
                                },
                                "args": [
                                    "str"  # Optional. Command line arguments to
                                      forward to the runner.
                                ]
                            }
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for
                          the session. Use of this field is recommended to avoid accidental compute
                          costs.
                        "replicas": 1,  # Optional. Default value is 1. Number of model
                          replicas.
                        "useSpotPods": True  # Optional. Default value is True. Use 'spot
                          pods' for cheaper computation.
                    },
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Evaluation",  # Optional. Default value is "Evaluation". Kind.
                      "Evaluation"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "replications": 1,  # Optional. Default value is 1. Number of replications to
                      run.
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str",  # Optional. Top-level resource status (assigned by system).
                    "workersPerReplica": 0  # Optional. Number of data workers per inference
                      service replica.
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create an Evaluation.

        Create an Evaluation.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "dataset": "str",  # The Dataset to evaluate on. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "inferenceSession": {
                        "inferenceService": {
                            "account": "str",  # Account that owns the entity. Required.
                            "id": "str",  # Unique identifier of the entity. Required.
                            "interface": {
                                "endpoint": "str",  # HTTP endpoint for inference.
                                  Required.
                                "outputSchema": {
                                    "arrowSchema": "str",  # The schema in Arrow
                                      format, encoded with dyff.schema.arrow.encode_schema(). This is
                                      required, but can be populated from a DyffDataSchema. Required.
                                    "dyffSchema": {
                                        "components": [
                                            "str"  # A list of named dyff
                                              data schemas. The final schema is the composition of
                                              these component schemas. Required.
                                        ],
                                        "schemaVersion": "0.1"  # Optional.
                                          Default value is "0.1". The dyff schema version. "0.1"
                                    },
                                    "jsonSchema": {}  # Optional. The schema in
                                      JSON Schema format.
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ]
                            },
                            "name": "str",  # The name of the service. Required.
                            "builder": {
                                "kind": "str",  # Kind. Required.
                                "args": [
                                    "str"  # Optional. Args.
                                ]
                            },
                            "model": {
                                "account": "str",  # Account that owns the entity.
                                  Required.
                                "artifact": {
                                    "kind": "str",  # How the model data is
                                      represented. Required. "HuggingFaceCache"
                                    "huggingFaceCache": {
                                        "repoID": "str",  # Name of the model
                                          in the HuggingFace cache. Required.
                                        "revision": "str"  # Model revision.
                                          Required.
                                    }
                                },
                                "id": "str",  # Unique identifier of the entity.
                                  Required.
                                "name": "str",  # The name of the Model. Required.
                                "storage": {
                                    "medium": "str"  # Storage medium. Required.
                                      Known values are: "ObjectStorage" and "PersistentVolume".
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",  # Unique ID of the DataView.
                                      Required.
                                    "schema": {
                                        "arrowSchema": "str",  # The schema
                                          in Arrow format, encoded with
                                          dyff.schema.arrow.encode_schema(). This is required, but can
                                          be populated from a DyffDataSchema. Required.
                                        "dyffSchema": {
                                            "components": [
                                                "str"  # A list of
                                                  named dyff data schemas. The final schema is the
                                                  composition of these component schemas. Required.
                                            ],
                                            "schemaVersion": "0.1"  #
                                              Optional. Default value is "0.1". The dyff schema
                                              version. "0.1"
                                        },
                                        "jsonSchema": {}  # Optional. The
                                          schema in JSON Schema format.
                                    },
                                    "viewOf": "str",  # ID of the resource that
                                      this is a view of. Required.
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",  # Name of a
                                              schema adapter available on the platform. Required.
                                            "configuration": {}  #
                                              Optional. Configuration for the schema adapter. Must be
                                              encodable as JSON.
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",  # An enumeration. Required. Known
                                  values are: "bentoml_service_openllm", "mock", "standalone", and
                                  "vllm".
                                "resources": {
                                    "storage": "str",  # Amount of storage
                                      required for packaged model, in k8s Quantity notation. Required.
                                    "memory": "str"  # Optional. Amount of memory
                                      required to run the model on CPU, in k8s Quantity notation.
                                },
                                "accelerator": {
                                    "kind": "str",  # The kind of accelerator;
                                      available kinds are {{GPU}}. Required.
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"  # Acceptable GPU
                                              hardware types. Required.
                                        ],
                                        "count": 1,  # Optional. Default
                                          value is 1. Number of GPUs required.
                                        "memory": "str"  # Optional.
                                          [DEPRECATED] Amount of GPU memory required, in k8s Quantity
                                          notation.
                                    }
                                },
                                "args": [
                                    "str"  # Optional. Command line arguments to
                                      forward to the runner.
                                ]
                            }
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for
                          the session. Use of this field is recommended to avoid accidental compute
                          costs.
                        "replicas": 1,  # Optional. Default value is 1. Number of model
                          replicas.
                        "useSpotPods": True  # Optional. Default value is True. Use 'spot
                          pods' for cheaper computation.
                    },
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Evaluation",  # Optional. Default value is "Evaluation". Kind.
                      "Evaluation"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "replications": 1,  # Optional. Default value is 1. Number of replications to
                      run.
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str",  # Optional. Top-level resource status (assigned by system).
                    "workersPerReplica": 0  # Optional. Number of data workers per inference
                      service replica.
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Create an Evaluation.

        Create an Evaluation.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "dataset": "str",  # The Dataset to evaluate on. Required.
                    "inferenceSession": {
                        "inferenceService": "str",  # InferenceService ID. Required.
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for
                          the session. Use of this field is recommended to avoid accidental compute
                          costs.
                        "replicas": 1,  # Optional. Default value is 1. Number of model
                          replicas.
                        "useSpotPods": True  # Optional. Default value is True. Use 'spot
                          pods' for cheaper computation.
                    },
                    "replications": 1,  # Optional. Default value is 1. Number of replications to
                      run.
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "workersPerReplica": 0  # Optional. Number of data workers per inference
                      service replica.
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "dataset": "str",  # The Dataset to evaluate on. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "inferenceSession": {
                        "inferenceService": {
                            "account": "str",  # Account that owns the entity. Required.
                            "id": "str",  # Unique identifier of the entity. Required.
                            "interface": {
                                "endpoint": "str",  # HTTP endpoint for inference.
                                  Required.
                                "outputSchema": {
                                    "arrowSchema": "str",  # The schema in Arrow
                                      format, encoded with dyff.schema.arrow.encode_schema(). This is
                                      required, but can be populated from a DyffDataSchema. Required.
                                    "dyffSchema": {
                                        "components": [
                                            "str"  # A list of named dyff
                                              data schemas. The final schema is the composition of
                                              these component schemas. Required.
                                        ],
                                        "schemaVersion": "0.1"  # Optional.
                                          Default value is "0.1". The dyff schema version. "0.1"
                                    },
                                    "jsonSchema": {}  # Optional. The schema in
                                      JSON Schema format.
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ]
                            },
                            "name": "str",  # The name of the service. Required.
                            "builder": {
                                "kind": "str",  # Kind. Required.
                                "args": [
                                    "str"  # Optional. Args.
                                ]
                            },
                            "model": {
                                "account": "str",  # Account that owns the entity.
                                  Required.
                                "artifact": {
                                    "kind": "str",  # How the model data is
                                      represented. Required. "HuggingFaceCache"
                                    "huggingFaceCache": {
                                        "repoID": "str",  # Name of the model
                                          in the HuggingFace cache. Required.
                                        "revision": "str"  # Model revision.
                                          Required.
                                    }
                                },
                                "id": "str",  # Unique identifier of the entity.
                                  Required.
                                "name": "str",  # The name of the Model. Required.
                                "storage": {
                                    "medium": "str"  # Storage medium. Required.
                                      Known values are: "ObjectStorage" and "PersistentVolume".
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",  # Unique ID of the DataView.
                                      Required.
                                    "schema": {
                                        "arrowSchema": "str",  # The schema
                                          in Arrow format, encoded with
                                          dyff.schema.arrow.encode_schema(). This is required, but can
                                          be populated from a DyffDataSchema. Required.
                                        "dyffSchema": {
                                            "components": [
                                                "str"  # A list of
                                                  named dyff data schemas. The final schema is the
                                                  composition of these component schemas. Required.
                                            ],
                                            "schemaVersion": "0.1"  #
                                              Optional. Default value is "0.1". The dyff schema
                                              version. "0.1"
                                        },
                                        "jsonSchema": {}  # Optional. The
                                          schema in JSON Schema format.
                                    },
                                    "viewOf": "str",  # ID of the resource that
                                      this is a view of. Required.
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",  # Name of a
                                              schema adapter available on the platform. Required.
                                            "configuration": {}  #
                                              Optional. Configuration for the schema adapter. Must be
                                              encodable as JSON.
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",  # An enumeration. Required. Known
                                  values are: "bentoml_service_openllm", "mock", "standalone", and
                                  "vllm".
                                "resources": {
                                    "storage": "str",  # Amount of storage
                                      required for packaged model, in k8s Quantity notation. Required.
                                    "memory": "str"  # Optional. Amount of memory
                                      required to run the model on CPU, in k8s Quantity notation.
                                },
                                "accelerator": {
                                    "kind": "str",  # The kind of accelerator;
                                      available kinds are {{GPU}}. Required.
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"  # Acceptable GPU
                                              hardware types. Required.
                                        ],
                                        "count": 1,  # Optional. Default
                                          value is 1. Number of GPUs required.
                                        "memory": "str"  # Optional.
                                          [DEPRECATED] Amount of GPU memory required, in k8s Quantity
                                          notation.
                                    }
                                },
                                "args": [
                                    "str"  # Optional. Command line arguments to
                                      forward to the runner.
                                ]
                            }
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for
                          the session. Use of this field is recommended to avoid accidental compute
                          costs.
                        "replicas": 1,  # Optional. Default value is 1. Number of model
                          replicas.
                        "useSpotPods": True  # Optional. Default value is True. Use 'spot
                          pods' for cheaper computation.
                    },
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Evaluation",  # Optional. Default value is "Evaluation". Kind.
                      "Evaluation"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "replications": 1,  # Optional. Default value is 1. Number of replications to
                      run.
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str",  # Optional. Top-level resource status (assigned by system).
                    "workersPerReplica": 0  # Optional. Number of data workers per inference
                      service replica.
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_evaluations_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get(self, evaluation_id: str, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Get an Evaluation by its key.

        Get an Evaluation by its key. Raises a 404 error if no entity exists with that key.

        :param evaluation_id: Required.
        :type evaluation_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "dataset": "str",  # The Dataset to evaluate on. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "inferenceSession": {
                        "inferenceService": {
                            "account": "str",  # Account that owns the entity. Required.
                            "id": "str",  # Unique identifier of the entity. Required.
                            "interface": {
                                "endpoint": "str",  # HTTP endpoint for inference.
                                  Required.
                                "outputSchema": {
                                    "arrowSchema": "str",  # The schema in Arrow
                                      format, encoded with dyff.schema.arrow.encode_schema(). This is
                                      required, but can be populated from a DyffDataSchema. Required.
                                    "dyffSchema": {
                                        "components": [
                                            "str"  # A list of named dyff
                                              data schemas. The final schema is the composition of
                                              these component schemas. Required.
                                        ],
                                        "schemaVersion": "0.1"  # Optional.
                                          Default value is "0.1". The dyff schema version. "0.1"
                                    },
                                    "jsonSchema": {}  # Optional. The schema in
                                      JSON Schema format.
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ]
                            },
                            "name": "str",  # The name of the service. Required.
                            "builder": {
                                "kind": "str",  # Kind. Required.
                                "args": [
                                    "str"  # Optional. Args.
                                ]
                            },
                            "model": {
                                "account": "str",  # Account that owns the entity.
                                  Required.
                                "artifact": {
                                    "kind": "str",  # How the model data is
                                      represented. Required. "HuggingFaceCache"
                                    "huggingFaceCache": {
                                        "repoID": "str",  # Name of the model
                                          in the HuggingFace cache. Required.
                                        "revision": "str"  # Model revision.
                                          Required.
                                    }
                                },
                                "id": "str",  # Unique identifier of the entity.
                                  Required.
                                "name": "str",  # The name of the Model. Required.
                                "storage": {
                                    "medium": "str"  # Storage medium. Required.
                                      Known values are: "ObjectStorage" and "PersistentVolume".
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",  # Unique ID of the DataView.
                                      Required.
                                    "schema": {
                                        "arrowSchema": "str",  # The schema
                                          in Arrow format, encoded with
                                          dyff.schema.arrow.encode_schema(). This is required, but can
                                          be populated from a DyffDataSchema. Required.
                                        "dyffSchema": {
                                            "components": [
                                                "str"  # A list of
                                                  named dyff data schemas. The final schema is the
                                                  composition of these component schemas. Required.
                                            ],
                                            "schemaVersion": "0.1"  #
                                              Optional. Default value is "0.1". The dyff schema
                                              version. "0.1"
                                        },
                                        "jsonSchema": {}  # Optional. The
                                          schema in JSON Schema format.
                                    },
                                    "viewOf": "str",  # ID of the resource that
                                      this is a view of. Required.
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",  # Name of a
                                              schema adapter available on the platform. Required.
                                            "configuration": {}  #
                                              Optional. Configuration for the schema adapter. Must be
                                              encodable as JSON.
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",  # An enumeration. Required. Known
                                  values are: "bentoml_service_openllm", "mock", "standalone", and
                                  "vllm".
                                "resources": {
                                    "storage": "str",  # Amount of storage
                                      required for packaged model, in k8s Quantity notation. Required.
                                    "memory": "str"  # Optional. Amount of memory
                                      required to run the model on CPU, in k8s Quantity notation.
                                },
                                "accelerator": {
                                    "kind": "str",  # The kind of accelerator;
                                      available kinds are {{GPU}}. Required.
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"  # Acceptable GPU
                                              hardware types. Required.
                                        ],
                                        "count": 1,  # Optional. Default
                                          value is 1. Number of GPUs required.
                                        "memory": "str"  # Optional.
                                          [DEPRECATED] Amount of GPU memory required, in k8s Quantity
                                          notation.
                                    }
                                },
                                "args": [
                                    "str"  # Optional. Command line arguments to
                                      forward to the runner.
                                ]
                            }
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for
                          the session. Use of this field is recommended to avoid accidental compute
                          costs.
                        "replicas": 1,  # Optional. Default value is 1. Number of model
                          replicas.
                        "useSpotPods": True  # Optional. Default value is True. Use 'spot
                          pods' for cheaper computation.
                    },
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Evaluation",  # Optional. Default value is "Evaluation". Kind.
                      "Evaluation"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "replications": 1,  # Optional. Default value is 1. Number of replications to
                      run.
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str",  # Optional. Top-level resource status (assigned by system).
                    "workersPerReplica": 0  # Optional. Number of data workers per inference
                      service replica.
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_evaluations_get_request(
            evaluation_id=evaluation_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def delete(self, evaluation_id: str, **kwargs: Any) -> JSON:
        """Mark an Evaluation for deletion.

        Mark an Evaluation for deletion.

        :param evaluation_id: Required.
        :type evaluation_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_evaluations_delete_request(
            evaluation_id=evaluation_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class InferenceservicesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.DyffAPI`'s
        :attr:`inferenceservices` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    def label(
        self,
        service_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing InferenceService.

        Update labels for an existing InferenceService.

        :param service_id: Required.
        :type service_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def label(
        self,
        service_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        """Update labels for an existing InferenceService.

        Update labels for an existing InferenceService.

        :param service_id: Required.
        :type service_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def label(
        self, service_id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing InferenceService.

        Update labels for an existing InferenceService.

        :param service_id: Required.
        :type service_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Union[Any, JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_inferenceservices_label_request(
            service_id=service_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[Any, JSON], deserialized), {})  # type: ignore

        return cast(Union[Any, JSON], deserialized)  # type: ignore

    @distributed_trace
    def query(
        self,
        *,
        id: Optional[str] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        name: Optional[str] = None,
        model: Optional[str] = None,
        model_name: Optional[str] = None,
        **kwargs: Any
    ) -> Union[List[JSON], JSON]:
        # pylint: disable=line-too-long
        """Get all InferenceServices matching a query.

        Get all InferenceServices matching a query. The query is a set of equality
        constraints specified as key-value pairs.

        :keyword id: Default value is None.
        :paramtype id: str
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword name: Default value is None.
        :paramtype name: str
        :keyword model: Default value is None.
        :paramtype model: str
        :keyword model_name: Default value is None.
        :paramtype model_name: str
        :return: list of JSON object or JSON object
        :rtype: list[JSON] or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",  # Account that owns the entity. Required.
                        "id": "str",  # Unique identifier of the entity. Required.
                        "interface": {
                            "endpoint": "str",  # HTTP endpoint for inference. Required.
                            "outputSchema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "inputPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ],
                            "outputPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        },
                        "name": "str",  # The name of the service. Required.
                        "annotations": [
                            {
                                "key": "str",  # The annotation key. A DNS label with
                                  an optional DNS domain prefix. For example: 'my-key',
                                  'your.com/key_0'. Names prefixed with 'dyff.io/',
                                  'subdomain.dyff.io/', etc. are reserved.  See
                                  https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                                  for detailed naming rules. Required.
                                "value": "str"  # The annotation value. An arbitrary
                                  string. Required.
                            }
                        ],
                        "builder": {
                            "kind": "str",  # Kind. Required.
                            "args": [
                                "str"  # Optional. Args.
                            ]
                        },
                        "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation
                          time (assigned by system).
                        "kind": "InferenceService",  # Optional. Default value is
                          "InferenceService". Kind. "InferenceService"
                        "labels": {
                            "str": "str"  # Optional. A set of key-value labels for the
                              resource. Used to specify identifying attributes of resources that are
                              meaningful to users but do not imply semantics in the dyff system.  The
                              keys are DNS labels with an optional DNS domain prefix. For example:
                              'my-key', 'your.com/key_0'. Keys prefixed with 'dyff.io/',
                              'subdomain.dyff.io/', etc. are reserved.  The label values are
                              alphanumeric characters separated by '.', '-', or '_'.  We follow the
                              kubernetes label conventions closely. See:
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                        },
                        "model": {
                            "account": "str",  # Account that owns the entity. Required.
                            "artifact": {
                                "kind": "str",  # How the model data is represented.
                                  Required. "HuggingFaceCache"
                                "huggingFaceCache": {
                                    "repoID": "str",  # Name of the model in the
                                      HuggingFace cache. Required.
                                    "revision": "str"  # Model revision.
                                      Required.
                                }
                            },
                            "id": "str",  # Unique identifier of the entity. Required.
                            "name": "str",  # The name of the Model. Required.
                            "storage": {
                                "medium": "str"  # Storage medium. Required. Known
                                  values are: "ObjectStorage" and "PersistentVolume".
                            }
                        },
                        "outputViews": [
                            {
                                "id": "str",  # Unique ID of the DataView. Required.
                                "schema": {
                                    "arrowSchema": "str",  # The schema in Arrow
                                      format, encoded with dyff.schema.arrow.encode_schema(). This is
                                      required, but can be populated from a DyffDataSchema. Required.
                                    "dyffSchema": {
                                        "components": [
                                            "str"  # A list of named dyff
                                              data schemas. The final schema is the composition of
                                              these component schemas. Required.
                                        ],
                                        "schemaVersion": "0.1"  # Optional.
                                          Default value is "0.1". The dyff schema version. "0.1"
                                    },
                                    "jsonSchema": {}  # Optional. The schema in
                                      JSON Schema format.
                                },
                                "viewOf": "str",  # ID of the resource that this is a
                                  view of. Required.
                                "adapterPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ]
                            }
                        ],
                        "reason": "str",  # Optional. Reason for current status (assigned by
                          system).
                        "runner": {
                            "kind": "str",  # An enumeration. Required. Known values are:
                              "bentoml_service_openllm", "mock", "standalone", and "vllm".
                            "resources": {
                                "storage": "str",  # Amount of storage required for
                                  packaged model, in k8s Quantity notation. Required.
                                "memory": "str"  # Optional. Amount of memory
                                  required to run the model on CPU, in k8s Quantity notation.
                            },
                            "accelerator": {
                                "kind": "str",  # The kind of accelerator; available
                                  kinds are {{GPU}}. Required.
                                "gpu": {
                                    "hardwareTypes": [
                                        "str"  # Acceptable GPU hardware
                                          types. Required.
                                    ],
                                    "count": 1,  # Optional. Default value is 1.
                                      Number of GPUs required.
                                    "memory": "str"  # Optional. [DEPRECATED]
                                      Amount of GPU memory required, in k8s Quantity notation.
                                }
                            },
                            "args": [
                                "str"  # Optional. Command line arguments to forward
                                  to the runner.
                            ]
                        },
                        "schemaVersion": "0.1",  # Optional. Default value is "0.1". The
                          schema version. "0.1"
                        "status": "str"  # Optional. Top-level resource status (assigned by
                          system).
                    }
                ]
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[List[JSON], JSON]] = kwargs.pop("cls", None)

        _request = build_inferenceservices_query_request(
            id=id,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            name=name,
            model=model,
            model_name=model_name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[List[JSON], JSON], deserialized), {})  # type: ignore

        return cast(Union[List[JSON], JSON], deserialized)  # type: ignore

    @overload
    def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create an InferenceService.

        Create an InferenceService.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "interface": {
                        "endpoint": "str",  # HTTP endpoint for inference. Required.
                        "outputSchema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "name": "str",  # The name of the service. Required.
                    "builder": {
                        "kind": "str",  # Kind. Required.
                        "args": [
                            "str"  # Optional. Args.
                        ]
                    },
                    "model": "str",  # Optional. ID of Model backing the service, if applicable.
                    "outputViews": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ],
                    "runner": {
                        "kind": "str",  # An enumeration. Required. Known values are:
                          "bentoml_service_openllm", "mock", "standalone", and "vllm".
                        "resources": {
                            "storage": "str",  # Amount of storage required for packaged
                              model, in k8s Quantity notation. Required.
                            "memory": "str"  # Optional. Amount of memory required to run
                              the model on CPU, in k8s Quantity notation.
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "args": [
                            "str"  # Optional. Command line arguments to forward to the
                              runner.
                        ]
                    },
                    "schemaVersion": "0.1"  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "interface": {
                        "endpoint": "str",  # HTTP endpoint for inference. Required.
                        "outputSchema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "name": "str",  # The name of the service. Required.
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "builder": {
                        "kind": "str",  # Kind. Required.
                        "args": [
                            "str"  # Optional. Args.
                        ]
                    },
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "InferenceService",  # Optional. Default value is "InferenceService".
                      Kind. "InferenceService"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "model": {
                        "account": "str",  # Account that owns the entity. Required.
                        "artifact": {
                            "kind": "str",  # How the model data is represented.
                              Required. "HuggingFaceCache"
                            "huggingFaceCache": {
                                "repoID": "str",  # Name of the model in the
                                  HuggingFace cache. Required.
                                "revision": "str"  # Model revision. Required.
                            }
                        },
                        "id": "str",  # Unique identifier of the entity. Required.
                        "name": "str",  # The name of the Model. Required.
                        "storage": {
                            "medium": "str"  # Storage medium. Required. Known values
                              are: "ObjectStorage" and "PersistentVolume".
                        }
                    },
                    "outputViews": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ],
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "runner": {
                        "kind": "str",  # An enumeration. Required. Known values are:
                          "bentoml_service_openllm", "mock", "standalone", and "vllm".
                        "resources": {
                            "storage": "str",  # Amount of storage required for packaged
                              model, in k8s Quantity notation. Required.
                            "memory": "str"  # Optional. Amount of memory required to run
                              the model on CPU, in k8s Quantity notation.
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "args": [
                            "str"  # Optional. Command line arguments to forward to the
                              runner.
                        ]
                    },
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create an InferenceService.

        Create an InferenceService.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "interface": {
                        "endpoint": "str",  # HTTP endpoint for inference. Required.
                        "outputSchema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "name": "str",  # The name of the service. Required.
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "builder": {
                        "kind": "str",  # Kind. Required.
                        "args": [
                            "str"  # Optional. Args.
                        ]
                    },
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "InferenceService",  # Optional. Default value is "InferenceService".
                      Kind. "InferenceService"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "model": {
                        "account": "str",  # Account that owns the entity. Required.
                        "artifact": {
                            "kind": "str",  # How the model data is represented.
                              Required. "HuggingFaceCache"
                            "huggingFaceCache": {
                                "repoID": "str",  # Name of the model in the
                                  HuggingFace cache. Required.
                                "revision": "str"  # Model revision. Required.
                            }
                        },
                        "id": "str",  # Unique identifier of the entity. Required.
                        "name": "str",  # The name of the Model. Required.
                        "storage": {
                            "medium": "str"  # Storage medium. Required. Known values
                              are: "ObjectStorage" and "PersistentVolume".
                        }
                    },
                    "outputViews": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ],
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "runner": {
                        "kind": "str",  # An enumeration. Required. Known values are:
                          "bentoml_service_openllm", "mock", "standalone", and "vllm".
                        "resources": {
                            "storage": "str",  # Amount of storage required for packaged
                              model, in k8s Quantity notation. Required.
                            "memory": "str"  # Optional. Amount of memory required to run
                              the model on CPU, in k8s Quantity notation.
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "args": [
                            "str"  # Optional. Command line arguments to forward to the
                              runner.
                        ]
                    },
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Create an InferenceService.

        Create an InferenceService.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "interface": {
                        "endpoint": "str",  # HTTP endpoint for inference. Required.
                        "outputSchema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "name": "str",  # The name of the service. Required.
                    "builder": {
                        "kind": "str",  # Kind. Required.
                        "args": [
                            "str"  # Optional. Args.
                        ]
                    },
                    "model": "str",  # Optional. ID of Model backing the service, if applicable.
                    "outputViews": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ],
                    "runner": {
                        "kind": "str",  # An enumeration. Required. Known values are:
                          "bentoml_service_openllm", "mock", "standalone", and "vllm".
                        "resources": {
                            "storage": "str",  # Amount of storage required for packaged
                              model, in k8s Quantity notation. Required.
                            "memory": "str"  # Optional. Amount of memory required to run
                              the model on CPU, in k8s Quantity notation.
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "args": [
                            "str"  # Optional. Command line arguments to forward to the
                              runner.
                        ]
                    },
                    "schemaVersion": "0.1"  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "interface": {
                        "endpoint": "str",  # HTTP endpoint for inference. Required.
                        "outputSchema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "name": "str",  # The name of the service. Required.
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "builder": {
                        "kind": "str",  # Kind. Required.
                        "args": [
                            "str"  # Optional. Args.
                        ]
                    },
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "InferenceService",  # Optional. Default value is "InferenceService".
                      Kind. "InferenceService"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "model": {
                        "account": "str",  # Account that owns the entity. Required.
                        "artifact": {
                            "kind": "str",  # How the model data is represented.
                              Required. "HuggingFaceCache"
                            "huggingFaceCache": {
                                "repoID": "str",  # Name of the model in the
                                  HuggingFace cache. Required.
                                "revision": "str"  # Model revision. Required.
                            }
                        },
                        "id": "str",  # Unique identifier of the entity. Required.
                        "name": "str",  # The name of the Model. Required.
                        "storage": {
                            "medium": "str"  # Storage medium. Required. Known values
                              are: "ObjectStorage" and "PersistentVolume".
                        }
                    },
                    "outputViews": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ],
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "runner": {
                        "kind": "str",  # An enumeration. Required. Known values are:
                          "bentoml_service_openllm", "mock", "standalone", and "vllm".
                        "resources": {
                            "storage": "str",  # Amount of storage required for packaged
                              model, in k8s Quantity notation. Required.
                            "memory": "str"  # Optional. Amount of memory required to run
                              the model on CPU, in k8s Quantity notation.
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "args": [
                            "str"  # Optional. Command line arguments to forward to the
                              runner.
                        ]
                    },
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_inferenceservices_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get(self, service_id: str, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Get an InferenceService by its key.

        Get an InferenceService by its key. Raises a 404 error if no entity exists with that key.

        :param service_id: Required.
        :type service_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "interface": {
                        "endpoint": "str",  # HTTP endpoint for inference. Required.
                        "outputSchema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "name": "str",  # The name of the service. Required.
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "builder": {
                        "kind": "str",  # Kind. Required.
                        "args": [
                            "str"  # Optional. Args.
                        ]
                    },
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "InferenceService",  # Optional. Default value is "InferenceService".
                      Kind. "InferenceService"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "model": {
                        "account": "str",  # Account that owns the entity. Required.
                        "artifact": {
                            "kind": "str",  # How the model data is represented.
                              Required. "HuggingFaceCache"
                            "huggingFaceCache": {
                                "repoID": "str",  # Name of the model in the
                                  HuggingFace cache. Required.
                                "revision": "str"  # Model revision. Required.
                            }
                        },
                        "id": "str",  # Unique identifier of the entity. Required.
                        "name": "str",  # The name of the Model. Required.
                        "storage": {
                            "medium": "str"  # Storage medium. Required. Known values
                              are: "ObjectStorage" and "PersistentVolume".
                        }
                    },
                    "outputViews": [
                        {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        }
                    ],
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "runner": {
                        "kind": "str",  # An enumeration. Required. Known values are:
                          "bentoml_service_openllm", "mock", "standalone", and "vllm".
                        "resources": {
                            "storage": "str",  # Amount of storage required for packaged
                              model, in k8s Quantity notation. Required.
                            "memory": "str"  # Optional. Amount of memory required to run
                              the model on CPU, in k8s Quantity notation.
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "args": [
                            "str"  # Optional. Command line arguments to forward to the
                              runner.
                        ]
                    },
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_inferenceservices_get_request(
            service_id=service_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def delete(self, service_id: str, **kwargs: Any) -> JSON:
        """Mark an InferenceService for deletion.

        Mark an InferenceService for deletion.

        :param service_id: Required.
        :type service_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_inferenceservices_delete_request(
            service_id=service_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class InferencesessionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.DyffAPI`'s
        :attr:`inferencesessions` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    def label(
        self,
        session_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing InferenceSession.

        Update labels for an existing InferenceSession.

        :param session_id: Required.
        :type session_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def label(
        self,
        session_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        """Update labels for an existing InferenceSession.

        Update labels for an existing InferenceSession.

        :param session_id: Required.
        :type session_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def label(
        self, session_id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing InferenceSession.

        Update labels for an existing InferenceSession.

        :param session_id: Required.
        :type session_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Union[Any, JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_inferencesessions_label_request(
            session_id=session_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[Any, JSON], deserialized), {})  # type: ignore

        return cast(Union[Any, JSON], deserialized)  # type: ignore

    @distributed_trace
    def query(
        self,
        *,
        id: Optional[str] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        name: Optional[str] = None,
        inference_service: Optional[str] = None,
        inference_service_name: Optional[str] = None,
        model: Optional[str] = None,
        model_name: Optional[str] = None,
        **kwargs: Any
    ) -> Union[List[JSON], JSON]:
        # pylint: disable=line-too-long
        """Get all InferenceSessions matching a query.

        Get all InferenceSessions matching a query. The query is a set of equality
        constraints specified as key-value pairs.

        :keyword id: Default value is None.
        :paramtype id: str
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword name: Default value is None.
        :paramtype name: str
        :keyword inference_service: Default value is None.
        :paramtype inference_service: str
        :keyword inference_service_name: Default value is None.
        :paramtype inference_service_name: str
        :keyword model: Default value is None.
        :paramtype model: str
        :keyword model_name: Default value is None.
        :paramtype model_name: str
        :return: list of JSON object or JSON object
        :rtype: list[JSON] or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",  # Account that owns the entity. Required.
                        "id": "str",  # Unique identifier of the entity. Required.
                        "inferenceService": {
                            "account": "str",  # Account that owns the entity. Required.
                            "id": "str",  # Unique identifier of the entity. Required.
                            "interface": {
                                "endpoint": "str",  # HTTP endpoint for inference.
                                  Required.
                                "outputSchema": {
                                    "arrowSchema": "str",  # The schema in Arrow
                                      format, encoded with dyff.schema.arrow.encode_schema(). This is
                                      required, but can be populated from a DyffDataSchema. Required.
                                    "dyffSchema": {
                                        "components": [
                                            "str"  # A list of named dyff
                                              data schemas. The final schema is the composition of
                                              these component schemas. Required.
                                        ],
                                        "schemaVersion": "0.1"  # Optional.
                                          Default value is "0.1". The dyff schema version. "0.1"
                                    },
                                    "jsonSchema": {}  # Optional. The schema in
                                      JSON Schema format.
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ]
                            },
                            "name": "str",  # The name of the service. Required.
                            "builder": {
                                "kind": "str",  # Kind. Required.
                                "args": [
                                    "str"  # Optional. Args.
                                ]
                            },
                            "model": {
                                "account": "str",  # Account that owns the entity.
                                  Required.
                                "artifact": {
                                    "kind": "str",  # How the model data is
                                      represented. Required. "HuggingFaceCache"
                                    "huggingFaceCache": {
                                        "repoID": "str",  # Name of the model
                                          in the HuggingFace cache. Required.
                                        "revision": "str"  # Model revision.
                                          Required.
                                    }
                                },
                                "id": "str",  # Unique identifier of the entity.
                                  Required.
                                "name": "str",  # The name of the Model. Required.
                                "storage": {
                                    "medium": "str"  # Storage medium. Required.
                                      Known values are: "ObjectStorage" and "PersistentVolume".
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",  # Unique ID of the DataView.
                                      Required.
                                    "schema": {
                                        "arrowSchema": "str",  # The schema
                                          in Arrow format, encoded with
                                          dyff.schema.arrow.encode_schema(). This is required, but can
                                          be populated from a DyffDataSchema. Required.
                                        "dyffSchema": {
                                            "components": [
                                                "str"  # A list of
                                                  named dyff data schemas. The final schema is the
                                                  composition of these component schemas. Required.
                                            ],
                                            "schemaVersion": "0.1"  #
                                              Optional. Default value is "0.1". The dyff schema
                                              version. "0.1"
                                        },
                                        "jsonSchema": {}  # Optional. The
                                          schema in JSON Schema format.
                                    },
                                    "viewOf": "str",  # ID of the resource that
                                      this is a view of. Required.
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",  # Name of a
                                              schema adapter available on the platform. Required.
                                            "configuration": {}  #
                                              Optional. Configuration for the schema adapter. Must be
                                              encodable as JSON.
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",  # An enumeration. Required. Known
                                  values are: "bentoml_service_openllm", "mock", "standalone", and
                                  "vllm".
                                "resources": {
                                    "storage": "str",  # Amount of storage
                                      required for packaged model, in k8s Quantity notation. Required.
                                    "memory": "str"  # Optional. Amount of memory
                                      required to run the model on CPU, in k8s Quantity notation.
                                },
                                "accelerator": {
                                    "kind": "str",  # The kind of accelerator;
                                      available kinds are {{GPU}}. Required.
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"  # Acceptable GPU
                                              hardware types. Required.
                                        ],
                                        "count": 1,  # Optional. Default
                                          value is 1. Number of GPUs required.
                                        "memory": "str"  # Optional.
                                          [DEPRECATED] Amount of GPU memory required, in k8s Quantity
                                          notation.
                                    }
                                },
                                "args": [
                                    "str"  # Optional. Command line arguments to
                                      forward to the runner.
                                ]
                            }
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "annotations": [
                            {
                                "key": "str",  # The annotation key. A DNS label with
                                  an optional DNS domain prefix. For example: 'my-key',
                                  'your.com/key_0'. Names prefixed with 'dyff.io/',
                                  'subdomain.dyff.io/', etc. are reserved.  See
                                  https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                                  for detailed naming rules. Required.
                                "value": "str"  # The annotation value. An arbitrary
                                  string. Required.
                            }
                        ],
                        "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation
                          time (assigned by system).
                        "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for
                          the session. Use of this field is recommended to avoid accidental compute
                          costs.
                        "kind": "InferenceSession",  # Optional. Default value is
                          "InferenceSession". Kind. "InferenceSession"
                        "labels": {
                            "str": "str"  # Optional. A set of key-value labels for the
                              resource. Used to specify identifying attributes of resources that are
                              meaningful to users but do not imply semantics in the dyff system.  The
                              keys are DNS labels with an optional DNS domain prefix. For example:
                              'my-key', 'your.com/key_0'. Keys prefixed with 'dyff.io/',
                              'subdomain.dyff.io/', etc. are reserved.  The label values are
                              alphanumeric characters separated by '.', '-', or '_'.  We follow the
                              kubernetes label conventions closely. See:
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                        },
                        "reason": "str",  # Optional. Reason for current status (assigned by
                          system).
                        "replicas": 1,  # Optional. Default value is 1. Number of model
                          replicas.
                        "schemaVersion": "0.1",  # Optional. Default value is "0.1". The
                          schema version. "0.1"
                        "status": "str",  # Optional. Top-level resource status (assigned by
                          system).
                        "useSpotPods": True  # Optional. Default value is True. Use 'spot
                          pods' for cheaper computation.
                    }
                ]
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[List[JSON], JSON]] = kwargs.pop("cls", None)

        _request = build_inferencesessions_query_request(
            id=id,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            name=name,
            inference_service=inference_service,
            inference_service_name=inference_service_name,
            model=model,
            model_name=model_name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[List[JSON], JSON], deserialized), {})  # type: ignore

        return cast(Union[List[JSON], JSON], deserialized)  # type: ignore

    @overload
    def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create an InferenceSession.

        Create an InferenceSession.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "inferenceService": "str",  # InferenceService ID. Required.
                    "accelerator": {
                        "kind": "str",  # The kind of accelerator; available kinds are
                          {{GPU}}. Required.
                        "gpu": {
                            "hardwareTypes": [
                                "str"  # Acceptable GPU hardware types. Required.
                            ],
                            "count": 1,  # Optional. Default value is 1. Number of GPUs
                              required.
                            "memory": "str"  # Optional. [DEPRECATED] Amount of GPU
                              memory required, in k8s Quantity notation.
                        }
                    },
                    "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for the
                      session. Use of this field is recommended to avoid accidental compute costs.
                    "replicas": 1,  # Optional. Default value is 1. Number of model replicas.
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "useSpotPods": True  # Optional. Default value is True. Use 'spot pods' for
                      cheaper computation.
                }

                # response body for status code(s): 200
                response == {
                    "inferencesession": {
                        "account": "str",  # Account that owns the entity. Required.
                        "id": "str",  # Unique identifier of the entity. Required.
                        "inferenceService": {
                            "account": "str",  # Account that owns the entity. Required.
                            "id": "str",  # Unique identifier of the entity. Required.
                            "interface": {
                                "endpoint": "str",  # HTTP endpoint for inference.
                                  Required.
                                "outputSchema": {
                                    "arrowSchema": "str",  # The schema in Arrow
                                      format, encoded with dyff.schema.arrow.encode_schema(). This is
                                      required, but can be populated from a DyffDataSchema. Required.
                                    "dyffSchema": {
                                        "components": [
                                            "str"  # A list of named dyff
                                              data schemas. The final schema is the composition of
                                              these component schemas. Required.
                                        ],
                                        "schemaVersion": "0.1"  # Optional.
                                          Default value is "0.1". The dyff schema version. "0.1"
                                    },
                                    "jsonSchema": {}  # Optional. The schema in
                                      JSON Schema format.
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ]
                            },
                            "name": "str",  # The name of the service. Required.
                            "builder": {
                                "kind": "str",  # Kind. Required.
                                "args": [
                                    "str"  # Optional. Args.
                                ]
                            },
                            "model": {
                                "account": "str",  # Account that owns the entity.
                                  Required.
                                "artifact": {
                                    "kind": "str",  # How the model data is
                                      represented. Required. "HuggingFaceCache"
                                    "huggingFaceCache": {
                                        "repoID": "str",  # Name of the model
                                          in the HuggingFace cache. Required.
                                        "revision": "str"  # Model revision.
                                          Required.
                                    }
                                },
                                "id": "str",  # Unique identifier of the entity.
                                  Required.
                                "name": "str",  # The name of the Model. Required.
                                "storage": {
                                    "medium": "str"  # Storage medium. Required.
                                      Known values are: "ObjectStorage" and "PersistentVolume".
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",  # Unique ID of the DataView.
                                      Required.
                                    "schema": {
                                        "arrowSchema": "str",  # The schema
                                          in Arrow format, encoded with
                                          dyff.schema.arrow.encode_schema(). This is required, but can
                                          be populated from a DyffDataSchema. Required.
                                        "dyffSchema": {
                                            "components": [
                                                "str"  # A list of
                                                  named dyff data schemas. The final schema is the
                                                  composition of these component schemas. Required.
                                            ],
                                            "schemaVersion": "0.1"  #
                                              Optional. Default value is "0.1". The dyff schema
                                              version. "0.1"
                                        },
                                        "jsonSchema": {}  # Optional. The
                                          schema in JSON Schema format.
                                    },
                                    "viewOf": "str",  # ID of the resource that
                                      this is a view of. Required.
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",  # Name of a
                                              schema adapter available on the platform. Required.
                                            "configuration": {}  #
                                              Optional. Configuration for the schema adapter. Must be
                                              encodable as JSON.
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",  # An enumeration. Required. Known
                                  values are: "bentoml_service_openllm", "mock", "standalone", and
                                  "vllm".
                                "resources": {
                                    "storage": "str",  # Amount of storage
                                      required for packaged model, in k8s Quantity notation. Required.
                                    "memory": "str"  # Optional. Amount of memory
                                      required to run the model on CPU, in k8s Quantity notation.
                                },
                                "accelerator": {
                                    "kind": "str",  # The kind of accelerator;
                                      available kinds are {{GPU}}. Required.
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"  # Acceptable GPU
                                              hardware types. Required.
                                        ],
                                        "count": 1,  # Optional. Default
                                          value is 1. Number of GPUs required.
                                        "memory": "str"  # Optional.
                                          [DEPRECATED] Amount of GPU memory required, in k8s Quantity
                                          notation.
                                    }
                                },
                                "args": [
                                    "str"  # Optional. Command line arguments to
                                      forward to the runner.
                                ]
                            }
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "annotations": [
                            {
                                "key": "str",  # The annotation key. A DNS label with
                                  an optional DNS domain prefix. For example: 'my-key',
                                  'your.com/key_0'. Names prefixed with 'dyff.io/',
                                  'subdomain.dyff.io/', etc. are reserved.  See
                                  https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                                  for detailed naming rules. Required.
                                "value": "str"  # The annotation value. An arbitrary
                                  string. Required.
                            }
                        ],
                        "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation
                          time (assigned by system).
                        "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for
                          the session. Use of this field is recommended to avoid accidental compute
                          costs.
                        "kind": "InferenceSession",  # Optional. Default value is
                          "InferenceSession". Kind. "InferenceSession"
                        "labels": {
                            "str": "str"  # Optional. A set of key-value labels for the
                              resource. Used to specify identifying attributes of resources that are
                              meaningful to users but do not imply semantics in the dyff system.  The
                              keys are DNS labels with an optional DNS domain prefix. For example:
                              'my-key', 'your.com/key_0'. Keys prefixed with 'dyff.io/',
                              'subdomain.dyff.io/', etc. are reserved.  The label values are
                              alphanumeric characters separated by '.', '-', or '_'.  We follow the
                              kubernetes label conventions closely. See:
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                        },
                        "reason": "str",  # Optional. Reason for current status (assigned by
                          system).
                        "replicas": 1,  # Optional. Default value is 1. Number of model
                          replicas.
                        "schemaVersion": "0.1",  # Optional. Default value is "0.1". The
                          schema version. "0.1"
                        "status": "str",  # Optional. Top-level resource status (assigned by
                          system).
                        "useSpotPods": True  # Optional. Default value is True. Use 'spot
                          pods' for cheaper computation.
                    },
                    "token": "str"  # Token. Required.
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create an InferenceSession.

        Create an InferenceSession.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "inferencesession": {
                        "account": "str",  # Account that owns the entity. Required.
                        "id": "str",  # Unique identifier of the entity. Required.
                        "inferenceService": {
                            "account": "str",  # Account that owns the entity. Required.
                            "id": "str",  # Unique identifier of the entity. Required.
                            "interface": {
                                "endpoint": "str",  # HTTP endpoint for inference.
                                  Required.
                                "outputSchema": {
                                    "arrowSchema": "str",  # The schema in Arrow
                                      format, encoded with dyff.schema.arrow.encode_schema(). This is
                                      required, but can be populated from a DyffDataSchema. Required.
                                    "dyffSchema": {
                                        "components": [
                                            "str"  # A list of named dyff
                                              data schemas. The final schema is the composition of
                                              these component schemas. Required.
                                        ],
                                        "schemaVersion": "0.1"  # Optional.
                                          Default value is "0.1". The dyff schema version. "0.1"
                                    },
                                    "jsonSchema": {}  # Optional. The schema in
                                      JSON Schema format.
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ]
                            },
                            "name": "str",  # The name of the service. Required.
                            "builder": {
                                "kind": "str",  # Kind. Required.
                                "args": [
                                    "str"  # Optional. Args.
                                ]
                            },
                            "model": {
                                "account": "str",  # Account that owns the entity.
                                  Required.
                                "artifact": {
                                    "kind": "str",  # How the model data is
                                      represented. Required. "HuggingFaceCache"
                                    "huggingFaceCache": {
                                        "repoID": "str",  # Name of the model
                                          in the HuggingFace cache. Required.
                                        "revision": "str"  # Model revision.
                                          Required.
                                    }
                                },
                                "id": "str",  # Unique identifier of the entity.
                                  Required.
                                "name": "str",  # The name of the Model. Required.
                                "storage": {
                                    "medium": "str"  # Storage medium. Required.
                                      Known values are: "ObjectStorage" and "PersistentVolume".
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",  # Unique ID of the DataView.
                                      Required.
                                    "schema": {
                                        "arrowSchema": "str",  # The schema
                                          in Arrow format, encoded with
                                          dyff.schema.arrow.encode_schema(). This is required, but can
                                          be populated from a DyffDataSchema. Required.
                                        "dyffSchema": {
                                            "components": [
                                                "str"  # A list of
                                                  named dyff data schemas. The final schema is the
                                                  composition of these component schemas. Required.
                                            ],
                                            "schemaVersion": "0.1"  #
                                              Optional. Default value is "0.1". The dyff schema
                                              version. "0.1"
                                        },
                                        "jsonSchema": {}  # Optional. The
                                          schema in JSON Schema format.
                                    },
                                    "viewOf": "str",  # ID of the resource that
                                      this is a view of. Required.
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",  # Name of a
                                              schema adapter available on the platform. Required.
                                            "configuration": {}  #
                                              Optional. Configuration for the schema adapter. Must be
                                              encodable as JSON.
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",  # An enumeration. Required. Known
                                  values are: "bentoml_service_openllm", "mock", "standalone", and
                                  "vllm".
                                "resources": {
                                    "storage": "str",  # Amount of storage
                                      required for packaged model, in k8s Quantity notation. Required.
                                    "memory": "str"  # Optional. Amount of memory
                                      required to run the model on CPU, in k8s Quantity notation.
                                },
                                "accelerator": {
                                    "kind": "str",  # The kind of accelerator;
                                      available kinds are {{GPU}}. Required.
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"  # Acceptable GPU
                                              hardware types. Required.
                                        ],
                                        "count": 1,  # Optional. Default
                                          value is 1. Number of GPUs required.
                                        "memory": "str"  # Optional.
                                          [DEPRECATED] Amount of GPU memory required, in k8s Quantity
                                          notation.
                                    }
                                },
                                "args": [
                                    "str"  # Optional. Command line arguments to
                                      forward to the runner.
                                ]
                            }
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "annotations": [
                            {
                                "key": "str",  # The annotation key. A DNS label with
                                  an optional DNS domain prefix. For example: 'my-key',
                                  'your.com/key_0'. Names prefixed with 'dyff.io/',
                                  'subdomain.dyff.io/', etc. are reserved.  See
                                  https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                                  for detailed naming rules. Required.
                                "value": "str"  # The annotation value. An arbitrary
                                  string. Required.
                            }
                        ],
                        "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation
                          time (assigned by system).
                        "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for
                          the session. Use of this field is recommended to avoid accidental compute
                          costs.
                        "kind": "InferenceSession",  # Optional. Default value is
                          "InferenceSession". Kind. "InferenceSession"
                        "labels": {
                            "str": "str"  # Optional. A set of key-value labels for the
                              resource. Used to specify identifying attributes of resources that are
                              meaningful to users but do not imply semantics in the dyff system.  The
                              keys are DNS labels with an optional DNS domain prefix. For example:
                              'my-key', 'your.com/key_0'. Keys prefixed with 'dyff.io/',
                              'subdomain.dyff.io/', etc. are reserved.  The label values are
                              alphanumeric characters separated by '.', '-', or '_'.  We follow the
                              kubernetes label conventions closely. See:
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                        },
                        "reason": "str",  # Optional. Reason for current status (assigned by
                          system).
                        "replicas": 1,  # Optional. Default value is 1. Number of model
                          replicas.
                        "schemaVersion": "0.1",  # Optional. Default value is "0.1". The
                          schema version. "0.1"
                        "status": "str",  # Optional. Top-level resource status (assigned by
                          system).
                        "useSpotPods": True  # Optional. Default value is True. Use 'spot
                          pods' for cheaper computation.
                    },
                    "token": "str"  # Token. Required.
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Create an InferenceSession.

        Create an InferenceSession.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "inferenceService": "str",  # InferenceService ID. Required.
                    "accelerator": {
                        "kind": "str",  # The kind of accelerator; available kinds are
                          {{GPU}}. Required.
                        "gpu": {
                            "hardwareTypes": [
                                "str"  # Acceptable GPU hardware types. Required.
                            ],
                            "count": 1,  # Optional. Default value is 1. Number of GPUs
                              required.
                            "memory": "str"  # Optional. [DEPRECATED] Amount of GPU
                              memory required, in k8s Quantity notation.
                        }
                    },
                    "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for the
                      session. Use of this field is recommended to avoid accidental compute costs.
                    "replicas": 1,  # Optional. Default value is 1. Number of model replicas.
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "useSpotPods": True  # Optional. Default value is True. Use 'spot pods' for
                      cheaper computation.
                }

                # response body for status code(s): 200
                response == {
                    "inferencesession": {
                        "account": "str",  # Account that owns the entity. Required.
                        "id": "str",  # Unique identifier of the entity. Required.
                        "inferenceService": {
                            "account": "str",  # Account that owns the entity. Required.
                            "id": "str",  # Unique identifier of the entity. Required.
                            "interface": {
                                "endpoint": "str",  # HTTP endpoint for inference.
                                  Required.
                                "outputSchema": {
                                    "arrowSchema": "str",  # The schema in Arrow
                                      format, encoded with dyff.schema.arrow.encode_schema(). This is
                                      required, but can be populated from a DyffDataSchema. Required.
                                    "dyffSchema": {
                                        "components": [
                                            "str"  # A list of named dyff
                                              data schemas. The final schema is the composition of
                                              these component schemas. Required.
                                        ],
                                        "schemaVersion": "0.1"  # Optional.
                                          Default value is "0.1". The dyff schema version. "0.1"
                                    },
                                    "jsonSchema": {}  # Optional. The schema in
                                      JSON Schema format.
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ]
                            },
                            "name": "str",  # The name of the service. Required.
                            "builder": {
                                "kind": "str",  # Kind. Required.
                                "args": [
                                    "str"  # Optional. Args.
                                ]
                            },
                            "model": {
                                "account": "str",  # Account that owns the entity.
                                  Required.
                                "artifact": {
                                    "kind": "str",  # How the model data is
                                      represented. Required. "HuggingFaceCache"
                                    "huggingFaceCache": {
                                        "repoID": "str",  # Name of the model
                                          in the HuggingFace cache. Required.
                                        "revision": "str"  # Model revision.
                                          Required.
                                    }
                                },
                                "id": "str",  # Unique identifier of the entity.
                                  Required.
                                "name": "str",  # The name of the Model. Required.
                                "storage": {
                                    "medium": "str"  # Storage medium. Required.
                                      Known values are: "ObjectStorage" and "PersistentVolume".
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",  # Unique ID of the DataView.
                                      Required.
                                    "schema": {
                                        "arrowSchema": "str",  # The schema
                                          in Arrow format, encoded with
                                          dyff.schema.arrow.encode_schema(). This is required, but can
                                          be populated from a DyffDataSchema. Required.
                                        "dyffSchema": {
                                            "components": [
                                                "str"  # A list of
                                                  named dyff data schemas. The final schema is the
                                                  composition of these component schemas. Required.
                                            ],
                                            "schemaVersion": "0.1"  #
                                              Optional. Default value is "0.1". The dyff schema
                                              version. "0.1"
                                        },
                                        "jsonSchema": {}  # Optional. The
                                          schema in JSON Schema format.
                                    },
                                    "viewOf": "str",  # ID of the resource that
                                      this is a view of. Required.
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",  # Name of a
                                              schema adapter available on the platform. Required.
                                            "configuration": {}  #
                                              Optional. Configuration for the schema adapter. Must be
                                              encodable as JSON.
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",  # An enumeration. Required. Known
                                  values are: "bentoml_service_openllm", "mock", "standalone", and
                                  "vllm".
                                "resources": {
                                    "storage": "str",  # Amount of storage
                                      required for packaged model, in k8s Quantity notation. Required.
                                    "memory": "str"  # Optional. Amount of memory
                                      required to run the model on CPU, in k8s Quantity notation.
                                },
                                "accelerator": {
                                    "kind": "str",  # The kind of accelerator;
                                      available kinds are {{GPU}}. Required.
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"  # Acceptable GPU
                                              hardware types. Required.
                                        ],
                                        "count": 1,  # Optional. Default
                                          value is 1. Number of GPUs required.
                                        "memory": "str"  # Optional.
                                          [DEPRECATED] Amount of GPU memory required, in k8s Quantity
                                          notation.
                                    }
                                },
                                "args": [
                                    "str"  # Optional. Command line arguments to
                                      forward to the runner.
                                ]
                            }
                        },
                        "accelerator": {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        },
                        "annotations": [
                            {
                                "key": "str",  # The annotation key. A DNS label with
                                  an optional DNS domain prefix. For example: 'my-key',
                                  'your.com/key_0'. Names prefixed with 'dyff.io/',
                                  'subdomain.dyff.io/', etc. are reserved.  See
                                  https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                                  for detailed naming rules. Required.
                                "value": "str"  # The annotation value. An arbitrary
                                  string. Required.
                            }
                        ],
                        "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation
                          time (assigned by system).
                        "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for
                          the session. Use of this field is recommended to avoid accidental compute
                          costs.
                        "kind": "InferenceSession",  # Optional. Default value is
                          "InferenceSession". Kind. "InferenceSession"
                        "labels": {
                            "str": "str"  # Optional. A set of key-value labels for the
                              resource. Used to specify identifying attributes of resources that are
                              meaningful to users but do not imply semantics in the dyff system.  The
                              keys are DNS labels with an optional DNS domain prefix. For example:
                              'my-key', 'your.com/key_0'. Keys prefixed with 'dyff.io/',
                              'subdomain.dyff.io/', etc. are reserved.  The label values are
                              alphanumeric characters separated by '.', '-', or '_'.  We follow the
                              kubernetes label conventions closely. See:
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                        },
                        "reason": "str",  # Optional. Reason for current status (assigned by
                          system).
                        "replicas": 1,  # Optional. Default value is 1. Number of model
                          replicas.
                        "schemaVersion": "0.1",  # Optional. Default value is "0.1". The
                          schema version. "0.1"
                        "status": "str",  # Optional. Top-level resource status (assigned by
                          system).
                        "useSpotPods": True  # Optional. Default value is True. Use 'spot
                          pods' for cheaper computation.
                    },
                    "token": "str"  # Token. Required.
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_inferencesessions_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get(self, session_id: str, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Get an InferenceSession by its key.

        Get an InferenceSession by its key. Raises a 404 error if no entity exists with that key.

        :param session_id: Required.
        :type session_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "inferenceService": {
                        "account": "str",  # Account that owns the entity. Required.
                        "id": "str",  # Unique identifier of the entity. Required.
                        "interface": {
                            "endpoint": "str",  # HTTP endpoint for inference. Required.
                            "outputSchema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "inputPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ],
                            "outputPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        },
                        "name": "str",  # The name of the service. Required.
                        "builder": {
                            "kind": "str",  # Kind. Required.
                            "args": [
                                "str"  # Optional. Args.
                            ]
                        },
                        "model": {
                            "account": "str",  # Account that owns the entity. Required.
                            "artifact": {
                                "kind": "str",  # How the model data is represented.
                                  Required. "HuggingFaceCache"
                                "huggingFaceCache": {
                                    "repoID": "str",  # Name of the model in the
                                      HuggingFace cache. Required.
                                    "revision": "str"  # Model revision.
                                      Required.
                                }
                            },
                            "id": "str",  # Unique identifier of the entity. Required.
                            "name": "str",  # The name of the Model. Required.
                            "storage": {
                                "medium": "str"  # Storage medium. Required. Known
                                  values are: "ObjectStorage" and "PersistentVolume".
                            }
                        },
                        "outputViews": [
                            {
                                "id": "str",  # Unique ID of the DataView. Required.
                                "schema": {
                                    "arrowSchema": "str",  # The schema in Arrow
                                      format, encoded with dyff.schema.arrow.encode_schema(). This is
                                      required, but can be populated from a DyffDataSchema. Required.
                                    "dyffSchema": {
                                        "components": [
                                            "str"  # A list of named dyff
                                              data schemas. The final schema is the composition of
                                              these component schemas. Required.
                                        ],
                                        "schemaVersion": "0.1"  # Optional.
                                          Default value is "0.1". The dyff schema version. "0.1"
                                    },
                                    "jsonSchema": {}  # Optional. The schema in
                                      JSON Schema format.
                                },
                                "viewOf": "str",  # ID of the resource that this is a
                                  view of. Required.
                                "adapterPipeline": [
                                    {
                                        "kind": "str",  # Name of a schema
                                          adapter available on the platform. Required.
                                        "configuration": {}  # Optional.
                                          Configuration for the schema adapter. Must be encodable as
                                          JSON.
                                    }
                                ]
                            }
                        ],
                        "runner": {
                            "kind": "str",  # An enumeration. Required. Known values are:
                              "bentoml_service_openllm", "mock", "standalone", and "vllm".
                            "resources": {
                                "storage": "str",  # Amount of storage required for
                                  packaged model, in k8s Quantity notation. Required.
                                "memory": "str"  # Optional. Amount of memory
                                  required to run the model on CPU, in k8s Quantity notation.
                            },
                            "accelerator": {
                                "kind": "str",  # The kind of accelerator; available
                                  kinds are {{GPU}}. Required.
                                "gpu": {
                                    "hardwareTypes": [
                                        "str"  # Acceptable GPU hardware
                                          types. Required.
                                    ],
                                    "count": 1,  # Optional. Default value is 1.
                                      Number of GPUs required.
                                    "memory": "str"  # Optional. [DEPRECATED]
                                      Amount of GPU memory required, in k8s Quantity notation.
                                }
                            },
                            "args": [
                                "str"  # Optional. Command line arguments to forward
                                  to the runner.
                            ]
                        }
                    },
                    "accelerator": {
                        "kind": "str",  # The kind of accelerator; available kinds are
                          {{GPU}}. Required.
                        "gpu": {
                            "hardwareTypes": [
                                "str"  # Acceptable GPU hardware types. Required.
                            ],
                            "count": 1,  # Optional. Default value is 1. Number of GPUs
                              required.
                            "memory": "str"  # Optional. [DEPRECATED] Amount of GPU
                              memory required, in k8s Quantity notation.
                        }
                    },
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "expires": "2020-02-20 00:00:00",  # Optional. Expiration time for the
                      session. Use of this field is recommended to avoid accidental compute costs.
                    "kind": "InferenceSession",  # Optional. Default value is "InferenceSession".
                      Kind. "InferenceSession"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "replicas": 1,  # Optional. Default value is 1. Number of model replicas.
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str",  # Optional. Top-level resource status (assigned by system).
                    "useSpotPods": True  # Optional. Default value is True. Use 'spot pods' for
                      cheaper computation.
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_inferencesessions_get_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def delete(self, session_id: str, **kwargs: Any) -> JSON:
        """Mark an InferenceSession for deletion.

        Mark an InferenceSession for deletion.

        :param session_id: Required.
        :type session_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_inferencesessions_delete_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def terminate(self, session_id: str, **kwargs: Any) -> JSON:
        """Terminate an InferenceSession.

        Terminate an InferenceSession.

        :param session_id: Required.
        :type session_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_inferencesessions_terminate_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def infer(
        self, session_id: str, inference_endpoint: str, **kwargs: Any
    ) -> Union[Any, JSON]:
        """Create an InferenceSession.

        Create an InferenceSession.

        :param session_id: Required.
        :type session_id: str
        :param inference_endpoint: Required.
        :type inference_endpoint: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[Any, JSON]] = kwargs.pop("cls", None)

        _request = build_inferencesessions_infer_request(
            session_id=session_id,
            inference_endpoint=inference_endpoint,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[Any, JSON], deserialized), {})  # type: ignore

        return cast(Union[Any, JSON], deserialized)  # type: ignore

    @distributed_trace
    def token(self, session_id: str, **kwargs: Any) -> Union[str, JSON]:
        """Get an access token for an existing InferenceSession.

        Get an access token for an existing InferenceSession.

        :param session_id: Required.
        :type session_id: str
        :return: str or JSON object
        :rtype: str or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[str, JSON]] = kwargs.pop("cls", None)

        _request = build_inferencesessions_token_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[str, JSON], deserialized), {})  # type: ignore

        return cast(Union[str, JSON], deserialized)  # type: ignore

    @distributed_trace
    def ready(self, session_id: str, **kwargs: Any) -> Union[Any, JSON]:
        """Perform a readiness probe on the session.

        Check if an InferenceSession is ready. Returns status 200 if the
        session is ready. Raises a 503 (ServiceUnavailable) error if the session
        is not ready.

        Raises a 404 error if no session exists with the provided ID. Note that
        this may happen temporarily for session that were created recently, as it
        takes time for status information to propagate through the platform.

        :param session_id: Required.
        :type session_id: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[Any, JSON]] = kwargs.pop("cls", None)

        _request = build_inferencesessions_ready_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[Any, JSON], deserialized), {})  # type: ignore

        return cast(Union[Any, JSON], deserialized)  # type: ignore


class ModelsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.DyffAPI`'s
        :attr:`models` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    def label(
        self,
        model_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing Model.

        Update labels for an existing Model.

        :param model_id: Required.
        :type model_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def label(
        self,
        model_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        """Update labels for an existing Model.

        Update labels for an existing Model.

        :param model_id: Required.
        :type model_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def label(
        self, model_id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing Model.

        Update labels for an existing Model.

        :param model_id: Required.
        :type model_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Union[Any, JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_models_label_request(
            model_id=model_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[Any, JSON], deserialized), {})  # type: ignore

        return cast(Union[Any, JSON], deserialized)  # type: ignore

    @distributed_trace
    def query(
        self,
        *,
        id: Optional[str] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> Union[List[JSON], JSON]:
        # pylint: disable=line-too-long
        """Get all Models matching a query.

        Get all Models matching a query. The query is a set of equality
        constraints specified as key-value pairs.

        :keyword id: Default value is None.
        :paramtype id: str
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword name: Default value is None.
        :paramtype name: str
        :return: list of JSON object or JSON object
        :rtype: list[JSON] or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",  # Account that owns the entity. Required.
                        "artifact": {
                            "kind": "str",  # How the model data is represented.
                              Required. "HuggingFaceCache"
                            "huggingFaceCache": {
                                "repoID": "str",  # Name of the model in the
                                  HuggingFace cache. Required.
                                "revision": "str"  # Model revision. Required.
                            }
                        },
                        "id": "str",  # Unique identifier of the entity. Required.
                        "name": "str",  # The name of the Model. Required.
                        "resources": {
                            "storage": "str",  # Amount of storage required for packaged
                              model, in k8s Quantity notation. Required.
                            "memory": "str"  # Optional. Amount of memory required to run
                              the model on CPU, in k8s Quantity notation.
                        },
                        "source": {
                            "kind": "str",  # The kind of model source. Required. Known
                              values are: "GitLFS", "HuggingFaceHub", "OpenLLM", and "Upload".
                            "gitLFS": {
                                "url": "str"  # The URL of the Git LFS repository.
                                  Required.
                            },
                            "huggingFaceHub": {
                                "repoID": "str",  # Repoid. Required.
                                "revision": "str",  # Revision. Required.
                                "allowPatterns": [
                                    "str"  # Optional. Allowpatterns.
                                ],
                                "ignorePatterns": [
                                    "str"  # Optional. Ignorepatterns.
                                ]
                            },
                            "openLLM": {
                                "modelID": "str",  # The specific model identifier
                                  (c.f. 'openllm build ... --model-id :code:`<modelId>`'). Required.
                                "modelKind": "str",  # The kind of model (c.f.
                                  'openllm build :code:`<modelKind>`'). Required.
                                "modelVersion": "str"  # The version of the model
                                  (e.g., a git commit hash). Required.
                            }
                        },
                        "storage": {
                            "medium": "str"  # Storage medium. Required. Known values
                              are: "ObjectStorage" and "PersistentVolume".
                        },
                        "accelerators": [
                            {
                                "kind": "str",  # The kind of accelerator; available
                                  kinds are {{GPU}}. Required.
                                "gpu": {
                                    "hardwareTypes": [
                                        "str"  # Acceptable GPU hardware
                                          types. Required.
                                    ],
                                    "count": 1,  # Optional. Default value is 1.
                                      Number of GPUs required.
                                    "memory": "str"  # Optional. [DEPRECATED]
                                      Amount of GPU memory required, in k8s Quantity notation.
                                }
                            }
                        ],
                        "annotations": [
                            {
                                "key": "str",  # The annotation key. A DNS label with
                                  an optional DNS domain prefix. For example: 'my-key',
                                  'your.com/key_0'. Names prefixed with 'dyff.io/',
                                  'subdomain.dyff.io/', etc. are reserved.  See
                                  https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                                  for detailed naming rules. Required.
                                "value": "str"  # The annotation value. An arbitrary
                                  string. Required.
                            }
                        ],
                        "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation
                          time (assigned by system).
                        "kind": "Model",  # Optional. Default value is "Model". Kind. "Model"
                        "labels": {
                            "str": "str"  # Optional. A set of key-value labels for the
                              resource. Used to specify identifying attributes of resources that are
                              meaningful to users but do not imply semantics in the dyff system.  The
                              keys are DNS labels with an optional DNS domain prefix. For example:
                              'my-key', 'your.com/key_0'. Keys prefixed with 'dyff.io/',
                              'subdomain.dyff.io/', etc. are reserved.  The label values are
                              alphanumeric characters separated by '.', '-', or '_'.  We follow the
                              kubernetes label conventions closely. See:
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                        },
                        "reason": "str",  # Optional. Reason for current status (assigned by
                          system).
                        "schemaVersion": "0.1",  # Optional. Default value is "0.1". The
                          schema version. "0.1"
                        "status": "str"  # Optional. Top-level resource status (assigned by
                          system).
                    }
                ]
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[List[JSON], JSON]] = kwargs.pop("cls", None)

        _request = build_models_query_request(
            id=id,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            name=name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[List[JSON], JSON], deserialized), {})  # type: ignore

        return cast(Union[List[JSON], JSON], deserialized)  # type: ignore

    @overload
    def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create a Model.

        Create a Model.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifact": {
                        "kind": "str",  # How the model data is represented. Required.
                          "HuggingFaceCache"
                        "huggingFaceCache": {
                            "repoID": "str",  # Name of the model in the HuggingFace
                              cache. Required.
                            "revision": "str"  # Model revision. Required.
                        }
                    },
                    "name": "str",  # The name of the Model. Required.
                    "resources": {
                        "storage": "str",  # Amount of storage required for packaged model,
                          in k8s Quantity notation. Required.
                        "memory": "str"  # Optional. Amount of memory required to run the
                          model on CPU, in k8s Quantity notation.
                    },
                    "source": {
                        "kind": "str",  # The kind of model source. Required. Known values
                          are: "GitLFS", "HuggingFaceHub", "OpenLLM", and "Upload".
                        "gitLFS": {
                            "url": "str"  # The URL of the Git LFS repository. Required.
                        },
                        "huggingFaceHub": {
                            "repoID": "str",  # Repoid. Required.
                            "revision": "str",  # Revision. Required.
                            "allowPatterns": [
                                "str"  # Optional. Allowpatterns.
                            ],
                            "ignorePatterns": [
                                "str"  # Optional. Ignorepatterns.
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",  # The specific model identifier (c.f.
                              'openllm build ... --model-id :code:`<modelId>`'). Required.
                            "modelKind": "str",  # The kind of model (c.f. 'openllm build
                              :code:`<modelKind>`'). Required.
                            "modelVersion": "str"  # The version of the model (e.g., a
                              git commit hash). Required.
                        }
                    },
                    "storage": {
                        "medium": "str"  # Storage medium. Required. Known values are:
                          "ObjectStorage" and "PersistentVolume".
                    },
                    "accelerators": [
                        {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        }
                    ],
                    "schemaVersion": "0.1"  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifact": {
                        "kind": "str",  # How the model data is represented. Required.
                          "HuggingFaceCache"
                        "huggingFaceCache": {
                            "repoID": "str",  # Name of the model in the HuggingFace
                              cache. Required.
                            "revision": "str"  # Model revision. Required.
                        }
                    },
                    "id": "str",  # Unique identifier of the entity. Required.
                    "name": "str",  # The name of the Model. Required.
                    "resources": {
                        "storage": "str",  # Amount of storage required for packaged model,
                          in k8s Quantity notation. Required.
                        "memory": "str"  # Optional. Amount of memory required to run the
                          model on CPU, in k8s Quantity notation.
                    },
                    "source": {
                        "kind": "str",  # The kind of model source. Required. Known values
                          are: "GitLFS", "HuggingFaceHub", "OpenLLM", and "Upload".
                        "gitLFS": {
                            "url": "str"  # The URL of the Git LFS repository. Required.
                        },
                        "huggingFaceHub": {
                            "repoID": "str",  # Repoid. Required.
                            "revision": "str",  # Revision. Required.
                            "allowPatterns": [
                                "str"  # Optional. Allowpatterns.
                            ],
                            "ignorePatterns": [
                                "str"  # Optional. Ignorepatterns.
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",  # The specific model identifier (c.f.
                              'openllm build ... --model-id :code:`<modelId>`'). Required.
                            "modelKind": "str",  # The kind of model (c.f. 'openllm build
                              :code:`<modelKind>`'). Required.
                            "modelVersion": "str"  # The version of the model (e.g., a
                              git commit hash). Required.
                        }
                    },
                    "storage": {
                        "medium": "str"  # Storage medium. Required. Known values are:
                          "ObjectStorage" and "PersistentVolume".
                    },
                    "accelerators": [
                        {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        }
                    ],
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Model",  # Optional. Default value is "Model". Kind. "Model"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create a Model.

        Create a Model.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifact": {
                        "kind": "str",  # How the model data is represented. Required.
                          "HuggingFaceCache"
                        "huggingFaceCache": {
                            "repoID": "str",  # Name of the model in the HuggingFace
                              cache. Required.
                            "revision": "str"  # Model revision. Required.
                        }
                    },
                    "id": "str",  # Unique identifier of the entity. Required.
                    "name": "str",  # The name of the Model. Required.
                    "resources": {
                        "storage": "str",  # Amount of storage required for packaged model,
                          in k8s Quantity notation. Required.
                        "memory": "str"  # Optional. Amount of memory required to run the
                          model on CPU, in k8s Quantity notation.
                    },
                    "source": {
                        "kind": "str",  # The kind of model source. Required. Known values
                          are: "GitLFS", "HuggingFaceHub", "OpenLLM", and "Upload".
                        "gitLFS": {
                            "url": "str"  # The URL of the Git LFS repository. Required.
                        },
                        "huggingFaceHub": {
                            "repoID": "str",  # Repoid. Required.
                            "revision": "str",  # Revision. Required.
                            "allowPatterns": [
                                "str"  # Optional. Allowpatterns.
                            ],
                            "ignorePatterns": [
                                "str"  # Optional. Ignorepatterns.
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",  # The specific model identifier (c.f.
                              'openllm build ... --model-id :code:`<modelId>`'). Required.
                            "modelKind": "str",  # The kind of model (c.f. 'openllm build
                              :code:`<modelKind>`'). Required.
                            "modelVersion": "str"  # The version of the model (e.g., a
                              git commit hash). Required.
                        }
                    },
                    "storage": {
                        "medium": "str"  # Storage medium. Required. Known values are:
                          "ObjectStorage" and "PersistentVolume".
                    },
                    "accelerators": [
                        {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        }
                    ],
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Model",  # Optional. Default value is "Model". Kind. "Model"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Create a Model.

        Create a Model.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifact": {
                        "kind": "str",  # How the model data is represented. Required.
                          "HuggingFaceCache"
                        "huggingFaceCache": {
                            "repoID": "str",  # Name of the model in the HuggingFace
                              cache. Required.
                            "revision": "str"  # Model revision. Required.
                        }
                    },
                    "name": "str",  # The name of the Model. Required.
                    "resources": {
                        "storage": "str",  # Amount of storage required for packaged model,
                          in k8s Quantity notation. Required.
                        "memory": "str"  # Optional. Amount of memory required to run the
                          model on CPU, in k8s Quantity notation.
                    },
                    "source": {
                        "kind": "str",  # The kind of model source. Required. Known values
                          are: "GitLFS", "HuggingFaceHub", "OpenLLM", and "Upload".
                        "gitLFS": {
                            "url": "str"  # The URL of the Git LFS repository. Required.
                        },
                        "huggingFaceHub": {
                            "repoID": "str",  # Repoid. Required.
                            "revision": "str",  # Revision. Required.
                            "allowPatterns": [
                                "str"  # Optional. Allowpatterns.
                            ],
                            "ignorePatterns": [
                                "str"  # Optional. Ignorepatterns.
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",  # The specific model identifier (c.f.
                              'openllm build ... --model-id :code:`<modelId>`'). Required.
                            "modelKind": "str",  # The kind of model (c.f. 'openllm build
                              :code:`<modelKind>`'). Required.
                            "modelVersion": "str"  # The version of the model (e.g., a
                              git commit hash). Required.
                        }
                    },
                    "storage": {
                        "medium": "str"  # Storage medium. Required. Known values are:
                          "ObjectStorage" and "PersistentVolume".
                    },
                    "accelerators": [
                        {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        }
                    ],
                    "schemaVersion": "0.1"  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifact": {
                        "kind": "str",  # How the model data is represented. Required.
                          "HuggingFaceCache"
                        "huggingFaceCache": {
                            "repoID": "str",  # Name of the model in the HuggingFace
                              cache. Required.
                            "revision": "str"  # Model revision. Required.
                        }
                    },
                    "id": "str",  # Unique identifier of the entity. Required.
                    "name": "str",  # The name of the Model. Required.
                    "resources": {
                        "storage": "str",  # Amount of storage required for packaged model,
                          in k8s Quantity notation. Required.
                        "memory": "str"  # Optional. Amount of memory required to run the
                          model on CPU, in k8s Quantity notation.
                    },
                    "source": {
                        "kind": "str",  # The kind of model source. Required. Known values
                          are: "GitLFS", "HuggingFaceHub", "OpenLLM", and "Upload".
                        "gitLFS": {
                            "url": "str"  # The URL of the Git LFS repository. Required.
                        },
                        "huggingFaceHub": {
                            "repoID": "str",  # Repoid. Required.
                            "revision": "str",  # Revision. Required.
                            "allowPatterns": [
                                "str"  # Optional. Allowpatterns.
                            ],
                            "ignorePatterns": [
                                "str"  # Optional. Ignorepatterns.
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",  # The specific model identifier (c.f.
                              'openllm build ... --model-id :code:`<modelId>`'). Required.
                            "modelKind": "str",  # The kind of model (c.f. 'openllm build
                              :code:`<modelKind>`'). Required.
                            "modelVersion": "str"  # The version of the model (e.g., a
                              git commit hash). Required.
                        }
                    },
                    "storage": {
                        "medium": "str"  # Storage medium. Required. Known values are:
                          "ObjectStorage" and "PersistentVolume".
                    },
                    "accelerators": [
                        {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        }
                    ],
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Model",  # Optional. Default value is "Model". Kind. "Model"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_models_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get(self, model_id: str, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Get a Model by its key.

        Get a Model by its key. Raises a 404 error if no entity exists with that key.

        :param model_id: Required.
        :type model_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "artifact": {
                        "kind": "str",  # How the model data is represented. Required.
                          "HuggingFaceCache"
                        "huggingFaceCache": {
                            "repoID": "str",  # Name of the model in the HuggingFace
                              cache. Required.
                            "revision": "str"  # Model revision. Required.
                        }
                    },
                    "id": "str",  # Unique identifier of the entity. Required.
                    "name": "str",  # The name of the Model. Required.
                    "resources": {
                        "storage": "str",  # Amount of storage required for packaged model,
                          in k8s Quantity notation. Required.
                        "memory": "str"  # Optional. Amount of memory required to run the
                          model on CPU, in k8s Quantity notation.
                    },
                    "source": {
                        "kind": "str",  # The kind of model source. Required. Known values
                          are: "GitLFS", "HuggingFaceHub", "OpenLLM", and "Upload".
                        "gitLFS": {
                            "url": "str"  # The URL of the Git LFS repository. Required.
                        },
                        "huggingFaceHub": {
                            "repoID": "str",  # Repoid. Required.
                            "revision": "str",  # Revision. Required.
                            "allowPatterns": [
                                "str"  # Optional. Allowpatterns.
                            ],
                            "ignorePatterns": [
                                "str"  # Optional. Ignorepatterns.
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",  # The specific model identifier (c.f.
                              'openllm build ... --model-id :code:`<modelId>`'). Required.
                            "modelKind": "str",  # The kind of model (c.f. 'openllm build
                              :code:`<modelKind>`'). Required.
                            "modelVersion": "str"  # The version of the model (e.g., a
                              git commit hash). Required.
                        }
                    },
                    "storage": {
                        "medium": "str"  # Storage medium. Required. Known values are:
                          "ObjectStorage" and "PersistentVolume".
                    },
                    "accelerators": [
                        {
                            "kind": "str",  # The kind of accelerator; available kinds
                              are {{GPU}}. Required.
                            "gpu": {
                                "hardwareTypes": [
                                    "str"  # Acceptable GPU hardware types.
                                      Required.
                                ],
                                "count": 1,  # Optional. Default value is 1. Number
                                  of GPUs required.
                                "memory": "str"  # Optional. [DEPRECATED] Amount of
                                  GPU memory required, in k8s Quantity notation.
                            }
                        }
                    ],
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "kind": "Model",  # Optional. Default value is "Model". Kind. "Model"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_models_get_request(
            model_id=model_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def delete(self, model_id: str, **kwargs: Any) -> JSON:
        """Mark a Model for deletion.

        Mark a Model for deletion.

        :param model_id: Required.
        :type model_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_models_delete_request(
            model_id=model_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class ReportsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.DyffAPI`'s
        :attr:`reports` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    def label(
        self,
        report_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing Report.

        Update labels for an existing Report.

        :param report_id: Required.
        :type report_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def label(
        self,
        report_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[Any, JSON]:
        """Update labels for an existing Report.

        Update labels for an existing Report.

        :param report_id: Required.
        :type report_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def label(
        self, report_id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> Union[Any, JSON]:
        # pylint: disable=line-too-long
        """Update labels for an existing Report.

        Update labels for an existing Report.

        :param report_id: Required.
        :type report_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: any or JSON object
        :rtype: any or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    }
                }

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Union[Any, JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_reports_label_request(
            report_id=report_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[Any, JSON], deserialized), {})  # type: ignore

        return cast(Union[Any, JSON], deserialized)  # type: ignore

    @distributed_trace
    def query(
        self,
        *,
        id: Optional[str] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        report: Optional[str] = None,
        dataset: Optional[str] = None,
        evaluation: Optional[str] = None,
        inference_service: Optional[str] = None,
        model: Optional[str] = None,
        **kwargs: Any
    ) -> Union[List[JSON], JSON]:
        # pylint: disable=line-too-long
        """Get all Reports matching a query.

        Get all Reports matching a query. The query is a set of equality
        constraints specified as key-value pairs.

        :keyword id: Default value is None.
        :paramtype id: str
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword report: Default value is None.
        :paramtype report: str
        :keyword dataset: Default value is None.
        :paramtype dataset: str
        :keyword evaluation: Default value is None.
        :paramtype evaluation: str
        :keyword inference_service: Default value is None.
        :paramtype inference_service: str
        :keyword model: Default value is None.
        :paramtype model: str
        :return: list of JSON object or JSON object
        :rtype: list[JSON] or JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",  # Account that owns the entity. Required.
                        "dataset": "str",  # The input dataset. Required.
                        "evaluation": "str",  # The evaluation (and corresponding output
                          data) to run the report on. Required.
                        "id": "str",  # Unique identifier of the entity. Required.
                        "inferenceService": "str",  # The inference service used in the
                          evaluation. Required.
                        "rubric": "str",  # The scoring rubric to apply (e.g.,
                          'classification.TopKAccuracy'). Required.
                        "annotations": [
                            {
                                "key": "str",  # The annotation key. A DNS label with
                                  an optional DNS domain prefix. For example: 'my-key',
                                  'your.com/key_0'. Names prefixed with 'dyff.io/',
                                  'subdomain.dyff.io/', etc. are reserved.  See
                                  https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                                  for detailed naming rules. Required.
                                "value": "str"  # The annotation value. An arbitrary
                                  string. Required.
                            }
                        ],
                        "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation
                          time (assigned by system).
                        "datasetView": {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        },
                        "evaluationView": {
                            "id": "str",  # Unique ID of the DataView. Required.
                            "schema": {
                                "arrowSchema": "str",  # The schema in Arrow format,
                                  encoded with dyff.schema.arrow.encode_schema(). This is required, but
                                  can be populated from a DyffDataSchema. Required.
                                "dyffSchema": {
                                    "components": [
                                        "str"  # A list of named dyff data
                                          schemas. The final schema is the composition of these
                                          component schemas. Required.
                                    ],
                                    "schemaVersion": "0.1"  # Optional. Default
                                      value is "0.1". The dyff schema version. "0.1"
                                },
                                "jsonSchema": {}  # Optional. The schema in JSON
                                  Schema format.
                            },
                            "viewOf": "str",  # ID of the resource that this is a view
                              of. Required.
                            "adapterPipeline": [
                                {
                                    "kind": "str",  # Name of a schema adapter
                                      available on the platform. Required.
                                    "configuration": {}  # Optional.
                                      Configuration for the schema adapter. Must be encodable as JSON.
                                }
                            ]
                        },
                        "kind": "Report",  # Optional. Default value is "Report". Kind.
                          "Report"
                        "labels": {
                            "str": "str"  # Optional. A set of key-value labels for the
                              resource. Used to specify identifying attributes of resources that are
                              meaningful to users but do not imply semantics in the dyff system.  The
                              keys are DNS labels with an optional DNS domain prefix. For example:
                              'my-key', 'your.com/key_0'. Keys prefixed with 'dyff.io/',
                              'subdomain.dyff.io/', etc. are reserved.  The label values are
                              alphanumeric characters separated by '.', '-', or '_'.  We follow the
                              kubernetes label conventions closely. See:
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                        },
                        "model": "str",  # Optional. The model backing the inference service,
                          if applicable.
                        "reason": "str",  # Optional. Reason for current status (assigned by
                          system).
                        "schemaVersion": "0.1",  # Optional. Default value is "0.1". The
                          schema version. "0.1"
                        "status": "str"  # Optional. Top-level resource status (assigned by
                          system).
                    }
                ]
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[List[JSON], JSON]] = kwargs.pop("cls", None)

        _request = build_reports_query_request(
            id=id,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            report=report,
            dataset=dataset,
            evaluation=evaluation,
            inference_service=inference_service,
            model=model,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(Union[List[JSON], JSON], deserialized), {})  # type: ignore

        return cast(Union[List[JSON], JSON], deserialized)  # type: ignore

    @overload
    def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create a Report.

        Create a Report.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "evaluation": "str",  # The evaluation (and corresponding output data) to run
                      the report on. Required.
                    "rubric": "str",  # The scoring rubric to apply (e.g.,
                      'classification.TopKAccuracy'). Required.
                    "datasetView": {},
                    "evaluationView": {},
                    "schemaVersion": "0.1"  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "dataset": "str",  # The input dataset. Required.
                    "evaluation": "str",  # The evaluation (and corresponding output data) to run
                      the report on. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "inferenceService": "str",  # The inference service used in the evaluation.
                      Required.
                    "rubric": "str",  # The scoring rubric to apply (e.g.,
                      'classification.TopKAccuracy'). Required.
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "datasetView": {
                        "id": "str",  # Unique ID of the DataView. Required.
                        "schema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "viewOf": "str",  # ID of the resource that this is a view of.
                          Required.
                        "adapterPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "evaluationView": {
                        "id": "str",  # Unique ID of the DataView. Required.
                        "schema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "viewOf": "str",  # ID of the resource that this is a view of.
                          Required.
                        "adapterPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "kind": "Report",  # Optional. Default value is "Report". Kind. "Report"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "model": "str",  # Optional. The model backing the inference service, if
                      applicable.
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @overload
    def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create a Report.

        Create a Report.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "dataset": "str",  # The input dataset. Required.
                    "evaluation": "str",  # The evaluation (and corresponding output data) to run
                      the report on. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "inferenceService": "str",  # The inference service used in the evaluation.
                      Required.
                    "rubric": "str",  # The scoring rubric to apply (e.g.,
                      'classification.TopKAccuracy'). Required.
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "datasetView": {
                        "id": "str",  # Unique ID of the DataView. Required.
                        "schema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "viewOf": "str",  # ID of the resource that this is a view of.
                          Required.
                        "adapterPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "evaluationView": {
                        "id": "str",  # Unique ID of the DataView. Required.
                        "schema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "viewOf": "str",  # ID of the resource that this is a view of.
                          Required.
                        "adapterPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "kind": "Report",  # Optional. Default value is "Report". Kind. "Report"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "model": "str",  # Optional. The model backing the inference service, if
                      applicable.
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Create a Report.

        Create a Report.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",  # Account that owns the entity. Required.
                    "evaluation": "str",  # The evaluation (and corresponding output data) to run
                      the report on. Required.
                    "rubric": "str",  # The scoring rubric to apply (e.g.,
                      'classification.TopKAccuracy'). Required.
                    "datasetView": {},
                    "evaluationView": {},
                    "schemaVersion": "0.1"  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "dataset": "str",  # The input dataset. Required.
                    "evaluation": "str",  # The evaluation (and corresponding output data) to run
                      the report on. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "inferenceService": "str",  # The inference service used in the evaluation.
                      Required.
                    "rubric": "str",  # The scoring rubric to apply (e.g.,
                      'classification.TopKAccuracy'). Required.
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "datasetView": {
                        "id": "str",  # Unique ID of the DataView. Required.
                        "schema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "viewOf": "str",  # ID of the resource that this is a view of.
                          Required.
                        "adapterPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "evaluationView": {
                        "id": "str",  # Unique ID of the DataView. Required.
                        "schema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "viewOf": "str",  # ID of the resource that this is a view of.
                          Required.
                        "adapterPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "kind": "Report",  # Optional. Default value is "Report". Kind. "Report"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "model": "str",  # Optional. The model backing the inference service, if
                      applicable.
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_reports_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get(self, report_id: str, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Get a Report by its key.

        Get a Report by its key. Raises a 404 error if no entity exists with that key.

        :param report_id: Required.
        :type report_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",  # Account that owns the entity. Required.
                    "dataset": "str",  # The input dataset. Required.
                    "evaluation": "str",  # The evaluation (and corresponding output data) to run
                      the report on. Required.
                    "id": "str",  # Unique identifier of the entity. Required.
                    "inferenceService": "str",  # The inference service used in the evaluation.
                      Required.
                    "rubric": "str",  # The scoring rubric to apply (e.g.,
                      'classification.TopKAccuracy'). Required.
                    "annotations": [
                        {
                            "key": "str",  # The annotation key. A DNS label with an
                              optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                              Names prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.
                              See
                              https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
                              for detailed naming rules. Required.
                            "value": "str"  # The annotation value. An arbitrary string.
                              Required.
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",  # Optional. Resource creation time
                      (assigned by system).
                    "datasetView": {
                        "id": "str",  # Unique ID of the DataView. Required.
                        "schema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "viewOf": "str",  # ID of the resource that this is a view of.
                          Required.
                        "adapterPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "evaluationView": {
                        "id": "str",  # Unique ID of the DataView. Required.
                        "schema": {
                            "arrowSchema": "str",  # The schema in Arrow format, encoded
                              with dyff.schema.arrow.encode_schema(). This is required, but can be
                              populated from a DyffDataSchema. Required.
                            "dyffSchema": {
                                "components": [
                                    "str"  # A list of named dyff data schemas.
                                      The final schema is the composition of these component schemas.
                                      Required.
                                ],
                                "schemaVersion": "0.1"  # Optional. Default value is
                                  "0.1". The dyff schema version. "0.1"
                            },
                            "jsonSchema": {}  # Optional. The schema in JSON Schema
                              format.
                        },
                        "viewOf": "str",  # ID of the resource that this is a view of.
                          Required.
                        "adapterPipeline": [
                            {
                                "kind": "str",  # Name of a schema adapter available
                                  on the platform. Required.
                                "configuration": {}  # Optional. Configuration for
                                  the schema adapter. Must be encodable as JSON.
                            }
                        ]
                    },
                    "kind": "Report",  # Optional. Default value is "Report". Kind. "Report"
                    "labels": {
                        "str": "str"  # Optional. A set of key-value labels for the resource.
                          Used to specify identifying attributes of resources that are meaningful to
                          users but do not imply semantics in the dyff system.  The keys are DNS labels
                          with an optional DNS domain prefix. For example: 'my-key', 'your.com/key_0'.
                          Keys prefixed with 'dyff.io/', 'subdomain.dyff.io/', etc. are reserved.  The
                          label values are alphanumeric characters separated by '.', '-', or '_'.  We
                          follow the kubernetes label conventions closely. See:
                          https://kubernetes.io/docs/concepts/overview/working-with-objects/labels.
                    },
                    "model": "str",  # Optional. The model backing the inference service, if
                      applicable.
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "schemaVersion": "0.1",  # Optional. Default value is "0.1". The schema
                      version. "0.1"
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_reports_get_request(
            report_id=report_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def delete(self, report_id: str, **kwargs: Any) -> JSON:
        """Mark a Report for deletion.

        Mark a Report for deletion.

        :param report_id: Required.
        :type report_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "reason": "str",  # Optional. Reason for current status (assigned by system).
                    "status": "str"  # Optional. Top-level resource status (assigned by system).
                }
                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_reports_delete_request(
            report_id=report_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 422:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def data(self, report_id: str, **kwargs: Any) -> Union[Iterator[bytes], JSON]:
        """Get the raw data for the Report.

        Get the raw data for the Report.

        :param report_id: Required.
        :type report_id: str
        :return: Iterator of the response bytes or JSON object or None
        :rtype: Iterator[bytes] or JSON or None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 422
                response == {
                    "detail": [
                        {
                            "loc": [
                                {}
                            ],
                            "msg": "str",  # Message. Required.
                            "type": "str"  # Error Type. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Union[Iterator[bytes], JSON]] = kwargs.pop("cls", None)

        _request = build_reports_data_request(
            report_id=report_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404, 422]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 200:
            deserialized = response.iter_bytes()

        if response.status_code == 422:
            deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
