"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
const pdk_nag_1 = require("aws-prototyping-sdk/pdk-nag");
const application_stage_1 = require("./application-stage");
const pipeline_stack_1 = require("./pipeline-stack");
const app = pdk_nag_1.PDKNag.app();
const pipelineStack = new pipeline_stack_1.PipelineStack(app, 'PipelineStack', {
    env: {
        account: process.env.CDK_DEFAULT_ACCOUNT,
        region: process.env.CDK_DEFAULT_REGION,
    },
});
const devStage = new application_stage_1.ApplicationStage(app, 'Dev', {
    env: {
        account: process.env.CDK_DEFAULT_ACCOUNT,
        region: process.env.CDK_DEFAULT_REGION, // Replace with Dev region
    },
});
pipelineStack.pipeline.addStage(devStage);
// Add additional stages here i.e. Prod
pipelineStack.pipeline.buildPipeline(); // Needed for CDK Nag
app.synth();
//# sourceMappingURL=data:application/json;base64,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