#include "crlibm.h"
#include "crlibm_private.h"
/*
 * Constant to compute the natural logarithm. 
 */

/* NaNs and Infs by Eric */
static const db_number NaN=DB_NAN;
static const db_number NNaN=DB_NNAN;
static const db_number Inf=DB_INF;
static const db_number NInf=DB_NINF;

#ifdef WORDS_BIGENDIAN
static const db_number 
  norm_number = {{0x3FD60000, 0x00000000}}; /* 11*2^(-5) */
#else
static const db_number 
  norm_number = {{0x00000000, 0x3FD60000}}; /* 11*2^(-5) */
#endif

static const scs 
   sc_ln2_r10={{0x13441350, 0x27de7fbc, 0x311f12b3, 0x1605be48, 
		0x2f04d5a6, 0x062a1e8f, 0x269314bc, 0x37935be6},
	        DB_ONE,  -1,   1 };
#define sc_ln2_r10_ptr (scs_ptr)(&sc_ln2_r10)


static const scs table_ti[13]=
/* ~-1.627273e-01 */ 
{{{0x0a6a1fc1, 0x0eb49065, 0x1345798e, 0x140679b0, 
0x081ef491, 0x17f68260, 0x23021dc5, 0x2a5f533c},
DB_ONE,  -1,  -1 } 
,
/* ~-1.249387e-01 */ 
{{0x07feff0a, 0x3bc78037, 0x160df12c, 0x0b84f38a, 
0x05289585, 0x2123cf60, 0x14ce8a8a, 0x15c78dee},
DB_ONE,  -1,  -1 } 
,
/* ~-9.017663e-02 */ 
{{0x05c57433, 0x2367afba, 0x367bf155, 0x26de13d2, 
0x009e7fc4, 0x1b056682, 0x3fcd4940, 0x002cc256},
DB_ONE,  -1,  -1 } 
,
/* ~-5.799195e-02 */ 
{{0x03b623da, 0x3b355fa1, 0x25b87837, 0x1a0b3d37, 
0x168e5c1e, 0x1feab742, 0x0f66cbee, 0x2c0be907},
DB_ONE,  -1,  -1 } 
,
/* ~-2.802872e-02 */ 
{{0x01cb38fc, 0x3362ff6d, 0x296b2946, 0x0d962e64, 
0x12371677, 0x33a22b0f, 0x0887c8c0, 0x3c81a1a1},
DB_ONE,  -1,  -1 } 
,
/* ZERO         */
{{0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000},
{{0, 0}},  0,   1 }
,
/* ~2.632894e-02 */ 
{{0x01af5f92, 0x2c03983e, 0x26de0a6d, 0x29e7cca3, 
0x0a33955e, 0x3e1a096a, 0x1b598da7, 0x378d3fbf},
DB_ONE,  -1,   1 } 
,
/* ~5.115252e-02 */ 
{{0x0346153a, 0x304f7f4e, 0x0503305a, 0x3efbd734, 
0x24b3aa9b, 0x03e27fce, 0x3cf5ffa8, 0x0c044008},
DB_ONE,  -1,   1 } 
,
/* ~7.463362e-02 */ 
{{0x04c6cc15, 0x1c471180, 0x06d082e6, 0x3202edd2, 
0x0016422e, 0x07624fbe, 0x12dd46da, 0x35263427},
DB_ONE,  -1,   1 } 
,
/* ~9.691001e-02 */ 
{{0x0633c60e, 0x086480c9, 0x2ca2c7e5, 0x3deec525, 
0x32f17f0d, 0x2d81a451, 0x0c46c1c9, 0x1945ec4d},
DB_ONE,  -1,   1 } 
,
/* ~1.180993e-01 */ 
{{0x078ef06a, 0x30e19fe3, 0x3558a94f, 0x30758d87, 
0x134de402, 0x051b97ed, 0x025dbe43, 0x35bfe4ef},
DB_ONE,  -1,   1 } 
,
/* ~1.383027e-01 */ 
{{0x08d9f38f, 0x1929ef57, 0x1dd99925, 0x01ff4498, 
0x26e5e114, 0x2e339c2f, 0x0390f6f7, 0x0d3408aa},
DB_ONE,  -1,   1 } 
,
/* ~1.576079e-01 */ 
{{0x0a163f3f, 0x3c7f8038, 0x2dd54275, 0x10792a14, 
0x11bcd6d3, 0x20e1df11, 0x1cbc373c, 0x127d33b6},
DB_ONE,  -1,   1 } 
};


static const scs table_inv_wi[13]=
/* ~1.454545e+00 */ 
{{{0x00000001, 0x1d1745d1, 0x1d1745d1, 0x1d1745d1, 
0x1d1745d1, 0x1d1745d1, 0x1d183e2a, 0x36835582},
DB_ONE,   0,   1 } 
,
/* ~1.333333e+00 */ 
{{0x00000001, 0x15555555, 0x15555555, 0x15555555, 
0x15555555, 0x15555555, 0x15549b7e, 0x1a416c6b},
DB_ONE,   0,   1 } 
,
/* ~1.230769e+00 */ 
{{0x00000001, 0x0ec4ec4e, 0x313b13b1, 0x0ec4ec4e, 
0x313b13b1, 0x0ec4ec4e, 0x313a6825, 0x3ab28b77},
DB_ONE,   0,   1 } 
,
/* ~1.142857e+00 */ 
{{0x00000001, 0x09249249, 0x09249249, 0x09249249, 
0x09249249, 0x09249249, 0x09238b74, 0x26f620a6},
DB_ONE,   0,   1 } 
,
/* ~1.066667e+00 */ 
{{0x00000001, 0x04444444, 0x11111111, 0x04444444, 
0x11111111, 0x04444444, 0x1111d60e, 0x1f0c9d58},
DB_ONE,   0,   1 } 
,
/* ~1.000000e+00 */ 
{{0x00000001, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000},
DB_ONE,   0,   1 } 
,
/* ~9.411765e-01 */ 
{{0x3c3c3c3c, 0x0f0f0f0f, 0x03c3c3c3, 0x30f0f0f0, 
0x3c3c3c3c, 0x0f0f923d, 0x16e0e0a4, 0x3a84202f},
DB_ONE,  -1,   1 } 
,
/* ~8.888889e-01 */ 
{{0x38e38e38, 0x38e38e38, 0x38e38e38, 0x38e38e38, 
0x38e38e38, 0x38e3946a, 0x2e0ee2c9, 0x0d6e0fbd},
DB_ONE,  -1,   1 } 
,
/* ~8.421053e-01 */ 
{{0x35e50d79, 0x10d79435, 0x39435e50, 0x35e50d79, 
0x10d79435, 0x3943324d, 0x0637ea85, 0x131a67ba},
DB_ONE,  -1,   1 } 
,
/* ~8.000000e-01 */ 
{{0x33333333, 0x0ccccccc, 0x33333333, 0x0ccccccc, 
0x33333333, 0x0ccccccc, 0x33333333, 0x0ccccccc},
DB_ONE,  -1,   1 } 
,
/* ~7.619048e-01 */ 
{{0x30c30c30, 0x30c30c30, 0x30c30c30, 0x30c30c30, 
0x30c30c30, 0x30c2f1a4, 0x160958a1, 0x2b03bc88},
DB_ONE,  -1,   1 } 
,
/* ~7.272727e-01 */ 
{{0x2e8ba2e8, 0x2e8ba2e8, 0x2e8ba2e8, 0x2e8ba2e8, 
0x2e8ba2e8, 0x2e8bcb74, 0x2d78b525, 0x00a1db67},
DB_ONE,  -1,   1 } 
,
/* ~6.956522e-01 */ 
{{0x2c8590b2, 0x0590b216, 0x10b21642, 0x321642c8, 
0x1642c859, 0x02c8590b, 0x08590b21, 0x190b2164},
DB_ONE,  -1,   1 } 
};







static const scs constant_poly[20]=
/* ~-2.181621e-02 */ 
{{{0x01656fcd, 0x37120da4, 0x190a402d, 0x2ac8a249, 
0x17eb9ecf, 0x21392cb7, 0x1e533faa, 0x1e94a4c1},
DB_ONE,  -1,  -1 } 
,
/* ~2.295884e-02 */ 
{{0x0178285f, 0x34ddee28, 0x11041f2a, 0x0004876c, 
0x3c380350, 0x307e5fa7, 0x1ad7ebca, 0x2cd92fba},
DB_ONE,  -1,   1 } 
,
/* ~-2.412725e-02 */ 
{{0x018b4d03, 0x13ceb0d6, 0x0f366d90, 0x2452dbad, 
0x26fb5490, 0x1f5aada6, 0x1210b1de, 0x1ea31299},
DB_ONE,  -1,  -1 } 
,
/* ~2.554652e-02 */ 
{{0x01a28de3, 0x0ea68783, 0x149e1951, 0x0f8806dd, 
0x39b93947, 0x0d73f36e, 0x2556864f, 0x35fb5954},
DB_ONE,  -1,   1 } 
,
/* ~-2.714341e-02 */ 
{{0x01bcb7b1, 0x277a1e99, 0x0a0186c1, 0x2abb27d4, 
0x20e34ea1, 0x0758d32b, 0x1cebf224, 0x1d7b2016},
DB_ONE,  -1,  -1 } 
,
/* ~2.895297e-02 */ 
{{0x01da5d8a, 0x0cfd7c2b, 0x316425f7, 0x2d92e4cf, 
0x008c1fdc, 0x23ae9cbf, 0x1d559ae0, 0x1b6f36bb},
DB_ONE,  -1,   1 } 
,
/* ~-3.102103e-02 */ 
{{0x01fc3fa6, 0x0540727e, 0x1c591487, 0x1186711e, 
0x09da089b, 0x20053360, 0x1e9b73ea, 0x3bbb712a},
DB_ONE,  -1,  -1 } 
,
/* ~3.340727e-02 */ 
{{0x0223583c, 0x2d0b4c63, 0x0997717f, 0x3617845e, 
0x33925b09, 0x39608cfb, 0x1ed99ede, 0x3caa32d9},
DB_ONE,  -1,   1 } 
,
/* ~-3.619121e-02 */ 
{{0x0250f4ec, 0x1b7a1b68, 0x049620da, 0x0431e0d7, 
0x2e0d2629, 0x10d53812, 0x08d5688b, 0x1397f08c},
DB_ONE,  -1,  -1 } 
,
/* ~3.948132e-02 */ 
{{0x0286dca4, 0x353f638e, 0x1fa8de49, 0x2888ba50, 
0x34d68d6b, 0x0e7bad3b, 0x19fa1686, 0x0282c774},
DB_ONE,  -1,   1 } 
,
/* ~-4.342945e-02 */ 
{{0x02c78c4e, 0x3a9286c1, 0x0eded0f2, 0x3c167697, 
0x2376b903, 0x274a8e9a, 0x1ea39ef4, 0x1adf2868},
DB_ONE,  -1,  -1 } 
,
/* ~4.825494e-02 */ 
{{0x03169be5, 0x39f823f3, 0x0a6e8478, 0x0a36df0b, 
0x04a90e57, 0x0ab36f7e, 0x3d9e3285, 0x2e193fb5},
DB_ONE,  -1,   1 } 
,
/* ~-5.428681e-02 */ 
{{0x03796f62, 0x29372871, 0x254d7071, 0x1c065a5c, 
0x3347ad1b, 0x30a89c6a, 0x315b4612, 0x06566750},
DB_ONE,  -1,  -1 } 
,
/* ~6.204207e-02 */ 
{{0x03f87f4c, 0x0a882e38, 0x2aa1959d, 0x279ac008, 
0x3c958eee, 0x01eeeeb1, 0x3491f9b0, 0x23f74e8b},
DB_ONE,  -1,   1 } 
,
/* ~-7.238241e-02 */ 
{{0x04a1e9d8, 0x36f435ec, 0x31bc73e2, 0x3abc2601, 
0x39b401d0, 0x0cd60ae1, 0x1fc98f08, 0x29f06ff3},
DB_ONE,  -1,  -1 } 
,
/* ~8.685890e-02 */ 
{{0x058f189d, 0x35250d82, 0x221557dd, 0x26d3e9e7, 
0x0223e4ce, 0x3d2543cd, 0x25e892c0, 0x1cfd1f93},
DB_ONE,  -1,   1 } 
,
/* ~-1.085736e-01 */ 
{{0x06f2dec5, 0x126e50e3, 0x0a9aadd5, 0x15f620ad, 
0x1064ee7f, 0x3fe2456b, 0x2f4cb57f, 0x315bf14b},
DB_ONE,  -1,  -1 } 
,
/* ~1.447648e-01 */ 
{{0x0943d3b1, 0x2de86bd9, 0x2378e7c7, 0x07f2548d, 
0x2277243c, 0x3f053abc, 0x2fcd1adc, 0x23aee721},
DB_ONE,  -1,   1 } 
,
/* ~-2.171472e-01 */ 
{{0x0de5bd8a, 0x24dca1c6, 0x15355baa, 0x2beb4cf6, 
0x287a7da0, 0x34365d5c, 0x33a3fd4b, 0x2575986b},
DB_ONE,  -1,  -1 } 
,
/* ~4.342945e-01 */ 
{{0x1bcb7b15, 0x09b9438c, 0x2a6ab755, 0x17d699ee, 
0x039f03ea, 0x1d96911b, 0x10af7816, 0x1718a231},
DB_ONE,  -1,   1 } 
};

#define constant_poly_ptr (scs_ptr)&constant_poly
#define table_ti_ptr      (scs_ptr)&table_ti
#define table_inv_wi_ptr  (scs_ptr)&table_inv_wi
