
/*File generated by maple/coef_atan.mw */
#ifndef _ATAN_FAST_H
#define _ATAN_FAST_H

#include "crlibm.h"
#include "crlibm_private.h"
#ifdef WORDS_BIGENDIAN
static const db_number HALFPI = {{0x3FF921FB,0x54442D18}};static const db_number HALFPI_TO_PLUS_INFINITY = {{0x3FF921FB,0x54442D19}};
#else
static const db_number HALFPI = {{0x54442D18,0x3FF921FB}};static const db_number HALFPI_TO_PLUS_INFINITY = {{0x54442D19,0x3FF921FB}};
#endif
#define MIN_REDUCTION_NEEDED 0.01269144369306618004077670910586377580133132772550
#define nb_of_ai 62
#define nb_of_bi 62
static const double rncst[4] ={
1.00471410340923143324336636863711169631585562456166 , /* i<10 */ 
1.00006870424588938643610373270542712731412393623032 , /* i>10 */ 
1.00242490224514544614748698750112537725343031524972 , /* e > 2^-10 */ 
1.00001422622079385564641521206858537640371764609881 , /* e < 2^-10 */ 
 };
static const double epsilon[4] ={
2.60610366274046896231976436965093787902741931215705e-19 ,
3.76068267671359496762058387277198914980606464859832e-21 ,
1.34293370661420878668381572561396622952281116281661e-19 ,
7.36768713583100422889235387213940577473795817850748e-22 ,
 };
#define DEGREE 4
static double const coef_poly[4] = 
{
/* coef for degree 9 */ 0.11111111111111110494320541874913033097982406616211, 
/* coef for degree 7 */ -0.14285714285714284921269268124888185411691665649414, 
/* coef for degree 5 */ 0.20000000000000001110223024625156540423631668090820, 
/* coef for degree 3 */ -0.33333333333333331482961625624739099293947219848633, 
 }; 
#define A 0
#define B 1
#define ATAN_BHI 2
#define ATAN_BLO 3

#ifdef WORDS_BIGENDIAN
 
/* limits of the intervals [a[i],b[i]] */
static db_number const arctan_table[62][4] = 
{
{
/*a[0]     */ {{0x3F89FDF8,0xBCCE533D}} /* +1.2691443693e-02 */ ,
/*b[0] :   */ {{0x3F99FF0B,0x27760007}} /* +2.5386976512e-02 */ ,
/*atan_b[0]*/ {{0x3F99FD9D,0x4969F96C}} /* +2.5381524664e-02 */,{{0xBC301997,0x750685EA}} /* -8.7278097631e-19 */ ,
}
,{
/*a[1]     */ {{0x3FA3809F,0x90CEBC31}} /* +3.8090692927e-02 */ ,
/*b[1] :   */ {{0x3FAA0355,0xE3547CC2}} /* +5.0806697846e-02 */ ,
/*atan_b[1]*/ {{0x3FA9FD9D,0x4936262D}} /* +5.0763049304e-02 */,{{0xBC4C1F96,0x3A2D0F59}} /* -3.0491436238e-18 */ ,
}
,{
/*a[2]     */ {{0x3FB04419,0x68FBA526}} /* +6.3539112216e-02 */ ,
/*b[2] :   */ {{0x3FB387E0,0xABF7BFB9}} /* +7.6292078003e-02 */ ,
/*atan_b[2]*/ {{0x3FB37E35,0xF6C1E06C}} /* +7.6144573921e-02 */,{{0xBC556710,0x8378E024}} /* -4.6409481568e-18 */ ,
}
,{
/*a[3]     */ {{0x3FB6CD46,0xABCDFA25}} /* +8.9069764084e-02 */ ,
/*b[3] :   */ {{0x3FBA1491,0xE265B8AB}} /* +1.0187637117e-01 */ ,
/*atan_b[3]*/ {{0x3FB9FD9D,0x48CF1996}} /* +1.0152609851e-01 */,{{0xBC4360DC,0xB73BED3C}} /* -2.1010068528e-18 */ ,
}
,{
/*a[4]     */ {{0x3FBD5E09,0x6D2EA546}} /* +1.1471613803e-01 */ ,
/*b[4] :   */ {{0x3FC054FA,0x9124D46B}} /* +1.2759334647e-01 */ ,
/*atan_b[4]*/ {{0x3FC03E82,0x4D618156}} /* +1.2690762308e-01 */,{{0x3C62604E,0x49A86344}} /* +7.9694040325e-18 */ ,
}
,{
/*a[5]     */ {{0x3FC1FC4E,0xD691E891}} /* +1.4051232793e-01 */ ,
/*b[5] :   */ {{0x3FC3A526,0x51F57043}} /* +1.5347746851e-01 */ ,
/*atan_b[5]*/ {{0x3FC37E35,0xF64EF83E}} /* +1.5228914763e-01 */,{{0x3C5F2B13,0xB4A55EA6}} /* +6.7585410867e-18 */ ,
}
,{
/*a[6]     */ {{0x3FC54FA6,0x531F610B}} /* +1.6649321612e-01 */ ,
/*b[6] :   */ {{0x3FC6FBF4,0xB99F2601}} /* +1.7956408561e-01 */ ,
/*atan_b[6]*/ {{0x3FC6BDE9,0x9F302425}} /* +1.7767067216e-01 */,{{0xBC23B62A,0xC4D330CE}} /* -5.3428372026e-19 */ ,
}
,{
/*a[7]     */ {{0x3FC8AA38,0x0550EAF1}} /* +1.9269466648e-01 */ ,
/*b[7] :   */ {{0x3FCA5A97,0x61D9D63D}} /* +2.0588962820e-01 */ ,
/*atan_b[7]*/ {{0x3FC9FD9D,0x48053FC8}} /* +2.0305219666e-01 */,{{0xBC67A12C,0x98474AF1}} /* -1.0247699700e-17 */ ,
}
,{
/*a[8]     */ {{0x3FCC0D3A,0xB8975BD9}} /* +2.1915372861e-01 */ ,
/*b[8] :   */ {{0x3FCDC24A,0xBCBF6ABC}} /* +2.3249181954e-01 */ ,
/*atan_b[8]*/ {{0x3FCD3D50,0xF0CE8DD9}} /* +2.2843372114e-01 */,{{0x3C6EF257,0x3A31D353}} /* +1.3420967238e-17 */ ,
}
,{
/*a[9]     */ {{0x3FCF79F0,0xFEE46885}} /* +2.4590885588e-01 */ ,
/*b[9] :   */ {{0x3FD09A2B,0xFCF66B85}} /* +2.5940990165e-01 */ ,
/*atan_b[9]*/ {{0x3FD03E82,0x4CC62C6B}} /* +2.5381524560e-01 */,{{0x3C5DA594,0x95C6E482}} /* +6.4286246635e-18 */ ,
}
,{
/*a[10]     */ {{0x3FD178D5,0x943274CA}} /* +2.7300013993e-01 */ ,
/*b[10] :   */ {{0x3FD2590B,0x8943E603}} /* +2.8668487935e-01 */ ,
/*atan_b[10]*/ {{0x3FD1DE5C,0x211F7969}} /* +2.7919677004e-01 */,{{0x3C3C4E87,0x0B01EF44}} /* +1.5345118889e-18 */ ,
}
,{
/*a[11]     */ {{0x3FD33AE4,0xB2CFB5F7}} /* +3.0046956503e-01 */ ,
/*b[11] :   */ {{0x3FD41E78,0x81B0D1DF}} /* +3.1435978570e-01 */ ,
/*atan_b[11]*/ {{0x3FD37E35,0xF5735AA1}} /* +3.0457829447e-01 */,{{0xBC772D05,0x8D437AE9}} /* -2.0101859382e-17 */ ,
}
,{
/*a[12]     */ {{0x3FD503DF,0x0DD40A5B}} /* +3.2836128569e-01 */ ,
/*b[12] :   */ {{0x3FD5EB31,0x1EB6A659}} /* +3.4247997283e-01 */ ,
/*atan_b[12]*/ {{0x3FD51E0F,0xC9C20060}} /* +3.2995981887e-01 */,{{0xBC6C0F53,0x20BA7A7B}} /* -1.2169025414e-17 */ ,
}
,{
/*a[13]     */ {{0x3FD6D488,0x3998DD14}} /* +3.5672193169e-01 */ ,
/*b[13] :   */ {{0x3FD7BFFE,0xAAF865B1}} /* +3.7109343239e-01 */ ,
/*atan_b[13]*/ {{0x3FD6BDE9,0x9E0B9E67}} /* +3.5534134325e-01 */,{{0x3C797792,0x870D5E8E}} /* +2.2089170409e-17 */ ,
}
,{
/*a[14]     */ {{0x3FD8ADAF,0x964ABFA5}} /* +3.8560094525e-01 */ ,
/*b[14] :   */ {{0x3FD99DB7,0x00A6F44E}} /* +4.0025115074e-01 */ ,
/*atan_b[14]*/ {{0x3FD85DC3,0x72506BCA}} /* +3.8072286762e-01 */,{{0x3C720BD1,0x43A1CBA3}} /* +1.5652550322e-17 */ ,
}
,{
/*a[15]     */ {{0x3FDA9031,0xE241114E}} /* +4.1505095573e-01 */ ,
/*b[15] :   */ {{0x3FDB853E,0x327F0E90}} /* +4.3000750476e-01 */ ,
/*atan_b[15]*/ {{0x3FD9FD9D,0x4690A2C8}} /* +4.0610439197e-01 */,{{0xBC6A048E,0xEFB73034}} /* -1.1283424731e-17 */ ,
}
,{
/*a[16]     */ {{0x3FDC7CFA,0xFB78B41D}} /* +4.4512819822e-01 */ ,
/*b[16] :   */ {{0x3FDD7788,0x67BE333A}} /* +4.6042070514e-01 */ ,
/*atan_b[16]*/ {{0x3FDB9D77,0x1ACC80A6}} /* +4.3148591630e-01 */,{{0x3C6A9BD7,0xE8FB154D}} /* +1.1539711581e-17 */ ,
}
,{
/*a[17]     */ {{0x3FDE7507,0xD82B9DC6}} /* +4.7589298354e-01 */ ,
/*b[17] :   */ {{0x3FDF759B,0xF3B4AACC}} /* +4.9155329513e-01 */ ,
/*atan_b[17]*/ {{0x3FDD3D50,0xEF044589}} /* +4.5686744062e-01 */,{{0x3C575857,0x09E8652E}} /* +5.0621568797e-18 */ ,
}
,{
/*a[18]     */ {{0x3FE03CB4,0x5FF4B2AB}} /* +5.0741022817e-01 */ ,
/*b[18] :   */ {{0x3FE0C049,0xD9952BEF}} /* +5.2347271439e-01 */ ,
/*atan_b[18]*/ {{0x3FDEDD2A,0xC338344A}} /* +4.8224896492e-01 */,{{0x3C23C787,0x81513292}} /* +5.3612202011e-19 */ ,
}
,{
/*a[19]     */ {{0x3FE145A1,0xE826E4EA}} /* +5.3975005476e-01 */ ,
/*b[19] :   */ {{0x3FE1CCD0,0xDDD96DE0}} /* +5.5625193911e-01 */ ,
/*atan_b[19]*/ {{0x3FE03E82,0x4BB44923}} /* +5.0763048922e-01 */,{{0x3C8CAF01,0x49DF0A58}} /* +4.9758137561e-17 */ ,
}
,{
/*a[20]     */ {{0x3FE255EB,0xED462BAC}} /* +5.7298847525e-01 */ ,
/*b[20] :   */ {{0x3FE2E109,0x35B0819C}} /* +5.8997021185e-01 */ ,
/*atan_b[20]*/ {{0x3FE10E6F,0x35CAD39D}} /* +5.3301201350e-01 */,{{0x3C45DB33,0x0D1EB36B}} /* +2.3696591272e-18 */ ,
}
,{
/*a[21]     */ {{0x3FE36E3F,0xD4CDD9AC}} /* +6.0720817149e-01 */ ,
/*b[21] :   */ {{0x3FE3FDA7,0xF51235D9}} /* +6.2471387735e-01 */ ,
/*atan_b[21]*/ {{0x3FE1DE5C,0x1FDFDE84}} /* +5.5839353776e-01 */,{{0x3C86FBEF,0xD3921CA6}} /* +3.9871106783e-17 */ ,
}
,{
/*a[22]     */ {{0x3FE48F5A,0xE1FB2991}} /* +6.4249939095e-01 */ ,
/*b[22] :   */ {{0x3FE52373,0x18D0CCB0}} /* +6.6057734343e-01 */ ,
/*atan_b[22]*/ {{0x3FE2AE49,0x09F38FC9}} /* +5.8377506202e-01 */,{{0xBC84BBB5,0x058084C6}} /* -3.5966422408e-17 */ ,
}
,{
/*a[23]     */ {{0x3FE5BA0C,0x5FE86E27}} /* +6.7896097881e-01 */ ,
/*b[23] :   */ {{0x3FE65343,0xDA588D41}} /* +6.9766419073e-01 */ ,
/*atan_b[23]*/ {{0x3FE37E35,0xF4060E3D}} /* +6.0915658627e-01 */,{{0x3BF6235C,0xAE25B9B7}} /* +7.5006911959e-20 */ ,
}
,{
/*a[24]     */ {{0x3FE6EF38,0x22C19A5D}} /* +7.1670157231e-01 */ ,
/*b[24] :   */ {{0x3FE78E09,0x629002BC}} /* +7.3608845950e-01 */ ,
/*atan_b[24]*/ {{0x3FE44E22,0xDE17817F}} /* +6.3453811052e-01 */,{{0xBC85F46E,0x1A6D25E3}} /* -3.8085515717e-17 */ ,
}
,{
/*a[25]     */ {{0x3FE82FD9,0x70F967BD}} /* +7.5584098878e-01 */ ,
/*b[25] :   */ {{0x3FE8D4CB,0xEE8B9555}} /* +7.7597614852e-01 */ ,
/*atan_b[25]*/ {{0x3FE51E0F,0xC82811DC}} /* +6.5991963475e-01 */,{{0xBC81CCF7,0xFCB9720C}} /* -3.0879221028e-17 */ ,
}
,{
/*a[26]     */ {{0x3FE97D06,0x69351A0D}} /* +7.9651184605e-01 */ ,
/*b[26] :   */ {{0x3FEA28B0,0x7D0D616A}} /* +8.1746696877e-01 */ ,
/*atan_b[26]*/ {{0x3FE5EDFC,0xB237E838}} /* +6.8530115898e-01 */,{{0xBC833EA8,0xF8F29048}} /* -3.3384347049e-17 */ ,
}
,{
/*a[27]     */ {{0x3FEAD7F3,0xFE730FCD}} /* +8.3886146257e-01 */ ,
/*b[27] :   */ {{0x3FEB8AFD,0x21335E3D}} /* +8.6071640477e-01 */ ,
/*atan_b[27]*/ {{0x3FE6BDE9,0x9C472DF1}} /* +7.1068268321e-01 */,{{0x3C5E8127,0x80DED249}} /* +6.6146109909e-18 */ ,
}
,{
/*a[28]     */ {{0x3FEC41FA,0xAA0A733E}} /* +8.8305409633e-01 */ ,
/*b[28] :   */ {{0x3FECFD1E,0x1D9A7669}} /* +9.0589814932e-01 */ ,
/*atan_b[28]*/ {{0x3FE78DD6,0x86560CC5}} /* +7.3606420743e-01 */,{{0xBC7E962F,0x9396D511}} /* -2.6529701578e-17 */ ,
}
,{
/*a[29]     */ {{0x3FEDBC9B,0xFAEEEADF}} /* +9.2927359591e-01 */ ,
/*b[29] :   */ {{0x3FEE80AB,0xF41419E7}} /* +9.5320699379e-01 */ ,
/*atan_b[29]*/ {{0x3FE85DC3,0x7064AEB4}} /* +7.6144573166e-01 */,{{0x3C77C0FC,0x5225ACD1}} /* +2.0603180716e-17 */ ,
}
,{
/*a[30]     */ {{0x3FEF4989,0x33AC790A}} /* +9.7772655575e-01 */ ,
/*b[30] :   */ {{0x3FF00BB9,0x50BB2D02}} /* +1.0028622774e+00 */ ,
/*atan_b[30]*/ {{0x3FE92DB0,0x5A733DE9}} /* +7.8682725588e-01 */,{{0xBC6598C9,0xA318D041}} /* -9.3661305872e-18 */ ,
}
,{
/*a[31]     */ {{0x3FF07555,0x9AC922B4}} /* +1.0286460921e+00 */ ,
/*b[31] :   */ {{0x3FF0E1BD,0x25F4BC57}} /* +1.0551120265e+00 */ ,
/*atan_b[31]*/ {{0x3FE9FD9D,0x4481E499}} /* +8.1220878010e-01 */,{{0xBC82E89F,0x9464A40D}} /* -3.2801339756e-17 */ ,
}
,{
/*a[32]     */ {{0x3FF15116,0x0440E8D3}} /* +1.0822963873e+00 */ ,
/*b[32] :   */ {{0x3FF1C388,0xDEC8DA1A}} /* +1.1102379515e+00 */ ,
/*atan_b[32]*/ {{0x3FEACD8A,0x2E90CCEA}} /* +8.3759030433e-01 */,{{0x3C60B8DB,0xFE4AC33B}} /* +7.2520578222e-18 */ ,
}
,{
/*a[33]     */ {{0x3FF23941,0x329D3DD8}} /* +1.1389781930e+00 */ ,
/*b[33] :   */ {{0x3FF2B26D,0x8F9CF3AD}} /* +1.1685615168e+00 */ ,
/*atan_b[33]*/ {{0x3FEB9D77,0x18A020D8}} /* +8.6297182855e-01 */,{{0x3C714EA3,0x43DDC7EE}} /* +1.5011584621e-17 */ ,
}
,{
/*a[34]     */ {{0x3FF32F3F,0xE2DB7094}} /* +1.1990355360e+00 */ ,
/*b[34] :   */ {{0x3FF3AFED,0xC485093A}} /* +1.2304513623e+00 */ ,
/*atan_b[34]*/ {{0x3FEC6D64,0x02B00A17}} /* +8.8835335278e-01 */,{{0x3C5CF722,0xC1E56981}} /* +6.2808643065e-18 */ ,
}
,{
/*a[35]     */ {{0x3FF434B0,0xD38A35D7}} /* +1.2628639472e+00 */ ,
/*b[35] :   */ {{0x3FF4BDC7,0x16D89BC7}} /* +1.2963324444e+00 */ ,
/*atan_b[35]*/ {{0x3FED3D50,0xECC0B1F8}} /* +9.1373487702e-01 */,{{0x3C8FFD9A,0xC689AE1B}} /* +5.5494919315e-17 */ ,
}
,{
/*a[36]     */ {{0x3FF54B73,0x6F41F96D}} /* +1.3309206339e+00 */ ,
/*b[36] :   */ {{0x3FF5DDFE,0x11C53212}} /* +1.3666973776e+00 */ ,
/*atan_b[36]*/ {{0x3FEE0D3D,0xD6D24151}} /* +9.3911640126e-01 */,{{0xBC654F0F,0xC830B564}} /* -9.2412338910e-18 */ ,
}
,{
/*a[37]     */ {{0x3FF675B5,0x165CA5E1}} /* +1.4037371515e+00 */ ,
/*b[37] :   */ {{0x3FF712ED,0x13170C5B}} /* +1.4421206232e+00 */ ,
/*atan_b[37]*/ {{0x3FEEDD2A,0xC0E4E05B}} /* +9.6449792552e-01 */,{{0xBC8FEAC3,0xBF676FFE}} /* -5.5367254830e-17 */ ,
}
,{
/*a[38]     */ {{0x3FF7B601,0xD0DEA3C6}} /* +1.4819353255e+00 */ ,
/*b[38] :   */ {{0x3FF85F57,0x11FBEA40}} /* +1.5232763960e+00 */ ,
/*atan_b[38]*/ {{0x3FEFAD17,0xAAF8B69E}} /* +9.8987944978e-01 */,{{0x3C8B8DA3,0xE69F3AF7}} /* +4.7797325436e-17 */ ,
}
,{
/*a[39]     */ {{0x3FF90F59,0x79506F51}} /* +1.5662474383e+00 */ ,
/*b[39] :   */ {{0x3FF9C67F,0x8AF460DF}} /* +1.6109614780e+00 */ ,
/*atan_b[39]*/ {{0x3FF03E82,0x4A86F56B}} /* +1.0152609740e+00 */,{{0x3C8C4641,0xDE1DF40B}} /* +4.9048339280e-17 */ ,
}
,{
/*a[40]     */ {{0x3FFA854A,0xD74CF791}} /* +1.6575420771e+00 */ ,
/*b[40] :   */ {{0x3FFB4C49,0x4A696F14}} /* +1.7061245829e+00 */ ,
/*atan_b[40]*/ {{0x3FF0A678,0xBF92516C}} /* +1.0406424983e+00 */,{{0xBC9194FF,0x6A0966AF}} /* -6.0999893718e-17 */ ,
}
,{
/*a[41]     */ {{0x3FFC1C16,0xB3972246}} /* +1.7568575874e+00 */ ,
/*b[41] :   */ {{0x3FFCF55E,0x80F0B83E}} /* +1.8099045788e+00 */ ,
/*atan_b[41]*/ {{0x3FF10E6F,0x349E81BA}} /* +1.0660240226e+00 */,{{0x3C9C7D12,0x3CD05C13}} /* +9.8839546037e-17 */ ,
}
,{
/*a[42]     */ {{0x3FFDD8DD,0xC6DB1831}} /* +1.8654458778e+00 */ ,
/*b[42] :   */ {{0x3FFEC765,0x927D039C}} /* +1.9236808512e+00 */ ,
/*atan_b[42]*/ {{0x3FF17665,0xA9AB9836}} /* +1.0914055469e+00 */,{{0xBC924DFA,0x7B9C115B}} /* -6.3506850178e-17 */ ,
}
,{
/*a[43]     */ {{0x3FFFC1DD,0xA4F6D032}} /* +1.9848305172e+00 */ ,
/*b[43] :   */ {{0x400064A3,0xCDEC630C}} /* +2.0491405571e+00 */ ,
/*atan_b[43]*/ {{0x3FF1DE5C,0x1EB9A624}} /* +1.1167870712e+00 */,{{0xBC7002F6,0x595EC15D}} /* -1.3887824475e-17 */ ,
}
,{
/*a[44]     */ {{0x4000EF61,0x56AEFAF2}} /* +2.1168848774e+00 */ ,
/*b[44] :   */ {{0x400181C8,0x02FA3F97}} /* +2.1883697732e+00 */ ,
/*atan_b[44]*/ {{0x3FF24652,0x93C8BC28}} /* +1.1421685956e+00 */,{{0xBC8FE336,0xC61E8575}} /* -5.5316089441e-17 */ ,
}
,{
/*a[45]     */ {{0x40021C8B,0xFD9A80C1}} /* +2.2639388860e+00 */ ,
/*b[45] :   */ {{0x4002C078,0x188015C0}} /* +2.3439790644e+00 */ ,
/*atan_b[45]*/ {{0x3FF2AE49,0x08D8EA37}} /* +1.1675501199e+00 */,{{0xBC99C943,0x56281657}} /* -8.9463796524e-17 */ ,
}
,{
/*a[46]     */ {{0x40036E71,0x7D67269C}} /* +2.4289274022e+00 */ ,
/*b[46] :   */ {{0x4004277C,0x17EDBBF3}} /* +2.5192796583e+00 */ ,
/*atan_b[46]*/ {{0x3FF3163F,0x7DEA3F8C}} /* +1.1929316443e+00 */,{{0x3C9AD329,0x90EB721B}} /* +9.3067404471e-17 */ ,
}
,{
/*a[47]     */ {{0x4004ECBF,0xF069F1E4}} /* +2.6156004698e+00 */ ,
/*b[47] :   */ {{0x4005BF8F,0xA99113B9}} /* +2.7185357330e+00 */ ,
/*atan_b[47]*/ {{0x3FF37E35,0xF2FCCAA3}} /* +1.2183131687e+00 */,{{0xBC96C4D7,0x8B3674F4}} /* -7.8995539059e-17 */ ,
}
,{
/*a[48]     */ {{0x4006A170,0x780169B7}} /* +2.8288277984e+00 */ ,
/*b[48] :   */ {{0x40079423,0xEECFDE39}} /* +2.9473341615e+00 */ ,
/*atan_b[48]*/ {{0x3FF3E62C,0x68109926}} /* +1.2436946931e+00 */,{{0x3C9D395E,0x46562D7D}} /* +1.0139144652e-16 */ ,
}
,{
/*a[49]     */ {{0x400899B4,0x319C3F02}} /* +3.0750507236e+00 */ ,
/*b[49] :   */ {{0x4009B483,0x34491C9A}} /* +3.2131408772e+00 */ ,
/*atan_b[49]*/ {{0x3FF44E22,0xDD25B7F0}} /* +1.2690762175e+00 */,{{0xBC9AC408,0x96299AC9}} /* -9.2862370643e-17 */ ,
}
,{
/*a[50]     */ {{0x400AE75E,0x05B0834A}} /* +3.3629723019e+00 */ ,
/*b[50] :   */ {{0x400C3595,0x6451B6E9}} /* +3.5261638486e+00 */ ,
/*atan_b[50]*/ {{0x3FF4B619,0x523C32F8}} /* +1.2944577420e+00 */,{{0x3C98372D,0x9A6CF82B}} /* +8.4014530055e-17 */ ,
}
,{
/*a[51]     */ {{0x400DA31D,0x739BD0E3}} /* +3.7046460182e+00 */ ,
/*b[51] :   */ {{0x400F34B7,0x088B2A13}} /* +3.9007397335e+00 */ ,
/*atan_b[51]*/ {{0x3FF51E0F,0xC7541555}} /* +1.3198392664e+00 */,{{0xBC4DA0E1,0xD97CC177}} /* -3.2123225727e-18 */ ,
}
,{
/*a[52]     */ {{0x40107813,0x1886BC57}} /* +4.1172603447e+00 */ ,
/*b[52] :   */ {{0x40116E3D,0x8D819944}} /* +4.3576566801e+00 */ ,
/*atan_b[52]*/ {{0x3FF58606,0x3C6D692D}} /* +1.3452207909e+00 */,{{0xBC7DAB9D,0xD9D13C46}} /* -2.5734950076e-17 */ ,
}
,{
/*a[53]     */ {{0x4012813A,0x8BCE2241}} /* +4.6261998982e+00 */ ,
/*b[53] :   */ {{0x4013B685,0x9F0E4EBF}} /* +4.9282440999e+00 */ ,
/*atan_b[53]*/ {{0x3FF5EDFC,0xB18837B4}} /* +1.3706023154e+00 */,{{0xBC858200,0xBC854F71}} /* -3.7310126753e-17 */ ,
}
,{
/*a[54]     */ {{0x40151516,0x4ACECE78}} /* +5.2705928506e+00 */ ,
/*b[54] :   */ {{0x4016A5E9,0xF3CD0189}} /* +5.6620252699e+00 */ ,
/*atan_b[54]*/ {{0x3FF655F3,0x26A48924}} /* +1.3959838399e+00 */,{{0xBC95DCD4,0x0EF07703}} /* -7.5851168241e-17 */ ,
}
,{
/*a[55]     */ {{0x401874CE,0x9526FAB9}} /* +6.1140693002e+00 */ ,
/*b[55] :   */ {{0x401A9194,0xBA057809}} /* +6.6421689096e+00 */ ,
/*atan_b[55]*/ {{0x3FF6BDE9,0x9BC264B7}} /* +1.4213653645e+00 */,{{0x3C839FB7,0x555821B5}} /* +3.4042024747e-17 */ ,
}
,{
/*a[56]     */ {{0x401D11EB,0xE094C913}} /* +7.2675013629e+00 */ ,
/*b[56] :   */ {{0x40200A31,0xA01EFACA}} /* +8.0199098623e+00 */ ,
/*atan_b[56]*/ {{0x3FF725E0,0x10E1D0A5}} /* +1.4467468891e+00 */,{{0x3C86B63B,0x56DADB03}} /* +3.9398767140e-17 */ ,
}
,{
/*a[57]     */ {{0x4021E2BC,0x220DFA19}} /* +8.9428415911e+00 */ ,
/*b[57] :   */ {{0x40243445,0xFBA72898}} /* +1.0102096428e+01 */ ,
/*atan_b[57]*/ {{0x3FF78DD6,0x8602D21D}} /* +1.4721284137e+00 */,{{0xBC9FD7D6,0x4D2EA6E0}} /* -1.1047799388e-16 */ ,
}
,{
/*a[58]     */ {{0x40273463,0xD0337C49}} /* +1.1602324015e+01 */ ,
/*b[58] :   */ {{0x402B3DC7,0x4A4A5A1D}} /* +1.3620661089e+01 */ ,
/*atan_b[58]*/ {{0x3FF7F5CC,0xFB256D40}} /* +1.4975099383e+00 */,{{0x3C954E9E,0xA28CF77C}} /* +7.3923881174e-17 */ ,
}
,{
/*a[59]     */ {{0x40307B8E,0x26350916}} /* +1.6482637775e+01 */ ,
/*b[59] :   */ {{0x4034DBD6,0x24D415BF}} /* +2.0858736326e+01 */ ,
/*atan_b[59]*/ {{0x3FF85DC3,0x7049A526}} /* +1.5228914629e+00 */,{{0xBC8424E5,0xE9374500}} /* -3.4944500702e-17 */ ,
}
,{
/*a[60]     */ {{0x403C62CF,0x497BF2F2}} /* +2.8385975449e+01 */ ,
/*b[60] :   */ {{0x40463208,0x6C3EC43C}} /* +4.4390882044e+01 */ ,
/*atan_b[60]*/ {{0x3FF8C5B9,0xE56F7BD2}} /* +1.5482729876e+00 */,{{0xBC81D57A,0x2F7EC153}} /* -3.0936877458e-17 */ ,
}
,{
/*a[61]     */ {{0x40596CC3,0xFA9E0EF4}} /* +1.0169946161e+02 */ ,
/*b[61] :   */ {{0x4054B2C4,0x7BFF8329}} /* +8.2793242454e+01 */ ,
/*atan_b[61]*/ {{0x3FF8F082,0xF333CBBA}} /* +1.5587186337e+00 */,{{0x3C952577,0x3909BC3A}} /* +7.3366141099e-17 */ ,
}
,
};
#else

/* limits of the intervals [a[i],b[i]] */
static db_number const arctan_table[62][4] = 
{
{
/*a[0]     */ {{0xBCCE533D,0x3F89FDF8}} /* +1.2691443693e-02 */ ,
/*b[0] :   */ {{0x27760007,0x3F99FF0B}} /* +2.5386976512e-02 */ ,
/*atan_b[0]*/ {{0x4969F96C,0x3F99FD9D}} /* +2.5381524664e-02 */,{{0x750685EA,0xBC301997}} /* -8.7278097631e-19 */ ,
}
,{
/*a[1]     */ {{0x90CEBC31,0x3FA3809F}} /* +3.8090692927e-02 */ ,
/*b[1] :   */ {{0xE3547CC2,0x3FAA0355}} /* +5.0806697846e-02 */ ,
/*atan_b[1]*/ {{0x4936262D,0x3FA9FD9D}} /* +5.0763049304e-02 */,{{0x3A2D0F59,0xBC4C1F96}} /* -3.0491436238e-18 */ ,
}
,{
/*a[2]     */ {{0x68FBA526,0x3FB04419}} /* +6.3539112216e-02 */ ,
/*b[2] :   */ {{0xABF7BFB9,0x3FB387E0}} /* +7.6292078003e-02 */ ,
/*atan_b[2]*/ {{0xF6C1E06C,0x3FB37E35}} /* +7.6144573921e-02 */,{{0x8378E024,0xBC556710}} /* -4.6409481568e-18 */ ,
}
,{
/*a[3]     */ {{0xABCDFA25,0x3FB6CD46}} /* +8.9069764084e-02 */ ,
/*b[3] :   */ {{0xE265B8AB,0x3FBA1491}} /* +1.0187637117e-01 */ ,
/*atan_b[3]*/ {{0x48CF1996,0x3FB9FD9D}} /* +1.0152609851e-01 */,{{0xB73BED3C,0xBC4360DC}} /* -2.1010068528e-18 */ ,
}
,{
/*a[4]     */ {{0x6D2EA546,0x3FBD5E09}} /* +1.1471613803e-01 */ ,
/*b[4] :   */ {{0x9124D46B,0x3FC054FA}} /* +1.2759334647e-01 */ ,
/*atan_b[4]*/ {{0x4D618156,0x3FC03E82}} /* +1.2690762308e-01 */,{{0x49A86344,0x3C62604E}} /* +7.9694040325e-18 */ ,
}
,{
/*a[5]     */ {{0xD691E891,0x3FC1FC4E}} /* +1.4051232793e-01 */ ,
/*b[5] :   */ {{0x51F57043,0x3FC3A526}} /* +1.5347746851e-01 */ ,
/*atan_b[5]*/ {{0xF64EF83E,0x3FC37E35}} /* +1.5228914763e-01 */,{{0xB4A55EA6,0x3C5F2B13}} /* +6.7585410867e-18 */ ,
}
,{
/*a[6]     */ {{0x531F610B,0x3FC54FA6}} /* +1.6649321612e-01 */ ,
/*b[6] :   */ {{0xB99F2601,0x3FC6FBF4}} /* +1.7956408561e-01 */ ,
/*atan_b[6]*/ {{0x9F302425,0x3FC6BDE9}} /* +1.7767067216e-01 */,{{0xC4D330CE,0xBC23B62A}} /* -5.3428372026e-19 */ ,
}
,{
/*a[7]     */ {{0x0550EAF1,0x3FC8AA38}} /* +1.9269466648e-01 */ ,
/*b[7] :   */ {{0x61D9D63D,0x3FCA5A97}} /* +2.0588962820e-01 */ ,
/*atan_b[7]*/ {{0x48053FC8,0x3FC9FD9D}} /* +2.0305219666e-01 */,{{0x98474AF1,0xBC67A12C}} /* -1.0247699700e-17 */ ,
}
,{
/*a[8]     */ {{0xB8975BD9,0x3FCC0D3A}} /* +2.1915372861e-01 */ ,
/*b[8] :   */ {{0xBCBF6ABC,0x3FCDC24A}} /* +2.3249181954e-01 */ ,
/*atan_b[8]*/ {{0xF0CE8DD9,0x3FCD3D50}} /* +2.2843372114e-01 */,{{0x3A31D353,0x3C6EF257}} /* +1.3420967238e-17 */ ,
}
,{
/*a[9]     */ {{0xFEE46885,0x3FCF79F0}} /* +2.4590885588e-01 */ ,
/*b[9] :   */ {{0xFCF66B85,0x3FD09A2B}} /* +2.5940990165e-01 */ ,
/*atan_b[9]*/ {{0x4CC62C6B,0x3FD03E82}} /* +2.5381524560e-01 */,{{0x95C6E482,0x3C5DA594}} /* +6.4286246635e-18 */ ,
}
,{
/*a[10]     */ {{0x943274CA,0x3FD178D5}} /* +2.7300013993e-01 */ ,
/*b[10] :   */ {{0x8943E603,0x3FD2590B}} /* +2.8668487935e-01 */ ,
/*atan_b[10]*/ {{0x211F7969,0x3FD1DE5C}} /* +2.7919677004e-01 */,{{0x0B01EF44,0x3C3C4E87}} /* +1.5345118889e-18 */ ,
}
,{
/*a[11]     */ {{0xB2CFB5F7,0x3FD33AE4}} /* +3.0046956503e-01 */ ,
/*b[11] :   */ {{0x81B0D1DF,0x3FD41E78}} /* +3.1435978570e-01 */ ,
/*atan_b[11]*/ {{0xF5735AA1,0x3FD37E35}} /* +3.0457829447e-01 */,{{0x8D437AE9,0xBC772D05}} /* -2.0101859382e-17 */ ,
}
,{
/*a[12]     */ {{0x0DD40A5B,0x3FD503DF}} /* +3.2836128569e-01 */ ,
/*b[12] :   */ {{0x1EB6A659,0x3FD5EB31}} /* +3.4247997283e-01 */ ,
/*atan_b[12]*/ {{0xC9C20060,0x3FD51E0F}} /* +3.2995981887e-01 */,{{0x20BA7A7B,0xBC6C0F53}} /* -1.2169025414e-17 */ ,
}
,{
/*a[13]     */ {{0x3998DD14,0x3FD6D488}} /* +3.5672193169e-01 */ ,
/*b[13] :   */ {{0xAAF865B1,0x3FD7BFFE}} /* +3.7109343239e-01 */ ,
/*atan_b[13]*/ {{0x9E0B9E67,0x3FD6BDE9}} /* +3.5534134325e-01 */,{{0x870D5E8E,0x3C797792}} /* +2.2089170409e-17 */ ,
}
,{
/*a[14]     */ {{0x964ABFA5,0x3FD8ADAF}} /* +3.8560094525e-01 */ ,
/*b[14] :   */ {{0x00A6F44E,0x3FD99DB7}} /* +4.0025115074e-01 */ ,
/*atan_b[14]*/ {{0x72506BCA,0x3FD85DC3}} /* +3.8072286762e-01 */,{{0x43A1CBA3,0x3C720BD1}} /* +1.5652550322e-17 */ ,
}
,{
/*a[15]     */ {{0xE241114E,0x3FDA9031}} /* +4.1505095573e-01 */ ,
/*b[15] :   */ {{0x327F0E90,0x3FDB853E}} /* +4.3000750476e-01 */ ,
/*atan_b[15]*/ {{0x4690A2C8,0x3FD9FD9D}} /* +4.0610439197e-01 */,{{0xEFB73034,0xBC6A048E}} /* -1.1283424731e-17 */ ,
}
,{
/*a[16]     */ {{0xFB78B41D,0x3FDC7CFA}} /* +4.4512819822e-01 */ ,
/*b[16] :   */ {{0x67BE333A,0x3FDD7788}} /* +4.6042070514e-01 */ ,
/*atan_b[16]*/ {{0x1ACC80A6,0x3FDB9D77}} /* +4.3148591630e-01 */,{{0xE8FB154D,0x3C6A9BD7}} /* +1.1539711581e-17 */ ,
}
,{
/*a[17]     */ {{0xD82B9DC6,0x3FDE7507}} /* +4.7589298354e-01 */ ,
/*b[17] :   */ {{0xF3B4AACC,0x3FDF759B}} /* +4.9155329513e-01 */ ,
/*atan_b[17]*/ {{0xEF044589,0x3FDD3D50}} /* +4.5686744062e-01 */,{{0x09E8652E,0x3C575857}} /* +5.0621568797e-18 */ ,
}
,{
/*a[18]     */ {{0x5FF4B2AB,0x3FE03CB4}} /* +5.0741022817e-01 */ ,
/*b[18] :   */ {{0xD9952BEF,0x3FE0C049}} /* +5.2347271439e-01 */ ,
/*atan_b[18]*/ {{0xC338344A,0x3FDEDD2A}} /* +4.8224896492e-01 */,{{0x81513292,0x3C23C787}} /* +5.3612202011e-19 */ ,
}
,{
/*a[19]     */ {{0xE826E4EA,0x3FE145A1}} /* +5.3975005476e-01 */ ,
/*b[19] :   */ {{0xDDD96DE0,0x3FE1CCD0}} /* +5.5625193911e-01 */ ,
/*atan_b[19]*/ {{0x4BB44923,0x3FE03E82}} /* +5.0763048922e-01 */,{{0x49DF0A58,0x3C8CAF01}} /* +4.9758137561e-17 */ ,
}
,{
/*a[20]     */ {{0xED462BAC,0x3FE255EB}} /* +5.7298847525e-01 */ ,
/*b[20] :   */ {{0x35B0819C,0x3FE2E109}} /* +5.8997021185e-01 */ ,
/*atan_b[20]*/ {{0x35CAD39D,0x3FE10E6F}} /* +5.3301201350e-01 */,{{0x0D1EB36B,0x3C45DB33}} /* +2.3696591272e-18 */ ,
}
,{
/*a[21]     */ {{0xD4CDD9AC,0x3FE36E3F}} /* +6.0720817149e-01 */ ,
/*b[21] :   */ {{0xF51235D9,0x3FE3FDA7}} /* +6.2471387735e-01 */ ,
/*atan_b[21]*/ {{0x1FDFDE84,0x3FE1DE5C}} /* +5.5839353776e-01 */,{{0xD3921CA6,0x3C86FBEF}} /* +3.9871106783e-17 */ ,
}
,{
/*a[22]     */ {{0xE1FB2991,0x3FE48F5A}} /* +6.4249939095e-01 */ ,
/*b[22] :   */ {{0x18D0CCB0,0x3FE52373}} /* +6.6057734343e-01 */ ,
/*atan_b[22]*/ {{0x09F38FC9,0x3FE2AE49}} /* +5.8377506202e-01 */,{{0x058084C6,0xBC84BBB5}} /* -3.5966422408e-17 */ ,
}
,{
/*a[23]     */ {{0x5FE86E27,0x3FE5BA0C}} /* +6.7896097881e-01 */ ,
/*b[23] :   */ {{0xDA588D41,0x3FE65343}} /* +6.9766419073e-01 */ ,
/*atan_b[23]*/ {{0xF4060E3D,0x3FE37E35}} /* +6.0915658627e-01 */,{{0xAE25B9B7,0x3BF6235C}} /* +7.5006911959e-20 */ ,
}
,{
/*a[24]     */ {{0x22C19A5D,0x3FE6EF38}} /* +7.1670157231e-01 */ ,
/*b[24] :   */ {{0x629002BC,0x3FE78E09}} /* +7.3608845950e-01 */ ,
/*atan_b[24]*/ {{0xDE17817F,0x3FE44E22}} /* +6.3453811052e-01 */,{{0x1A6D25E3,0xBC85F46E}} /* -3.8085515717e-17 */ ,
}
,{
/*a[25]     */ {{0x70F967BD,0x3FE82FD9}} /* +7.5584098878e-01 */ ,
/*b[25] :   */ {{0xEE8B9555,0x3FE8D4CB}} /* +7.7597614852e-01 */ ,
/*atan_b[25]*/ {{0xC82811DC,0x3FE51E0F}} /* +6.5991963475e-01 */,{{0xFCB9720C,0xBC81CCF7}} /* -3.0879221028e-17 */ ,
}
,{
/*a[26]     */ {{0x69351A0D,0x3FE97D06}} /* +7.9651184605e-01 */ ,
/*b[26] :   */ {{0x7D0D616A,0x3FEA28B0}} /* +8.1746696877e-01 */ ,
/*atan_b[26]*/ {{0xB237E838,0x3FE5EDFC}} /* +6.8530115898e-01 */,{{0xF8F29048,0xBC833EA8}} /* -3.3384347049e-17 */ ,
}
,{
/*a[27]     */ {{0xFE730FCD,0x3FEAD7F3}} /* +8.3886146257e-01 */ ,
/*b[27] :   */ {{0x21335E3D,0x3FEB8AFD}} /* +8.6071640477e-01 */ ,
/*atan_b[27]*/ {{0x9C472DF1,0x3FE6BDE9}} /* +7.1068268321e-01 */,{{0x80DED249,0x3C5E8127}} /* +6.6146109909e-18 */ ,
}
,{
/*a[28]     */ {{0xAA0A733E,0x3FEC41FA}} /* +8.8305409633e-01 */ ,
/*b[28] :   */ {{0x1D9A7669,0x3FECFD1E}} /* +9.0589814932e-01 */ ,
/*atan_b[28]*/ {{0x86560CC5,0x3FE78DD6}} /* +7.3606420743e-01 */,{{0x9396D511,0xBC7E962F}} /* -2.6529701578e-17 */ ,
}
,{
/*a[29]     */ {{0xFAEEEADF,0x3FEDBC9B}} /* +9.2927359591e-01 */ ,
/*b[29] :   */ {{0xF41419E7,0x3FEE80AB}} /* +9.5320699379e-01 */ ,
/*atan_b[29]*/ {{0x7064AEB4,0x3FE85DC3}} /* +7.6144573166e-01 */,{{0x5225ACD1,0x3C77C0FC}} /* +2.0603180716e-17 */ ,
}
,{
/*a[30]     */ {{0x33AC790A,0x3FEF4989}} /* +9.7772655575e-01 */ ,
/*b[30] :   */ {{0x50BB2D02,0x3FF00BB9}} /* +1.0028622774e+00 */ ,
/*atan_b[30]*/ {{0x5A733DE9,0x3FE92DB0}} /* +7.8682725588e-01 */,{{0xA318D041,0xBC6598C9}} /* -9.3661305872e-18 */ ,
}
,{
/*a[31]     */ {{0x9AC922B4,0x3FF07555}} /* +1.0286460921e+00 */ ,
/*b[31] :   */ {{0x25F4BC57,0x3FF0E1BD}} /* +1.0551120265e+00 */ ,
/*atan_b[31]*/ {{0x4481E499,0x3FE9FD9D}} /* +8.1220878010e-01 */,{{0x9464A40D,0xBC82E89F}} /* -3.2801339756e-17 */ ,
}
,{
/*a[32]     */ {{0x0440E8D3,0x3FF15116}} /* +1.0822963873e+00 */ ,
/*b[32] :   */ {{0xDEC8DA1A,0x3FF1C388}} /* +1.1102379515e+00 */ ,
/*atan_b[32]*/ {{0x2E90CCEA,0x3FEACD8A}} /* +8.3759030433e-01 */,{{0xFE4AC33B,0x3C60B8DB}} /* +7.2520578222e-18 */ ,
}
,{
/*a[33]     */ {{0x329D3DD8,0x3FF23941}} /* +1.1389781930e+00 */ ,
/*b[33] :   */ {{0x8F9CF3AD,0x3FF2B26D}} /* +1.1685615168e+00 */ ,
/*atan_b[33]*/ {{0x18A020D8,0x3FEB9D77}} /* +8.6297182855e-01 */,{{0x43DDC7EE,0x3C714EA3}} /* +1.5011584621e-17 */ ,
}
,{
/*a[34]     */ {{0xE2DB7094,0x3FF32F3F}} /* +1.1990355360e+00 */ ,
/*b[34] :   */ {{0xC485093A,0x3FF3AFED}} /* +1.2304513623e+00 */ ,
/*atan_b[34]*/ {{0x02B00A17,0x3FEC6D64}} /* +8.8835335278e-01 */,{{0xC1E56981,0x3C5CF722}} /* +6.2808643065e-18 */ ,
}
,{
/*a[35]     */ {{0xD38A35D7,0x3FF434B0}} /* +1.2628639472e+00 */ ,
/*b[35] :   */ {{0x16D89BC7,0x3FF4BDC7}} /* +1.2963324444e+00 */ ,
/*atan_b[35]*/ {{0xECC0B1F8,0x3FED3D50}} /* +9.1373487702e-01 */,{{0xC689AE1B,0x3C8FFD9A}} /* +5.5494919315e-17 */ ,
}
,{
/*a[36]     */ {{0x6F41F96D,0x3FF54B73}} /* +1.3309206339e+00 */ ,
/*b[36] :   */ {{0x11C53212,0x3FF5DDFE}} /* +1.3666973776e+00 */ ,
/*atan_b[36]*/ {{0xD6D24151,0x3FEE0D3D}} /* +9.3911640126e-01 */,{{0xC830B564,0xBC654F0F}} /* -9.2412338910e-18 */ ,
}
,{
/*a[37]     */ {{0x165CA5E1,0x3FF675B5}} /* +1.4037371515e+00 */ ,
/*b[37] :   */ {{0x13170C5B,0x3FF712ED}} /* +1.4421206232e+00 */ ,
/*atan_b[37]*/ {{0xC0E4E05B,0x3FEEDD2A}} /* +9.6449792552e-01 */,{{0xBF676FFE,0xBC8FEAC3}} /* -5.5367254830e-17 */ ,
}
,{
/*a[38]     */ {{0xD0DEA3C6,0x3FF7B601}} /* +1.4819353255e+00 */ ,
/*b[38] :   */ {{0x11FBEA40,0x3FF85F57}} /* +1.5232763960e+00 */ ,
/*atan_b[38]*/ {{0xAAF8B69E,0x3FEFAD17}} /* +9.8987944978e-01 */,{{0xE69F3AF7,0x3C8B8DA3}} /* +4.7797325436e-17 */ ,
}
,{
/*a[39]     */ {{0x79506F51,0x3FF90F59}} /* +1.5662474383e+00 */ ,
/*b[39] :   */ {{0x8AF460DF,0x3FF9C67F}} /* +1.6109614780e+00 */ ,
/*atan_b[39]*/ {{0x4A86F56B,0x3FF03E82}} /* +1.0152609740e+00 */,{{0xDE1DF40B,0x3C8C4641}} /* +4.9048339280e-17 */ ,
}
,{
/*a[40]     */ {{0xD74CF791,0x3FFA854A}} /* +1.6575420771e+00 */ ,
/*b[40] :   */ {{0x4A696F14,0x3FFB4C49}} /* +1.7061245829e+00 */ ,
/*atan_b[40]*/ {{0xBF92516C,0x3FF0A678}} /* +1.0406424983e+00 */,{{0x6A0966AF,0xBC9194FF}} /* -6.0999893718e-17 */ ,
}
,{
/*a[41]     */ {{0xB3972246,0x3FFC1C16}} /* +1.7568575874e+00 */ ,
/*b[41] :   */ {{0x80F0B83E,0x3FFCF55E}} /* +1.8099045788e+00 */ ,
/*atan_b[41]*/ {{0x349E81BA,0x3FF10E6F}} /* +1.0660240226e+00 */,{{0x3CD05C13,0x3C9C7D12}} /* +9.8839546037e-17 */ ,
}
,{
/*a[42]     */ {{0xC6DB1831,0x3FFDD8DD}} /* +1.8654458778e+00 */ ,
/*b[42] :   */ {{0x927D039C,0x3FFEC765}} /* +1.9236808512e+00 */ ,
/*atan_b[42]*/ {{0xA9AB9836,0x3FF17665}} /* +1.0914055469e+00 */,{{0x7B9C115B,0xBC924DFA}} /* -6.3506850178e-17 */ ,
}
,{
/*a[43]     */ {{0xA4F6D032,0x3FFFC1DD}} /* +1.9848305172e+00 */ ,
/*b[43] :   */ {{0xCDEC630C,0x400064A3}} /* +2.0491405571e+00 */ ,
/*atan_b[43]*/ {{0x1EB9A624,0x3FF1DE5C}} /* +1.1167870712e+00 */,{{0x595EC15D,0xBC7002F6}} /* -1.3887824475e-17 */ ,
}
,{
/*a[44]     */ {{0x56AEFAF2,0x4000EF61}} /* +2.1168848774e+00 */ ,
/*b[44] :   */ {{0x02FA3F97,0x400181C8}} /* +2.1883697732e+00 */ ,
/*atan_b[44]*/ {{0x93C8BC28,0x3FF24652}} /* +1.1421685956e+00 */,{{0xC61E8575,0xBC8FE336}} /* -5.5316089441e-17 */ ,
}
,{
/*a[45]     */ {{0xFD9A80C1,0x40021C8B}} /* +2.2639388860e+00 */ ,
/*b[45] :   */ {{0x188015C0,0x4002C078}} /* +2.3439790644e+00 */ ,
/*atan_b[45]*/ {{0x08D8EA37,0x3FF2AE49}} /* +1.1675501199e+00 */,{{0x56281657,0xBC99C943}} /* -8.9463796524e-17 */ ,
}
,{
/*a[46]     */ {{0x7D67269C,0x40036E71}} /* +2.4289274022e+00 */ ,
/*b[46] :   */ {{0x17EDBBF3,0x4004277C}} /* +2.5192796583e+00 */ ,
/*atan_b[46]*/ {{0x7DEA3F8C,0x3FF3163F}} /* +1.1929316443e+00 */,{{0x90EB721B,0x3C9AD329}} /* +9.3067404471e-17 */ ,
}
,{
/*a[47]     */ {{0xF069F1E4,0x4004ECBF}} /* +2.6156004698e+00 */ ,
/*b[47] :   */ {{0xA99113B9,0x4005BF8F}} /* +2.7185357330e+00 */ ,
/*atan_b[47]*/ {{0xF2FCCAA3,0x3FF37E35}} /* +1.2183131687e+00 */,{{0x8B3674F4,0xBC96C4D7}} /* -7.8995539059e-17 */ ,
}
,{
/*a[48]     */ {{0x780169B7,0x4006A170}} /* +2.8288277984e+00 */ ,
/*b[48] :   */ {{0xEECFDE39,0x40079423}} /* +2.9473341615e+00 */ ,
/*atan_b[48]*/ {{0x68109926,0x3FF3E62C}} /* +1.2436946931e+00 */,{{0x46562D7D,0x3C9D395E}} /* +1.0139144652e-16 */ ,
}
,{
/*a[49]     */ {{0x319C3F02,0x400899B4}} /* +3.0750507236e+00 */ ,
/*b[49] :   */ {{0x34491C9A,0x4009B483}} /* +3.2131408772e+00 */ ,
/*atan_b[49]*/ {{0xDD25B7F0,0x3FF44E22}} /* +1.2690762175e+00 */,{{0x96299AC9,0xBC9AC408}} /* -9.2862370643e-17 */ ,
}
,{
/*a[50]     */ {{0x05B0834A,0x400AE75E}} /* +3.3629723019e+00 */ ,
/*b[50] :   */ {{0x6451B6E9,0x400C3595}} /* +3.5261638486e+00 */ ,
/*atan_b[50]*/ {{0x523C32F8,0x3FF4B619}} /* +1.2944577420e+00 */,{{0x9A6CF82B,0x3C98372D}} /* +8.4014530055e-17 */ ,
}
,{
/*a[51]     */ {{0x739BD0E3,0x400DA31D}} /* +3.7046460182e+00 */ ,
/*b[51] :   */ {{0x088B2A13,0x400F34B7}} /* +3.9007397335e+00 */ ,
/*atan_b[51]*/ {{0xC7541555,0x3FF51E0F}} /* +1.3198392664e+00 */,{{0xD97CC177,0xBC4DA0E1}} /* -3.2123225727e-18 */ ,
}
,{
/*a[52]     */ {{0x1886BC57,0x40107813}} /* +4.1172603447e+00 */ ,
/*b[52] :   */ {{0x8D819944,0x40116E3D}} /* +4.3576566801e+00 */ ,
/*atan_b[52]*/ {{0x3C6D692D,0x3FF58606}} /* +1.3452207909e+00 */,{{0xD9D13C46,0xBC7DAB9D}} /* -2.5734950076e-17 */ ,
}
,{
/*a[53]     */ {{0x8BCE2241,0x4012813A}} /* +4.6261998982e+00 */ ,
/*b[53] :   */ {{0x9F0E4EBF,0x4013B685}} /* +4.9282440999e+00 */ ,
/*atan_b[53]*/ {{0xB18837B4,0x3FF5EDFC}} /* +1.3706023154e+00 */,{{0xBC854F71,0xBC858200}} /* -3.7310126753e-17 */ ,
}
,{
/*a[54]     */ {{0x4ACECE78,0x40151516}} /* +5.2705928506e+00 */ ,
/*b[54] :   */ {{0xF3CD0189,0x4016A5E9}} /* +5.6620252699e+00 */ ,
/*atan_b[54]*/ {{0x26A48924,0x3FF655F3}} /* +1.3959838399e+00 */,{{0x0EF07703,0xBC95DCD4}} /* -7.5851168241e-17 */ ,
}
,{
/*a[55]     */ {{0x9526FAB9,0x401874CE}} /* +6.1140693002e+00 */ ,
/*b[55] :   */ {{0xBA057809,0x401A9194}} /* +6.6421689096e+00 */ ,
/*atan_b[55]*/ {{0x9BC264B7,0x3FF6BDE9}} /* +1.4213653645e+00 */,{{0x555821B5,0x3C839FB7}} /* +3.4042024747e-17 */ ,
}
,{
/*a[56]     */ {{0xE094C913,0x401D11EB}} /* +7.2675013629e+00 */ ,
/*b[56] :   */ {{0xA01EFACA,0x40200A31}} /* +8.0199098623e+00 */ ,
/*atan_b[56]*/ {{0x10E1D0A5,0x3FF725E0}} /* +1.4467468891e+00 */,{{0x56DADB03,0x3C86B63B}} /* +3.9398767140e-17 */ ,
}
,{
/*a[57]     */ {{0x220DFA19,0x4021E2BC}} /* +8.9428415911e+00 */ ,
/*b[57] :   */ {{0xFBA72898,0x40243445}} /* +1.0102096428e+01 */ ,
/*atan_b[57]*/ {{0x8602D21D,0x3FF78DD6}} /* +1.4721284137e+00 */,{{0x4D2EA6E0,0xBC9FD7D6}} /* -1.1047799388e-16 */ ,
}
,{
/*a[58]     */ {{0xD0337C49,0x40273463}} /* +1.1602324015e+01 */ ,
/*b[58] :   */ {{0x4A4A5A1D,0x402B3DC7}} /* +1.3620661089e+01 */ ,
/*atan_b[58]*/ {{0xFB256D40,0x3FF7F5CC}} /* +1.4975099383e+00 */,{{0xA28CF77C,0x3C954E9E}} /* +7.3923881174e-17 */ ,
}
,{
/*a[59]     */ {{0x26350916,0x40307B8E}} /* +1.6482637775e+01 */ ,
/*b[59] :   */ {{0x24D415BF,0x4034DBD6}} /* +2.0858736326e+01 */ ,
/*atan_b[59]*/ {{0x7049A526,0x3FF85DC3}} /* +1.5228914629e+00 */,{{0xE9374500,0xBC8424E5}} /* -3.4944500702e-17 */ ,
}
,{
/*a[60]     */ {{0x497BF2F2,0x403C62CF}} /* +2.8385975449e+01 */ ,
/*b[60] :   */ {{0x6C3EC43C,0x40463208}} /* +4.4390882044e+01 */ ,
/*atan_b[60]*/ {{0xE56F7BD2,0x3FF8C5B9}} /* +1.5482729876e+00 */,{{0x2F7EC153,0xBC81D57A}} /* -3.0936877458e-17 */ ,
}
,{
/*a[61]     */ {{0xFA9E0EF4,0x40596CC3}} /* +1.0169946161e+02 */ ,
/*b[61] :   */ {{0x7BFF8329,0x4054B2C4}} /* +8.2793242454e+01 */ ,
/*atan_b[61]*/ {{0xF333CBBA,0x3FF8F082}} /* +1.5587186337e+00 */,{{0x3909BC3A,0x3C952577}} /* +7.3366141099e-17 */ ,
}
,
};

#endif

#endif /* def _ATAN_FAST_H */
