import setuptools
from pathlib import Path
from Cython.Build import cythonize
import numpy

with open("README.md", 'r') as f:
    long_description = f.read()
  
setuptools.setup(
    name="fABBA",
    packages=setuptools.find_packages(),
    version="0.2.0",
    ext_modules=cythonize(["fABBA/caggregation.pyx", "fABBA/caggregation_memview.pyx", "fABBA/chainApproximation_c.pyx"]), 
    include_dirs=[numpy.get_include()],
    long_description=long_description,
    author="Stefan Guettel, Xinye Chen",
    author_email="stefan.guettel@manchester.ac.uk",
    description="An efficient aggregation based symbolic representation",
    long_description_content_type='text/markdown',
    url="https://github.com/nla-group/fABBA",
    # packages=setuptools.find_packages(),
    install_requires=['numpy'],
    license='BSD 3-Clause'
)