# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['vcfstats']

package_data = \
{'': ['*']}

install_requires = \
['cyvcf2>=0.30,<0.31',
 'datar[pandas]>=0.11,<0.12',
 'lark-parser>=0.12,<0.13',
 'plotnine-prism>=0.2,<0.3',
 'plotnine>=0.10,<0.11',
 'py>=1.10,<2.0',
 'pyparam>=0.5,<0.6',
 'python-slugify>=8,<9']

entry_points = \
{'console_scripts': ['vcfstats = vcfstats.cli:main']}

setup_kwargs = {
    'name': 'vcfstats',
    'version': '0.4.3',
    'description': 'Powerful statistics for VCF files',
    'long_description': '# vcfstats - powerful statistics for VCF files\n\n[![Pypi][1]][2] [![Github][3]][4] [![PythonVers][5]][2] [![docs][6]][13] ![github action][7] [![Codacy][9]][10] [![Codacy coverage][11]][10]\n\n[Documentation][13] | [CHANGELOG][12]\n\n## Motivation\n\nThere are a couple of tools that can plot some statistics of VCF files, including [`bcftools`][14] and [`jvarkit`][15]. However, none of them could:\n\n1. plot specific metrics\n2. customize the plots\n3. focus on variants with certain filters\n\nR package [`vcfR`][19] can do some of the above. However, it has to load entire VCF into memory, which is not friendly to large VCF files.\n\n## Installation\n\n```shell\npip install -U vcfstats\n```\n\nOr run with docker:\n\n```shell\ndocker run \\\n  -w /vcfstats/workdir \\\n  -v $(pwd):/vcfstats/workdir \\\n  --rm justold/vcfstats:latest \\\n  vcfstats \\\n  --vcf myfile.vcf \\\n  -o outputs \\\n  --formula \'COUNT(1) ~ CONTIG\' \\\n  --title \'Number of variants on each chromosome\'\n```\n\n## Gallery\n\n### Number of variants on each chromosome\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'COUNT(1) ~ CONTIG\' \\\n    --title \'Number of variants on each chromosome\' \\\n    --config examples/config.toml\n```\n\n![Number of variants on each chromosome](examples/number-of-variants-on-each-chromosome.col.png)\n\n#### Changing labels and ticks\n\n`vcfstats` uses [`plotnine`][17] for plotting, read more about it on how to specify `--ggs` to modify the plots.\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'COUNT(1) ~ CONTIG\' \\\n    --title \'Number of variants on each chromosome (modified)\' \\\n    --config examples/config.toml \\\n    --ggs \'scale_x_discrete(name ="Chromosome", \\\n        limits=["1","2","3","4","5","6","7","8","9","10","X"]); \\\n        ylab("# Variants")\'\n```\n\n![Number of variants on each chromosome (modified)](examples/number-of-variants-on-each-chromosome-modified.col.png)\n\n#### Number of variants on first 5 chromosome\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'COUNT(1) ~ CONTIG[1,2,3,4,5]\' \\\n    --title \'Number of variants on each chromosome (first 5)\' \\\n    --config examples/config.toml\n# or\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'COUNT(1) ~ CONTIG[1-5]\' \\\n    --title \'Number of variants on each chromosome (first 5)\' \\\n    --config examples/config.toml\n# or\n# require vcf file to be tabix-indexed.\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'COUNT(1) ~ CONTIG\' \\\n    --title \'Number of variants on each chromosome (first 5)\' \\\n    --config examples/config.toml -r 1 2 3 4 5\n```\n\n![Number of variants on each chromosome (first 5)](examples/number-of-variants-on-each-chromosome-first-5.col.png)\n\n### Number of substitutions of SNPs\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'COUNT(1, VARTYPE[snp]) ~ SUBST[A>T,A>G,A>C,T>A,T>G,T>C,G>A,G>T,G>C,C>A,C>T,C>G]\' \\\n    --title \'Number of substitutions of SNPs\' \\\n    --config examples/config.toml\n```\n\n![Number of substitutions of SNPs](examples/number-of-substitutions-of-snps.col.png)\n\n#### Only with SNPs PASS all filters\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'COUNT(1, VARTYPE[snp]) ~ SUBST[A>T,A>G,A>C,T>A,T>G,T>C,G>A,G>T,G>C,C>A,C>T,C>G]\' \\\n    --title \'Number of substitutions of SNPs (passed)\' \\\n    --config examples/config.toml \\\n    --passed\n```\n\n![Number of substitutions of SNPs (passed)](examples/number-of-substitutions-of-snps-passed.col.png)\n\n### Alternative allele frequency on each chromosome\n\n```shell\n# using a dark theme\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'AAF ~ CONTIG\' \\\n    --title \'Allele frequency on each chromosome\' \\\n    --config examples/config.toml --ggs \'theme_dark()\'\n```\n\n![Allele frequency on each chromosome](examples/allele-frequency-on-each-chromosome.violin.png)\n\n#### Using boxplot\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'AAF ~ CONTIG\' \\\n    --title \'Allele frequency on each chromosome (boxplot)\' \\\n    --config examples/config.toml \\\n    --figtype boxplot\n```\n\n![Allele frequency on each chromosome](examples/allele-frequency-on-each-chromosome.boxplot.png)\n\n#### Using density plot/histogram to investigate the distribution:\n\nYou can plot the distribution, using density plot or histogram\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'AAF ~ CONTIG[1,2]\' \\\n    --title \'Allele frequency on chromosome 1,2\' \\\n    --config examples/config.toml \\\n    --figtype density\n```\n\n![Allele frequency on chromosome 1,2](examples/allele-frequency-on-chromosome-1-2.density.png)\n\n### Overall distribution of allele frequency\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'AAF ~ 1\' \\\n    --title \'Overall allele frequency distribution\' \\\n    --config examples/config.toml\n```\n\n![Overall allele frequency distribution](examples/overall-allele-frequency-distribution.histogram.png)\n\n#### Excluding some low/high frequency variants\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'AAF[0.05, 0.95] ~ 1\' \\\n    --title \'Overall allele frequency distribution (0.05-0.95)\' \\\n    --config examples/config.toml\n```\n\n![Overall allele frequency distribution](examples/overall-allele-frequency-distribution-0-05-0-95.histogram.png)\n\n### Counting types of variants on each chromosome\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'COUNT(1, group=VARTYPE) ~ CHROM\' \\\n    # or simply\n    # --formula \'VARTYPE ~ CHROM\' \\\n    --title \'Types of variants on each chromosome\' \\\n    --config examples/config.toml\n```\n\n![Types of variants on each chromosome](examples/types-of-variants-on-each-chromosome.col.png)\n\n#### Using bar chart if there is only one chromosome\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'COUNT(1, group=VARTYPE) ~ CHROM[1]\' \\\n    # or simply\n    # --formula \'VARTYPE ~ CHROM[1]\' \\\n    --title \'Types of variants on chromosome 1\' \\\n    --config examples/config.toml \\\n    --figtype pie\n```\n\n![Types of variants on chromosome 1](examples/types-of-variants-on-chromosome-1.pie.png)\n\n#### Counting variant types on whole genome\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    # or simply\n    # --formula \'VARTYPE ~ 1\' \\\n    --formula \'COUNT(1, group=VARTYPE) ~ 1\' \\\n    --title \'Types of variants on whole genome\' \\\n    --config examples/config.toml\n```\n\n![Types of variants on whole genome](examples/types-of-variants-on-whole-genome.col.png)\n\n### Counting type of mutant genotypes (HET, HOM_ALT) for sample 1 on each chromosome\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    # or simply\n    # --formula \'GTTYPEs[HET,HOM_ALT]{0} ~ CHROM\' \\\n    --formula \'COUNT(1, group=GTTYPEs[HET,HOM_ALT]{0}) ~ CHROM\' \\\n    --title \'Mutant genotypes on each chromosome (sample 1)\' \\\n    --config examples/config.toml\n```\n\n![Mutant genotypes on each chromosome](examples/mutant-genotypes-on-each-chromosome-sample-1.col.png)\n\n\n### Exploration of mean(genotype quality) and mean(depth) on each chromosome for sample 1\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'MEAN(GQs{0}) ~ MEAN(DEPTHs{0}, group=CHROM)\' \\\n    --title \'GQ vs depth (sample 1)\' \\\n    --config examples/config.toml\n```\n\n![GQ vs depth (sample 1)](examples/gq-vs-depth-sample-1.scatter.png)\n\n### Exploration of depths for sample 1,2\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n    --outdir examples/ \\\n    --formula \'DEPTHs{0} ~ DEPTHs{1}\' \\\n    --title \'Depths between sample 1 and 2\' \\\n    --config examples/config.toml\n```\n\n![Depths between sample 1 and 2](examples/depths-between-sample-1-and-2.scatter.png)\n\nSee more examples:\n\n[https://github.com/pwwang/vcfstats/issues/15#issuecomment-1029367903](https://github.com/pwwang/vcfstats/issues/15#issuecomment-1029367903)\n\n[1]: https://img.shields.io/pypi/v/vcfstats?style=flat-square\n[2]: https://pypi.org/project/vcfstats/\n[3]: https://img.shields.io/github/v/tag/pwwang/vcfstats?style=flat-square\n[4]: https://github.com/pwwang/vcfstats\n[5]: https://img.shields.io/pypi/pyversions/vcfstats?style=flat-square\n[6]: https://img.shields.io/github/actions/workflow/status/pwwang/vcfstats/docs.yml?label=docs&style=flat-square\n[7]: https://img.shields.io/github/actions/workflow/status/pwwang/vcfstats/build.yml?style=flat-square\n[9]: https://img.shields.io/codacy/grade/c8c8bfa8c5e9443bbf268a0a7c6f206d?style=flat-square\n[10]: https://app.codacy.com/gh/pwwang/vcfstats/\n[11]: https://img.shields.io/codacy/coverage/c8c8bfa8c5e9443bbf268a0a7c6f206d?style=flat-square\n[12]: https://pwwang.github.io/vcfstats/CHANGELOG/\n[13]: https://pwwang.github.io/vcfstats/\n[14]: https://samtools.github.io/bcftools/bcftools.html#stats\n[15]: http://lindenb.github.io/jvarkit/VcfStatsJfx.html\n[17]: https://plotnine.readthedocs.io/en/stable/\n[19]: https://knausb.github.io/vcfR_documentation/visualization_1.html\n',
    'author': 'pwwang',
    'author_email': 'pwwang@pwwang.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/pwwang/vcfstats',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
