# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_container.configuration import Configuration


class ContainerManifestSignatureResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pulp_href': 'str',
        'prn': 'str',
        'pulp_created': 'datetime',
        'pulp_last_updated': 'datetime',
        'name': 'str',
        'digest': 'str',
        'type': 'str',
        'key_id': 'str',
        'timestamp': 'int',
        'creator': 'str',
        'signed_manifest': 'str'
    }

    attribute_map = {
        'pulp_href': 'pulp_href',
        'prn': 'prn',
        'pulp_created': 'pulp_created',
        'pulp_last_updated': 'pulp_last_updated',
        'name': 'name',
        'digest': 'digest',
        'type': 'type',
        'key_id': 'key_id',
        'timestamp': 'timestamp',
        'creator': 'creator',
        'signed_manifest': 'signed_manifest'
    }

    def __init__(self, pulp_href=None, prn=None, pulp_created=None, pulp_last_updated=None, name=None, digest=None, type=None, key_id=None, timestamp=None, creator=None, signed_manifest=None, local_vars_configuration=None):  # noqa: E501
        """ContainerManifestSignatureResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._pulp_href = None
        self._prn = None
        self._pulp_created = None
        self._pulp_last_updated = None
        self._name = None
        self._digest = None
        self._type = None
        self._key_id = None
        self._timestamp = None
        self._creator = None
        self._signed_manifest = None
        self.discriminator = None

        if pulp_href is not None:
            self.pulp_href = pulp_href
        if prn is not None:
            self.prn = prn
        if pulp_created is not None:
            self.pulp_created = pulp_created
        if pulp_last_updated is not None:
            self.pulp_last_updated = pulp_last_updated
        self.name = name
        self.digest = digest
        self.type = type
        self.key_id = key_id
        self.timestamp = timestamp
        self.creator = creator
        self.signed_manifest = signed_manifest

    @property
    def pulp_href(self):
        """Gets the pulp_href of this ContainerManifestSignatureResponse.  # noqa: E501


        :return: The pulp_href of this ContainerManifestSignatureResponse.  # noqa: E501
        :rtype: str
        """
        return self._pulp_href

    @pulp_href.setter
    def pulp_href(self, pulp_href):
        """Sets the pulp_href of this ContainerManifestSignatureResponse.


        :param pulp_href: The pulp_href of this ContainerManifestSignatureResponse.  # noqa: E501
        :type: str
        """

        self._pulp_href = pulp_href

    @property
    def prn(self):
        """Gets the prn of this ContainerManifestSignatureResponse.  # noqa: E501

        The Pulp Resource Name (PRN).  # noqa: E501

        :return: The prn of this ContainerManifestSignatureResponse.  # noqa: E501
        :rtype: str
        """
        return self._prn

    @prn.setter
    def prn(self, prn):
        """Sets the prn of this ContainerManifestSignatureResponse.

        The Pulp Resource Name (PRN).  # noqa: E501

        :param prn: The prn of this ContainerManifestSignatureResponse.  # noqa: E501
        :type: str
        """

        self._prn = prn

    @property
    def pulp_created(self):
        """Gets the pulp_created of this ContainerManifestSignatureResponse.  # noqa: E501

        Timestamp of creation.  # noqa: E501

        :return: The pulp_created of this ContainerManifestSignatureResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._pulp_created

    @pulp_created.setter
    def pulp_created(self, pulp_created):
        """Sets the pulp_created of this ContainerManifestSignatureResponse.

        Timestamp of creation.  # noqa: E501

        :param pulp_created: The pulp_created of this ContainerManifestSignatureResponse.  # noqa: E501
        :type: datetime
        """

        self._pulp_created = pulp_created

    @property
    def pulp_last_updated(self):
        """Gets the pulp_last_updated of this ContainerManifestSignatureResponse.  # noqa: E501

        Timestamp of the last time this resource was updated. Note: for immutable resources - like content, repository versions, and publication - pulp_created and pulp_last_updated dates will be the same.  # noqa: E501

        :return: The pulp_last_updated of this ContainerManifestSignatureResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._pulp_last_updated

    @pulp_last_updated.setter
    def pulp_last_updated(self, pulp_last_updated):
        """Sets the pulp_last_updated of this ContainerManifestSignatureResponse.

        Timestamp of the last time this resource was updated. Note: for immutable resources - like content, repository versions, and publication - pulp_created and pulp_last_updated dates will be the same.  # noqa: E501

        :param pulp_last_updated: The pulp_last_updated of this ContainerManifestSignatureResponse.  # noqa: E501
        :type: datetime
        """

        self._pulp_last_updated = pulp_last_updated

    @property
    def name(self):
        """Gets the name of this ContainerManifestSignatureResponse.  # noqa: E501

        Signature name in the format of `digest_algo:manifest_digest@random_32_chars`  # noqa: E501

        :return: The name of this ContainerManifestSignatureResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ContainerManifestSignatureResponse.

        Signature name in the format of `digest_algo:manifest_digest@random_32_chars`  # noqa: E501

        :param name: The name of this ContainerManifestSignatureResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def digest(self):
        """Gets the digest of this ContainerManifestSignatureResponse.  # noqa: E501

        sha256 digest of the signature blob  # noqa: E501

        :return: The digest of this ContainerManifestSignatureResponse.  # noqa: E501
        :rtype: str
        """
        return self._digest

    @digest.setter
    def digest(self, digest):
        """Sets the digest of this ContainerManifestSignatureResponse.

        sha256 digest of the signature blob  # noqa: E501

        :param digest: The digest of this ContainerManifestSignatureResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and digest is None:  # noqa: E501
            raise ValueError("Invalid value for `digest`, must not be `None`")  # noqa: E501

        self._digest = digest

    @property
    def type(self):
        """Gets the type of this ContainerManifestSignatureResponse.  # noqa: E501

        Container signature type, e.g. 'atomic'  # noqa: E501

        :return: The type of this ContainerManifestSignatureResponse.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ContainerManifestSignatureResponse.

        Container signature type, e.g. 'atomic'  # noqa: E501

        :param type: The type of this ContainerManifestSignatureResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def key_id(self):
        """Gets the key_id of this ContainerManifestSignatureResponse.  # noqa: E501

        Signing key ID  # noqa: E501

        :return: The key_id of this ContainerManifestSignatureResponse.  # noqa: E501
        :rtype: str
        """
        return self._key_id

    @key_id.setter
    def key_id(self, key_id):
        """Sets the key_id of this ContainerManifestSignatureResponse.

        Signing key ID  # noqa: E501

        :param key_id: The key_id of this ContainerManifestSignatureResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and key_id is None:  # noqa: E501
            raise ValueError("Invalid value for `key_id`, must not be `None`")  # noqa: E501

        self._key_id = key_id

    @property
    def timestamp(self):
        """Gets the timestamp of this ContainerManifestSignatureResponse.  # noqa: E501

        Timestamp of a signature  # noqa: E501

        :return: The timestamp of this ContainerManifestSignatureResponse.  # noqa: E501
        :rtype: int
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this ContainerManifestSignatureResponse.

        Timestamp of a signature  # noqa: E501

        :param timestamp: The timestamp of this ContainerManifestSignatureResponse.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and timestamp is None:  # noqa: E501
            raise ValueError("Invalid value for `timestamp`, must not be `None`")  # noqa: E501

        self._timestamp = timestamp

    @property
    def creator(self):
        """Gets the creator of this ContainerManifestSignatureResponse.  # noqa: E501

        Signature creator  # noqa: E501

        :return: The creator of this ContainerManifestSignatureResponse.  # noqa: E501
        :rtype: str
        """
        return self._creator

    @creator.setter
    def creator(self, creator):
        """Sets the creator of this ContainerManifestSignatureResponse.

        Signature creator  # noqa: E501

        :param creator: The creator of this ContainerManifestSignatureResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and creator is None:  # noqa: E501
            raise ValueError("Invalid value for `creator`, must not be `None`")  # noqa: E501

        self._creator = creator

    @property
    def signed_manifest(self):
        """Gets the signed_manifest of this ContainerManifestSignatureResponse.  # noqa: E501

        Manifest that is signed  # noqa: E501

        :return: The signed_manifest of this ContainerManifestSignatureResponse.  # noqa: E501
        :rtype: str
        """
        return self._signed_manifest

    @signed_manifest.setter
    def signed_manifest(self, signed_manifest):
        """Sets the signed_manifest of this ContainerManifestSignatureResponse.

        Manifest that is signed  # noqa: E501

        :param signed_manifest: The signed_manifest of this ContainerManifestSignatureResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and signed_manifest is None:  # noqa: E501
            raise ValueError("Invalid value for `signed_manifest`, must not be `None`")  # noqa: E501

        self._signed_manifest = signed_manifest

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContainerManifestSignatureResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContainerManifestSignatureResponse):
            return True

        return self.to_dict() != other.to_dict()
