# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_container.configuration import Configuration


class ContainerManifestResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pulp_href': 'str',
        'prn': 'str',
        'pulp_created': 'datetime',
        'pulp_last_updated': 'datetime',
        'digest': 'str',
        'schema_version': 'int',
        'media_type': 'str',
        'listed_manifests': 'list[str]',
        'config_blob': 'str',
        'blobs': 'list[str]',
        'annotations': 'object',
        'labels': 'object',
        'is_bootable': 'bool',
        'is_flatpak': 'bool'
    }

    attribute_map = {
        'pulp_href': 'pulp_href',
        'prn': 'prn',
        'pulp_created': 'pulp_created',
        'pulp_last_updated': 'pulp_last_updated',
        'digest': 'digest',
        'schema_version': 'schema_version',
        'media_type': 'media_type',
        'listed_manifests': 'listed_manifests',
        'config_blob': 'config_blob',
        'blobs': 'blobs',
        'annotations': 'annotations',
        'labels': 'labels',
        'is_bootable': 'is_bootable',
        'is_flatpak': 'is_flatpak'
    }

    def __init__(self, pulp_href=None, prn=None, pulp_created=None, pulp_last_updated=None, digest=None, schema_version=None, media_type=None, listed_manifests=None, config_blob=None, blobs=None, annotations=None, labels=None, is_bootable=False, is_flatpak=False, local_vars_configuration=None):  # noqa: E501
        """ContainerManifestResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._pulp_href = None
        self._prn = None
        self._pulp_created = None
        self._pulp_last_updated = None
        self._digest = None
        self._schema_version = None
        self._media_type = None
        self._listed_manifests = None
        self._config_blob = None
        self._blobs = None
        self._annotations = None
        self._labels = None
        self._is_bootable = None
        self._is_flatpak = None
        self.discriminator = None

        if pulp_href is not None:
            self.pulp_href = pulp_href
        if prn is not None:
            self.prn = prn
        if pulp_created is not None:
            self.pulp_created = pulp_created
        if pulp_last_updated is not None:
            self.pulp_last_updated = pulp_last_updated
        self.digest = digest
        self.schema_version = schema_version
        self.media_type = media_type
        self.listed_manifests = listed_manifests
        if config_blob is not None:
            self.config_blob = config_blob
        self.blobs = blobs
        if annotations is not None:
            self.annotations = annotations
        if labels is not None:
            self.labels = labels
        if is_bootable is not None:
            self.is_bootable = is_bootable
        if is_flatpak is not None:
            self.is_flatpak = is_flatpak

    @property
    def pulp_href(self):
        """Gets the pulp_href of this ContainerManifestResponse.  # noqa: E501


        :return: The pulp_href of this ContainerManifestResponse.  # noqa: E501
        :rtype: str
        """
        return self._pulp_href

    @pulp_href.setter
    def pulp_href(self, pulp_href):
        """Sets the pulp_href of this ContainerManifestResponse.


        :param pulp_href: The pulp_href of this ContainerManifestResponse.  # noqa: E501
        :type: str
        """

        self._pulp_href = pulp_href

    @property
    def prn(self):
        """Gets the prn of this ContainerManifestResponse.  # noqa: E501

        The Pulp Resource Name (PRN).  # noqa: E501

        :return: The prn of this ContainerManifestResponse.  # noqa: E501
        :rtype: str
        """
        return self._prn

    @prn.setter
    def prn(self, prn):
        """Sets the prn of this ContainerManifestResponse.

        The Pulp Resource Name (PRN).  # noqa: E501

        :param prn: The prn of this ContainerManifestResponse.  # noqa: E501
        :type: str
        """

        self._prn = prn

    @property
    def pulp_created(self):
        """Gets the pulp_created of this ContainerManifestResponse.  # noqa: E501

        Timestamp of creation.  # noqa: E501

        :return: The pulp_created of this ContainerManifestResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._pulp_created

    @pulp_created.setter
    def pulp_created(self, pulp_created):
        """Sets the pulp_created of this ContainerManifestResponse.

        Timestamp of creation.  # noqa: E501

        :param pulp_created: The pulp_created of this ContainerManifestResponse.  # noqa: E501
        :type: datetime
        """

        self._pulp_created = pulp_created

    @property
    def pulp_last_updated(self):
        """Gets the pulp_last_updated of this ContainerManifestResponse.  # noqa: E501

        Timestamp of the last time this resource was updated. Note: for immutable resources - like content, repository versions, and publication - pulp_created and pulp_last_updated dates will be the same.  # noqa: E501

        :return: The pulp_last_updated of this ContainerManifestResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._pulp_last_updated

    @pulp_last_updated.setter
    def pulp_last_updated(self, pulp_last_updated):
        """Sets the pulp_last_updated of this ContainerManifestResponse.

        Timestamp of the last time this resource was updated. Note: for immutable resources - like content, repository versions, and publication - pulp_created and pulp_last_updated dates will be the same.  # noqa: E501

        :param pulp_last_updated: The pulp_last_updated of this ContainerManifestResponse.  # noqa: E501
        :type: datetime
        """

        self._pulp_last_updated = pulp_last_updated

    @property
    def digest(self):
        """Gets the digest of this ContainerManifestResponse.  # noqa: E501

        sha256 of the Manifest file  # noqa: E501

        :return: The digest of this ContainerManifestResponse.  # noqa: E501
        :rtype: str
        """
        return self._digest

    @digest.setter
    def digest(self, digest):
        """Sets the digest of this ContainerManifestResponse.

        sha256 of the Manifest file  # noqa: E501

        :param digest: The digest of this ContainerManifestResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and digest is None:  # noqa: E501
            raise ValueError("Invalid value for `digest`, must not be `None`")  # noqa: E501

        self._digest = digest

    @property
    def schema_version(self):
        """Gets the schema_version of this ContainerManifestResponse.  # noqa: E501

        Manifest schema version  # noqa: E501

        :return: The schema_version of this ContainerManifestResponse.  # noqa: E501
        :rtype: int
        """
        return self._schema_version

    @schema_version.setter
    def schema_version(self, schema_version):
        """Sets the schema_version of this ContainerManifestResponse.

        Manifest schema version  # noqa: E501

        :param schema_version: The schema_version of this ContainerManifestResponse.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and schema_version is None:  # noqa: E501
            raise ValueError("Invalid value for `schema_version`, must not be `None`")  # noqa: E501

        self._schema_version = schema_version

    @property
    def media_type(self):
        """Gets the media_type of this ContainerManifestResponse.  # noqa: E501

        Manifest media type of the file  # noqa: E501

        :return: The media_type of this ContainerManifestResponse.  # noqa: E501
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type):
        """Sets the media_type of this ContainerManifestResponse.

        Manifest media type of the file  # noqa: E501

        :param media_type: The media_type of this ContainerManifestResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and media_type is None:  # noqa: E501
            raise ValueError("Invalid value for `media_type`, must not be `None`")  # noqa: E501

        self._media_type = media_type

    @property
    def listed_manifests(self):
        """Gets the listed_manifests of this ContainerManifestResponse.  # noqa: E501

        Manifests that are referenced by this Manifest List  # noqa: E501

        :return: The listed_manifests of this ContainerManifestResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._listed_manifests

    @listed_manifests.setter
    def listed_manifests(self, listed_manifests):
        """Sets the listed_manifests of this ContainerManifestResponse.

        Manifests that are referenced by this Manifest List  # noqa: E501

        :param listed_manifests: The listed_manifests of this ContainerManifestResponse.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and listed_manifests is None:  # noqa: E501
            raise ValueError("Invalid value for `listed_manifests`, must not be `None`")  # noqa: E501

        self._listed_manifests = listed_manifests

    @property
    def config_blob(self):
        """Gets the config_blob of this ContainerManifestResponse.  # noqa: E501

        Blob that contains configuration for this Manifest  # noqa: E501

        :return: The config_blob of this ContainerManifestResponse.  # noqa: E501
        :rtype: str
        """
        return self._config_blob

    @config_blob.setter
    def config_blob(self, config_blob):
        """Sets the config_blob of this ContainerManifestResponse.

        Blob that contains configuration for this Manifest  # noqa: E501

        :param config_blob: The config_blob of this ContainerManifestResponse.  # noqa: E501
        :type: str
        """

        self._config_blob = config_blob

    @property
    def blobs(self):
        """Gets the blobs of this ContainerManifestResponse.  # noqa: E501

        Blobs that are referenced by this Manifest  # noqa: E501

        :return: The blobs of this ContainerManifestResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._blobs

    @blobs.setter
    def blobs(self, blobs):
        """Sets the blobs of this ContainerManifestResponse.

        Blobs that are referenced by this Manifest  # noqa: E501

        :param blobs: The blobs of this ContainerManifestResponse.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and blobs is None:  # noqa: E501
            raise ValueError("Invalid value for `blobs`, must not be `None`")  # noqa: E501

        self._blobs = blobs

    @property
    def annotations(self):
        """Gets the annotations of this ContainerManifestResponse.  # noqa: E501

        Property that contains arbitrary metadata stored inside the image manifest.  # noqa: E501

        :return: The annotations of this ContainerManifestResponse.  # noqa: E501
        :rtype: object
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this ContainerManifestResponse.

        Property that contains arbitrary metadata stored inside the image manifest.  # noqa: E501

        :param annotations: The annotations of this ContainerManifestResponse.  # noqa: E501
        :type: object
        """

        self._annotations = annotations

    @property
    def labels(self):
        """Gets the labels of this ContainerManifestResponse.  # noqa: E501

        Property describing metadata stored inside the image configuration  # noqa: E501

        :return: The labels of this ContainerManifestResponse.  # noqa: E501
        :rtype: object
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this ContainerManifestResponse.

        Property describing metadata stored inside the image configuration  # noqa: E501

        :param labels: The labels of this ContainerManifestResponse.  # noqa: E501
        :type: object
        """

        self._labels = labels

    @property
    def is_bootable(self):
        """Gets the is_bootable of this ContainerManifestResponse.  # noqa: E501

        A boolean determining whether users can boot from an image or not.  # noqa: E501

        :return: The is_bootable of this ContainerManifestResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_bootable

    @is_bootable.setter
    def is_bootable(self, is_bootable):
        """Sets the is_bootable of this ContainerManifestResponse.

        A boolean determining whether users can boot from an image or not.  # noqa: E501

        :param is_bootable: The is_bootable of this ContainerManifestResponse.  # noqa: E501
        :type: bool
        """

        self._is_bootable = is_bootable

    @property
    def is_flatpak(self):
        """Gets the is_flatpak of this ContainerManifestResponse.  # noqa: E501

        A boolean determining whether the image bundles a Flatpak application  # noqa: E501

        :return: The is_flatpak of this ContainerManifestResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_flatpak

    @is_flatpak.setter
    def is_flatpak(self, is_flatpak):
        """Sets the is_flatpak of this ContainerManifestResponse.

        A boolean determining whether the image bundles a Flatpak application  # noqa: E501

        :param is_flatpak: The is_flatpak of this ContainerManifestResponse.  # noqa: E501
        :type: bool
        """

        self._is_flatpak = is_flatpak

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContainerManifestResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContainerManifestResponse):
            return True

        return self.to_dict() != other.to_dict()
