# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_container.configuration import Configuration


class ContainerContainerPullThroughDistribution(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pulp_labels': 'dict(str, str)',
        'content_guard': 'str',
        'hidden': 'bool',
        'repository': 'str',
        'name': 'str',
        'base_path': 'str',
        'remote': 'str',
        'distributions': 'list[str]',
        'private': 'bool',
        'description': 'str'
    }

    attribute_map = {
        'pulp_labels': 'pulp_labels',
        'content_guard': 'content_guard',
        'hidden': 'hidden',
        'repository': 'repository',
        'name': 'name',
        'base_path': 'base_path',
        'remote': 'remote',
        'distributions': 'distributions',
        'private': 'private',
        'description': 'description'
    }

    def __init__(self, pulp_labels=None, content_guard=None, hidden=False, repository=None, name=None, base_path=None, remote=None, distributions=None, private=None, description=None, local_vars_configuration=None):  # noqa: E501
        """ContainerContainerPullThroughDistribution - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._pulp_labels = None
        self._content_guard = None
        self._hidden = None
        self._repository = None
        self._name = None
        self._base_path = None
        self._remote = None
        self._distributions = None
        self._private = None
        self._description = None
        self.discriminator = None

        if pulp_labels is not None:
            self.pulp_labels = pulp_labels
        if content_guard is not None:
            self.content_guard = content_guard
        if hidden is not None:
            self.hidden = hidden
        self.repository = repository
        self.name = name
        self.base_path = base_path
        self.remote = remote
        if distributions is not None:
            self.distributions = distributions
        if private is not None:
            self.private = private
        self.description = description

    @property
    def pulp_labels(self):
        """Gets the pulp_labels of this ContainerContainerPullThroughDistribution.  # noqa: E501


        :return: The pulp_labels of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._pulp_labels

    @pulp_labels.setter
    def pulp_labels(self, pulp_labels):
        """Sets the pulp_labels of this ContainerContainerPullThroughDistribution.


        :param pulp_labels: The pulp_labels of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :type: dict(str, str)
        """

        self._pulp_labels = pulp_labels

    @property
    def content_guard(self):
        """Gets the content_guard of this ContainerContainerPullThroughDistribution.  # noqa: E501

        An optional content-guard. If none is specified, a default one will be used.  # noqa: E501

        :return: The content_guard of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :rtype: str
        """
        return self._content_guard

    @content_guard.setter
    def content_guard(self, content_guard):
        """Sets the content_guard of this ContainerContainerPullThroughDistribution.

        An optional content-guard. If none is specified, a default one will be used.  # noqa: E501

        :param content_guard: The content_guard of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :type: str
        """

        self._content_guard = content_guard

    @property
    def hidden(self):
        """Gets the hidden of this ContainerContainerPullThroughDistribution.  # noqa: E501

        Whether this distribution should be shown in the content app.  # noqa: E501

        :return: The hidden of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :rtype: bool
        """
        return self._hidden

    @hidden.setter
    def hidden(self, hidden):
        """Sets the hidden of this ContainerContainerPullThroughDistribution.

        Whether this distribution should be shown in the content app.  # noqa: E501

        :param hidden: The hidden of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :type: bool
        """

        self._hidden = hidden

    @property
    def repository(self):
        """Gets the repository of this ContainerContainerPullThroughDistribution.  # noqa: E501

        The latest RepositoryVersion for this Repository will be served.  # noqa: E501

        :return: The repository of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :rtype: str
        """
        return self._repository

    @repository.setter
    def repository(self, repository):
        """Sets the repository of this ContainerContainerPullThroughDistribution.

        The latest RepositoryVersion for this Repository will be served.  # noqa: E501

        :param repository: The repository of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :type: str
        """

        self._repository = repository

    @property
    def name(self):
        """Gets the name of this ContainerContainerPullThroughDistribution.  # noqa: E501

        A unique name. Ex, `rawhide` and `stable`.  # noqa: E501

        :return: The name of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ContainerContainerPullThroughDistribution.

        A unique name. Ex, `rawhide` and `stable`.  # noqa: E501

        :param name: The name of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def base_path(self):
        """Gets the base_path of this ContainerContainerPullThroughDistribution.  # noqa: E501

        The base (relative) path component of the published url. Avoid paths that                     overlap with other distribution base paths (e.g. \"foo\" and \"foo/bar\")  # noqa: E501

        :return: The base_path of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :rtype: str
        """
        return self._base_path

    @base_path.setter
    def base_path(self, base_path):
        """Sets the base_path of this ContainerContainerPullThroughDistribution.

        The base (relative) path component of the published url. Avoid paths that                     overlap with other distribution base paths (e.g. \"foo\" and \"foo/bar\")  # noqa: E501

        :param base_path: The base_path of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and base_path is None:  # noqa: E501
            raise ValueError("Invalid value for `base_path`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                base_path is not None and len(base_path) < 1):
            raise ValueError("Invalid value for `base_path`, length must be greater than or equal to `1`")  # noqa: E501

        self._base_path = base_path

    @property
    def remote(self):
        """Gets the remote of this ContainerContainerPullThroughDistribution.  # noqa: E501

        Remote that can be used to fetch content when using pull-through caching.  # noqa: E501

        :return: The remote of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :rtype: str
        """
        return self._remote

    @remote.setter
    def remote(self, remote):
        """Sets the remote of this ContainerContainerPullThroughDistribution.

        Remote that can be used to fetch content when using pull-through caching.  # noqa: E501

        :param remote: The remote of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and remote is None:  # noqa: E501
            raise ValueError("Invalid value for `remote`, must not be `None`")  # noqa: E501

        self._remote = remote

    @property
    def distributions(self):
        """Gets the distributions of this ContainerContainerPullThroughDistribution.  # noqa: E501

        Distributions created after pulling content through cache  # noqa: E501

        :return: The distributions of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :rtype: list[str]
        """
        return self._distributions

    @distributions.setter
    def distributions(self, distributions):
        """Sets the distributions of this ContainerContainerPullThroughDistribution.

        Distributions created after pulling content through cache  # noqa: E501

        :param distributions: The distributions of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :type: list[str]
        """

        self._distributions = distributions

    @property
    def private(self):
        """Gets the private of this ContainerContainerPullThroughDistribution.  # noqa: E501

        Restrict pull access to explicitly authorized users. Related distributions inherit this value. Defaults to unrestricted pull access.  # noqa: E501

        :return: The private of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :rtype: bool
        """
        return self._private

    @private.setter
    def private(self, private):
        """Sets the private of this ContainerContainerPullThroughDistribution.

        Restrict pull access to explicitly authorized users. Related distributions inherit this value. Defaults to unrestricted pull access.  # noqa: E501

        :param private: The private of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :type: bool
        """

        self._private = private

    @property
    def description(self):
        """Gets the description of this ContainerContainerPullThroughDistribution.  # noqa: E501

        An optional description.  # noqa: E501

        :return: The description of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ContainerContainerPullThroughDistribution.

        An optional description.  # noqa: E501

        :param description: The description of this ContainerContainerPullThroughDistribution.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) < 1):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `1`")  # noqa: E501

        self._description = description

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContainerContainerPullThroughDistribution):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContainerContainerPullThroughDistribution):
            return True

        return self.to_dict() != other.to_dict()
