from typing import Any, Dict, Tuple
from vtelem.classes.byte_buffer import crc as crc
from vtelem.classes.type_primitive import TypePrimitive as TypePrimitive
from vtelem.frame import Frame as Frame
from vtelem.frame.fields import MESSAGE_FIELDS as MESSAGE_FIELDS

HEADER_SIZE: int

class MessageFrame(Frame):
    initialized: bool
    def initialize(self, field_data: Dict[str, TypePrimitive], fragment: bytes) -> None: ...
    def initialize_str(self, field_data: Dict[str, TypePrimitive], fragment: str) -> None: ...
    @property
    def frame_overhead(self) -> int: ...
    def frame_size(self, message: bytes) -> int: ...
    def frame_size_str(self, message: str) -> int: ...
    @staticmethod
    def messag_crc(message: bytes) -> int: ...
    @staticmethod
    def messag_crc_str(message: str) -> int: ...
    @staticmethod
    def create_fields(values: Dict[str, Any] = ...) -> Dict[str, TypePrimitive]: ...

def frames_required(prototype: MessageFrame, message_len: int) -> Tuple[int, int]: ...
