import logging
from cerberus import Validator as Validator
from json import JSONDecoder, JSONEncoder
from typing import Any, List, NamedTuple, Optional, TextIO, Type
from vtelem.names import class_to_snake as class_to_snake
from vtelem.schema.manager import SchemaManager as SchemaManager
from vtelem.types.serializable import ObjectData as ObjectData, ObjectKey as ObjectKey, ObjectMap as ObjectMap

LOG: Any
DEFAULT_INDENT: int

class SerializableEncoder(JSONEncoder):
    def default(self, o) -> dict: ...

class SerializableParams(NamedTuple):
    encoder: Type[JSONEncoder]
    decoder: Type[JSONDecoder]
    schema: Optional[Validator]

class Serializable:
    data: Any
    params: Any
    manager: Any
    log: Any
    valid: Any
    def __init__(self, data: ObjectData = ..., params: SerializableParams = ..., log: logging.Logger = ..., manager: SchemaManager = ...) -> None: ...
    @staticmethod
    def int_keys(data: ObjectMap) -> ObjectMap: ...
    @classmethod
    def schema(cls, manager: SchemaManager) -> Validator: ...
    def validate(self, log: bool = ..., manager: SchemaManager = ...) -> bool: ...
    def __eq__(self, other) -> bool: ...
    def init(self, data: ObjectData) -> None: ...
    def json(self, stream: TextIO, indent: int = ..., **dump_kwargs) -> None: ...
    def json_str(self, indent: int = ..., **dump_kwargs) -> str: ...
    def load(self, stream: TextIO, **load_kwargs) -> Serializable: ...
    def load_str(self, data: str, **load_kwargs) -> Serializable: ...
    def coerce_int_keys(self, paths: List[ObjectKey], data: ObjectData = ...) -> None: ...
    @property
    def name(self) -> str: ...
    def __hash__(self) -> int: ...

def max_key(data: ObjectMap) -> int: ...
