<h3 align="center">Evolution of Algebraic Terms</h3>

<p>
EAT is software implementation of the algorithms described in the paper Evolution of Algebraic Terms (EAT) 4: Biological Beam Algorithms. Given an arbitrary performance specification, the program systematically designs a digital ciruit using binary logic on groupoids of size 3 or larger. The program's success is documented by its ability to consistently find such designs from an incredibly vast search space in fractions of
a second. It has applications in both the fields of Mathematics and Computer Engineering.
</p>

<h4>Installation</h4>

For a normal install run
```
pip install evolution-of-algebraic-terms
```

For a development install first download the project and then run
```
pip3 install -e .
```
in the root project directory, or run
```
python3 setup.py develop
```

<h4>Wiki</h4>

A detailed description of this applicaiton may be found in the [EAT Wiki](https://github.com/nick-falco/eat/wiki).

<h4>References</h4>

[1] David M. Clark, Evolution of algebraic terms 1: Term to term operation continuity,<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;International Journal of Algebra and Computation, Vol. 23, No. 5 (2013) 1175–1205.<br/>
[2] David M. Clark, Maarten Keijzer, Lee Spector, Evolution of algebraic terms 2: Deep drilling algorithm,<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;International Journal of Algebra and Computation, Vol. 26, No. 6 (2016) 1141–1176.<br/>
[3] David M. Clark, Lee Spector, Evolution of algebraic terms 3: evolutionary algorithms,<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;International Journal of Algebra and Computation, Vol. 28, No. 5 (2018).<br/>

