# Generated by Django 2.0.9 on 2018-11-16 17:36

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_countries.fields
import django_extensions.db.fields
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Carrier',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='carrier name')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='name')),
            ],
            options={
                'db_table': 'pyfb_direction_carrier',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('country_iso2', django_countries.fields.CountryField(max_length=2, unique=True, verbose_name='country')),
            ],
            options={
                'db_table': 'pyfb_direction_country',
                'ordering': ('country_iso2',),
            },
        ),
        migrations.CreateModel(
            name='Destination',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='name of destination')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='name')),
                ('carrier', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='pyfb_direction.Carrier', verbose_name='carrier')),
                ('country_iso2', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='pyfb_direction.Country', to_field='country_iso2', verbose_name='country')),
            ],
            options={
                'db_table': 'pyfb_direction_destination',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Prefix',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('prefix', models.CharField(help_text='International public telecommunication prefix (maximum 15 digits)', max_length=15, unique=True, verbose_name='prefix')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='prefix')),
                ('destination', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='pyfb_direction.Destination', verbose_name='destination')),
            ],
            options={
                'db_table': 'pyfb_direction_prefix',
                'ordering': ('prefix',),
            },
        ),
        migrations.CreateModel(
            name='Region',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='region name')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='name')),
            ],
            options={
                'db_table': 'pyfb_direction_region',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='type of destination')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='name')),
            ],
            options={
                'db_table': 'pyfb_direction_type',
                'ordering': ('name',),
            },
        ),
        migrations.AddField(
            model_name='destination',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='pyfb_direction.Type', verbose_name='Type of destination'),
        ),
        migrations.AddField(
            model_name='country',
            name='region',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='pyfb_direction.Region', verbose_name='region'),
        ),
    ]
