/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Predicate;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.commands.XSiteStateTransferFinishSendCommand;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStateProviderState;
import org.infinispan.xsite.statetransfer.XSiteStatePushTask;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class XSiteStateProviderImpl
implements XSiteStateProvider {
    private static final Log log = LogFactory.getLog(XSiteStateProviderImpl.class);
    private static final Predicate<InternalCacheEntry<Object, Object>> NOT_L1_ENTRY = e -> !e.isL1Entry();
    @Inject
    InternalDataContainer<Object, Object> dataContainer;
    @Inject
    PersistenceManager persistenceManager;
    @Inject
    ClusteringDependentLogic clusteringDependentLogic;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    RpcManager rpcManager;
    @Inject
    ComponentRef<XSiteStateTransferManager> stateTransferManager;
    @Inject
    IracManager iracManager;
    @Inject
    StateTransferLock stateTransferLock;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    ExecutorService nonBlockingExecutor;
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    ScheduledExecutorService timeoutExecutor;
    private final ConcurrentMap<String, XSiteStateProviderState> sites = new ConcurrentHashMap<String, XSiteStateProviderState>();

    public XSiteStateProviderImpl(Configuration configuration) {
        for (BackupConfiguration backupConfiguration : configuration.sites().allBackups()) {
            this.sites.put(backupConfiguration.site(), XSiteStateProviderState.fromBackupConfiguration(backupConfiguration));
        }
    }

    @Start
    public void start() {
        this.sites.remove(this.rpcManager.getTransport().localSiteName());
    }

    @Override
    public void startStateTransfer(String siteName, Address origin, int minTopologyId) {
        XSiteStateProviderState state = (XSiteStateProviderState)this.sites.get(siteName);
        assert (state != null);
        XSiteStatePushTask task = state.createPushTask(origin, this);
        if (task == null) {
            if (log.isDebugEnabled()) {
                log.debugf("Do not start state transfer to site '%s'. It has already started!", (Object)siteName);
            }
            this.checkCoordinatorAlive(siteName, origin);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Starting state transfer to site '%s'", (Object)siteName);
        }
        IntSet segments = this.localPrimarySegments();
        Flowable<XSiteState> flowable = Flowable.concat(this.publishDataContainerEntries(segments), this.publishStoreEntries(segments, state.isSync()));
        task.execute(flowable, this.stateTransferLock.topologyFuture(minTopologyId));
        this.checkCoordinatorAlive(siteName, origin);
    }

    @Override
    public void cancelStateTransfer(String siteName) {
        XSiteStateProviderState state = (XSiteStateProviderState)this.sites.get(siteName);
        assert (state != null);
        state.cancelTransfer();
    }

    @Override
    public Collection<String> getCurrentStateSending() {
        return this.sites.entrySet().stream().filter(e -> ((XSiteStateProviderState)e.getValue()).isSending()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getSitesMissingCoordinator(Collection<Address> currentMembers) {
        return this.sites.entrySet().stream().filter(e -> ((XSiteStateProviderState)e.getValue()).isOriginatorMissing(currentMembers)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public void notifyStateTransferEnd(String siteName, Address origin, boolean statusOk) {
        if (log.isDebugEnabled()) {
            log.debugf("Finished state transfer to site '%s'. Ok? %s", (Object)siteName, (Object)statusOk);
        }
        if (this.rpcManager.getAddress().equals(origin)) {
            this.stateTransferManager.running().notifyStatePushFinished(siteName, origin, statusOk);
        } else {
            XSiteStateTransferFinishSendCommand command = this.commandsFactory.buildXSiteStateTransferFinishSendCommand(siteName, statusOk);
            this.rpcManager.sendTo(origin, command, DeliverOrder.NONE);
        }
    }

    @Override
    public CommandsFactory getCommandsFactory() {
        return this.commandsFactory;
    }

    @Override
    public RpcManager getRpcManager() {
        return this.rpcManager;
    }

    @Override
    public IracManager getIracManager() {
        return this.iracManager;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.timeoutExecutor;
    }

    @Override
    public Executor getExecutor() {
        return this.nonBlockingExecutor;
    }

    private void checkCoordinatorAlive(String siteName, Address origin) {
        if (this.rpcManager.getAddress().equals(this.rpcManager.getMembers().get(0)) && !this.rpcManager.getMembers().contains(origin)) {
            this.stateTransferManager.running().becomeCoordinator(siteName);
        }
    }

    private IntSet localPrimarySegments() {
        return IntSets.from(this.clusteringDependentLogic.getCacheTopology().getWriteConsistentHash().getPrimarySegmentsForOwner(this.rpcManager.getAddress()));
    }

    private Flowable<XSiteState> publishDataContainerEntries(IntSet segments) {
        return Flowable.fromIterable(() -> this.dataContainer.iterator(segments)).filter(NOT_L1_ENTRY).map(XSiteState::fromDataContainer);
    }

    private Flowable<XSiteState> publishStoreEntries(IntSet segments, boolean syncBackup) {
        Publisher loaderPublisher = this.persistenceManager.publishEntries(segments, this::missingInDataContainer, syncBackup, syncBackup, Configurations::isStateTransferStore);
        return Flowable.fromPublisher(loaderPublisher).map(XSiteState::fromCacheLoader);
    }

    private boolean missingInDataContainer(Object key) {
        return this.dataContainer.peek(key) == null;
    }
}

