/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class CountDownRunnable {
    private static final AtomicIntegerFieldUpdater<CountDownRunnable> PENDING_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CountDownRunnable.class, "pending");
    private static final int COMPLETED = -1;
    private static final int READY = 0;
    private final Runnable runnable;
    private volatile int pending = 0;
    private volatile boolean frozen;

    public CountDownRunnable(Runnable runnable2) {
        this.runnable = Objects.requireNonNull(runnable2);
    }

    public void increment() {
        if (this.frozen) {
            throw new IllegalStateException();
        }
        PENDING_UPDATER.incrementAndGet(this);
    }

    public void decrement() {
        if (PENDING_UPDATER.decrementAndGet(this) == 0 && this.frozen) {
            this.tryComplete();
        }
    }

    public int missing() {
        return this.pending;
    }

    public void freeze() {
        this.frozen = true;
        this.tryComplete();
    }

    private void tryComplete() {
        if (PENDING_UPDATER.compareAndSet(this, 0, -1)) {
            this.runnable.run();
        }
    }
}

