/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class RebalanceConfirmationCollector {
    private static final Log log = LogFactory.getLog(RebalanceConfirmationCollector.class);
    private final String cacheName;
    private final int topologyId;
    private final Set<Address> confirmationsNeeded;
    private final Runnable whenCompleted;

    public RebalanceConfirmationCollector(String cacheName, int topologyId, Collection<Address> members, Runnable whenCompleted) {
        this.cacheName = cacheName;
        this.topologyId = topologyId;
        this.confirmationsNeeded = new HashSet<Address>(members);
        this.whenCompleted = whenCompleted;
        log.tracef("Initialized topology confirmation collector %d@%s, initial list is %s", topologyId, (Object)cacheName, (Object)this.confirmationsNeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmPhase(Address node, int receivedTopologyId) {
        RebalanceConfirmationCollector rebalanceConfirmationCollector = this;
        synchronized (rebalanceConfirmationCollector) {
            boolean removed;
            if (this.topologyId > receivedTopologyId) {
                log.tracef("Ignoring rebalance confirmation with old topology from %s for cache %s, expecting topology id %d but got %d", node, this.cacheName, this.topologyId, receivedTopologyId);
            }
            if (!(removed = this.confirmationsNeeded.remove(node))) {
                log.tracef("Rebalance confirmation collector %d@%s ignored confirmation for %s, which is already confirmed", this.topologyId, (Object)this.cacheName, (Object)node);
                return;
            }
            log.tracef("Rebalance confirmation collector %d@%s received confirmation for %s, remaining list is %s", this.topologyId, this.cacheName, node, this.confirmationsNeeded);
            if (this.confirmationsNeeded.isEmpty()) {
                this.whenCompleted.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMembers(Collection<Address> newMembers) {
        RebalanceConfirmationCollector rebalanceConfirmationCollector = this;
        synchronized (rebalanceConfirmationCollector) {
            boolean modified = this.confirmationsNeeded.retainAll(newMembers);
            log.tracef("Rebalance confirmation collector %d@%s members list updated, remaining list is %s", this.topologyId, (Object)this.cacheName, (Object)this.confirmationsNeeded);
            if (modified && this.confirmationsNeeded.isEmpty()) {
                this.whenCompleted.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        RebalanceConfirmationCollector rebalanceConfirmationCollector = this;
        synchronized (rebalanceConfirmationCollector) {
            return "RebalanceConfirmationCollector{cacheName=" + this.cacheName + ", topologyId=" + this.topologyId + ", confirmationsNeeded=" + this.confirmationsNeeded + '}';
        }
    }
}

