/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.security.AccessControlException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.AuditResponse;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.Security;
import org.infinispan.security.impl.CacheSubjectPair;
import org.infinispan.security.impl.SubjectACL;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class Authorizer {
    private static final Log log = LogFactory.getLog(Authorizer.class);
    public static final SubjectACL SUPERUSER = new SubjectACL(Collections.emptySet(), AuthorizationPermission.ALL.getMask());
    private final GlobalSecurityConfiguration globalConfiguration;
    private final AuditLogger audit;
    private final AuditContext context;
    private final String name;
    private Map<CacheSubjectPair, SubjectACL> aclCache;

    public Authorizer(GlobalSecurityConfiguration globalConfiguration, AuditContext context, String name, Map<CacheSubjectPair, SubjectACL> aclCache) {
        this.globalConfiguration = globalConfiguration;
        this.audit = globalConfiguration.authorization().auditLogger();
        this.context = context;
        this.name = name;
        this.aclCache = aclCache;
    }

    public void setAclCache(Map<CacheSubjectPair, SubjectACL> aclCache) {
        this.aclCache = aclCache;
    }

    public void checkPermission(AuthorizationPermission perm) {
        this.checkPermission(null, null, this.name, this.context, null, perm);
    }

    public void checkPermission(AuthorizationPermission perm, String role) {
        this.checkPermission(null, null, this.name, this.context, role, perm);
    }

    public void checkPermission(AuthorizationConfiguration configuration, AuthorizationPermission perm) {
        this.checkPermission(configuration, null, this.name, this.context, null, perm);
    }

    public void checkPermission(Subject subject, AuthorizationPermission perm) {
        this.checkPermission(null, subject, this.name, this.context, null, perm);
    }

    public SubjectACL getACL(Subject subject) {
        return this.getACL(subject, null);
    }

    public SubjectACL getACL(Subject subject, AuthorizationConfiguration configuration) {
        if (this.globalConfiguration.authorization().enabled() && (configuration == null || configuration.enabled())) {
            return this.computeSubjectACL(subject, configuration);
        }
        return SUPERUSER;
    }

    public void checkPermission(AuthorizationConfiguration configuration, Subject subject, AuthorizationPermission perm, String role) {
        this.checkPermission(configuration, subject, null, this.context, role, perm);
    }

    public void checkPermission(Subject subject, AuthorizationPermission perm, AuditContext explicitContext) {
        this.checkPermission(null, subject, null, explicitContext, null, perm);
    }

    public void checkPermission(Subject subject, AuthorizationPermission perm, String contextName, AuditContext auditContext) {
        this.checkPermission(null, subject, contextName, auditContext, null, perm);
    }

    public void checkPermission(AuthorizationConfiguration configuration, Subject subject, String explicitName, AuditContext explicitContext, String role, AuthorizationPermission perm) {
        if (this.globalConfiguration.authorization().enabled()) {
            if (Security.isPrivileged()) {
                Security.checkPermission(perm.getSecurityPermission());
            } else {
                subject = subject != null ? subject : Security.getSubject();
                try {
                    if (subject != null) {
                        if (this.checkSubjectPermissionAndRole(subject, configuration, perm, role)) {
                            this.audit.audit(subject, explicitContext, explicitName, perm, AuditResponse.ALLOW);
                        } else {
                            this.checkSecurityManagerPermission(perm);
                        }
                    } else {
                        this.checkSecurityManagerPermission(perm);
                    }
                }
                catch (SecurityException e) {
                    this.audit.audit(subject, explicitContext, explicitName, perm, AuditResponse.DENY);
                    throw Log.SECURITY.unauthorizedAccess(Util.prettyPrintSubject(subject), perm.toString());
                }
            }
        }
    }

    private void checkSecurityManagerPermission(AuthorizationPermission perm) {
        if (System.getSecurityManager() == null) {
            throw new AccessControlException("", perm.getSecurityPermission());
        }
        System.getSecurityManager().checkPermission(perm.getSecurityPermission());
    }

    private boolean checkSubjectPermissionAndRole(Subject subject, AuthorizationConfiguration configuration, AuthorizationPermission requiredPermission, String requestedRole) {
        if (subject != null) {
            boolean authorized;
            CacheSubjectPair csp = new CacheSubjectPair(subject, this.name);
            SubjectACL subjectACL = this.aclCache != null ? this.aclCache.computeIfAbsent(csp, s2 -> this.computeSubjectACL(subject, configuration)) : this.computeSubjectACL(subject, configuration);
            int permissionMask = requiredPermission.getMask();
            boolean bl = authorized = subjectACL.matches(permissionMask) && (requestedRole == null || subjectACL.containsRole(requestedRole));
            if (log.isTraceEnabled()) {
                log.tracef("Check subject '%s' with ACL '%s' has permission '%s' and role '%s' = %b", new Object[]{subject, subjectACL, requiredPermission, requestedRole, authorized});
            }
            return authorized;
        }
        return false;
    }

    private SubjectACL computeSubjectACL(Subject subject, AuthorizationConfiguration configuration) {
        PrincipalRoleMapper roleMapper = this.globalConfiguration.authorization().principalRoleMapper();
        Set<Principal> principals = subject.getPrincipals();
        HashSet<String> allRoles = new HashSet<String>(principals.size());
        for (Principal principal : principals) {
            Set<String> roleNames = roleMapper.principalToRoles(principal);
            if (roleNames == null) continue;
            allRoles.addAll(roleNames);
        }
        int subjectMask = 0;
        Map<String, Role> globalRoles = this.globalConfiguration.authorization().roles();
        boolean implicit = configuration != null ? configuration.roles().isEmpty() : false;
        for (String role : allRoles) {
            Role globalRole;
            if (configuration != null && !implicit && !configuration.roles().contains(role) || (globalRole = globalRoles.get(role)) == null || implicit && !globalRole.isInheritable()) continue;
            subjectMask |= globalRole.getMask();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Subject '%s' has roles '%s' and permission mask %d", (Object)subject, (Object)allRoles, (Object)subjectMask);
        }
        return new SubjectACL(allRoles, subjectMask);
    }
}

