/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.inboundhandler.DefaultTopologyRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.inboundhandler.action.ReadyAction;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public abstract class BasePerCacheInboundInvocationHandler
implements PerCacheInboundInvocationHandler {
    private static final Log log = LogFactory.getLog(BasePerCacheInboundInvocationHandler.class);
    private static final int NO_TOPOLOGY_COMMAND = Integer.MIN_VALUE;
    @Inject
    @ComponentName(value="org.infinispan.executors.blocking")
    protected BlockingTaskAwareExecutorService blockingExecutor;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    protected BlockingTaskAwareExecutorService nonBlockingExecutor;
    @Inject
    StateTransferLock stateTransferLock;
    @Inject
    ResponseGenerator responseGenerator;
    @Inject
    ComponentRegistry componentRegistry;
    @Inject
    protected Configuration configuration;
    @Inject
    RpcManager rpcManager;
    private volatile boolean stopped = false;
    private volatile int firstTopologyAsMember = Integer.MAX_VALUE;

    private static int extractCommandTopologyId(SingleRpcCommand command) {
        ReplicableCommand innerCmd = command.getCommand();
        if (innerCmd instanceof TopologyAffectedCommand) {
            return ((TopologyAffectedCommand)innerCmd).getTopologyId();
        }
        return Integer.MIN_VALUE;
    }

    static int extractCommandTopologyId(CacheRpcCommand command) {
        switch (command.getCommandId()) {
            case 1: {
                return BasePerCacheInboundInvocationHandler.extractCommandTopologyId((SingleRpcCommand)command);
            }
            case 16: 
            case 46: {
                return Integer.MIN_VALUE;
            }
        }
        if (command instanceof TopologyAffectedCommand) {
            return ((TopologyAffectedCommand)((Object)command)).getTopologyId();
        }
        return Integer.MIN_VALUE;
    }

    @Start
    public void start() {
        this.stopped = false;
    }

    @Stop
    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    final CompletableFuture<Response> invokeCommand(CacheRpcCommand cmd) throws Throwable {
        CompletableFuture<?> future;
        if (log.isTraceEnabled()) {
            log.tracef("Calling perform() on %s", (Object)cmd);
        }
        if (CompletionStages.isCompletedSuccessfully(future = cmd.invokeAsync(this.componentRegistry).toCompletableFuture())) {
            Object obj = future.join();
            Response response = this.responseGenerator.getResponse(cmd, obj);
            if (response == null) {
                return CompletableFutures.completedNull();
            }
            return CompletableFuture.completedFuture(response);
        }
        return future.handle((rv, throwable) -> {
            CompletableFutures.rethrowExceptionIfPresent(throwable);
            return this.responseGenerator.getResponse(cmd, rv);
        });
    }

    final StateTransferLock getStateTransferLock() {
        return this.stateTransferLock;
    }

    final ExceptionResponse exceptionHandlingCommand(CacheRpcCommand command, Throwable throwable) {
        if (command.logThrowable(throwable)) {
            Log.CLUSTER.exceptionHandlingCommand(command, throwable);
        }
        if (throwable instanceof Exception) {
            return new ExceptionResponse((Exception)throwable);
        }
        return new ExceptionResponse(new CacheException("Problems invoking command.", throwable));
    }

    final ExceptionResponse outdatedTopology(OutdatedTopologyException exception) {
        log.tracef("Topology changed, retrying: %s", (Object)exception);
        return new ExceptionResponse(exception);
    }

    final Response interruptedException(CacheRpcCommand command) {
        Log.CLUSTER.debugf("Shutdown while handling command %s", (Object)command);
        return CacheNotFoundResponse.INSTANCE;
    }

    final void unexpectedDeliverMode(ReplicableCommand command, DeliverOrder deliverOrder) {
        throw new IllegalArgumentException(String.format("Unexpected deliver mode %s for command%s", new Object[]{deliverOrder, command}));
    }

    final void handleRunnable(BlockingRunnable runnable2, boolean onExecutorService) {
        if (onExecutorService) {
            this.blockingExecutor.execute(runnable2);
        } else {
            runnable2.run();
        }
    }

    public final boolean isCommandSentBeforeFirstTopology(int commandTopologyId) {
        if (0 <= commandTopologyId && commandTopologyId < this.firstTopologyAsMember) {
            if (log.isTraceEnabled()) {
                log.tracef("Ignoring command sent before the local node was a member (command topology id is %d, first topology as member is %d)", commandTopologyId, this.firstTopologyAsMember);
            }
            return true;
        }
        return false;
    }

    final BlockingRunnable createDefaultRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, boolean waitTransactionalData, boolean onExecutorService, boolean sync) {
        return new DefaultTopologyRunnable(this, command, reply, TopologyMode.create(onExecutorService, waitTransactionalData), commandTopologyId, sync);
    }

    final BlockingRunnable createDefaultRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, TopologyMode topologyMode, boolean sync) {
        return new DefaultTopologyRunnable(this, command, reply, topologyMode, commandTopologyId, sync);
    }

    final boolean executeOnExecutorService(DeliverOrder order, CacheRpcCommand command) {
        return !order.preserveOrder() && command.canBlock();
    }

    final BlockingRunnable createReadyActionRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, boolean sync, ReadyAction readyAction) {
        if (readyAction != null) {
            return this.createNonNullReadyActionRunnable(command, reply, commandTopologyId, sync, readyAction);
        }
        return new DefaultTopologyRunnable(this, command, reply, TopologyMode.READY_TX_DATA, commandTopologyId, sync);
    }

    private BlockingRunnable createNonNullReadyActionRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, boolean sync, final ReadyAction readyAction) {
        readyAction.addListener(this::checkForReadyTasks);
        return new DefaultTopologyRunnable(this, command, reply, TopologyMode.READY_TX_DATA, commandTopologyId, sync){

            @Override
            public boolean isReady() {
                return super.isReady() && readyAction.isReady();
            }

            @Override
            protected void onException(Throwable throwable) {
                super.onException(throwable);
                readyAction.onException();
            }

            @Override
            protected void onFinally() {
                super.onFinally();
                readyAction.onFinally();
            }
        };
    }

    @Override
    public void setFirstTopologyAsMember(int firstTopologyAsMember) {
        this.firstTopologyAsMember = firstTopologyAsMember;
    }

    @Override
    public int getFirstTopologyAsMember() {
        return this.firstTopologyAsMember;
    }

    @Override
    public void checkForReadyTasks() {
        this.blockingExecutor.checkForReadyTasks();
        this.nonBlockingExecutor.checkForReadyTasks();
    }
}

