/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.executors.ManageableExecutorService;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.concurrent.WithinThreadExecutor;

@Scope(value=Scopes.GLOBAL)
public final class LazyInitializingExecutorService
extends ManageableExecutorService<ExecutorService>
implements ExecutorService {
    private static final ExecutorService STOPPED = new WithinThreadExecutor();
    private final ThreadPoolExecutorFactory<ExecutorService> executorFactory;
    private final ThreadFactory threadFactory;

    public LazyInitializingExecutorService(ThreadPoolExecutorFactory<ExecutorService> executorFactory, ThreadFactory threadFactory2) {
        this.executorFactory = executorFactory;
        this.threadFactory = threadFactory2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() {
        if (this.executor == null) {
            LazyInitializingExecutorService lazyInitializingExecutorService = this;
            synchronized (lazyInitializingExecutorService) {
                if (this.executor == null) {
                    this.executor = this.executorFactory.createExecutor(this.threadFactory);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        LazyInitializingExecutorService lazyInitializingExecutorService = this;
        synchronized (lazyInitializingExecutorService) {
            if (this.executor == null) {
                this.executor = STOPPED;
            }
            this.executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Stop
    public List<Runnable> shutdownNow() {
        LazyInitializingExecutorService lazyInitializingExecutorService = this;
        synchronized (lazyInitializingExecutorService) {
            if (this.executor == null) {
                this.executor = STOPPED;
            }
            return this.executor.shutdownNow();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.executor == null || this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor == null || this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout2, TimeUnit unit) throws InterruptedException {
        if (this.executor == null) {
            return true;
        }
        return this.executor.awaitTermination(timeout2, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.initIfNeeded();
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.initIfNeeded();
        return this.executor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.initIfNeeded();
        return this.executor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.initIfNeeded();
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException {
        this.initIfNeeded();
        return this.executor.invokeAll(tasks, timeout2, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.initIfNeeded();
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.initIfNeeded();
        return this.executor.invokeAny(tasks, timeout2, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.initIfNeeded();
        this.executor.execute(command);
    }

    static {
        STOPPED.shutdown();
    }
}

