/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.executors.SecurityAwareScheduledExecutorFactory;

public class DefaultScheduledExecutorFactory
implements SecurityAwareScheduledExecutorFactory {
    static final AtomicInteger counter = new AtomicInteger(0);

    @Override
    public ScheduledExecutorService getScheduledExecutor(Properties p) {
        return this.getScheduledExecutor(p, null);
    }

    @Override
    public ScheduledExecutorService getScheduledExecutor(Properties p, AccessControlContext context) {
        TypedProperties tp = new TypedProperties((Map<?, ?>)p);
        final String threadNamePrefix = p.getProperty("threadNamePrefix", p.getProperty("componentName", "Thread"));
        final int threadPrio = tp.getIntProperty("threadPriority", 1);
        final AccessControlContext acc = context;
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            public Thread createThread(Runnable r) {
                Thread th = new Thread(r, "Scheduled-" + threadNamePrefix + "-" + counter.getAndIncrement());
                th.setDaemon(true);
                th.setPriority(threadPrio);
                return th;
            }

            @Override
            public Thread newThread(Runnable r) {
                final Runnable runnable2 = r;
                if (System.getSecurityManager() != null && acc != null) {
                    return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                        @Override
                        public Thread run() {
                            return this.createThread(runnable2);
                        }
                    }, acc);
                }
                return this.createThread(runnable2);
            }
        });
    }
}

