/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.interceptors.AsyncInterceptor;

public class InterceptorConfiguration
extends AbstractTypedPropertiesConfiguration {
    public static final AttributeDefinition<Position> POSITION = AttributeDefinition.builder(Attribute.POSITION, Position.OTHER_THAN_FIRST_OR_LAST).immutable().build();
    public static final AttributeDefinition<Class> AFTER = AttributeDefinition.builder(Attribute.AFTER, null, Class.class).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
    public static final AttributeDefinition<Class> BEFORE = AttributeDefinition.builder(Attribute.BEFORE, null, Class.class).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
    public static final AttributeDefinition<AsyncInterceptor> INTERCEPTOR = AttributeDefinition.builder(Element.INTERCEPTOR, null, AsyncInterceptor.class).copier(IdentityAttributeCopier.identityCopier()).immutable().build();
    public static final AttributeDefinition<Class> INTERCEPTOR_CLASS = AttributeDefinition.builder(Attribute.CLASS, null, Class.class).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
    public static final AttributeDefinition<Integer> INDEX = AttributeDefinition.builder(Attribute.INDEX, Integer.valueOf(-1)).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Position> position;
    private final org.infinispan.commons.configuration.attributes.Attribute<Class> after;
    private final org.infinispan.commons.configuration.attributes.Attribute<Class> before;
    private final org.infinispan.commons.configuration.attributes.Attribute<AsyncInterceptor> interceptor;
    private final org.infinispan.commons.configuration.attributes.Attribute<Class> interceptorClass;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> index;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(InterceptorConfiguration.class, AbstractTypedPropertiesConfiguration.attributeSet(), POSITION, AFTER, BEFORE, INTERCEPTOR, INTERCEPTOR_CLASS, INDEX);
    }

    InterceptorConfiguration(AttributeSet attributes) {
        super(attributes);
        this.position = attributes.attribute(POSITION);
        this.after = attributes.attribute(AFTER);
        this.before = attributes.attribute(BEFORE);
        this.interceptor = attributes.attribute(INTERCEPTOR);
        this.interceptorClass = attributes.attribute(INTERCEPTOR_CLASS);
        this.index = attributes.attribute(INDEX);
    }

    public Class<? extends AsyncInterceptor> after() {
        return this.after.get();
    }

    public Class<? extends AsyncInterceptor> before() {
        return this.before.get();
    }

    public AsyncInterceptor asyncInterceptor() {
        if (this.interceptor.isNull()) {
            return (AsyncInterceptor)Util.getInstance(this.interceptorClass.get());
        }
        return this.interceptor.get();
    }

    public Class<? extends AsyncInterceptor> sequentialInterceptorClass() {
        return this.interceptorClass.get();
    }

    public int index() {
        return this.index.get();
    }

    public Position position() {
        return this.position.get();
    }

    public boolean first() {
        return this.position() == Position.FIRST;
    }

    public boolean last() {
        return this.position() == Position.LAST;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public String toString() {
        return "InterceptorConfiguration [attributes=" + this.attributes + "]";
    }

    public static enum Position {
        FIRST,
        LAST,
        OTHER_THAN_FIRST_OR_LAST;

    }
}

