/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.GroupsConfiguration;
import org.infinispan.distribution.group.Grouper;

public class GroupsConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<GroupsConfiguration> {
    private final AttributeSet attributes = GroupsConfiguration.attributeDefinitionSet();

    protected GroupsConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public boolean isEnabled() {
        return this.attributes.attribute(GroupsConfiguration.ENABLED).get();
    }

    public GroupsConfigurationBuilder enabled() {
        this.attributes.attribute(GroupsConfiguration.ENABLED).set(true);
        return this;
    }

    public GroupsConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(GroupsConfiguration.ENABLED).set(enabled);
        return this;
    }

    public GroupsConfigurationBuilder disabled() {
        this.attributes.attribute(GroupsConfiguration.ENABLED).set(false);
        return this;
    }

    public GroupsConfigurationBuilder withGroupers(List<Grouper<?>> groupers) {
        this.attributes.attribute(GroupsConfiguration.GROUPERS).set(groupers);
        return this;
    }

    public GroupsConfigurationBuilder clearGroupers() {
        List<Grouper<?>> groupers = this.attributes.attribute(GroupsConfiguration.GROUPERS).get();
        groupers.clear();
        this.attributes.attribute(GroupsConfiguration.GROUPERS).set(groupers);
        return this;
    }

    public GroupsConfigurationBuilder addGrouper(Grouper<?> grouper) {
        List<Grouper<?>> groupers = this.attributes.attribute(GroupsConfiguration.GROUPERS).get();
        groupers.add(grouper);
        this.attributes.attribute(GroupsConfiguration.GROUPERS).set(groupers);
        return this;
    }

    @Override
    public GroupsConfiguration create() {
        return new GroupsConfiguration(this.attributes.protect());
    }

    public GroupsConfigurationBuilder read(GroupsConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "GroupsConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

