/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.ContentTypeConfigurationBuilder;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.util.logging.Log;

public class EncodingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<EncodingConfiguration> {
    private ContentTypeConfigurationBuilder keyContentTypeBuilder = new ContentTypeConfigurationBuilder(Element.KEY_DATA_TYPE, this);
    private ContentTypeConfigurationBuilder valueContentTypeBuilder = new ContentTypeConfigurationBuilder(Element.VALUE_DATA_TYPE, this);
    private final Attribute<String> mediaType;
    private final AttributeSet attributes = EncodingConfiguration.attributeDefinitionSet();

    EncodingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.mediaType = this.attributes.attribute(EncodingConfiguration.MEDIA_TYPE);
    }

    @Override
    public void validate() {
        String globalMediaType = this.mediaType.get();
        if (globalMediaType != null) {
            String keyType = this.keyContentTypeBuilder.mediaType();
            String valueType = this.valueContentTypeBuilder.mediaType();
            if (keyType != null && !keyType.equals(globalMediaType) || valueType != null && !valueType.equals(globalMediaType)) {
                Log.CONFIG.ignoringSpecificMediaTypes();
            }
            this.keyContentTypeBuilder.mediaType(globalMediaType);
            this.valueContentTypeBuilder.mediaType(globalMediaType);
        }
        this.keyContentTypeBuilder.validate();
        this.valueContentTypeBuilder.validate();
    }

    public boolean isObjectStorage() {
        return this.keyContentTypeBuilder.isObjectStorage() && this.valueContentTypeBuilder.isObjectStorage();
    }

    public ContentTypeConfigurationBuilder key() {
        return this.keyContentTypeBuilder;
    }

    public ContentTypeConfigurationBuilder value() {
        return this.valueContentTypeBuilder;
    }

    public EncodingConfigurationBuilder mediaType(String keyValueMediaType) {
        this.mediaType.set(keyValueMediaType);
        return this;
    }

    public boolean isStorageBinary() {
        String keyMediaType = this.keyContentTypeBuilder.mediaType();
        String valueMediaType = this.valueContentTypeBuilder.mediaType();
        return keyMediaType != null && valueMediaType != null && MediaType.fromString(keyMediaType).isBinary() && MediaType.fromString(valueMediaType).isBinary();
    }

    @Override
    public EncodingConfiguration create() {
        ContentTypeConfiguration keyContentType = this.keyContentTypeBuilder.create();
        ContentTypeConfiguration valueContentType = this.valueContentTypeBuilder.create();
        return new EncodingConfiguration(this.attributes.protect(), keyContentType, valueContentType);
    }

    @Override
    public Builder<?> read(EncodingConfiguration template) {
        this.attributes.read(template.attributes());
        this.keyContentTypeBuilder = new ContentTypeConfigurationBuilder(Element.KEY_DATA_TYPE, this).read(template.keyDataType());
        this.valueContentTypeBuilder = new ContentTypeConfigurationBuilder(Element.VALUE_DATA_TYPE, this).read(template.valueDataType());
        return this;
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public String toString() {
        return "EncodingConfigurationBuilder{keyContentTypeBuilder=" + this.keyContentTypeBuilder + ", valueContentTypeBuilder=" + this.valueContentTypeBuilder + ", attributes=" + this.attributes + '}';
    }
}

