/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class BackupConfiguration
extends ConfigurationElement<BackupConfiguration> {
    public static final AttributeDefinition<String> SITE = AttributeDefinition.builder(Attribute.SITE, null, String.class).autoPersist(false).immutable().build();
    public static final AttributeDefinition<BackupStrategy> STRATEGY = AttributeDefinition.builder(Attribute.STRATEGY, BackupStrategy.ASYNC).immutable().build();
    public static final AttributeDefinition<Long> REPLICATION_TIMEOUT = AttributeDefinition.builder(Attribute.TIMEOUT, Long.valueOf(15000L)).build();
    public static final AttributeDefinition<BackupFailurePolicy> FAILURE_POLICY = AttributeDefinition.builder(Attribute.BACKUP_FAILURE_POLICY, BackupFailurePolicy.WARN).build();
    public static final AttributeDefinition<String> FAILURE_POLICY_CLASS = AttributeDefinition.builder(Attribute.FAILURE_POLICY_CLASS, null, String.class).immutable().build();
    public static final AttributeDefinition<Boolean> USE_TWO_PHASE_COMMIT = AttributeDefinition.builder(Attribute.USE_TWO_PHASE_COMMIT, Boolean.valueOf(false)).immutable().build();
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder(Attribute.ENABLED, Boolean.valueOf(true)).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<String> site;
    private final org.infinispan.commons.configuration.attributes.Attribute<BackupStrategy> strategy;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> replicationTimeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<BackupFailurePolicy> backupFailurePolicy;
    private final org.infinispan.commons.configuration.attributes.Attribute<String> failurePolicyClass;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> useTwoPhaseCommit;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> enabled;
    private final AttributeSet attributes;
    private final TakeOfflineConfiguration takeOfflineConfiguration;
    private final XSiteStateTransferConfiguration xSiteStateTransferConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(BackupConfiguration.class, SITE, STRATEGY, REPLICATION_TIMEOUT, FAILURE_POLICY, FAILURE_POLICY_CLASS, USE_TWO_PHASE_COMMIT, ENABLED);
    }

    public BackupConfiguration(AttributeSet attributes, TakeOfflineConfiguration takeOfflineConfiguration, XSiteStateTransferConfiguration xSiteStateTransferConfiguration) {
        super(Element.BACKUP, attributes, takeOfflineConfiguration, xSiteStateTransferConfiguration);
        this.attributes = attributes.checkProtection();
        this.takeOfflineConfiguration = takeOfflineConfiguration;
        this.xSiteStateTransferConfiguration = xSiteStateTransferConfiguration;
        this.site = attributes.attribute(SITE);
        this.strategy = attributes.attribute(STRATEGY);
        this.replicationTimeout = attributes.attribute(REPLICATION_TIMEOUT);
        this.backupFailurePolicy = attributes.attribute(FAILURE_POLICY);
        this.failurePolicyClass = attributes.attribute(FAILURE_POLICY_CLASS);
        this.useTwoPhaseCommit = attributes.attribute(USE_TWO_PHASE_COMMIT);
        this.enabled = attributes.attribute(ENABLED);
    }

    public String site() {
        return this.site.get();
    }

    public BackupStrategy strategy() {
        return this.strategy.get();
    }

    public TakeOfflineConfiguration takeOffline() {
        return this.takeOfflineConfiguration;
    }

    public String failurePolicyClass() {
        return this.failurePolicyClass.get();
    }

    public boolean isAsyncBackup() {
        return this.strategy() == BackupStrategy.ASYNC;
    }

    public boolean isSyncBackup() {
        return this.strategy() == BackupStrategy.SYNC;
    }

    public long replicationTimeout() {
        return this.replicationTimeout.get();
    }

    public BackupConfiguration replicationTimeout(long timeout2) {
        this.replicationTimeout.set(timeout2);
        return this;
    }

    public BackupFailurePolicy backupFailurePolicy() {
        return this.backupFailurePolicy.get();
    }

    public boolean isTwoPhaseCommit() {
        return this.useTwoPhaseCommit.get();
    }

    public boolean enabled() {
        return this.enabled.get();
    }

    public XSiteStateTransferConfiguration stateTransfer() {
        return this.xSiteStateTransferConfiguration;
    }

    public static enum BackupStrategy {
        SYNC,
        ASYNC;

    }
}

