/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io;

public enum NamingStrategy {
    IDENTITY{

        @Override
        public String convert(String s2) {
            return s2;
        }
    }
    ,
    CAMEL_CASE{

        @Override
        public String convert(String s2) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < s2.length(); ++i) {
                char c = s2.charAt(i);
                if ((c == '-' || c == '_') && i < s2.length() - 1) {
                    b.append(Character.toUpperCase(s2.charAt(++i)));
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }
    }
    ,
    KEBAB_CASE{

        @Override
        public String convert(String s2) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < s2.length(); ++i) {
                char c = s2.charAt(i);
                if (i > 0 && 3.isWordBoundary(c, s2.charAt(i - 1))) {
                    b.append('-');
                    b.append(Character.toLowerCase(c));
                    continue;
                }
                if (c == '_') {
                    b.append('-');
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }
    }
    ,
    SNAKE_CASE{

        @Override
        public String convert(String s2) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < s2.length(); ++i) {
                char c = s2.charAt(i);
                if (i > 0 && 4.isWordBoundary(c, s2.charAt(i - 1))) {
                    b.append('_');
                    b.append(Character.toLowerCase(c));
                    continue;
                }
                if (c == '-') {
                    b.append('_');
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }
    };


    static boolean isWordBoundary(char ch1, char ch2) {
        return Character.isUpperCase(ch1) && (Character.isLowerCase(ch2) || Character.isDigit(ch2));
    }

    public abstract String convert(String var1);
}

