/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class RemoveCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final byte COMMAND_ID = 10;
    protected boolean successful = true;
    private boolean nonExistent = false;
    protected Metadata metadata;
    protected ValueMatcher valueMatcher;
    private PrivateMetadata internalMetadata;
    protected Object value;

    public RemoveCommand(Object key, Object value, int segment, long flagsBitSet, CommandInvocationId commandInvocationId) {
        super(key, segment, flagsBitSet, commandInvocationId);
        this.value = value;
        this.valueMatcher = value != null ? ValueMatcher.MATCH_EXPECTED : ValueMatcher.MATCH_ALWAYS;
    }

    public RemoveCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveCommand(ctx, this);
    }

    @Override
    public byte getCommandId() {
        return 10;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        RemoveCommand that = (RemoveCommand)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "RemoveCommand{key=" + Util.toStr(this.key) + ", value=" + Util.toStr(this.value) + ", metadata=" + this.metadata + ", internalMetadata=" + this.internalMetadata + ", flags=" + this.printFlags() + ", commandInvocationId=" + CommandInvocationId.show(this.commandInvocationId) + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", topologyId=" + this.getTopologyId() + "}";
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return this.value != null;
    }

    public void nonExistant() {
        this.nonExistent = false;
    }

    public boolean isNonExistent() {
        return this.nonExistent;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.value);
        UnsignedNumeric.writeUnsignedInt(output, this.segment);
        output.writeObject(this.metadata);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        MarshallUtil.marshallEnum(this.valueMatcher, output);
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.internalMetadata);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.value = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt(input);
        this.metadata = (Metadata)input.readObject();
        this.setFlagsBitSet(input.readLong());
        this.valueMatcher = MarshallUtil.unmarshallEnum(input, ValueMatcher::valueOf);
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.internalMetadata = (PrivateMetadata)input.readObject();
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return this.isConditional() || !this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES) ? VisitableCommand.LoadType.PRIMARY : VisitableCommand.LoadType.DONT_LOAD;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public final boolean isReturnValueExpected() {
        return this.isConditional() || super.isReturnValueExpected();
    }

    @Override
    public PrivateMetadata getInternalMetadata() {
        return this.internalMetadata;
    }

    @Override
    public void setInternalMetadata(PrivateMetadata internalMetadata) {
        this.internalMetadata = internalMetadata;
    }
}

