/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.statetransfer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.conflict.impl.StateReceiver;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateResponseCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    private static final Log log = LogFactory.getLog(StateResponseCommand.class);
    public static final byte COMMAND_ID = 20;
    private int topologyId;
    private Collection<StateChunk> stateChunks;
    private boolean applyState;
    private boolean pushTransfer;

    private StateResponseCommand() {
        super(null);
    }

    public StateResponseCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StateResponseCommand(ByteString cacheName, int topologyId, Collection<StateChunk> stateChunks, boolean applyState, boolean pushTransfer) {
        super(cacheName);
        this.topologyId = topologyId;
        this.stateChunks = stateChunks;
        this.applyState = applyState;
        this.pushTransfer = pushTransfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(this.cacheName, trace);
        try {
            if (this.applyState) {
                StateConsumer stateConsumer = componentRegistry.getStateTransferManager().getStateConsumer();
                CompletionStage<?> completionStage = stateConsumer.applyState(this.origin, this.topologyId, this.pushTransfer, this.stateChunks);
                return completionStage;
            }
            StateReceiver stateReceiver = componentRegistry.getConflictManager().running().getStateReceiver();
            stateReceiver.receiveState(this.origin, this.topologyId, this.stateChunks);
            CompletableFuture completableFuture = CompletableFutures.completedNull();
            return completableFuture;
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public byte getCommandId() {
        return 20;
    }

    public Collection<StateChunk> getStateChunks() {
        return this.stateChunks;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeBoolean(this.pushTransfer);
        MarshallUtil.marshallCollection(this.stateChunks, output);
        output.writeBoolean(this.applyState);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.pushTransfer = input.readBoolean();
        this.stateChunks = MarshallUtil.unmarshallCollection(input, ArrayList::new);
        this.applyState = input.readBoolean();
    }

    @Override
    public String toString() {
        return "StateResponseCommand{cache=" + this.cacheName + ", pushTransfer=" + this.pushTransfer + ", stateChunks=" + this.stateChunks + ", origin=" + this.origin + ", topologyId=" + this.topologyId + ", applyState=" + this.applyState + '}';
    }
}

