/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;

public class GetAllCommand
extends AbstractTopologyAffectedCommand {
    public static final byte COMMAND_ID = 44;
    private Collection<?> keys;
    private boolean returnEntries;

    public GetAllCommand(Collection<?> keys2, long flagsBitSet, boolean returnEntries) {
        this.keys = keys2;
        this.returnEntries = returnEntries;
        this.setFlagsBitSet(flagsBitSet);
    }

    GetAllCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetAllCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public byte getCommandId() {
        return 44;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, output);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeBoolean(this.returnEntries);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = MarshallUtil.unmarshallCollection(input, ArrayList::new);
        this.setFlagsBitSet(input.readLong());
        this.returnEntries = input.readBoolean();
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    public boolean isReturnEntries() {
        return this.returnEntries;
    }

    public Collection<?> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<?> keys2) {
        this.keys = keys2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GetAllCommand{");
        sb.append("keys=").append(Util.toStr(this.keys));
        sb.append(", returnEntries=").append(this.returnEntries);
        sb.append(", flags=").append(this.printFlags());
        sb.append('}');
        return sb.toString();
    }
}

