/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.validation;

public class ValidationOptions {
    private String language;
    private boolean useServer = true;
    private boolean useClient = true;
    private boolean guessSystem = false;
    private ValueSetMode valueSetMode = ValueSetMode.ALL_CHECKS;
    private boolean vsAsUrl;
    private boolean versionFlexible = true;

    public ValidationOptions() {
    }

    public ValidationOptions(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isUseServer() {
        return this.useServer;
    }

    public boolean isUseClient() {
        return this.useClient;
    }

    public boolean isGuessSystem() {
        return this.guessSystem;
    }

    private ValidationOptions copy() {
        ValidationOptions n = new ValidationOptions(this.language);
        n.useServer = this.useServer;
        n.useClient = this.useClient;
        n.guessSystem = this.guessSystem;
        n.vsAsUrl = this.vsAsUrl;
        n.versionFlexible = this.versionFlexible;
        return n;
    }

    public ValidationOptions setLanguage(String language) {
        ValidationOptions n = this.copy();
        n.language = language;
        return n;
    }

    public ValidationOptions noServer() {
        ValidationOptions n = this.copy();
        n.useServer = false;
        return n;
    }

    public ValidationOptions noClient() {
        ValidationOptions n = this.copy();
        n.useClient = false;
        return n;
    }

    public ValidationOptions guessSystem() {
        ValidationOptions n = this.copy();
        n.guessSystem = true;
        return n;
    }

    public String toJson() {
        return "\"lang\":\"" + this.language + "\", \"useServer\":\"" + Boolean.toString(this.useServer) + "\", \"useClient\":\"" + Boolean.toString(this.useClient) + "\", \"guessSystem\":\"" + Boolean.toString(this.guessSystem) + "\", \"valueSetMode\":\"" + this.valueSetMode.toString() + "\", \"versionFlexible\":\"" + Boolean.toString(this.versionFlexible) + "\"";
    }

    public static ValidationOptions defaults() {
        return new ValidationOptions("en-US");
    }

    public ValidationOptions checkValueSetOnly() {
        ValidationOptions n = this.copy();
        n.valueSetMode = ValueSetMode.CHECK_MEMERSHIP_ONLY;
        return n;
    }

    public ValidationOptions noCheckValueSetMembership() {
        ValidationOptions n = this.copy();
        n.valueSetMode = ValueSetMode.NO_MEMBERSHIP_CHECK;
        return n;
    }

    public ValueSetMode getValueSetMode() {
        return this.valueSetMode;
    }

    public ValidationOptions setVsAsUrl() {
        this.vsAsUrl = true;
        return this;
    }

    public boolean getVsAsUrl() {
        return this.vsAsUrl;
    }

    public boolean versionFlexible() {
        return this.versionFlexible;
    }

    public ValidationOptions setVersionFlexible(boolean value) {
        ValidationOptions n = this.copy();
        n.versionFlexible = value;
        return n;
    }

    public static enum ValueSetMode {
        ALL_CHECKS,
        CHECK_MEMERSHIP_ONLY,
        NO_MEMBERSHIP_CHECK;

    }
}

