/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.graphql;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.graphql.Argument;
import org.hl7.fhir.utilities.graphql.Directive;
import org.hl7.fhir.utilities.graphql.Document;
import org.hl7.fhir.utilities.graphql.EGraphEngine;
import org.hl7.fhir.utilities.graphql.EGraphQLException;
import org.hl7.fhir.utilities.graphql.Field;
import org.hl7.fhir.utilities.graphql.Fragment;
import org.hl7.fhir.utilities.graphql.FragmentSpread;
import org.hl7.fhir.utilities.graphql.NameValue;
import org.hl7.fhir.utilities.graphql.NumberValue;
import org.hl7.fhir.utilities.graphql.ObjectValue;
import org.hl7.fhir.utilities.graphql.Operation;
import org.hl7.fhir.utilities.graphql.Package;
import org.hl7.fhir.utilities.graphql.Selection;
import org.hl7.fhir.utilities.graphql.StringValue;
import org.hl7.fhir.utilities.graphql.Value;
import org.hl7.fhir.utilities.graphql.Variable;
import org.hl7.fhir.utilities.graphql.VariableValue;

public class Parser {
    private Reader reader;
    private StringBuilder token;
    private String peek;
    private LexType lexType;
    private SourceLocation location = new SourceLocation();
    boolean readerDone = false;

    public static Package parse(String source2) throws IOException, EGraphQLException, EGraphEngine {
        Parser self = new Parser();
        self.reader = new StringReader(source2);
        self.next();
        Document doc = self.parseDocument();
        return new Package(doc);
    }

    public static Package parse(InputStream source2) throws IOException, EGraphQLException, EGraphEngine {
        Parser self = new Parser();
        self.reader = new InputStreamReader(source2);
        self.next();
        Document doc = self.parseDocument();
        return new Package(doc);
    }

    public static Package parseFile(String filename) throws FileNotFoundException, IOException, EGraphQLException, EGraphEngine {
        String src = TextFile.fileToString(filename);
        return Parser.parse(src);
    }

    public static Package parseJson(InputStream source2) throws EGraphQLException, IOException, EGraphEngine {
        JsonObject json = (JsonObject)new JsonParser().parse(TextFile.streamToString(source2));
        Parser self = new Parser();
        self.reader = new StringReader(json.get("query").getAsString());
        self.next();
        Package result = new Package(self.parseDocument());
        result.setOperationName(json.get("operationName").getAsString());
        if (json.has("variables")) {
            JsonObject vl = json.getAsJsonObject("variables");
            for (Map.Entry n : vl.entrySet()) {
                result.getVariables().add(new Argument((String)n.getKey(), (JsonElement)n.getValue()));
            }
        }
        return result;
    }

    private char getNextChar() throws IOException {
        int c;
        char result = '\u0000';
        if (this.peek != null) {
            result = this.peek.charAt(0);
            this.peek = this.peek.length() == 1 ? null : this.peek.substring(1);
        } else if (this.reader.ready() && (c = this.reader.read()) > -1) {
            result = (char)c;
            if (result == '\n') {
                ++this.location.line;
                this.location.col = 1;
            } else {
                ++this.location.col;
            }
        }
        this.readerDone = result == '\u0000';
        return result;
    }

    private void pushChar(char ch) {
        if (ch != '\u0000') {
            this.peek = this.peek == null ? String.valueOf(ch) : String.valueOf(ch) + this.peek;
        }
    }

    private void skipIgnore() throws IOException {
        char ch = this.getNextChar();
        while (Character.isWhitespace(ch) || ch == ',') {
            ch = this.getNextChar();
        }
        if (ch == '#') {
            while (ch != '\r' && ch != '\n') {
                ch = this.getNextChar();
            }
            this.pushChar(ch);
            this.skipIgnore();
        } else {
            this.pushChar(ch);
        }
    }

    private void next() throws IOException, EGraphQLException {
        this.skipIgnore();
        this.token = new StringBuilder();
        if (this.readerDone && this.peek == null) {
            this.lexType = LexType.gqlltNull;
        } else {
            char ch = this.getNextChar();
            if (Utilities.existsInList(ch, 33, 36, 40, 41, 58, 61, 64, 91, 93, 123, 124, 125)) {
                this.lexType = LexType.gqlltPunctuation;
                this.token.append(ch);
            } else if (ch == '.') {
                do {
                    this.token.append(ch);
                } while ((ch = this.getNextChar()) == '.');
                this.pushChar(ch);
                if (this.token.length() != 3) {
                    throw new EGraphQLException("Found \"" + this.token.toString() + "\" expecting \"...\"");
                }
            } else if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_') {
                this.lexType = LexType.gqlltName;
                do {
                    this.token.append(ch);
                } while ((ch = this.getNextChar()) >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_');
                this.pushChar(ch);
            } else if (ch >= '0' && ch <= '9' || ch == '-') {
                this.lexType = LexType.gqlltNumber;
                do {
                    this.token.append(ch);
                } while ((ch = this.getNextChar()) >= '0' && ch <= '9' || ch == '.' && this.token.toString().indexOf(46) == -1 || ch == 'e' && this.token.toString().indexOf(101) == -1);
                this.pushChar(ch);
            } else if (ch == '\"') {
                this.lexType = LexType.gqlltString;
                do {
                    if ((ch = this.getNextChar()) == '\\') {
                        if (!this.reader.ready()) {
                            throw new EGraphQLException("premature termination of GraphQL during a string constant");
                        }
                        ch = this.getNextChar();
                        if (ch == '\"') {
                            this.token.append('\"');
                        } else if (ch == '\\') {
                            this.token.append('\'');
                        } else if (ch == '/') {
                            this.token.append('/');
                        } else if (ch == 'n') {
                            this.token.append('\n');
                        } else if (ch == 'r') {
                            this.token.append('\r');
                        } else if (ch == 't') {
                            this.token.append('\t');
                        } else if (ch == 'u') {
                            String hex = String.valueOf(this.getNextChar()) + this.getNextChar() + this.getNextChar() + this.getNextChar();
                            this.token.append((char)Integer.parseInt(hex, 16));
                        } else {
                            throw new EGraphQLException("Unexpected character: \"" + ch + "\"");
                        }
                        ch = '\u0000';
                        continue;
                    }
                    if (ch == '\"') continue;
                    this.token.append(ch);
                } while (!this.readerDone && ch != '\"');
                if (ch != '\"') {
                    throw new EGraphQLException("premature termination of GraphQL during a string constant");
                }
            } else {
                throw new EGraphQLException("Unexpected character \"" + ch + "\"");
            }
        }
    }

    private boolean hasPunctuation(String punc) {
        return this.lexType == LexType.gqlltPunctuation && this.token.toString().equals(punc);
    }

    private void consumePunctuation(String punc) throws EGraphQLException, IOException {
        if (this.lexType != LexType.gqlltPunctuation) {
            throw new EGraphQLException("Found \"" + this.token.toString() + "\" expecting \"" + punc + "\"");
        }
        if (!this.token.toString().equals(punc)) {
            throw new EGraphQLException("Found \"" + this.token.toString() + "\" expecting \"" + punc + "\"");
        }
        this.next();
    }

    private boolean hasName() {
        return this.lexType == LexType.gqlltName && this.token.toString().length() > 0;
    }

    private boolean hasName(String name) {
        return this.lexType == LexType.gqlltName && this.token.toString().equals(name);
    }

    private String consumeName() throws EGraphQLException, IOException {
        if (this.lexType != LexType.gqlltName) {
            throw new EGraphQLException("Found \"" + this.token.toString() + "\" expecting a name");
        }
        String result = this.token.toString();
        this.next();
        return result;
    }

    private void consumeName(String name) throws EGraphQLException, IOException {
        if (this.lexType != LexType.gqlltName) {
            throw new EGraphQLException("Found \"" + this.token.toString() + "\" expecting a name");
        }
        if (!this.token.toString().equals(name)) {
            throw new EGraphQLException("Found \"" + this.token.toString() + "\" expecting \"" + name + "\"");
        }
        this.next();
    }

    private Value parseValue() throws EGraphQLException, IOException {
        Value result = null;
        switch (this.lexType) {
            case gqlltNull: {
                throw new EGraphQLException("Attempt to read a value after reading off the } of the GraphQL statement");
            }
            case gqlltName: {
                result = new NameValue(this.token.toString());
                break;
            }
            case gqlltPunctuation: {
                if (this.hasPunctuation("$")) {
                    this.consumePunctuation("$");
                    result = new VariableValue(this.token.toString());
                    break;
                }
                if (this.hasPunctuation("{")) {
                    this.consumePunctuation("{");
                    ObjectValue obj = new ObjectValue();
                    while (!this.hasPunctuation("}")) {
                        obj.getFields().add(this.parseArgument());
                    }
                    result = obj;
                    break;
                }
                throw new EGraphQLException("Attempt to read a value at \"" + this.token.toString() + "\"");
            }
            case gqlltString: {
                result = new StringValue(this.token.toString());
                break;
            }
            case gqlltNumber: {
                result = new NumberValue(this.token.toString());
            }
        }
        this.next();
        return result;
    }

    private Argument parseArgument() throws EGraphQLException, IOException {
        Argument result = new Argument();
        result.setName(this.consumeName());
        this.consumePunctuation(":");
        if (this.hasPunctuation("[")) {
            result.setListStatus(Argument.ArgumentListStatus.REPEATING);
            this.consumePunctuation("[");
            while (!this.hasPunctuation("]")) {
                result.getValues().add(this.parseValue());
            }
            this.consumePunctuation("]");
        } else {
            result.getValues().add(this.parseValue());
        }
        return result;
    }

    private Directive parseDirective() throws EGraphQLException, IOException {
        Directive result = new Directive();
        this.consumePunctuation("@");
        result.setName(this.consumeName());
        if (this.hasPunctuation("(")) {
            this.consumePunctuation("(");
            do {
                result.getArguments().add(this.parseArgument());
            } while (!this.hasPunctuation(")"));
            this.consumePunctuation(")");
        }
        return result;
    }

    private Document parseDocument() throws EGraphQLException, IOException, EGraphEngine {
        Document doc = new Document();
        if (!this.hasName()) {
            Operation op = new Operation();
            this.parseOperationInner(op);
            doc.getOperations().add(op);
        } else {
            while (!this.readerDone || this.peek != null) {
                String s2 = this.consumeName();
                if (s2.equals("mutation") || s2.equals("query")) {
                    doc.getOperations().add(this.parseOperation(s2));
                    continue;
                }
                if (s2.equals("fragment")) {
                    doc.getFragments().add(this.parseFragment());
                    continue;
                }
                throw new EGraphEngine("Not done yet");
            }
        }
        return doc;
    }

    private Field parseField() throws EGraphQLException, IOException {
        Field result = new Field();
        result.setName(this.consumeName());
        result.setAlias(result.getName());
        if (this.hasPunctuation(":")) {
            this.consumePunctuation(":");
            result.setName(this.consumeName());
        }
        if (this.hasPunctuation("(")) {
            this.consumePunctuation("(");
            while (!this.hasPunctuation(")")) {
                result.getArguments().add(this.parseArgument());
            }
            this.consumePunctuation(")");
        }
        while (this.hasPunctuation("@")) {
            result.getDirectives().add(this.parseDirective());
        }
        if (this.hasPunctuation("{")) {
            this.consumePunctuation("{");
            do {
                result.getSelectionSet().add(this.parseSelection());
            } while (!this.hasPunctuation("}"));
            this.consumePunctuation("}");
        }
        return result;
    }

    private void parseFragmentInner(Fragment fragment) throws EGraphQLException, IOException {
        while (this.hasPunctuation("@")) {
            fragment.getDirectives().add(this.parseDirective());
        }
        this.consumePunctuation("{");
        do {
            fragment.getSelectionSet().add(this.parseSelection());
        } while (!this.hasPunctuation("}"));
        this.consumePunctuation("}");
    }

    private Fragment parseFragment() throws EGraphQLException, IOException {
        Fragment result = new Fragment();
        result.setName(this.consumeName());
        this.consumeName("on");
        result.setTypeCondition(this.consumeName());
        this.parseFragmentInner(result);
        return result;
    }

    private FragmentSpread parseFragmentSpread() throws EGraphQLException, IOException {
        FragmentSpread result = new FragmentSpread();
        result.setName(this.consumeName());
        while (this.hasPunctuation("@")) {
            result.getDirectives().add(this.parseDirective());
        }
        return result;
    }

    private Fragment parseInlineFragment() throws EGraphQLException, IOException {
        Fragment result = new Fragment();
        if (this.hasName("on")) {
            this.consumeName("on");
            result.setTypeCondition(this.consumeName());
        }
        this.parseFragmentInner(result);
        return result;
    }

    private Operation parseOperation(String name) throws EGraphQLException, IOException {
        Operation result = new Operation();
        if (name.equals("mutation")) {
            result.setOperationType(Operation.OperationType.qglotMutation);
            if (this.hasName()) {
                result.setName(this.consumeName());
            }
        } else if (name.equals("query")) {
            result.setOperationType(Operation.OperationType.qglotQuery);
            if (this.hasName()) {
                result.setName(this.consumeName());
            }
        } else {
            result.setName(name);
        }
        this.parseOperationInner(result);
        return result;
    }

    private void parseOperationInner(Operation op) throws EGraphQLException, IOException {
        if (this.hasPunctuation("(")) {
            this.consumePunctuation("(");
            do {
                op.getVariables().add(this.parseVariable());
            } while (!this.hasPunctuation(")"));
            this.consumePunctuation(")");
        }
        while (this.hasPunctuation("@")) {
            op.getDirectives().add(this.parseDirective());
        }
        if (this.hasPunctuation("{")) {
            this.consumePunctuation("{");
            do {
                op.getSelectionSet().add(this.parseSelection());
            } while (!this.hasPunctuation("}"));
            this.consumePunctuation("}");
        }
    }

    private Selection parseSelection() throws EGraphQLException, IOException {
        Selection result = new Selection();
        if (this.hasPunctuation("...")) {
            this.consumePunctuation("...");
            if (this.hasName() && !this.token.toString().equals("on")) {
                result.setFragmentSpread(this.parseFragmentSpread());
            } else {
                result.setInlineFragment(this.parseInlineFragment());
            }
        } else {
            result.setField(this.parseField());
        }
        return result;
    }

    private Variable parseVariable() throws EGraphQLException, IOException {
        Variable result = new Variable();
        this.consumePunctuation("$");
        result.setName(this.consumeName());
        this.consumePunctuation(":");
        result.setTypeName(this.consumeName());
        if (this.hasPunctuation("=")) {
            this.consumePunctuation("=");
            result.setDefaultValue(this.parseValue());
        }
        return result;
    }

    static class SourceLocation {
        int line;
        int col;

        SourceLocation() {
        }
    }

    static enum LexType {
        gqlltNull,
        gqlltName,
        gqlltPunctuation,
        gqlltString,
        gqlltNumber;

    }
}

