/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;

public class Turtle {
    public static final String GOOD_IRI_CHAR = "a-zA-Z0-9\u00a0-\ufffe";
    public static final String IRI_URL = "(([a-z])+:)*((%[0-9a-fA-F]{2})|[&'\\(\\)*+,;:@_~?!$\\/\\-\\#.\\=a-zA-Z0-9\u00a0-\ufffe])+";
    public static final String LANG_REGEX = "[a-z]{2}(\\-[a-zA-Z]{2})?";
    private List<Section> sections = new ArrayList<Section>();
    protected Set<String> subjectSet = new HashSet<String>();
    protected Set<String> predicateSet = new HashSet<String>();
    protected Set<String> objectSet = new HashSet<String>();
    protected Map<String, String> prefixes = new HashMap<String, String>();
    private Map<TTLURL, TTLComplex> objects = new HashMap<TTLURL, TTLComplex>();
    private Object base;

    public void prefix(String code, String url) {
        this.prefixes.put(code, url);
    }

    protected boolean hasSection(String sn) {
        for (Section s2 : this.sections) {
            if (!s2.name.equals(sn)) continue;
            return true;
        }
        return false;
    }

    public Section section(String sn) {
        if (this.hasSection(sn)) {
            throw new Error("Duplicate section name " + sn);
        }
        Section s2 = new Section();
        s2.name = sn;
        this.sections.add(s2);
        return s2;
    }

    protected String matches(String url, String prefixUri, String prefix) {
        if (url.startsWith(prefixUri)) {
            this.prefixes.put(prefix, prefixUri);
            return prefix + ":" + Turtle.escape(url.substring(prefixUri.length()), false);
        }
        return null;
    }

    protected Complex complex() {
        return new Complex();
    }

    private void checkPrefix(Triple object) {
        if (object instanceof StringType) {
            this.checkPrefix(((StringType)object).value);
        } else {
            Complex obj = (Complex)object;
            for (Predicate po : obj.predicates) {
                this.checkPrefix(po.getPredicate());
                for (Triple o : po.getObjects()) {
                    this.checkPrefix(o);
                }
            }
        }
    }

    protected void checkPrefix(String pname) {
        String prefix;
        if (pname.startsWith("(")) {
            return;
        }
        if (pname.startsWith("\"")) {
            return;
        }
        if (pname.startsWith("<")) {
            return;
        }
        if (pname.contains(":") && !this.prefixes.containsKey(prefix = pname.substring(0, pname.indexOf(":"))) && !prefix.equals("http") && !prefix.equals("urn")) {
            throw new Error("undefined prefix " + prefix);
        }
    }

    protected StringType literal(String s2) {
        return new StringType("\"" + Turtle.escape(s2, true) + "\"");
    }

    protected StringType literalTyped(String s2, String t) {
        return new StringType("\"" + Turtle.escape(s2, true) + "\"^^xs:" + t);
    }

    public static String escape(String s2, boolean string) {
        if (s2 == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (char c : s2.toCharArray()) {
            if (c == '\r') {
                b.append("\\r");
                continue;
            }
            if (c == '\n') {
                b.append("\\n");
                continue;
            }
            if (c == '\"') {
                b.append("\\\"");
                continue;
            }
            if (c == '\\') {
                b.append("\\\\");
                continue;
            }
            if (c == '/' && !string) {
                b.append("\\/");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    protected String pctEncode(String s2) {
        if (s2 == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (char c : s2.toCharArray()) {
            if (c >= 'A' && c <= 'Z') {
                b.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                b.append(c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                b.append(c);
                continue;
            }
            if (c == '.') {
                b.append(c);
                continue;
            }
            b.append("%" + Integer.toHexString(c));
        }
        return b.toString();
    }

    protected List<String> sorted(Set<String> keys2) {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(keys2);
        Collections.sort(names);
        return names;
    }

    public void commit(OutputStream destination, boolean header) throws IOException {
        LineOutputStreamWriter writer = new LineOutputStreamWriter(destination);
        this.commitPrefixes(writer, header);
        for (Section s2 : this.sections) {
            this.commitSection(writer, s2);
        }
        writer.ln("# -------------------------------------------------------------------------------------");
        writer.ln();
        writer.flush();
        writer.close();
    }

    public String asHtml() throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("<pre class=\"rdf\">\r\n");
        this.commitPrefixes(b);
        for (Section s2 : this.sections) {
            this.commitSection(b, s2);
        }
        b.append("</pre>\r\n");
        b.append("\r\n");
        return b.toString();
    }

    private void commitPrefixes(LineOutputStreamWriter writer, boolean header) throws IOException {
        if (header) {
            writer.ln("# FHIR Sub-definitions");
            writer.write("# This is work in progress, and may change rapidly \r\n");
            writer.ln();
            writer.write("# A note about policy: the focus here is providing the knowledge from \r\n");
            writer.write("# the FHIR specification as a set of triples for knowledge processing. \r\n");
            writer.write("# Where appopriate, predicates defined external to FHIR are used. \"Where \r\n");
            writer.write("# appropriate\" means that the predicates are a faithful representation \r\n");
            writer.write("# of the FHIR semantics, and do not involve insane (or owful) syntax. \r\n");
            writer.ln();
            writer.write("# Where the community agrees on additional predicate statements (such \r\n");
            writer.write("# as OWL constraints) these are added in addition to the direct FHIR \r\n");
            writer.write("# predicates \r\n");
            writer.ln();
            writer.write("# This it not a formal ontology, though it is possible it may start to become one eventually\r\n");
            writer.ln();
            writer.write("# this file refers to concepts defined in rim.ttl and to others defined elsewhere outside HL7 \r\n");
            writer.ln();
        }
        for (String p : this.sorted(this.prefixes.keySet())) {
            writer.ln("@prefix " + p + ": <" + this.prefixes.get(p) + "> .");
        }
        writer.ln();
        if (header) {
            writer.ln("# Predicates used in this file:");
            for (String s2 : this.sorted(this.predicateSet)) {
                writer.ln(" # " + s2);
            }
            writer.ln();
        }
    }

    private void commitPrefixes(StringBuilder b) throws Exception {
        for (String p : this.sorted(this.prefixes.keySet())) {
            b.append("@prefix " + p + ": &lt;" + this.prefixes.get(p) + "&gt; .\r\n");
        }
        b.append("\r\n");
    }

    private void commitSection(LineOutputStreamWriter writer, Section section) throws IOException {
        writer.ln("# - " + section.name + " " + Utilities.padLeft("", '-', 75 - section.name.length()));
        writer.ln();
        for (Subject sbj : section.subjects) {
            if (Utilities.noString(sbj.id)) {
                writer.write("[");
            } else {
                writer.write(sbj.id);
                writer.write(" ");
            }
            int i = 0;
            for (Predicate p : sbj.predicates) {
                String comment;
                writer.write(p.getPredicate());
                writer.write(" ");
                boolean first = true;
                for (Triple o : p.getObjects()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(", ");
                    }
                    if (o instanceof StringType) {
                        writer.write(((StringType)o).value);
                        continue;
                    }
                    writer.write("[");
                    if (this.write((Complex)o, writer, 4)) {
                        writer.write("\r\n  ]");
                        continue;
                    }
                    writer.write("]");
                }
                String string = comment = p.comment == null ? "" : " # " + p.comment;
                if (++i < sbj.predicates.size()) {
                    writer.write(";" + comment + "\r\n  ");
                    continue;
                }
                if (Utilities.noString(sbj.id)) {
                    writer.write("]");
                }
                writer.write(" ." + comment + "\r\n\r\n");
            }
        }
    }

    private void commitSection(StringBuilder b, Section section) throws Exception {
        b.append("# - " + section.name + " " + Utilities.padLeft("", '-', 75 - section.name.length()) + "\r\n");
        b.append("\r\n");
        for (Subject sbj : section.subjects) {
            b.append(Utilities.escapeXml(sbj.id));
            b.append(" ");
            int i = 0;
            for (Predicate p : sbj.predicates) {
                String comment;
                b.append(p.makelink());
                b.append(" ");
                boolean first = true;
                for (Triple o : p.getObjects()) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(", ");
                    }
                    if (o instanceof StringType) {
                        b.append(Utilities.escapeXml(((StringType)o).value));
                        continue;
                    }
                    b.append("[");
                    if (this.write((Complex)o, b, 4)) {
                        b.append("\r\n  ]");
                        continue;
                    }
                    b.append("]");
                }
                String string = comment = p.comment == null ? "" : " # " + p.comment;
                if (++i < sbj.predicates.size()) {
                    b.append(";" + Utilities.escapeXml(comment) + "\r\n  ");
                    continue;
                }
                b.append("." + Utilities.escapeXml(comment) + "\r\n\r\n");
            }
        }
    }

    public boolean write(Complex complex, LineOutputStreamWriter writer, int indent) throws IOException {
        if (complex.predicates.isEmpty()) {
            return false;
        }
        if (complex.predicates.size() == 1 && complex.predicates.get(0).getObjects().size() == 1 && complex.predicates.get(0).getObjects().get(0) instanceof StringType && Utilities.noString(complex.predicates.get((int)0).comment)) {
            writer.write(" " + complex.predicates.get((int)0).predicate + " " + ((StringType)complex.predicates.get(0).getObjects().get(0)).value);
            return false;
        }
        String left = Utilities.padLeft("", ' ', indent);
        int i = 0;
        for (Predicate po : complex.predicates) {
            writer.write("\r\n");
            boolean first = true;
            for (Triple o : po.getObjects()) {
                if (first) {
                    first = false;
                    writer.write(left + " " + po.getPredicate() + " ");
                } else {
                    writer.write(", ");
                }
                if (o instanceof StringType) {
                    writer.write(((StringType)o).value);
                    continue;
                }
                writer.write("[");
                if (this.write((Complex)o, writer, indent + 2)) {
                    writer.write("\r\n" + left + " ]");
                    continue;
                }
                writer.write(" ]");
            }
            if (++i < complex.predicates.size()) {
                writer.write(";");
            }
            if (Utilities.noString(po.comment)) continue;
            writer.write(" # " + Turtle.escape(po.comment, false));
        }
        return true;
    }

    public boolean write(Complex complex, StringBuilder b, int indent) throws Exception {
        if (complex.predicates.isEmpty()) {
            return false;
        }
        if (complex.predicates.size() == 1 && complex.predicates.get(0).getObjects().size() == 1 && complex.predicates.get(0).getObjects().get(0) instanceof StringType && Utilities.noString(complex.predicates.get((int)0).comment)) {
            b.append(" " + complex.predicates.get(0).makelink() + " " + Utilities.escapeXml(((StringType)complex.predicates.get(0).getObjects().get(0)).value));
            return false;
        }
        String left = Utilities.padLeft("", ' ', indent);
        int i = 0;
        for (Predicate po : complex.predicates) {
            b.append("\r\n");
            boolean first = true;
            for (Triple o : po.getObjects()) {
                if (first) {
                    first = false;
                    b.append(left + " " + po.makelink() + " ");
                } else {
                    b.append(", ");
                }
                if (o instanceof StringType) {
                    b.append(Utilities.escapeXml(((StringType)o).value));
                    continue;
                }
                b.append("[");
                if (this.write((Complex)o, b, indent + 2)) {
                    b.append(left + " ]");
                    continue;
                }
                b.append(" ]");
            }
            if (++i < complex.predicates.size()) {
                b.append(";");
            }
            if (Utilities.noString(po.comment)) continue;
            b.append(" # " + Utilities.escapeXml(Turtle.escape(po.comment, false)));
        }
        return true;
    }

    public void parse(String source2) throws FHIRFormatError {
        this.prefixes.clear();
        this.prefixes.put("_", "urn:uuid:4425b440-2c33-4488-b9fc-cf9456139995#");
        this.parse(new Lexer(source2));
    }

    private void parse(Lexer lexer) throws FHIRFormatError {
        boolean doPrefixes = true;
        while (!lexer.done()) {
            if (doPrefixes && (lexer.peek(LexerTokenType.TOKEN, "@") || lexer.peek(LexerTokenType.WORD, "PREFIX") || lexer.peek(LexerTokenType.WORD, "BASE"))) {
                String p;
                boolean sparqlStyle = false;
                boolean base = false;
                if (lexer.peek(LexerTokenType.TOKEN, "@")) {
                    lexer.token("@");
                    p = lexer.word();
                    if (p.equals("base")) {
                        base = true;
                    } else if (!p.equals("prefix")) {
                        throw new FHIRFormatError("Unexpected token " + p);
                    }
                } else {
                    sparqlStyle = true;
                    p = lexer.word();
                    if (p.equals("BASE")) {
                        base = true;
                    } else if (!p.equals("PREFIX")) {
                        throw new FHIRFormatError("Unexpected token " + p);
                    }
                }
                String prefix = null;
                if (!base) {
                    prefix = lexer.peekType() == LexerTokenType.WORD ? lexer.next(LexerTokenType.WORD, false) : null;
                    lexer.token(":");
                }
                String url = lexer.next(LexerTokenType.URI, false);
                if (!sparqlStyle) {
                    lexer.token(".");
                }
                if (!base) {
                    this.prefix(prefix, url);
                    continue;
                }
                if (this.base == null) {
                    this.base = url;
                    continue;
                }
                throw new FHIRFormatError("Duplicate @base");
            }
            if (lexer.peekType() == LexerTokenType.URI) {
                doPrefixes = false;
                TTLURL uri = new TTLURL(lexer.startLine, lexer.startCol);
                uri.setUri(lexer.uri());
                TTLComplex complex = this.parseComplex(lexer);
                this.objects.put(uri, complex);
                lexer.token(".");
                continue;
            }
            if (lexer.peekType() == LexerTokenType.WORD) {
                doPrefixes = false;
                TTLURL uri = new TTLURL(lexer.startLine, lexer.startCol);
                String pfx = lexer.word();
                if (!this.prefixes.containsKey(pfx)) {
                    throw new FHIRFormatError("Unknown prefix " + pfx);
                }
                lexer.token(":");
                uri.setUri(this.prefixes.get(pfx) + lexer.word());
                TTLComplex complex = this.parseComplex(lexer);
                this.objects.put(uri, complex);
                lexer.token(".");
                continue;
            }
            if (lexer.peek(LexerTokenType.TOKEN, ":")) {
                doPrefixes = false;
                TTLURL uri = new TTLURL(lexer.startLine, lexer.startCol);
                lexer.token(":");
                if (!this.prefixes.containsKey(null)) {
                    throw new FHIRFormatError("Unknown prefix ''");
                }
                uri.setUri(this.prefixes.get(null) + lexer.word());
                TTLComplex complex = this.parseComplex(lexer);
                this.objects.put(uri, complex);
                lexer.token(".");
                continue;
            }
            if (lexer.peek(LexerTokenType.TOKEN, "[")) {
                doPrefixes = false;
                lexer.token("[");
                TTLComplex bnode = this.parseComplex(lexer);
                lexer.token("]");
                TTLComplex complex = null;
                if (!lexer.peek(LexerTokenType.TOKEN, ".")) {
                    complex = this.parseComplex(lexer);
                    bnode.addPredicates(complex.predicates);
                }
                this.objects.put(this.anonymousId(), bnode);
                lexer.token(".");
                continue;
            }
            throw lexer.error("Unknown token " + lexer.token);
        }
    }

    private TTLURL anonymousId() throws FHIRFormatError {
        TTLURL url = new TTLURL(-1, -1);
        url.setUri("urn:uuid:" + UUID.randomUUID().toString().toLowerCase());
        return url;
    }

    private TTLComplex parseComplex(Lexer lexer) throws FHIRFormatError {
        TTLComplex result = new TTLComplex(lexer.startLine, lexer.startCol);
        boolean done = lexer.peek(LexerTokenType.TOKEN, "]");
        while (!done) {
            String uri = null;
            if (lexer.peekType() == LexerTokenType.URI) {
                uri = lexer.uri();
            } else {
                String t;
                String string = t = lexer.peekType() == LexerTokenType.WORD ? lexer.word() : null;
                if (lexer.type == LexerTokenType.TOKEN && lexer.token.equals(":")) {
                    lexer.token(":");
                    if (!this.prefixes.containsKey(t)) {
                        throw new FHIRFormatError("unknown prefix " + t);
                    }
                    uri = this.prefixes.get(t) + lexer.word();
                } else if (t.equals("a")) {
                    uri = this.prefixes.get("rdfs") + "type";
                } else {
                    throw lexer.error("unexpected token");
                }
            }
            boolean inlist = false;
            if (lexer.peek(LexerTokenType.TOKEN, "(")) {
                inlist = true;
                lexer.token("(");
            }
            boolean rpt = false;
            do {
                if (lexer.peek(LexerTokenType.TOKEN, "[")) {
                    lexer.token("[");
                    result.addPredicate(uri, this.parseComplex(lexer));
                    lexer.token("]");
                } else if (lexer.peekType() == LexerTokenType.URI) {
                    TTLURL u = new TTLURL(lexer.startLine, lexer.startCol);
                    u.setUri(lexer.uri());
                    result.addPredicate(uri, u);
                } else if (lexer.peekType() == LexerTokenType.LITERAL) {
                    TTLLiteral u = new TTLLiteral(lexer.startLine, lexer.startCol);
                    u.value = lexer.literal();
                    if (lexer.peek(LexerTokenType.TOKEN, "^")) {
                        lexer.token("^");
                        lexer.token("^");
                        if (lexer.peekType() == LexerTokenType.URI) {
                            u.type = lexer.uri();
                        } else {
                            String l = lexer.word();
                            lexer.token(":");
                            u.type = this.prefixes.get(l) + lexer.word();
                        }
                    }
                    if (lexer.peek(LexerTokenType.TOKEN, "@")) {
                        lexer.token("@");
                        String lang = lexer.word();
                        if (!lang.matches(LANG_REGEX)) {
                            throw new FHIRFormatError("Invalid Language tag " + lang);
                        }
                    }
                    result.addPredicate(uri, u);
                } else if (lexer.peekType() == LexerTokenType.WORD || lexer.peek(LexerTokenType.TOKEN, ":")) {
                    TTLObject u;
                    String pfx;
                    int sl = lexer.startLine;
                    int sc = lexer.startCol;
                    String string = pfx = lexer.peekType() == LexerTokenType.WORD ? lexer.word() : null;
                    if (Utilities.isDecimal(pfx, true) && !lexer.peek(LexerTokenType.TOKEN, ":")) {
                        u = new TTLLiteral(sl, sc);
                        ((TTLLiteral)u).value = pfx;
                        result.addPredicate(uri, u);
                    } else if (("false".equals(pfx) || "true".equals(pfx)) && !lexer.peek(LexerTokenType.TOKEN, ":")) {
                        u = new TTLLiteral(sl, sc);
                        ((TTLLiteral)u).value = pfx;
                        result.addPredicate(uri, u);
                    } else {
                        if (!this.prefixes.containsKey(pfx)) {
                            throw new FHIRFormatError("Unknown prefix " + (pfx == null ? "''" : pfx));
                        }
                        u = new TTLURL(sl, sc);
                        lexer.token(":");
                        ((TTLURL)u).setUri(this.prefixes.get(pfx) + lexer.word());
                        result.addPredicate(uri, u);
                    }
                } else if (!(lexer.peek(LexerTokenType.TOKEN, ";") || inlist && lexer.peek(LexerTokenType.TOKEN, ")"))) {
                    throw new FHIRFormatError("unexpected token " + lexer.token);
                }
                if (inlist) {
                    rpt = !lexer.peek(LexerTokenType.TOKEN, ")");
                    continue;
                }
                rpt = lexer.peek(LexerTokenType.TOKEN, ",");
                if (!rpt) continue;
                lexer.readNext(false);
            } while (rpt);
            if (inlist) {
                lexer.token(")");
            }
            if (lexer.peek(LexerTokenType.TOKEN, ";")) {
                while (lexer.peek(LexerTokenType.TOKEN, ";")) {
                    lexer.token(";");
                }
                done = lexer.peek(LexerTokenType.TOKEN, ".") || lexer.peek(LexerTokenType.TOKEN, "]");
                continue;
            }
            done = true;
        }
        return result;
    }

    public Map<TTLURL, TTLComplex> getObjects() {
        return this.objects;
    }

    public TTLComplex getObject(String url) {
        for (TTLURL t : this.objects.keySet()) {
            if (!t.getUri().equals(url)) continue;
            return this.objects.get(t);
        }
        return null;
    }

    public class Lexer {
        private String source;
        private LexerTokenType type;
        private int cursor;
        private int line;
        private int col;
        private int startLine;
        private int startCol;
        private String token;

        public Lexer(String source2) throws FHIRFormatError {
            this.source = source2;
            this.cursor = 0;
            this.line = 1;
            this.col = 1;
            this.readNext(false);
        }

        private void skipWhitespace() {
            while (this.cursor < this.source.length()) {
                char ch = this.source.charAt(this.cursor);
                if (Character.isWhitespace(ch)) {
                    this.grab();
                    continue;
                }
                if (ch != '#') break;
                ch = this.grab();
                while (this.cursor < this.source.length() && (ch = this.grab()) != '\r' && ch != '\n') {
                }
            }
        }

        private char grab() {
            char c = this.source.charAt(this.cursor);
            if (c == '\n') {
                ++this.line;
                this.col = 1;
            } else {
                ++this.col;
            }
            ++this.cursor;
            return c;
        }

        private void readNext(boolean postColon) throws FHIRFormatError {
            this.token = null;
            this.type = null;
            this.skipWhitespace();
            if (this.cursor >= this.source.length()) {
                return;
            }
            this.startLine = this.line;
            this.startCol = this.col;
            char ch = this.grab();
            StringBuilder b = new StringBuilder();
            switch (ch) {
                case '(': 
                case ')': 
                case ',': 
                case '.': 
                case ':': 
                case ';': 
                case '@': 
                case '[': 
                case ']': 
                case '^': {
                    this.type = LexerTokenType.TOKEN;
                    b.append(ch);
                    this.token = b.toString();
                    return;
                }
                case '<': {
                    while (this.cursor < this.source.length() && (ch = this.grab()) != '>') {
                        b.append(ch);
                    }
                    this.type = LexerTokenType.URI;
                    this.token = this.unescape(b.toString(), true);
                    return;
                }
                case '\"': {
                    b.append(ch);
                    String end = "\"";
                    while (this.cursor < this.source.length()) {
                        ch = this.grab();
                        if (b.length() == 2 && ch != '\"' && b.equals("\"\"")) {
                            --this.cursor;
                            break;
                        }
                        b.append(ch);
                        if (ch != '\"') continue;
                        if (b.toString().equals("\"\"\"")) {
                            end = "\"\"\"";
                            continue;
                        }
                        if (b.toString().equals("\"\"") || !b.toString().endsWith(end) || b.toString().endsWith("\\" + end)) continue;
                    }
                    this.type = LexerTokenType.LITERAL;
                    this.token = this.unescape(b.toString().substring(end.length(), b.length() - end.length()), false);
                    return;
                }
                case '\'': {
                    b.append(ch);
                    String end = "'";
                    while (this.cursor < this.source.length()) {
                        ch = this.grab();
                        if (b.equals("''") && ch != '\'') {
                            --this.cursor;
                            break;
                        }
                        b.append(ch);
                        if (b.toString().equals("'''")) {
                            end = "'''";
                            continue;
                        }
                        if (b.toString().equals("''") || !b.toString().endsWith(end)) continue;
                    }
                    this.type = LexerTokenType.LITERAL;
                    this.token = this.unescape(b.toString().substring(end.length(), b.length() - end.length()), false);
                    return;
                }
            }
            if (Utilities.charInRange(ch, '0', '9') || Utilities.charInRange(ch, 'a', 'z') || Utilities.charInRange(ch, 'A', 'Z') || Utilities.charInSet(ch, '_', '-', '+', '%')) {
                b.append(ch);
                while (!(this.cursor >= this.source.length() || Character.isWhitespace(ch = this.grab()) || Utilities.charInSet(ch, ';', ']', ')', '~') || ch == ':' && !postColon)) {
                    b.append(ch);
                }
                this.type = LexerTokenType.WORD;
                this.token = b.toString();
                --this.cursor;
                return;
            }
            throw this.error("unexpected lexer char " + ch);
        }

        private String unescape(String s2, boolean isUri) throws FHIRFormatError {
            StringBuilder b = new StringBuilder();
            block11: for (int i = 0; i < s2.length(); ++i) {
                char ch = s2.charAt(i);
                if (ch == '\\' && i < s2.length() - 1) {
                    switch (s2.charAt(++i)) {
                        case 't': {
                            b.append('\t');
                            continue block11;
                        }
                        case 'r': {
                            b.append('\r');
                            continue block11;
                        }
                        case 'n': {
                            b.append('\n');
                            continue block11;
                        }
                        case 'f': {
                            b.append('\f');
                            continue block11;
                        }
                        case '\'': {
                            b.append('\'');
                            continue block11;
                        }
                        case '\"': {
                            b.append('\"');
                            continue block11;
                        }
                        case '\\': {
                            b.append('\\');
                            continue block11;
                        }
                        case '/': {
                            b.append('\\');
                            continue block11;
                        }
                        case 'U': 
                        case 'u': {
                            int l = 4;
                            int uc = Integer.parseInt(s2.substring(++i, i + l), 16);
                            if (uc < (isUri ? 33 : 32)) {
                                l = 8;
                                uc = Integer.parseInt(s2.substring(i, i + 8), 16);
                            }
                            if (uc < (isUri ? 33 : 32) || isUri && (uc == 60 || uc == 62)) {
                                throw new FHIRFormatError("Illegal unicode character");
                            }
                            b.append((char)uc);
                            i += l;
                            continue block11;
                        }
                        default: {
                            throw new FHIRFormatError("Unknown character escape \\" + s2.charAt(i));
                        }
                    }
                }
                b.append(ch);
            }
            return b.toString();
        }

        public boolean done() {
            return this.type == null;
        }

        public String next(LexerTokenType type, boolean postColon) throws FHIRFormatError {
            if (type != null && this.type != type) {
                throw this.error("Unexpected type. Found " + this.type.toString() + " looking for a " + type.toString());
            }
            String res = this.token;
            this.readNext(postColon);
            return res;
        }

        public String peek() throws Exception {
            return this.token;
        }

        public LexerTokenType peekType() {
            return this.type;
        }

        public void token(String token) throws FHIRFormatError {
            if (!token.equals(this.token)) {
                throw this.error("Unexpected word " + this.token + " looking for " + token);
            }
            this.next(LexerTokenType.TOKEN, token.equals(":"));
        }

        public void word(String word) throws Exception {
            if (!word.equals(this.token)) {
                throw this.error("Unexpected word " + this.token + " looking for " + word);
            }
            this.next(LexerTokenType.WORD, false);
        }

        public String word() throws FHIRFormatError {
            String t = this.token;
            this.next(LexerTokenType.WORD, false);
            return t;
        }

        public String uri() throws FHIRFormatError {
            if (this.type != LexerTokenType.URI) {
                throw this.error("Unexpected type. Found " + this.type.toString() + " looking for a URI");
            }
            String t = this.token;
            this.next(LexerTokenType.URI, false);
            return t;
        }

        public String literal() throws FHIRFormatError {
            if (this.type != LexerTokenType.LITERAL) {
                throw this.error("Unexpected type. Found " + this.type.toString() + " looking for a Literal");
            }
            String t = this.token;
            this.next(LexerTokenType.LITERAL, false);
            return t;
        }

        public boolean peek(LexerTokenType type, String token) {
            return this.type == type && this.token.equals(token);
        }

        public FHIRFormatError error(String message) {
            return new FHIRFormatError("Syntax Error parsing Turtle on line " + Integer.toString(this.line) + " col " + Integer.toString(this.col) + ": " + message);
        }
    }

    public static enum LexerTokenType {
        TOKEN,
        WORD,
        URI,
        LITERAL;

    }

    public class TTLComplex
    extends TTLObject {
        private Map<String, TTLObject> predicates;

        protected TTLComplex(int line, int col) {
            this.predicates = new HashMap<String, TTLObject>();
            this.line = line;
            this.col = col;
        }

        public Map<String, TTLObject> getPredicates() {
            return this.predicates;
        }

        @Override
        public boolean hasValue(String value) {
            return false;
        }

        public void addPredicate(String uri, TTLObject obj) {
            if (!this.predicates.containsKey(uri)) {
                this.predicates.put(uri, obj);
            } else {
                TTLObject eo = this.predicates.get(uri);
                TTLList list = null;
                if (eo instanceof TTLList) {
                    list = (TTLList)eo;
                } else {
                    list = new TTLList(eo);
                    this.predicates.put(uri, list);
                }
                list.list.add(obj);
            }
        }

        public void addPredicates(Map<String, TTLObject> values2) {
            for (String s2 : values2.keySet()) {
                this.addPredicate(s2, values2.get(s2));
            }
        }
    }

    public class TTLList
    extends TTLObject {
        private List<TTLObject> list;

        public TTLList(TTLObject obj) {
            this.list = new ArrayList<TTLObject>();
            this.list.add(obj);
        }

        @Override
        public boolean hasValue(String value) {
            for (TTLObject obj : this.list) {
                if (!obj.hasValue(value)) continue;
                return true;
            }
            return false;
        }

        public List<TTLObject> getList() {
            return this.list;
        }
    }

    public class TTLURL
    extends TTLObject {
        private String uri;

        protected TTLURL(int line, int col) {
            this.line = line;
            this.col = col;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) throws FHIRFormatError {
            if (!uri.matches(Turtle.IRI_URL)) {
                throw new FHIRFormatError("Illegal URI " + uri);
            }
            this.uri = uri;
        }

        @Override
        public boolean hasValue(String value) {
            return value.equals(this.uri);
        }
    }

    public class TTLLiteral
    extends TTLObject {
        private String value;
        private String type;

        protected TTLLiteral(int line, int col) {
            this.line = line;
            this.col = col;
        }

        @Override
        public boolean hasValue(String value) {
            return value.equals(this.value);
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }
    }

    public abstract class TTLObject {
        protected int line;
        protected int col;

        public abstract boolean hasValue(String var1);

        public int getLine() {
            return this.line;
        }

        public int getCol() {
            return this.col;
        }
    }

    protected class LineOutputStreamWriter
    extends OutputStreamWriter {
        private LineOutputStreamWriter(OutputStream out) throws UnsupportedEncodingException {
            super(out, "UTF-8");
        }

        private void ln() throws IOException {
            this.write("\r\n");
        }

        private void ln(String s2) throws IOException {
            this.write(s2);
            this.write("\r\n");
        }
    }

    public class Section {
        private String name;
        private List<Subject> subjects = new ArrayList<Subject>();

        public Subject triple(String subject, String predicate, String object, String comment) {
            return this.triple(subject, predicate, new StringType(object), comment);
        }

        public Subject triple(String subject, String predicate, String object) {
            return this.triple(subject, predicate, new StringType(object));
        }

        public Subject triple(String subject, String predicate, Triple object) {
            return this.triple(subject, predicate, object, null);
        }

        public Subject triple(String subject, String predicate, Triple object, String comment) {
            Subject s2 = this.subject(subject);
            s2.predicate(predicate, object, comment);
            return s2;
        }

        public void comment(String subject, String comment) {
            this.triple(subject, "rdfs:comment", Turtle.this.literal(comment));
            this.triple(subject, "dcterms:description", Turtle.this.literal(comment));
        }

        public void label(String subject, String comment) {
            this.triple(subject, "rdfs:label", Turtle.this.literal(comment));
            this.triple(subject, "dc:title", Turtle.this.literal(comment));
        }

        public Subject subject(String subject) {
            for (Subject ss : this.subjects) {
                if (!ss.id.equals(subject)) continue;
                return ss;
            }
            Subject s2 = new Subject();
            s2.id = subject;
            this.subjects.add(s2);
            return s2;
        }

        public boolean hasSubject(String subject) {
            for (Subject ss : this.subjects) {
                if (!ss.id.equals(subject)) continue;
                return true;
            }
            return false;
        }
    }

    public class Subject
    extends Complex {
        private String id;

        public Predicate predicate(String predicate, Triple object, String comment) {
            Predicate p = this.getPredicate(predicate);
            if (p == null) {
                p = new Predicate();
                p.predicate = predicate;
                Turtle.this.predicateSet.add(predicate);
                this.predicates.add(p);
                p.comment = comment;
            }
            if (object instanceof StringType) {
                Turtle.this.objectSet.add(((StringType)object).value);
            }
            p.objects.add(object);
            return p;
        }

        public void comment(String comment) {
            if (!Utilities.noString(comment)) {
                this.predicate("rdfs:comment", Turtle.this.literal(comment));
                this.predicate("dcterms:description", Turtle.this.literal(comment));
            }
        }

        public void label(String label) {
            if (!Utilities.noString(label)) {
                this.predicate("rdfs:label", Turtle.this.literal(label));
                this.predicate("dc:title", Turtle.this.literal(label));
            }
        }
    }

    private class Predicate {
        protected String predicate;
        protected String link;
        protected List<Triple> objects = new ArrayList<Triple>();
        protected String comment;

        private Predicate() {
        }

        public String getPredicate() {
            return this.predicate;
        }

        public String makelink() {
            if (this.link == null) {
                return this.predicate;
            }
            return "<a href=\"" + this.link + "\">" + Utilities.escapeXml(this.predicate) + "</a>";
        }

        public List<Triple> getObjects() {
            return this.objects;
        }

        public String getComment() {
            return this.comment;
        }
    }

    public class Complex
    extends Triple {
        protected List<Predicate> predicates;

        public Complex() {
            this.predicates = new ArrayList<Predicate>();
        }

        public Complex predicate(String predicate, String object) {
            Turtle.this.predicateSet.add(predicate);
            Turtle.this.objectSet.add(object);
            return this.predicate(predicate, new StringType(object));
        }

        public Complex linkedPredicate(String predicate, String object, String link) {
            Turtle.this.predicateSet.add(predicate);
            Turtle.this.objectSet.add(object);
            return this.linkedPredicate(predicate, new StringType(object), link);
        }

        public Complex predicate(String predicate, Triple object) {
            Predicate p = this.getPredicate(predicate);
            if (p == null) {
                p = new Predicate();
                p.predicate = predicate;
                Turtle.this.predicateSet.add(predicate);
                this.predicates.add(p);
            }
            if (object instanceof StringType) {
                Turtle.this.objectSet.add(((StringType)object).value);
            }
            p.objects.add(object);
            return this;
        }

        protected Predicate getPredicate(String predicate) {
            for (Predicate p : this.predicates) {
                if (!p.predicate.equals(predicate)) continue;
                return p;
            }
            return null;
        }

        public Complex linkedPredicate(String predicate, Triple object, String link) {
            Predicate p = this.getPredicate(predicate);
            if (p == null) {
                p = new Predicate();
                p.predicate = predicate;
                p.link = link;
                Turtle.this.predicateSet.add(predicate);
                this.predicates.add(p);
            }
            if (object instanceof StringType) {
                Turtle.this.objectSet.add(((StringType)object).value);
            }
            p.objects.add(object);
            return this;
        }

        public Complex predicate(String predicate) {
            Turtle.this.predicateSet.add(predicate);
            Complex c = Turtle.this.complex();
            this.predicate(predicate, c);
            return c;
        }

        public Complex linkedPredicate(String predicate, String link) {
            Turtle.this.predicateSet.add(predicate);
            Complex c = Turtle.this.complex();
            this.linkedPredicate(predicate, c, link);
            return c;
        }

        public void prefix(String code, String url) {
            Turtle.this.prefix(code, url);
        }
    }

    public class StringType
    extends Triple {
        private String value;

        public StringType(String value) {
            this.value = value;
        }
    }

    public abstract class Triple {
        private String uri;
    }
}

