/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VerificationresultStatus {
    ATTESTED,
    VALIDATED,
    INPROCESS,
    REQREVALID,
    VALFAIL,
    REVALFAIL,
    NULL;


    public static VerificationresultStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("attested".equals(codeString)) {
            return ATTESTED;
        }
        if ("validated".equals(codeString)) {
            return VALIDATED;
        }
        if ("in-process".equals(codeString)) {
            return INPROCESS;
        }
        if ("req-revalid".equals(codeString)) {
            return REQREVALID;
        }
        if ("val-fail".equals(codeString)) {
            return VALFAIL;
        }
        if ("reval-fail".equals(codeString)) {
            return REVALFAIL;
        }
        throw new FHIRException("Unknown VerificationresultStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ATTESTED: {
                return "attested";
            }
            case VALIDATED: {
                return "validated";
            }
            case INPROCESS: {
                return "in-process";
            }
            case REQREVALID: {
                return "req-revalid";
            }
            case VALFAIL: {
                return "val-fail";
            }
            case REVALFAIL: {
                return "reval-fail";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/CodeSystem/status";
    }

    public String getDefinition() {
        switch (this) {
            case ATTESTED: {
                return "***TODO***";
            }
            case VALIDATED: {
                return "***TODO***";
            }
            case INPROCESS: {
                return "***TODO***";
            }
            case REQREVALID: {
                return "***TODO***";
            }
            case VALFAIL: {
                return "***TODO***";
            }
            case REVALFAIL: {
                return "***TODO***";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ATTESTED: {
                return "Attested";
            }
            case VALIDATED: {
                return "Validated";
            }
            case INPROCESS: {
                return "In process";
            }
            case REQREVALID: {
                return "Requires revalidation";
            }
            case VALFAIL: {
                return "Validation failed";
            }
            case REVALFAIL: {
                return "Re-Validation failed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

