/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RemittanceOutcome {
    QUEUED,
    COMPLETE,
    ERROR,
    PARTIAL,
    NULL;


    public static RemittanceOutcome fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("queued".equals(codeString)) {
            return QUEUED;
        }
        if ("complete".equals(codeString)) {
            return COMPLETE;
        }
        if ("error".equals(codeString)) {
            return ERROR;
        }
        if ("partial".equals(codeString)) {
            return PARTIAL;
        }
        throw new FHIRException("Unknown RemittanceOutcome code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case QUEUED: {
                return "queued";
            }
            case COMPLETE: {
                return "complete";
            }
            case ERROR: {
                return "error";
            }
            case PARTIAL: {
                return "partial";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/remittance-outcome";
    }

    public String getDefinition() {
        switch (this) {
            case QUEUED: {
                return "The Claim/Pre-authorization/Pre-determination has been received but processing has not begun.";
            }
            case COMPLETE: {
                return "The processing has completed without errors";
            }
            case ERROR: {
                return "One or more errors have been detected in the Claim";
            }
            case PARTIAL: {
                return "No errors have been detected in the Claim and some of the adjudication has been performed.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case QUEUED: {
                return "Queued";
            }
            case COMPLETE: {
                return "Processing Complete";
            }
            case ERROR: {
                return "Error";
            }
            case PARTIAL: {
                return "Partial Processing";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

